var BOARD_HEIGHT = 627;

var ADD_BOARD_WIDTH = 140;
var ADD_BOARD_HEIGHT = 20;

var PORT_MAX_NUMBER_COLUMN = 16;

var TOOLTIP_WIDTH = 90;
var TOOLTIP_HEIGHT = 20;

var SHOW_BOARD_X = 300;
var SHOW_BOARD_Y = 0;
var SHOW_BOARD_WIDTH = 60;

var SHOW_BOARD_COMMENTS_X = SHOW_BOARD_X + 70;
var SHOW_BOARD_COMMENTS_Y = 0;
var SHOW_BOARD_COMMENTS_WIDTH = 230;
var SHOW_BOARD_COMMENTS_HEIGHT = 150;

var SHOW_PORT_COMMENTS_X = SHOW_BOARD_X + 70;
var SHOW_PORT_COMMENTS_Y = 0;
var SHOW_PORT_COMMENTS_WIDTH = 230;
var SHOW_PORT_COMMENTS_HEIGHT = 50;

var SHOW_BOARD_BUTTON_X = SHOW_BOARD_X + 60;
var SHOW_BOARD_BUTTON_Y = 10;
var SHOW_BOARD_BUTTON_WIDTH = 120;
var SHOW_BOARD_BUTTON_HEIGHT = 100;

var SHOW_BOARD_PATHVIEW_X = SHOW_BOARD_X + 60;
var SHOW_BOARD_PATHVIEW_Y = 70;

var BOARD_NAME_FONT_SIZE = 9;
var BOARD_NAME_FONT_SIZE_HOR = 9;

var BOARD_ALARM_R = 5;

var BOARD_ALM_OFFSET = 3;

var PORT_SIZE = 5;

var SUB_BOARD_X = 35;

var SUB_BOARD_Y = 5.5;

var BAR_WIDTH_DELTA = 35;

var BOARD_NUM_COLUMN = 10;

var THRESHOLD_Y = 440;

var SLOT_PREFIX = "o.1.";
var BOARD_PREFIX ="o.2.";
var ALARM_PREFIX =".a";
var BOARD_POSTFIX = ".b";
var PORT_PREFIX = ".p.";
var SHOW_BOARD_PREFIX = "s.1.";
var PORT_RECT = ".r";
var PORT_POSTFIX = ".p";
var PORT_EXTEND = ".e";
var PORT_LOOP = ".l";

var SUB_BOARD_PREFIX = "o.3.";

var SUB_BOARD_AREA_PREFIX = "o.4.";

var ALARM_AREA_PER = 0.1;
var NAME_AREA_PER = 0.3;
var SHOW_NAME_AREA_PER = 0.15;
var PORT_AREA_PER = 0.6;

var ADD_BOARD_PREFIX = "a.o.";
var ADD_BOARD_POSTFIX = ".a";

var BOARD_SHOW_ID = "o.showboard";
var BOARD_ADD_ID = "o.addboard";
var BOARD_MENU_ID = "o.boardmenu";
var BOARD_RIGHT_MENU = "o.boardrightmenu";
var BOARD_COMMENTS_ID = "o.boardcomments";
var BOARD_DESC_ID = "o.boarddescription";
var PORT_COMMENTS_ID = "o.portcomments";

var STANDBY_STATE_PREFIX = "Backstate.";
var PATH_PAGE_TIP = "p.page";

var isIE = (navigator.userAgent.indexOf("MSIE") > -1);
var isIE9 = (navigator.userAgent.indexOf("MSIE 9.0") > -1);
var isFF = (navigator.userAgent.indexOf("Firefox") > -1);

var UNDEFINED;
var SVG_NS = 'http://www.w3.org/2000/svg';
var svgDoc = null;
var htmlDoc = null;

/**
 *                                   
 * 
 * @param board
 */
function paintBoard(board)
{
	var slot = getSVGElement(SLOT_PREFIX + board.slotId);
	if(!slot)
	{
		return;
	}
	var lastboard = getSVGElement(BOARD_PREFIX + board.slotId);
	if(lastboard)
	{
		var oboard = JSON.parse(lastboard.getAttribute("oboard"));
		if(compareJsonBoard(board,oboard))
		{
			if(currentSelectBoard && currentSelectBoard == lastboard)
			{
				currentSelectBoard = null;
			}
		}
		else
		{
			if(needRefreshBoardState(board,oboard))
			{
				refreshBoardsState(board);
			}
			if("0" == SYSTEMCONF.getStatus() && needRefreshBoardAlarm(board,oboard))
			{
				refreshBoardsAlarm(board);
			}
			if(needRefreshBoardLoopback(board,oboard))
			{
				refreshBoardsLoopback(board);
			}
			if(needRefreshBoardPG(board,oboard))
			{
				refreshBoardsPG(board);
			}
            if("0" == SYSTEMCONF.getStatus() && needRefreshPortStateAlarm(board,oboard))
            {
            	refreshPortStateAlarm(board, oboard);
            }
            lastboard.setAttribute("oboard",JSON.stringify(board));
			if(board.boardType != oboard.boardType)
			{
				lastboard.parentNode.removeChild(lastboard);
			}
		}
		paintSubBoardView(board,1);
		return ;
	}
	var oPos = calcBoardPostion(board);

	var bCtn = createSVGElement("svg");
	attr(bCtn,extendObj(oPos,{id:BOARD_PREFIX + board.slotId}));
	bCtn.setAttribute("oboard",JSON.stringify(board));

	attachSVGEvent(bCtn,"click",board_onclick);
	attachSVGEvent(bCtn,"contextmenu",board_oncontextmenu);
	attachSVGEvent(bCtn,"mouseover",board_onmouseover);
	attachSVGEvent(bCtn,"mouseout",board_onmouseout);
	
	var bElm = createSVGElement("rect");
	bElm.setAttribute("id",bCtn.getAttribute("id") + BOARD_POSTFIX);
	bElm.setAttribute("class","SlotPhy");
	bElm.setAttribute("width","100%");
	bElm.setAttribute("height","100%");
	bElm.style.setProperty("fill",getBoardColor(board.boardState),"important");
	bCtn.appendChild(bElm);
	bCtn.setAttribute("rectid",bElm.getAttribute("id"));

	var alarm = createSVGElement("circle");
	var almPos = calcBoardAlmPostion(oPos);
	attr(alarm,almPos);
	alarm.setAttribute("alarm","1");
	if(0 == SYSTEMCONF.getStatus())
	{
		alarm.style.setProperty("fill","url(#radial"  + board.alarmLevel + ")","important");
	}
	else
	{
		alarm.style.setProperty("stroke","white","important");
		alarm.style.setProperty("fill",getAlarmColor(board.alarmLevel),"important");
	}
	if(2 == board.boardState)
	{
		alarm.setAttribute("display", "none");
	}
	bCtn.appendChild(alarm);
	var boardtext = createBoardText(board,oPos,almPos);
	if(boardtext)
	{
		bCtn.appendChild(boardtext);
	}
	
	var portContainer = createSVGElement("svg");
	var portContainerPos = calPortContainerPos(board,oPos);
	portContainer.setAttribute("portlist", "1");
	attr(portContainer,portContainerPos);
	
	var isHor = oPos.width > oPos.height;
	for(var i = 0,len = board.portList.length;i < len;i++)
	{
		if(i > PORT_MAX_NUMBER_COLUMN)
		{
			break;
		}
		var portId = board.portList[i];
		var id = BOARD_PREFIX + board.slotId + PORT_PREFIX + portId;
		portContainer.appendChild(createPort(i,id,oPos,isHor));
	}
	if(board.issupportsubcard == "true")
	{

		var subBoardContainer = createSVGElement("svg");
		var subBoardContainerPos = calSubBoardContainerPos(board,oPos);
		subBoardContainer.setAttribute("subBoardList", "1");
		attr(subBoardContainer,subBoardContainerPos);
		for(var i = 0,len = board.subboardnum;i < len;i++)
		{			
			var id = SUB_BOARD_PREFIX + board.slotId + "." + (i + 1);
			subBoardContainer.appendChild(createSubBoard(i,id,oPos,isHor));
		}
		bCtn.appendChild(subBoardContainer);
	}
	bCtn.appendChild(portContainer);
	if(2 == board.boardState)
	{
		portContainer.setAttribute("display", "none");
	}
	
	if(board.loopback && pInt(board.loopback) > 0)
	{
		bCtn.appendChild(createLoopback(oPos, board.loopback));
	}
	if(board.boardPG && pInt(board.boardPG) > 0)
	{
		bCtn.appendChild(createBackState(board,oPos));
	}
	slot.parentNode.appendChild(bCtn);
	paintSubBoardView(board,0);
}

function paintSubBoardView(board,flag)
{
	for(var i = 0,len = board.subBoardList.length;i < len;i++)
	{
	
		var subBoardList = [];
		if(typeof(board.subBoardList[i]) == "object")
		{	
			subBoardList[subBoardList.length] = board.subBoardList[i].neID;
			subBoardList[subBoardList.length] = board.subBoardList[i].subBoardState;
			subBoardList[subBoardList.length] = board.subBoardList[i].subBoardName;
			subBoardList[subBoardList.length] = board.subBoardList[i].subBoardType;
			subBoardList[subBoardList.length] = board.subBoardList[i].subSlotID;
		}
		else
		{	
			subBoardList = convertSubBoardStrToList(board.subBoardList[i],1);	
		}
		var id = board.slotId + "." + subBoardList[4];
		var index = subBoardList[4] - 1;
		
		if(flag == 0)
		{
			paintSubBoard(index,id,subBoardList,board.slotId);
		}else if(flag == 1)
		{
			modifySubBoard(index,id,subBoardList,board.slotId);
		}
	}
}
/**
 *            
 * 
 * @param board1
 * @param board2
 * @returns {Boolean}
 */
function needRefreshBoardState(board1,board2)
{
	if(board1 && board2)
	{
		if(board1.slotId == board2.slotId
			&& board1.boardType == board2.boardType
			&& board1.boardState != board2.boardState)
		{
			return true;
		}
	}
	return false;
}

/**
 *            
 * 
 * @param board1
 * @param board2
 * @returns {Boolean}
 */
function needRefreshBoardAlarm(board1,board2)
{
	if(board1 && board2)
	{
		if(board1.slotId == board2.slotId
			&& board1.boardType == board2.boardType
			&& board1.alarmLevel != board2.alarmLevel)
		{
			return true;
		}
	}
	return false;
}

/**
 *             
 * 
 * @param board1
 * @param board2
 * @returns {Boolean}
 */
function needRefreshBoardLoopback(board1,board2)
{
	if(board1 && board2)
	{
		if(board1.slotId == board2.slotId
			&& board1.boardType == board2.boardType
			&& board1.loopback != board2.loopback)
		{
			return true;
		}
	}
	return false;
}

/**
 *             
 * 
 * @param board1
 * @param board2
 */
function needRefreshBoardPG(board1, board2)
{
	if(board1 && board2)
	{
		if(board1.slotId == board2.slotId
			&& board1.boardType == board2.boardType
			&& board1.boardPG != board2.boardPG)
		{
			return true;
		}
	}
	return false;
}

/**
 *                                         
 * 
 * @param board
 * @param oboard
 */
function needRefreshPortStateAlarm(board1,board2)
{
	if(board1 && board2)
	{
		if(board1.slotId == board2.slotId
			&& board1.boardType == board2.boardType
			&& !comparePortListObj(board1, board2))
		{
			return true;
		}
	}
	return false;
}

/**
 *                                              
 * 
 * @param board
 */
function refreshBoardsState(board)
{
	var id = BOARD_PREFIX + board.slotId + BOARD_POSTFIX;
	var oldchild = getSVGElement(id);
	if(oldchild)
	{
		oldchild.style.setProperty("fill",getBoardColor(board.boardState),"important");
	}
	
	var card = getSVGElement(BOARD_PREFIX + board.slotId);
    var childs = card.childNodes;
    var child;
	if(2 == board.boardState)
	{
	    for(var i = 0, len = childs.length; i < len; i++)
	    {
	    	child = childs.item(i);
	    	if("circle" == child.nodeName && "1" == child.getAttribute("alarm"))
	    	{
	    		child.setAttribute("display", "none");
	    	}
	    	if("svg" == child.nodeName && "1" == child.getAttribute("portlist"))
        	{
        		child.setAttribute("display", "none");
        	}
	    }
	}
	else if(3 == board.boardState)
	{
		var hasPort = false;
	    for(var i = 0, len = childs.length; i < len; i++)
	    {
	    	child = childs.item(i);
	    	if("circle" == child.nodeName && "1" == child.getAttribute("alarm"))
	    	{
	    		child.setAttribute("display", "");
	    	}
	    	if("svg" == child.nodeName && "1" == child.getAttribute("portlist"))
        	{
	    		hasPort = true;
        		child.setAttribute("display", "");
        	}
	    }	
	    if(!hasPort && board.portList.length > 0)
	    {
	    	var portContainer = createSVGElement("svg");
	     	var oPos = calcBoardPostion(board);
	    	var portContainerPos = calPortContainerPos(board,oPos);
	    	attr(portContainer,portContainerPos);
	    	portContainer.setAttribute("portlist", "1");
	    	var isHor = oPos.width > oPos.height;
	    	for(var i = 0,len = board.portList.length;i < len;i++)
	    	{
	    		if(i > PORT_MAX_NUMBER_COLUMN)
	    		{
	    			break;
	    		}
	    		var portId = board.portList[i];
	    		var id = BOARD_PREFIX + board.slotId + PORT_PREFIX + portId;
	    		portContainer.appendChild(createPort(i,id,isHor));
	    	}
	    	card.appendChild(portContainer);
	    }
	}
}

/**
 *         (      )
 * 
 * @param board
 */
function refreshBoardsAlarmFromJava(slotIDAlaram)
{
	var attrs = slotIDAlaram.split("-");
    var slotID = attrs[0];
    var pair = parseBigSlotId(slotID);
    var shId = pair[0];
    slotID = pair[1];
    var alarmLevel = pInt(attrs[1]);
    if(shelfID == shId)
    {
        var id = BOARD_PREFIX + slotID;
    	var g = getSVGElement(id);
    	if(g)
    	{
    		var board = JSON.parse(g.getAttribute("oboard"));
    	    board.alarmLevel = alarmLevel;
    	    refreshBoardsAlarm(board);
    	    g.setAttribute("oboard",JSON.stringify(board));
    	}
    }
}


/**
 *         
 * 
 * @param board
 */
function refreshBoardsAlarm(board)
{
	var id = BOARD_PREFIX + board.slotId;
	var g = getSVGElement(id);
	if(g)
	{
        var childs = g.childNodes;
        var child;
        for(var i = 0, len = childs.length; i < len; i++)
        {
        	child = childs.item(i);
        	if(child.nodeName == "circle" && "1" == child.getAttribute("alarm"))
        	{
        		if(0 == SYSTEMCONF.getStatus())
        		{
        			child.style.setProperty("fill","url(#radial"  + board.alarmLevel + ")","important");
        		}
        		else
        		{
        			child.style.setProperty("fill",getAlarmColor(board.alarmLevel),"important");
        		}
        		break;
        	}
        }
	}
	if(clickedSlot == board.slotId)
	{
		var ele = getSVGElement(BOARD_SHOW_ID);
		if(null != ele)
		{
			var childs = ele.childNodes;
			var child;
			for(var i =0, len = childs.length; i < len; i++)
			{
				child = childs.item(i);
				if("circle" == child.nodeName && "1" == child.getAttribute("alarm"))
				{
					if(0 == SYSTEMCONF.getStatus())
	        		{
	        			child.style.setProperty("fill","url(#radial"  + board.alarmLevel + ")","important");
	        		}
	        		else
	        		{
	        			child.style.setProperty("fill",getAlarmColor(board.alarmLevel),"important");
	        		}
				}				
			}
		}
	}
}

/**
 *         
 * 
 * @param board
 */
function refreshBoardsLoopback(board)
{
	var id = BOARD_PREFIX + board.slotId;
	var g = getSVGElement(id);
	if(null != g)
	{
		var childs = g.childNodes;
		var child;
		for(var k = (childs.length - 1); k >= 0; k--)
		{
			child  = childs.item(k);
			if("g" == child.nodeName && "1" == child.getAttribute("loopback"))
			{
				g.removeChild(child);
				break;
			}
		}
		if(board.loopback > 0)
		{
			var oPos = calcBoardPostion(board);
			g.appendChild(createLoopback(oPos, board.loopback));
		}
	}
}

/**
 *                     
 * 
 * @param param
 */
function refreshBoardsLoopbackInter(param)
{
	if(null != param && typeof(param) != undefined && '' != param)
	{
		var obj = JSON.parse(param);
		if(null != obj)
		{
			var neId = obj.neId;
			var slotId = obj.slotId;
			var pair = parseBigSlotId(slotId);
		    var shId = pair[0];
		    slotId = pair[1];
			if(neid == neId && shelfID == shId)
			{
				if(null != obj.boardloopback)
				{
					var board = new BoardDesObj();
					board.slotId = slotId;
					board.loopback = obj.boardloopback;
					refreshBoardsLoopback(board);
				}
				if(slotId == clickedSlot)
				{
				    var loopList = obj.loopbackList;
				    var loopObj;
					var portId;
					var loopType;
					var type;
					var id;
					for(var i = 0, size = loopList.length; i < size; i++)
					{
						loopObj = loopList[i];
						portId = loopObj.portId;
						loopType = loopObj.loopback;
						type = loopObj.type;
						id = loopObj.id;
						if(0 == type)
						{
							refreshPortLoopback(slotId, portId, loopType);
						}
						else if(portId == clickedPort)
						{
							var pathContainer = getSVGElement("pathView");
							if(null != pathContainer)
							{
								var pathEle = getSVGElement("pathviewchild" + id);
								if(null != pathEle)
								{
									var child;
									for(var j = 0, len = pathEle.childNodes.length; j < len; j++)
									{
										child = pathEle.childNodes.item(j);
										if(("g" == child.nodeName) && ("1" == child.getAttribute("loopback")))
										{
											pathEle.removeChild(child);
											break;
										}
									}
									var pPos = {width:20,height:20};
									pathEle.appendChild(createLoopback(pPos, loopType));
								}														
							}
							var pathList = JSON.parse(pathContainer.getAttribute("opath"));
							if(null != pathList)
							{
								for(var j = 0, len = pathList.length; j < len; j++)
								{
									if(pathList[j].id == id)
									{
										pathList[j].loopback = loopType;
										pathContainer.setAttribute("opath",JSON.stringify(pathList));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

/**
 *          
 */
function refreshPortLoopback(slotId, portId, loopType)
{
	var id = SHOW_BOARD_PREFIX + slotId + PORT_PREFIX + portId + PORT_RECT;
	var ele = getSVGElement(id);
	if(null != ele)
	{
		var childs = ele.childNodes;
		var child;
		for(var i = 0, len = childs.length; i < len; i++)
		{
			child = childs.item(i);
			if(("g" == child.nodeName) && ("1" == child.getAttribute("loopback")))
			{
				ele.removeChild(child);
				break;
			}
		}
		if(loopType > 0)
		{
			var pPos = {x:0,y:0,width:0,height:0};
			pPos.width = ele.getAttribute("width");
			pPos.height = ele.getAttribute("height");
			ele.appendChild(createLoopback(pPos, loopType));
		}
		
		if(portId == clickedPort)
		{
			var pathContainer = getSVGElement("pathView");
			if(null != pathContainer)
			{
				var childs = pathContainer.childNodes;
				var child = null;
				for(var i = 0, len = childs.length; i < len; i++)
				{
					child = childs.item(i);
					if(child.nodeName == "svg")
					{
						var item = null;
						var nodes = child.childNodes;
						for(var j = 0, size = nodes.length; j < size; j++)
						{
							item = nodes.item(j);
							if(("g" == item.nodeName) && ("1" == item.getAttribute("loopback")))
							{
								child.removeChild(item);
								break;
							}
						}
						if(loopType > 0)
						{
							var pPos = {width:20,height:20};
							child.appendChild(createLoopback(pPos, loopType));
						}
						break;
					}
				}
			}
		}
	}
}

/**
U2000      web         
*/
function openWebPanelWithPortSelected(param)
{
    if((null != param) && ("" != param))
    {
        var obj = JSON.parse(param);
		if(null != obj)
		{
			var neId = obj.neId;
			var slotId = obj.slotId;
			var portId = obj.portId;
			if(slotId > -1)
			{
				var pair = parseBigSlotId(slotId);
		    	var shId = pair[0];
		    	slotId = pair[1];
				if((neid == neId) && (shelfID == shId))
				{
			    	var id = BOARD_PREFIX + slotId;
	            	var board = getSVGElement(id);
	            	if((null != board) && (slotId != clickedSlot))
	            	{				
						if(currentSelectBoard)
						{
							var ele = getSVGElement(currentSelectBoard.getAttribute("rectid"));
							if(null != ele)
							{
								ele.setAttribute("class","SlotPhy");
							}
							currentSelectBoard = null;
						}
						if(currentSelectSlot)
						{
							setSlotRectClass(currentSelectSlot,"Slot");
						}
						destroyShowBoard(); //          
						
						var ele = getSVGElement(board.getAttribute("rectid"));
						if(null != ele)
						{			
							ele.setAttribute("class","SlotPhySelectInteger");
						}
						currentSelectBoard = board;
						clickedSlot = slotId;
						clickedPort = -1;
						clickedPath = -1;
	            	}
				}
			}
		}
    }
}

/**
 *         
 */
function paintBoardDesFromJava(param)
{
	if(null != param && typeof(param) != undefined && '' != param)
	{
		var attrs = param.split('-');
		var slotId = pInt(attrs[0]);
		var pair = parseBigSlotId(slotId);
	    var shId = pair[0];
	    slotId = pair[1];
		if(shelfID == shId)
		{
			var comments = getSVGElement(BOARD_DESC_ID);
			if(comments)
			{
				comments.parentNode.removeChild(comments);
			}
			var ele = getSVGElement(BOARD_PREFIX + clickedSlot)
		    if(null != ele)
		    {
		    	var oboard = JSON.parse(ele.getAttribute("oboard"));
		    	if(null != oboard)
		    	{
		    		var index = param.indexOf('-');
		    		var comments = param.substring(index + 1);
					var portNum = oboard.portList.length;
					var x = SHOW_BOARD_COMMENTS_X;
					if(portNum > PORT_MAX_NUMBER_COLUMN)
					{
						x += BAR_WIDTH_DELTA;
					}
		    		var oPos = {x:x,y:SHOW_BOARD_COMMENTS_Y + 60,width:SHOW_BOARD_COMMENTS_WIDTH,height:SHOW_BOARD_COMMENTS_HEIGHT};
		    		paintBoardComments(oPos, BOARD_DESC_ID, comments, 100);
		    	}
		    }
		}
	}
}

/**
 *         
 * 
 * @param board
 */
function refreshBoardsPG(board)
{
	var id = BOARD_PREFIX + board.slotId;
	var g = getSVGElement(id);
	if(null != g)
	{
		if(board.boardPG > 0)
		{
			var oPos = calcBoardPostion(board);
			g.appendChild(createBackState(board, oPos));
		}
		else 
		{
			var childs = g.childNodes;
			var child;
			for(var k = (childs.length - 1); k >= 0; k--)
			{
				child  = childs.item(k);
				if("text" == child.nodeName && "1" == child.getAttribute("boardPG"))
				{
					g.removeChild(child);
					break;
				}
			}
		}
	}
}

/**
 *                                                                      
 * 
 * @param board
 * @param oboard
 */
function refreshPortStateAlarm(board, oboard)
{
	var portList = board.portList;
	var oPortList = oboard.portList;
	var slotId = board.slotId;
	var port;
	var oport;
	var id;
	var ele;
	var color;
	var childs;
	var child;
	var portNum = portList.length;
	for(var i = 0; i < portNum; i++)
	{
		port = portList[i];	
		id = BOARD_PREFIX + slotId + PORT_PREFIX + port.portId;
		ele = getSVGElement(id);
		if(null != ele)
		{
			color = getPortColor(port.portState, port.alarmLevel);
			childs = ele.childNodes;
			for(var j =0, len = childs.length; j < len; j++)
			{
				child = childs.item(j);
				if("rect" == child.nodeName && "1" == child.getAttribute("port"))
				{
					child.style.setProperty("fill",color,"important");
				}				
			}
		}
	}
	if(clickedSlot == board.slotId)
	{
		for(var i = 0; i < portNum; i++)
		{
			port = portList[i];
			id = SHOW_BOARD_PREFIX + slotId + PORT_PREFIX + port.portId;
			ele = getSVGElement(id + PORT_RECT);
			if(null != ele)
			{
				ele.setAttribute("oport",JSON.stringify(extendObj(port,{slotId:slotId,boardName:board.boardName,portNum:portNum})));
			}
			oport = oPortList[i];		
			ele = getSVGElement(id + PORT_EXTEND);
			if(null != ele)
			{
				color = getPortColor(port.portState, port.alarmLevel);
				childs = ele.childNodes;
				for(var j = 0, len = childs.length; j < len; j++)
				{
					child = childs.item(j);
					if("polygon" == child.nodeName)
					{
						child.style.setProperty("fill",color,"important");
					}				
				}
			}
			if(port.portType != oport.portType)
			{
				ele = getSVGElement(id);
				if(null != ele)
				{
					var pos = JSON.parse(ele.getAttribute("oportrect"));
					var pPos = {x:0,y:0,width:pos.width * 0.5,height:pos.height};
					var pnode = getSVGElement(id + PORT_RECT);
					var ochild = getSVGElement(id + PORT_EXTEND);
					if(null != ochild)
					{
						var nchild = createPortElement(port, pPos, id + PORT_EXTEND);
						pnode.replaceChild(nchild, ochild);
					}
				}
			}
			if(port.loopback != oport.loopback)
			{
			}
		}
	}
}

/**
 *              
 * 
 * @param param
 *            slotId,portId,alarmLevel
 */
function refreshPortStateAlarmInter(param)
{
	if(null == param || "" == param)
	{
	    return ;
	}
	var attrs = param.split("-");
	var slotId = pInt(attrs[0]);
    var pair = parseBigSlotId(slotId);
    var shId = pair[0];
    slotId = pair[1];
	var portId = pInt(attrs[1]);
	var alarmLevel = pInt(attrs[2]);
	if(shelfID == shId)
	{
		var id = BOARD_PREFIX + slotId + PORT_PREFIX + portId;
		var	ele = getSVGElement(id);
		if(null != ele)
		{
			color = getPortColor(1, alarmLevel);
			childs = ele.childNodes;
			for(var j =0, len = childs.length; j < len; j++)
			{
				child = childs.item(j);
				if("rect" == child.nodeName && "1" == child.getAttribute("port"))
				{
					child.style.setProperty("fill",color,"important");
					break;
				}				
			}
			ele.setAttribute("alarmLevel",alarmLevel);
		}

		if(clickedSlot == slotId)
		{
			id = SHOW_BOARD_PREFIX + slotId + PORT_PREFIX + portId;	
			ele = getSVGElement(id + PORT_RECT);
			if(null != ele)
			{
				var oport = JSON.parse(ele.getAttribute("oport"));
				if(0 == oport.portState)
				{					
					return;
				}
			}
			ele = getSVGElement(id + PORT_EXTEND);
			if(null != ele)
			{
				color = getPortColor(1, alarmLevel);
				childs = ele.childNodes;
				for(var j = 0, len = childs.length; j < len; j++)
				{
					child = childs.item(j);
					if("polygon" == child.nodeName)
					{
						child.style.setProperty("fill",color,"important");
					}				
				}
			}
		}
	}
}

/**
 *            
 */
function refreshPathAlarmInter(param)
{
	if(null == param || "" == param)
	{
	    return ;
	}
	var attrs = param.split("-");
	var slotId = pInt(attrs[0]);
    var pair = parseBigSlotId(slotId);
    var shId = pair[0];
    slotId = pair[1];
	var pathId = attrs[1];
	var alarmLevel = pInt(attrs[2]);
	if(shelfID == shId)
	{
		var ele = getSVGElement("pathviewchild" + pathId);	
		if(null != ele)
		{
			var childs = ele.childNodes;
			var child;
			var color;
			for(var j = 0, jLen = childs.length; j < jLen; j++)
			{
				child = childs.item(j);
				if("circle" == child.nodeName)
				{
					color = getAlarmColor(alarmLevel);
					child.style.setProperty("fill",color,"important");
					break;
				}
			}
		}
		var ochild = getSVGElement("pathView");
		if(null != ochild)
		{
			var pathList = JSON.parse(ochild.getAttribute("opath"));
			for(var i = 0, len = pathList.length; i < len; i++)
			{
				if(pathId == pathList[i].id)
				{			
					pathList[i].alarmLevel = alarmLevel;
					ochild.setAttribute("opath", JSON.stringify(pathList));
					break;
				}
			}
		}
	}
}

/**
 *            
 * 
 * @param param
 */
function refreshPortStateInter(param)
{
	if(null == param || "" == param)
	{
	    return ;
	}
	var attrs = param.split("-");
	var slotId = pInt(attrs[0]);
	if(currentDeletePortSlotId == slotId)
	{
		return ;
	}
    var pair = parseBigSlotId(slotId);
    var shId = pair[0];
    slotId = pair[1];
	var portId = attrs[1];
	var portState = pInt(attrs[2]);
	if(shelfID == shId)
	{
		if(clickedSlot == slotId)
		{
			var id = SHOW_BOARD_PREFIX + slotId + PORT_PREFIX + portId;
			var ele = getSVGElement(id + PORT_RECT);
			if(null != ele)
			{
				var oport = ele.getAttribute("oport");
				oport = JSON.parse(oport);
				oport.portState = portState;
				ele.setAttribute("oport", JSON.stringify(oport));
				
				ele = getSVGElement(id + PORT_EXTEND);
				if(null != ele)
				{
					color = getPortColor(oport.portState, oport.alarmLevel);
					childs = ele.childNodes;
					for(var j = 0, len = childs.length; j < len; j++)
					{
						child = childs.item(j);
						if("polygon" == child.nodeName)
						{
							child.style.setProperty("fill",color,"important");
						}				
					}
				}
				if(portId == clickedPort && 0 == portState)
				{
					clickedPort = -1;
					clickedPath = -1;
					lastClickedSlot = -1;
					refreshPathView();
					isServiceAccessiable(1);
					$("deletebtn").disabled = true;
			        $("deletebtn").setAttribute("deleteTarget", null);
			        $("deletebtn").className = "myborder1";
					
			    	var portComments = getSVGElement(PORT_COMMENTS_ID);
			    	if(portComments)
			    	{
			    		portComments.parentNode.removeChild(portComments);
			    	}
					var page = getSVGElement(PATH_PAGE_TIP);
					if(page)
					{
						page.parentNode.removeChild(page);
					}
				}
			}					
		}
	}
}

/**
 *      
 */
function refreshPathView()
{
	var pathContainer = getSVGElement("pathView");
	if(pathContainer)
	{
		var cancelAlarm = pathContainer.getAttribute("cancelAlarm");
		var pathSlotId = pathContainer.getAttribute("slotId");
		if(((-1 == lastClickedSlot) && ('0' == cancelAlarm)) || ('1' == cancelAlarm))
		{
			if(-1 == lastClickedSlot)
			{
				document.location="wrui://pathViewUnregAlarm&slotID=" + convertSlotToBigSlot(clickedSlot); 
			}
			else
			{
				document.location="wrui://pathViewUnregAlarm&slotID=" + convertSlotToBigSlot(lastClickedSlot); 
			}
		} 
		if(clickedSlot != pathSlotId)
		{
			
		}
		while(pathContainer.childNodes.length > 0)
		{
			pathContainer.removeChild(pathContainer.firstChild);
		}
		var line = getSVGElement("pathViewLine");
		if(line)
		{
			line.parentNode.removeChild(line);
		}
	}
}

/**
 *                   
 */
function refreshRunningBoardColor(color)
{
	customizeRunningBoardColor = color;
	var slotId = -1;
	var bele;
	for(var i = 0, len = runningBoardList.length; i < len; i++)
	{
		slotId = runningBoardList[i];
		bele = getSVGElement(BOARD_PREFIX + slotId + BOARD_POSTFIX);
		if(null != bele)
		{
			bele.style.setProperty("fill",getRunningBoardColor(),"important");
			break;
		}
	}
}

/**
 *               
 */
function refreshSelfDefBoardAlarm(param)
{
	if(null == param || "" == param)
	{
	    return ;
	}
	var maps = param.split(",");
	var obj = new Object();
	for(var i = 0, len = maps.length; i < len; i++)
	{
		var arr = maps[i].split("=");
		obj[arr[0]] = arr[1];
		arr = null;
	}
	boardAlarmCritical = obj["criticalColor"];
	boardAlarmMajor = obj["majorColor"];
	boardAlramMinor = obj["minorColor"];
	boardAlarmWarning = obj["waningColor"];
	boardAlarmNormal = obj["normalColor"];
	boardAlarmUnknown = obj["unkownColor"];
	boardAlarmCommBreak = obj["commBreakColor"];
	boardAlarmNotReport = obj["notReportlColor"];
	var board;
	var childs;
	var child;
	var slotId;
	var portList;
	var port;
	var id;
	var ele;
	var alarmLevel;
	var color;
	for(var i = 0, len = installedSlotList.length; i < len; i++)
	{
		board = getSVGElement(BOARD_PREFIX + installedSlotList[i]);
		if(null != board)
		{
			var oboard = JSON.parse(board.getAttribute("oboard"));			
			color = getAlarmColor(oboard.alarmLevel);
			for(var j = 0, jLen = board.childNodes.length; j < jLen; j++)
			{
				child = board.childNodes.item(j);
				if("circle" == child.nodeName && "1" == child.getAttribute("alarm"))
				{
					child.style.setProperty("fill",color,"important");
					break;
				}
			}
			
			portList = oboard.portList;
			slotId = oboard.slotId;
			for(var j = 0, jLen = portList.length; j < jLen; j++)
			{	
				port = portList[j];
				id = BOARD_PREFIX + slotId + PORT_PREFIX + port.portId;
				ele = getSVGElement(id);
				if(null != ele)
				{
					alarmLevel = ele.getAttribute("alarmLevel");					
					color = getAlarmColor(pInt(alarmLevel));
					childs = ele.childNodes;
					for(var k = 0, kLen = childs.length; k < kLen; k++)
					{
						child = childs.item(k);
						if("rect" == child.nodeName && "1" == child.getAttribute("port"))
						{
							child.style.setProperty("fill",color,"important");
							break;
						}				
					}
				}				
			}
		}
		if(clickedSlot == installedSlotList[i])
		{
			ele = getSVGElement(BOARD_SHOW_ID);
			if(null != ele)
			{				
				color = getAlarmColor(oboard.alarmLevel);
				for(var j = 0, jLen = ele.childNodes.length; j < jLen; j++)
				{
					child = ele.childNodes.item(j);
					if("circle" == child.nodeName && "1" == child.getAttribute("alarm"))
					{
						child.style.setProperty("fill",color,"important");
						break;
					}
				}
				var oboard = JSON.parse(ele.getAttribute("oboard"));
				portList = oboard.portList;
				for(var j = 0, jLen = portList.length; j < jLen; j++)
				{
					port = portList[j];
					id = BOARD_PREFIX + slotId + PORT_PREFIX + port.portId;
					ele = getSVGElement(id);
					alarmLevel = ele.getAttribute("alarmLevel");
					id = SHOW_BOARD_PREFIX + slotId + PORT_PREFIX + port.portId;					
					ele = getSVGElement(id + PORT_EXTEND);
					if(null != ele)
					{
						color = getPortColor(port.portState, pInt(alarmLevel));
						childs = ele.childNodes;
						for(var k = 0, kLen = childs.length; k < kLen; k++)
						{
							child = childs.item(k);
							if("polygon" == child.nodeName)
							{
								child.style.setProperty("fill",color,"important");
							}				
						}
					}
					if(clickedPort == port.portId)
					{
						var pathTree = getSVGElement("pathView");
						if(null != pathTree)
						{
							var pathList = JSON.parse(pathTree.getAttribute("opath"));
							var path;
							for(var k = 0, kLen = pathList.length; k < kLen; k++)
							{
								path = pathList[k];
								ele = getSVGElement("pathviewchild" + path.id);
								if(null != ele)
								{
									childs = ele.childNodes;							
									for(var m = 0, mLen = childs.length; m < mLen; m++)
									{
										child = childs.item(m);
										if("circle" == child.nodeName)
										{
											color = getAlarmColor(pInt(path.alarmLevel));
											child.style.setProperty("fill",color,"important");
											break;
										}
									}
								}								
							}
						}
					}
				}
			}			
		}
	}
}

/**
 *            
 */
function refreshPortColor(slotid, portid)
{
	slotid = convertBigSlotToSlot(slotid);
	var id = SHOW_BOARD_PREFIX + slotid + PORT_PREFIX + portid;
	var ele = getSVGElement(id + PORT_EXTEND);
	if(null != ele)
	{
		var color = getPortColor(1,7);
		var childs = ele.childNodes;
		for(var i = 0, len = childs.length; i < len; i++)
		{
			child = childs.item(i);
			if("polygon" == child.nodeName)
			{
				child.style.setProperty("fill",color,"important");
			}				
		}
	}
	ele = getSVGElement(id + PORT_RECT);
	if(null != ele)
	{
		var oport = JSON.parse(ele.getAttribute("oport"));
		oport.portState = 1;
		ele.setAttribute("oport",JSON.stringify(oport));
	}
}

/**
 *              
 */
function updateBoardCommentsInteger(param)
{
	if(null != param && typeof(param) != undefined && '' != param)
	{
		var attrs = param.split('-');
		var neId = attrs[0];
		var slotId = pInt(attrs[1]);
		var pair = parseBigSlotId(slotId);
	    var shId = pair[0];
	    slotId = pair[1];
		if(neid == neId && shelfID == shId)
		{
			var comments = getSVGElement(BOARD_COMMENTS_ID);
			if(comments)
			{
				comments.parentNode.removeChild(comments);
			}
			var ele = getSVGElement(BOARD_PREFIX + clickedSlot)
		    if(null != ele)
		    {
		    	var oboard = JSON.parse(ele.getAttribute("oboard"));
		    	if(null != oboard)
		    	{
		    		var index = param.indexOf('-');
		    		var substr = param.substring(index + 1);
		    		index = substr.indexOf('-');
		    		var comments = RESOURCE["boardremark"] + substr.substring(index + 1);
					var portNum = oboard.portList.length;
					var x = SHOW_BOARD_COMMENTS_X;
					if(portNum > PORT_MAX_NUMBER_COLUMN)
					{
						x += BAR_WIDTH_DELTA;
					}
		    		var oPos = {x:x,y:SHOW_BOARD_COMMENTS_Y,width:SHOW_BOARD_COMMENTS_WIDTH,height:SHOW_BOARD_COMMENTS_HEIGHT};
		    		paintBoardComments(oPos, BOARD_COMMENTS_ID, comments, 40);
		    	}
		    }
		}
	}
}

/**
 *         
 */
function paintBoardDesFromJava(param)
{
	if(null != param && typeof(param) != undefined && '' != param)
	{
		var attrs = param.split('-');
		var slotId = pInt(attrs[0]);
		var pair = parseBigSlotId(slotId);
	    var shId = pair[0];
	    slotId = pair[1];
		if(shelfID == shId)
		{
			var comments = getSVGElement(BOARD_DESC_ID);
			if(comments)
			{
				comments.parentNode.removeChild(comments);
			}
			var ele = getSVGElement(BOARD_PREFIX + clickedSlot)
		    if(null != ele)
		    {
		    	var oboard = JSON.parse(ele.getAttribute("oboard"));
		    	if(null != oboard)
		    	{
		    		var index = param.indexOf('-');
		    		var comments = param.substring(index + 1);
					var portNum = oboard.portList.length;
					var x = SHOW_BOARD_COMMENTS_X;
					if(portNum > PORT_MAX_NUMBER_COLUMN)
					{
						x += BAR_WIDTH_DELTA;
					}
		    		var oPos = {x:x,y:SHOW_BOARD_COMMENTS_Y + 60,width:SHOW_BOARD_COMMENTS_WIDTH,height:SHOW_BOARD_COMMENTS_HEIGHT};
		    		paintBoardComments(oPos, BOARD_DESC_ID, comments, 100);
		    	}
		    }
		}
	}
}

/**
 *       
 * 
 * @param board
 * @param oPos
 * @param bCtn
 * @return
 */
function createBackState(/* Object */ board ,/* Object */ oPos )
{
	var backText = createSVGElement("text");
	var textPos = {x:0,y:0};

	if(oPos.width > oPos.height)
	{
		textPos.x = oPos.width - 10;
		textPos.y = oPos.height - 1;
	}
	else
	{
		textPos.y = oPos.height - 10;
	}
	backText.appendChild(createSVGText("S"));
	attr(backText,textPos);
	backText.setAttribute("boardPG", "1");
	backText.setAttribute("class","Backstate");
	backText.setAttribute("id",STANDBY_STATE_PREFIX + board.slotId);
	return backText;
}

/**
 *       
 * 
 * @param oPos
 * @param loopback:0   
 *            1     2    
 * @return
 */
function createLoopback(/* Object */ oPos, /* num */loopback)
{
	var g = createSVGElement("g");
	g.setAttribute("loopback", "1");
	var pT2 = createSVGElement("path");
	var pT3 = createSVGElement("path");
	
	pT2.setAttribute("class","ShowSlotPortLP");
	pT3.setAttribute("class","ShowSlotPortLP");
	var data1;
	var data2;
	var x1;
	var x2;
	var y1; 
	var y2;
	switch(loopback)
	{
	case 1:
		if(oPos.width > oPos.height)
		{
			x1 = oPos.width - 4;
			x2 = oPos.width;
			y1 = oPos.height;
			y2 = oPos.height - 4;
			data1 = "M" + x1 + "," + y1 + " A4,4 0 0,1 " + x2 + "," + y2;
			x1 = oPos.width - 8;
			y2 = oPos.height - 8;
			data2 = "M" + x1 + "," + y1 + " A8,8 0 0,1 " + x2 + "," + y2;
		}
		else
		{
			y1 = oPos.height - 6;
			y2 = oPos.height - 2;
			data1 = "M1," + y1 + " A4,4 0 0,1 5," + y2;
			y1 = oPos.height - 10;
			data2 = "M1," + y1 + " A8,8 0 0,1 9," + y2;
		}
		break;
	case 2:
		if(oPos.width > oPos.height)
		{
			x1 = oPos.width - 4;
			x2 = oPos.width;
			y1 = oPos.height;
			y2 = oPos.height - 4;
			data1 = "M" + x1 + "," + y1 + " A4,4 0 0,0 " + x2 + "," + y2;
			x1 = oPos.width - 12;
			y2 = oPos.height - 12;
			data2 = "M" + x1 + "," + y1 + " A12,12 0 0,0 " + x2 + "," + y2;
		}
		else
		{
			y1 = oPos.height - 6;
			y2 = oPos.height - 2;
			data1 = "M1," + y1 + " A4,4 0 0,0 5," + y2;
			y1 = oPos.height - 14;
			data2 = "M1," + y1 + " A12,12 0 0,0 12," + y2;
		}
		break;
	default:
		break;
	}
	
	attr(pT2,{d:data1});
	attr(pT3,{d:data2});
	g.appendChild(pT2);
	g.appendChild(pT3);
	
	return g;
}

/**
 *         
 * 
 * @param board
 * @param bPos
 * @param aPos
 * @returns
 */
function createBoardText(/* Object */board,/* Object */bPos,/* Object */aPos)
{
	var boardtext = createSVGElement("text");
	var textPos = {x:0,y:0};

	if(bPos.width < bPos.height)
	{
		textPos.y = aPos.r + aPos.cy;
		var tsize = board.boardName.length;
		if(tsize * BOARD_NAME_FONT_SIZE > bPos.height)
		{
			return;
		}
		var wordLen = BOARD_NAME_FONT_SIZE;
		var x = 0.5;
		if(65 == bPos.height)
		{
			x = (bPos.width - wordLen) / 2;
		}
		for ( var i = 0; i < tsize; i++)
		{
			var tspan = createSVGElement("tspan");
			var ch = board.boardName.charAt(i);
			tspan.appendChild(createSVGText(ch));
			tspan.setAttribute("x", x);
			if("I" == ch)
			{
				tspan.setAttribute("x", x + 2);
			}			
			tspan.setAttribute("dy",wordLen + 1);
			setFontSize(tspan,wordLen);
			boardtext.appendChild(tspan);
		}
	}
	else
	{
		textPos = {x:16.5,y:((bPos.height - BOARD_NAME_FONT_SIZE_HOR)/2 + BOARD_NAME_FONT_SIZE_HOR )};
		boardtext.appendChild(createSVGText(board.boardName));
		setFontSize(boardtext,BOARD_NAME_FONT_SIZE_HOR);
	}
	attr(boardtext,textPos);
	boardtext.setAttribute("class","boardtext");
	return boardtext;
}

/**
 *           
 * 
 * @param board
 * @param bPos
 * @returns
 */
function createSubBoardText(/* Object */board,/* Object */bPos)
{
	var boardtext = createSVGElement("text");
	var textPos = {x:0,y:0};

	if(bPos.width < bPos.height)
	{
		var tsize = board[2].length;

		var wordLen = 6;
		var x = 0.5;
		if(65 == bPos.height)
		{
			x = (bPos.width - wordLen) / 2;
		}
		for ( var i = 0; i < tsize; i++)
		{
			var tspan = createSVGElement("tspan");
			var ch = board[2].charAt(i);
			tspan.appendChild(createSVGText(ch));
			tspan.setAttribute("x", x);
			if("I" == ch)
			{
				tspan.setAttribute("x", x + 2);
			}			
			tspan.setAttribute("dy",wordLen + 1);
			setFontSize(tspan,wordLen);
			boardtext.appendChild(tspan);
		}
	}
	else
	{
		textPos = {x:18,y:((bPos.height - BOARD_NAME_FONT_SIZE_HOR)/2 + BOARD_NAME_FONT_SIZE_HOR )};
		boardtext.appendChild(createSVGText(board[2]));
		setFontSize(boardtext,BOARD_NAME_FONT_SIZE_HOR);
	}
	attr(boardtext,textPos);
	boardtext.setAttribute("class","boardtext");
	return boardtext;
}

/**
 *            
 * 
 * @param board
 * @param bPos
 * @param aPos
 * @returns
 */
function createPortListBarNameText(/* Object */bCtn,/* Object */board,/* Object */bPos,/* Object */aPos)
{	
	var boardtext;
	var content = board.boardName;
	var tsize = content.length;
	var textRow = calBoardTextRow(board);
	var boardName;
	for(i = 1;i <= textRow;i++)
	{
		var start = (i - 1) * 4;
		var end = i * 4;
		boardName = content.substring(start,end);
		boardtext = createSVGElement("text");
		var textPos = {x:0,y:0};
		textPos.x = bPos.width * 0.55 - 2 * BOARD_NAME_FONT_SIZE;
		textPos.y = aPos.r + aPos.cy + i * 20;
	    attr(boardtext,textPos);
		boardtext.appendChild(createSVGText(boardName));
		var wordLen = BOARD_NAME_FONT_SIZE + 5;
		if(isFF)
		{
			setFontSize(boardtext, wordLen - 2);
		}
		else
		{
			setFontSize(boardtext, wordLen);
		}
		bCtn.appendChild(boardtext);
	}
	return textRow;
}

/**
 *          4         
 * 
 * @param board
 * @param bPos
 * @param aPos
 * @returns
 */
function calBoardTextRow(/* Object */board)
{
	var textRow;
	var content = board.boardName;
	var tsize = content.length;
	var res = tsize%4;
	if(res == 0)
	{
		textRow = tsize/4;
	}else
	{
		textRow = (tsize-res)/4 + 1;
	}
	return textRow;
}

var currentSelectBoard;

var currentSelectPort;

/**
 *         
 * 
 * @param evt
 */
function port_onclick(evt)
{
	bd05log('query path view begin, date=' + new Date());
	var evt = evt?evt:window.event;
	var target = evt.target;
	var targetObject = getTargetObject(target,"oport");
	var port;

	if(targetObject == null)
	{
		targetObject = getTargetObject(target,"oboard");
		port = JSON.parse(targetObject.getAttribute("oboard"));
		clickedPort = -1;
		clickedPath = -1;
		lastClickedSlot = -1;
		refreshPathView();
		isServiceAccessiable(1);
		$("deletebtn").disabled = false;
		$("deletebtn").setAttribute("deleteTarget", "board_" + port.slotId);
		
    	var portComments = getSVGElement(PORT_COMMENTS_ID);
    	if(portComments)
    	{
    		portComments.parentNode.removeChild(portComments);
    	}
		var page = getSVGElement(PATH_PAGE_TIP);
		if(page)
		{
			page.parentNode.removeChild(page);
		}
	}
	else
	{
		port = JSON.parse(targetObject.getAttribute("oport"));
		currentSelectedPort = port;
		var slotid = port.slotId;
		var portid = port.portId;
		clickedPort = portid;
		clickedPath = -1;
    	if(0 == port.portState)
    	{
    		lastClickedSlot = -1;
    		refreshPathView();
            var oldmenu=getSVGElement(BOARD_RIGHT_MENU);
        	if(oldmenu)
        	{
        		oldmenu.parentNode.removeChild(oldmenu);
        	}
        	ele = getSVGElement(BOARD_COMMENTS_ID);
        	if(null != ele)
        	{
        		ele.parentNode.removeChild(ele);
        	} 
        	ele = getSVGElement(BOARD_DESC_ID);
        	if(null != ele)
        	{
        		ele.parentNode.removeChild(ele);
        	}
    	}
		var width = $("boardViewContainer").offsetWidth;
		var height = $("toolbar").offsetHeight;
		showWaitStatus(0,0,width,height);
        queryPathView(slotid, portid);
	}
	if(currentSelectPort)
	{
		if(currentSelectPort == targetObject)
		{
			return;
		}
		if(currentSelectPort.firstChild.getAttribute("class") == "ShowSlotPortSelect")
		{
			currentSelectPort.firstChild.setAttribute("class","ShowSlotPort");
		}
		else if(currentSelectPort.firstChild.getAttribute("class") == "ShowSlotSelect")
		{
			currentSelectPort.firstChild.setAttribute("class","ShowSlot");
		}
	}
	currentSelectPort = targetObject;
	if(currentSelectPort.firstChild.getAttribute("class") == "ShowSlotPort")
	{
		currentSelectPort.firstChild.setAttribute("class","ShowSlotPortSelect");
	}
	else if(currentSelectPort.firstChild.getAttribute("class") == "ShowSlot")
	{
		currentSelectPort.firstChild.setAttribute("class","ShowSlotSelect");
	}	
}

/**
 *      
 */
function deleteDynamicPort()
{
	var id = SHOW_BOARD_PREFIX + clickedSlot + PORT_PREFIX + clickedPort;
	var ele = getSVGElement(id + PORT_EXTEND);
	if(null != ele)
	{
		var color = getPortColor(0);
		var childs = ele.childNodes;
		for(var i = 0, len = childs.length; i < len; i++)
		{
			child = childs.item(i);
			if("polygon" == child.nodeName)
			{
				child.style.setProperty("fill",color,"important");
			}				
		}
	}
	ele = getSVGElement(id + PORT_RECT);
	if(null != ele)
	{
		var oport = JSON.parse(ele.getAttribute("oport"));
		oport.portState = 0;
		ele.setAttribute("oport",JSON.stringify(oport));
	}
	refreshPathView();
	var portComments=getSVGElement(PORT_COMMENTS_ID);
	if(portComments)
	{
		portComments.parentNode.removeChild(portComments);
	}
	var page = getSVGElement(PATH_PAGE_TIP);
	if(page)
	{
		page.parentNode.removeChild(page);
	}
}

/**
 *       
 * 
 * @param port
 */
function portclickShowPath(port,pathList)
{
	var portNum = port.portNum;
	var x = SHOW_BOARD_PATHVIEW_X;
	if(portNum > PORT_MAX_NUMBER_COLUMN)
	{
		x += BAR_WIDTH_DELTA;
	}
	refreshPathView();
	var pathContainer = createSVGElement("svg");
	attr(pathContainer,{x:x,y:SHOW_BOARD_PATHVIEW_Y,id:"pathView",slotId:port.slotId});
    var ochild = getSVGElement("pathView");
    var pnode = getSVGElement("svgBoardview");
    if(null != ochild)
    {
    	pnode.replaceChild(pathContainer, ochild);
    }
    else
    {
    	pnode.appendChild(pathContainer);
    }	
	var portObject = getSVGElement(SHOW_BOARD_PREFIX + port.slotId + PORT_PREFIX + port.portId);
	if(portObject)
	{	    
		var pathContainer = getSVGElement("pathView");
		var pos = getCurrentMoveBoardPoint(portObject);
		var px = pos.x + pos.width/2;
		var py = pos.y + pos.height/2;
		var pathX = pInt(pathContainer.getAttribute("x")) + 20;
		var pathY = pInt(pathContainer.getAttribute("y")) + 10;
		var sx = px + pos.width/2 + 10;
		var portId = port.portId;
		var portNum = port.portNum;
		if(portNum > PORT_MAX_NUMBER_COLUMN)
		{
			sx += 2;
            if(portId <= PORT_MAX_NUMBER_COLUMN)
            {
                sx -= 10;
            }
		}
		var points = px+","+py+" "+sx+","+py+" "+sx+","+pathY+" "+pathX+","+pathY;
		var paths = createSVGElement("polyline");
		paths.setAttribute("points",points);
		paths.setAttribute("id","pathViewLine");
		paths.setAttribute("layer","0");
		paths.setAttribute("class","ShowPathTreeLine");
		getSVGElement("svgBoardview").appendChild(paths);
		
		pathContainer.setAttribute("opath",JSON.stringify(pathList));
	    var total = drawPathTree(pathList,0);
		var pos = {x:x, y:620};
		drawPathPageTip(pos,total,1);
		
		if((-1 == lastClickedSlot) || (lastClickedSlot == port.slotId))
		{
		    pathContainer.setAttribute("cancelAlarm", "0");
		}
		else if(lastClickedSlot != port.slotId)
		{
			pathContainer.setAttribute("cancelAlarm", "1");
		}
	    lastClickedSlot = port.slotId;
	}
}

var currentMoveBoard;
/**
 *            
 * 
 * @param evt
 */
function board_onmouseover(evt)
{
	var evt = evt?evt:window.event;
	var target = evt.target;
	var board = getTargetBoard(target);
	var subBoard;
	var targetObject = getTargetObject(target,"osubboard");	
	
	if(targetObject != null)
	{
		return;
	}

	if(currentMoveBoard && board)
	{
		if(currentMoveBoard.getAttribute("id") == board.getAttribute("id"))
		{
			return;
		}
		var rectObject = getSVGElement(currentMoveBoard.getAttribute("rectid"));
		var style;
		if(style == "SlotPhyMove" || style == "SlotPhyMoveInteger")
		{
			rectObject.setAttribute("class","SlotPhy");
		}
	}
	if(board)
	{
		destroyTooltip();
		tooltip = createSVGElement("polygon");
		currentMoveBoard = board;
		var rectObject = getSVGElement(currentMoveBoard.getAttribute("rectid"));
		if(rectObject.getAttribute("class") == "SlotPhy")
		{
			rectObject.setAttribute("class","SlotPhyMove");
			if(1 == SYSTEMCONF.getStatus())
			{
				rectObject.setAttribute("class","SlotPhyMoveInteger");
			}
		}
		var boardstr = board.getAttribute("oboard");
		var oBoard = JSON.parse(boardstr)
		var pPos = calcBoardPostion(oBoard);
		pPos.x = pPos.x + pInt(board.parentNode.getAttribute("x"));
		pPos.y = pPos.y + pInt(board.parentNode.getAttribute("y"));
		
		var tx = pPos.x - (TOOLTIP_WIDTH - pPos.width)/2;
		tx = tx < 0?0:tx;
		var ty = pPos.y - (TOOLTIP_HEIGHT + 10);
		if(ty < 0)
		{
			ty = pPos.y + pPos.height + 10;
		}

		if(tx + TOOLTIP_WIDTH > 289)
		{
			tx = 289 - TOOLTIP_WIDTH;
		}
		var points = getTooltipPoints(tx,ty,TOOLTIP_WIDTH,TOOLTIP_HEIGHT,pPos);
		attr(tooltip,{points:points,id:"tooltip1"});
		tooltip.setAttribute("class","SlotTooltip");
		board.parentNode.parentNode.appendChild(tooltip);
		
		var text = createSVGElement("text");
		text.appendChild(createSVGText(oBoard.slotId + "-" + oBoard.boardName));
		attr(text,{x:tx + 5,y:ty + 13,id:"tooltip2"});
		board.parentNode.parentNode.appendChild(text);
	}
}

/**
 *              
 * 
 * @param evt
 */
function sub_board_onmouseover(evt)
{	
	var evt = evt?evt:window.event;
	var target = evt.target;
	var board = getTargetBoard(target);
	var subBoard;
	var targetObject = getTargetObject(target,"osubboard");	

	if(currentMoveBoard && board)
	{
		if(currentMoveBoard.getAttribute("id") == board.getAttribute("id"))
		{
			return;
		}
		var rectObject = getSVGElement(currentMoveBoard.getAttribute("rectid"));
		var style = rectObject.getAttribute("class");
		if(style == "SlotPhyMove" || style == "SlotPhyMoveInteger")
		{
			rectObject.setAttribute("class","SlotPhy");
		}
	}
	if(board)
	{
		destroyTooltip();
		tooltip = createSVGElement("polygon");
		currentMoveBoard = board;
		var rectObject = getSVGElement(currentMoveBoard.getAttribute("rectid"));
		if(rectObject.getAttribute("class") == "SlotPhy")
		{
			rectObject.setAttribute("class","SlotPhyMove");
			if(1 == SYSTEMCONF.getStatus())
			{
				rectObject.setAttribute("class","SlotPhyMoveInteger");
			}
		}
		var boardstr = board.getAttribute("oboard");
		var oBoard = JSON.parse(boardstr);
		
		var subBoardstr = board.getAttribute("osubboard");
		var osubboard = JSON.parse(subBoardstr);
		
		var pPos = calcSubBoardPostion(oBoard);
		pPos.x = pPos.x + pInt(board.parentNode.parentNode.parentNode.getAttribute("x"));
		pPos.y = pPos.y + pInt(board.parentNode.parentNode.parentNode.getAttribute("y"));
		
		var tx = pPos.x - (TOOLTIP_WIDTH - pPos.width)/2;
		tx = tx < 0?0:tx;
		var ty = pPos.y - (TOOLTIP_HEIGHT + 10);
		if(ty < 0)
		{
			ty = pPos.y + pPos.height + 10;
		}else 
		{
			ty = ty + pPos.height*2;
		}

		if(tx + TOOLTIP_WIDTH > 289)
		{
			tx = 289 - TOOLTIP_WIDTH;
		}
		var points = getTooltipPoints(tx,ty,TOOLTIP_WIDTH,TOOLTIP_HEIGHT,pPos);
		attr(tooltip,{points:points,id:"tooltip1"});
		tooltip.setAttribute("class","SlotTooltip");
		board.parentNode.parentNode.parentNode.parentNode.appendChild(tooltip);
		
		var text = createSVGElement("text");
		text.appendChild(createSVGText(osubboard.slotId + "-" + oBoard.boardName));
		attr(text,{x:tx + 5,y:ty + 13,id:"tooltip2"});
		board.parentNode.parentNode.parentNode.parentNode.appendChild(text);
	}
}

/**
 *   tip    
 */
function destroyTooltip()
{
	var tooltip = getSVGElement("tooltip1");
	var tooltip2 = getSVGElement("tooltip2");
	if(tooltip)
	{
		tooltip.parentNode.removeChild(tooltip);
		tooltip2.parentNode.removeChild(tooltip2);
	}
}

/**
 *           
 * 
 * @param evt
 */
function board_onmouseout(evt)
{
	var target = evt.target;
	
	var targetObject = getTargetObject(target,"osubboard");	
	
	if(targetObject != null)
	{
	}
	
	if(currentMoveBoard)
	{
		var cPos = getCurrentMoveBoardPoint(currentMoveBoard);
		if(!(evt.clientX >= cPos.x && evt.clientX <= (cPos.x + cPos.width)
			&& evt.clientY >= cPos.y && evt.clientY <=(cPos.y + cPos.height)))
		{
			var rectObject = getSVGElement(currentMoveBoard.getAttribute("rectid"));
			var style = rectObject.getAttribute("class");
			if(style == "SlotPhyMove" || style == "SlotPhyMoveInteger")
			{
				rectObject.setAttribute("class","SlotPhy");
			}
			destroyTooltip();
			currentMoveBoard = null;
		}
	}
}

/**
 *             
 * 
 * @param evt
 */
function sub_board_onmouseout(evt)
{
	var target = evt.target;
	
	var targetObject = getTargetObject(target,"osubboard");	
	
	if(targetObject != null)
	{
	}
	
	if(currentMoveBoard)
	{
		var cPos = getCurrentMoveBoardPoint(currentMoveBoard);
		if(!(evt.clientX >= cPos.x && evt.clientX <= (cPos.x + cPos.width)
			&& evt.clientY >= cPos.y && evt.clientY <=(cPos.y + cPos.height)))
		{
			var rectObject = getSVGElement(currentMoveBoard.getAttribute("rectid"));
			var style = rectObject.getAttribute("class");
			if(style == "SlotPhyMove" || style == "SlotPhyMoveInteger")
			{
				rectObject.setAttribute("class","SlotPhy");
			}
			destroyTooltip();
			currentMoveBoard = null;
		}
	}
}

/**
 *         
 * 
 * @param evt
 */
function board_onclick(evt)
{	
	var evt = evt?evt:window.event;
	var target = evt.target;
	var board = getTargetBoard(target);
	var subBoard;
	var targetObject = getTargetObject(target,"osubboard");
	var slotid;
	if(targetObject == null)
	{
		board = currentBoardSelect(board);
		if(2 == board.boardState)
		{			
			if(!btnRightArr.addboardbtn.right)
			{
				return ;
			}
			currentSelectSlot = getSVGElement(SLOT_PREFIX + board.slotId);
			currentSelectedSlotId = board.slotId;
			querySupportBoard(board.slotId, true);
		}
		else
		{
			var width = $("boardViewContainer").offsetWidth;
			var height = $("toolbar").offsetHeight;
			showWaitStatus(0,0,width,height);
			queryPortList(board.slotId);
			isServiceAccessiable(1);
			hightlightSelectedService(1);
		}
	}
	else
	{
		subBoard = JSON.parse(targetObject.getAttribute("osubboard"));
		var subBoard_t = getTargetBoard(targetObject);

		if(subBoard.isSubClick)
		{
			return;
		}else
		{
			board = currentBoardSelect(subBoard_t);
			if(2 == board.boardState)
			{			
				if(!btnRightArr.addboardbtn.right)
				{
					return ;
				}
				currentSelectSlot = getSVGElement(SUB_BOARD_PREFIX + board.slotId);
				currentSelectedSlotId = board.slotId;
				querySupportSubBoard(board.slotId, true);
			}else
			{
				sub_board_onclick(board.slotId,subBoard_t,subBoard);
			}
		}

	}
}

/**
 *            
 * 
 * @param board
 */
function currentBoardSelect(board)
{
	if(currentSelectSlot)
	{
		setSlotRectClass(currentSelectSlot,"Slot");
	}
	currentSelectSlot = null;
	if(currentSelectBoard)
	{
		var ele = getSVGElement(currentSelectBoard.getAttribute("rectid"));
		if(null != ele)
		{			
			ele.setAttribute("class","SlotPhy");			
		} 
	}
	currentSelectBoard = board;
	var ele = getSVGElement(currentSelectBoard.getAttribute("rectid"));
	if(null != ele)
	{			
		ele.setAttribute("class","SlotPhySelect");
		if(1 == SYSTEMCONF.getStatus())
		{
			ele.setAttribute("class","SlotPhySelectInteger");
		}
	}
	var boardstr = board.getAttribute("oboard");
	var board = JSON.parse(boardstr);
	currentSelectedBoard = board;
	var slotid = board.slotId;
	currentSelectedSlotId = slotid;
	clickedSlot = slotid;
	clickedPort = -1;
	clickedPath = -1;
	clickedBoardType = board.boardType;
	return board;
}

/**
 *           
 * 
 * @param evt
 */
function sub_board_onclick(slotId,subBoard_t,subBoard)
{
		var ele = getSVGElement(subBoard_t.getAttribute("rectid"));
		if(null != ele)
		{			
			ele.setAttribute("class","SlotPhySelect");
			if(1 == SYSTEMCONF.getStatus())
			{
				ele.setAttribute("class","SlotPhySelectInteger");
			}
		}
	if(btnRightArr.delboardbtn.right)
	{
		$("deletebtn").disabled = false;
		$("deletebtn").setAttribute("deleteTarget", "board_" + slotId);
	}
	else
	{
		$("deletebtn").disabled = true;
	}
	
	var tempSlotid = slotId.split(".");
	slotId = tempSlotid[0];
	var subSlotid = tempSlotid[1];
	
	querySubBoardMenu(slotId,subSlotid,subBoard.boardType);
	
}

/**
*        
*/
function querySubBoardMenu(slotId,subSlotid,subBoardType)
{
	var width = $("boardViewContainer").offsetWidth;
	var height = $("toolbar").offsetHeight;
	showWaitStatus(0,0,width,height);
	querySubBoardMenuID(slotId,subSlotid,subBoardType);
	isServiceAccessiable(4);
	hightlightSelectedService(1);
}

/**
 *           
 * 
 * @param evt
 */
function board_oncontextmenu(evt)
{
	var evt = evt?evt:window.event;
	var target = evt.target;
	var board = getTargetBoard(target);
	
	var oldmenu=getSVGElement(BOARD_ADD_ID);
	if(oldmenu)
	{
	    oldmenu.parentNode.removeChild(oldmenu);
	}
	
	if(currentSelectSlot)
	{
		setSlotRectClass(currentSelectSlot,"Slot");
	}
	currentSelectSlot = null;
	if(currentSelectBoard)
	{
		var ele = getSVGElement(currentSelectBoard.getAttribute("rectid"));
		if(null != ele)
		{			
			ele.setAttribute("class","SlotPhy");			
		} 
	}
	currentSelectBoard = board;
	var ele = getSVGElement(currentSelectBoard.getAttribute("rectid"));
	if(null != ele)
	{			
		ele.setAttribute("class","SlotPhySelect");
		if(1 == SYSTEMCONF.getStatus())
		{
			ele.setAttribute("class","SlotPhySelectInteger");
		}
	}
	var boardstr = board.getAttribute("oboard");
	var board = JSON.parse(boardstr);
	currentSelectedBoard = board;
	var slotid = board.slotId;
	currentSelectedSlotId = slotid;
	clickedSlot = slotid;
	clickedPort = -1;
	clickedPath = -1;
	clickedBoardType = board.boardType;
	if(2 == board.boardState)
	{
		if(!btnRightArr.addboardbtn.right)
		{
			return ;
		}
		currentSelectSlot = getSVGElement(SLOT_PREFIX + slotid);
		currentSelectedSlotId = slotid;
		querySupportBoard(slotid, true);
	}
}

/**
 *                     
 */
function paintLine2ShowBoard(board)
{
	var showBoardContainer = getSVGElement(BOARD_SHOW_ID);
	if(null == currentSelectBoard)
	{
		currentSelectBoard = getSVGElement(BOARD_PREFIX + clickedSlot);
		if(null == currentSelectBoard)
		{
			return;
		}
	}
	var pos = getCurrentMoveBoardPoint(currentSelectBoard);
	var px = pos.x + pos.width/2 + 3;
	var py = pos.y + 10;
	if(pos.height < 20)
	{
		py = pos.y + pos.height/2;
	}
	var pathX = pInt(showBoardContainer.getAttribute("x")) + 30;
	var pathY = pInt(showBoardContainer.getAttribute("y")) + 15;
	var sx = pathX - 35;
	if(board.portList.length > PORT_MAX_NUMBER_COLUMN)
	{
		pathX += 18;
	}
	var points = px+","+py+" "+sx+","+py+" "+sx+","+pathY+" "+pathX+","+pathY;
	var paths = createSVGElement("polyline");
	paths.setAttribute("points",points);
	paths.setAttribute("id","showBoardViewLine");
	paths.setAttribute("class","ShowPathLine");
	getSVGElement("svgBoardview").appendChild(paths);
}

/**
 *                
 */
function destroyShowBoard()
{
	refreshPathView();
	destroyTooltip();
	var oldmenu=getSVGElement(BOARD_RIGHT_MENU);
	if(oldmenu)
	{
	    oldmenu.parentNode.removeChild(oldmenu);
	}
	var showSlot = getSVGElement(BOARD_SHOW_ID);
	if(showSlot)
	{
		currentSelectPort = null;
		showSlot.parentNode.removeChild(showSlot);
	}
	var comments = getSVGElement(BOARD_COMMENTS_ID);
	if(comments)
	{
		comments.parentNode.removeChild(comments);
	}
	comments = getSVGElement(BOARD_DESC_ID);
	if(comments)
	{
		comments.parentNode.removeChild(comments);
	}
	comments = getSVGElement(PORT_COMMENTS_ID);
	if(comments)
	{
		comments.parentNode.removeChild(comments);
	}	
	showSlot = getSVGElement(BOARD_MENU_ID);
	if(showSlot)
	{
		currentSelectPort = null;
		showSlot.parentNode.removeChild(showSlot);
	}
		
	showSlot = getSVGElement(BOARD_ADD_ID);
	if(showSlot)
	{
		currentMoveAddBoard = null;
		showSlot.parentNode.removeChild(showSlot);
	}	
	var line = getSVGElement("showBoardViewLine");
	if(line)
	{
		line.parentNode.removeChild(line);
	}
	line = getSVGElement("addBoardViewLine");
	if(line)
	{
		line.parentNode.removeChild(line);
	}
	var page = getSVGElement(PATH_PAGE_TIP);
	if(page)
	{
		page.parentNode.removeChild(page);
	}
	var ele = getSVGElement("portnamedetail");
	if(null != ele)
	{
		ele.parentNode.removeChild(ele);
	}
}

/**
 *                   
 * 
 * @param bCtn
 * @param oPos
 */
function paintRectBar(bCtn,oPos,boardTextRow)
{
	var bOWidth = oPos.width / 10;
	var bOHeight = 120;
	var boardTextHeight = boardTextRow * 20 + 30;
	var bOC1 = createSVGElement("svg");
	attr(bOC1,{x:0,y:0,width:bOWidth,height:bOHeight});
	var style = "ShowSlotOther";
	if(1 == SYSTEMCONF.getStatus())
	{
		style = "ShowSlotOtherInteger";
	}
	var bO = createSVGElement("rect");
	attr(bO,{width:"100%",height:"100%"});
	bO.setAttribute("class",style);
	bOC1.appendChild(bO);
	bCtn.appendChild(bOC1);
	
	var bOC2 = createSVGElement("svg");
	attr(bOC2,{x:0,y:oPos.height - bOHeight,width:bOWidth,height:bOHeight});
	bO = createSVGElement("rect");
	attr(bO,{width:"100%",height:"100%"});
	bO.setAttribute("class",style);
	bOC2.appendChild(bO);
	bCtn.appendChild(bOC2);

	var width = oPos.width - bOWidth; 
	var lg = createSVGElement("svg");
	attr(lg,{x:bOWidth,y:0,width:width,height:120});
	var line = createSVGElement("line");
	attr(line,{x1:0,y1:30,x2:width,y2:30});
	line.setAttribute("class", "splitline");
	lg.appendChild(line);
	
	line = createSVGElement("line");
	attr(line,{x1:0,y1:boardTextHeight,x2:width,y2:boardTextHeight});
	line.setAttribute("class", "splitline");
	lg.appendChild(line);
	bCtn.appendChild(lg);
}

/**
 *          
 */
function paintPortListBar(board)
{	
	paintPortList(board);
	var status = SYSTEMCONF.getStatus();
	if(1 == status)
	{
		paintBoardInfo(board);
	}
	paintLine2ShowBoard(board);
	if(btnRightArr.delboardbtn.right)
	{
		$("deletebtn").disabled = false;
		$("deletebtn").setAttribute("deleteTarget", "board_" + board.slotId);
	}
	else
	{
		$("deletebtn").disabled = true;
	}
}

/**
 *                  
 * 
 * @param board
 */
function paintPortList(board)
{
	lastClickedSlot = -1;
	var pathContainer = getSVGElement("pathView");
	if(pathContainer)
	{		
		var pathSlotId = pathContainer.getAttribute("slotId");
		lastClickedSlot = pathSlotId;
	}
	destroyShowBoard();
    var portNum = board.portList.length;
	var oPos = calcPortListBarPostion(portNum);
	var bCtn = createSVGElement("svg");
	attr(bCtn,extendObj(oPos,{id:BOARD_SHOW_ID}));
	bCtn.setAttribute("oboard",JSON.stringify(board));
	attachSVGEvent(bCtn,"click",port_onclick);
	var bElm = createSVGElement("rect");
	bElm.setAttribute("class","ShowSlot");
	if(1 == SYSTEMCONF.getStatus())
	{
		bElm.setAttribute("class","ShowSlotInteger");
	}
	attr(bElm,{width:"100%",height:"100%"});
	bCtn.appendChild(bElm);
	
	var alarm = createSVGElement("circle");
	var almPos = calcPortListBarAlmPostion(oPos);
	if(portNum > PORT_MAX_NUMBER_COLUMN)
	{
		almPos.cx += 18;
	}
	attr(alarm,almPos);
	alarm.setAttribute("alarm", "1");
	var style = getBoardAlarmStyle(board);
	if(0 == SYSTEMCONF.getStatus())
	{
		if(isChrome)
		{
			style = "url(" + style + ")";
		}
		else if(isFF)
		{
			var index = style.indexOf(" rgb");
			style = style.substring(0,index);
		}
	}
	alarm.style.setProperty("fill",style,"important");
	bCtn.appendChild(alarm);
	
	var boardTextRow = createPortListBarNameText(bCtn,board,oPos,almPos);
	
	paintRectBar(bCtn,oPos,boardTextRow);

	var width = oPos.width * 0.9;
	var pPos = {x:0.1 * oPos.width, y:oPos.height * SHOW_NAME_AREA_PER + almPos.r * 3,width:width,height:oPos.height};
	pPos.height = oPos.height - pPos.y;
	var portContainer = createSVGElement("svg");
	attr(portContainer,pPos);
	portContainer.setAttribute("id", "portcontainer");
	if(portNum > PORT_MAX_NUMBER_COLUMN)
	{
		width = width * 0.5;
	}
	pPos.width = width;
	var port;
	var id;
	var ele;
	var alarmLevel;
	for(var i = 0; i < portNum; i++)
	{
		port = board.portList[i];
		id = BOARD_PREFIX + board.slotId + PORT_PREFIX + port.portId;
		ele = getSVGElement(id);
		if(null != ele)
		{
			alarmLevel = ele.getAttribute("alarmLevel");
			if(null != alarmLevel && "" != alarmLevel)
			{
				port.alarmLevel = pInt(alarmLevel);
			}
		}
		id = SHOW_BOARD_PREFIX + board.slotId + PORT_PREFIX + port.portId;
		portContainer.appendChild(createShowPort(i,id,port,pPos,board.slotId,board.boardName,portNum));
	}
	bCtn.appendChild(portContainer);
	getSVGElement("svgBoardview").appendChild(bCtn);
}


/**
 *     
 * 
 * @param index
 *                
 * @param id
 *              ID
 * @param port
 *                   
 * @param cPos
 *                               
 * @param slotId
 *              ID
 * @param boardName
 *                
 * @returns
 */
function createShowPort(/* int */index,/* String */id,/* Object */port,/* Object */cPos,/* int */slotId,/* String */boardName,/* int */portNum)
{
	var portId = port.portId;
	var x = 0;
	if(portId > PORT_MAX_NUMBER_COLUMN)
	{
		x = cPos.width;
		index -= PORT_MAX_NUMBER_COLUMN;
	}
	var pcPos = {x:x, y:0, width:cPos.width, height:((cPos.height)/ PORT_MAX_NUMBER_COLUMN) - 2};
	pcPos.y = (pcPos.height + 2) * index;
	var pCtn = createSVGElement("svg");
	attr(pCtn,extendObj(pcPos,{id:id}));
	pCtn.setAttribute("oportrect",JSON.stringify(pcPos));
	
	var pPos = {x:0,y:0,width:0,height:pcPos.height};
	pPos.width = cPos.width * 0.5;
	pPos.x = 3;
	var pElmCtn = createSVGElement("svg");
	pElmCtn.setAttribute("id", id + PORT_RECT);
	pElmCtn.setAttribute("oport",JSON.stringify(extendObj(port,{slotId:slotId,boardName:boardName,portNum:portNum})));
	attr(pElmCtn,pPos);
	var pElm = createSVGElement("rect");
	attr(pElm,{width:"100%",height:"100%",id:id + PORT_POSTFIX});
	pElm.setAttribute("class","ShowSlotPort");
	if(1 == SYSTEMCONF.getStatus())
	{
		pElm.setAttribute("class","ShowSlotPortInteger");
	}
	pElmCtn.appendChild(pElm);
	pCtn.appendChild(pElmCtn);
	pCtn.setAttribute("rectid",pElm.getAttribute("id"));
	
	var porttext = createSVGElement("text");
	attr(porttext,{x:pPos.x + pPos.width + 2,y:((pcPos.height/2) + 4)});
	porttext.appendChild(createSVGText(port.portId));
	setFontSize(porttext,9);
	pCtn.appendChild(porttext);
	
	pPos.x = 0;
	pElmCtn.appendChild(createPortElement(port, pPos, id + PORT_EXTEND));
		
	if(port.loopback && pInt(port.loopback) > 0)
	{
		pElmCtn.appendChild(createLoopback(pPos, port.loopback));
	}
	
	return pCtn;
}

function createPortLoopback(id, pPos)
{
	var g = createSVGElement("g");
	g.setAttribute("id", id);
	pT2 = createSVGElement("circle");
	attr(pT2,{cx:0,cy:pPos.y + pPos.height,r:5});
	pT2.setAttribute("class","ShowSlotPortLP");
	g.appendChild(pT2);
	
	pT2 = createSVGElement("circle");
	attr(pT2,{cx:0,cy:pPos.y + pPos.height,r:10});
	pT2.setAttribute("class","ShowSlotPortLP");
	g.appendChild(pT2);
	
	return g;
}

/**
 *                        
 * 
 * @param pElmCtn
 * @param port
 * @param pPos
 */
function createPortElement(port, pPos, id)
{
	var type = port.portType;
	var ele;
	switch(type)
	{
	case 0:
		ele = drawEthPortElement(port, pPos, id);
		break;
	case 1:
		ele = drawSinglePortElement(port, pPos, id);
		break;
	case 2:
		ele = drawDoublePortElement(port, pPos, id);
		break;
	default:
		break;
	}
	
	return ele;
}

/**
 *        
 * 
 * @param pElmCtn
 * @param port
 * @param pPos
 */
function drawDoublePortElement(port, pPos, id)
{		
	var g = createSVGElement("g");
	g.setAttribute("id", id);
	var color = getPortColor(port.portState, port.alarmLevel);
	var px1 = pPos.x + 1;
	var px2 = pPos.x + (pPos.width-2) * 0.7;
	var px3 =  pPos.x + pPos.width-2;
	var py1 = pPos.y + 1;
	var py2 = pPos.y + pPos.height - 1;
	var points = px1 + "," + py1 + " " + px2 + "," + py1 + " " + (px2 + 1) + "," + pPos.y + " " + px3 + "," + pPos.y + " " 
    + px3 + "," + (py2 + 1) + " " + (px2 + 1) + "," + (py2 + 1) + " " + px2 + "," + py2 + " " + px1 + "," + py2;
	var pT1 = createSVGElement("polygon");
	pT1.setAttribute("points",points);
	pT1.setAttribute("class","waveport");
	pT1.style.setProperty("fill",color,"important");
	g.appendChild(pT1);

	px1 += 2;
	px2 -= 2;
	px3 = px2 + 2;
	py1 = pPos.y + 3;
	py2 = py1 + 2;
	var py3 = pPos.y + pPos.height / 2 - 3;
	var py4 = py3 + 2;
	var path = "M" + px1 + "," + py1 + " " + px2 + "," + py1 + " " +px2 + "," + py2 + " " + px3 + "," + py2 + " " 
             + px3 + "," + py3 + " " + px2 + "," + py3 + " " + px2 + "," + py4 + " " + px1 + "," + py4 + " " + px1 + "," + py2 + "Z";
	pT1 = createSVGElement("path");
	pT1.setAttribute("d",path);
	pT1.style.setProperty("opacity",'0.5',"important");
	g.appendChild(pT1);
	
	py1 = pPos.y + pPos.height / 2 + 1;
	py2 = py1 + 2;
	py3 = pPos.y + pPos.height - 5;
	py4 = py3 + 2;
	path = "M" + px1 + "," + py1 + " " + px2 + "," + py1 + " " +px2 + "," + py2 + " " + px3 + "," + py2 + " " 
         + px3 + "," + py3 + " " + px2 + "," + py3 + " " + px2 + "," + py4 + " " + px1 + "," + py4 + " " + px1 + "," + py2 + "Z";
	pT1 = createSVGElement("path");
	pT1.setAttribute("d",path);
	pT1.style.setProperty("opacity",'0.5',"important");
	g.appendChild(pT1);


	var x = pPos.x + pPos.width - 5;
	var y = pPos.y + 3;
	var line = createSVGElement("line");
	attr(line,{x1:x,y1:y,x2:x,y2:y + 3});
	line.setAttribute("class", "portline");
	g.appendChild(line);
	
	line = createSVGElement("line");
	attr(line,{x1:x,y1:y + 5,x2:x,y2:y + 8});
	line.setAttribute("class", "portline");
	g.appendChild(line);
	
	y =  pPos.y + pPos.height - 2;
	line = createSVGElement("line");
	attr(line,{x1:x,y1:y - 8,x2:x,y2:y - 5});
	line.setAttribute("class", "portline");
	g.appendChild(line);
	
	line = createSVGElement("line");
	attr(line,{x1:x,y1:y - 3,x2:x,y2:y});
	line.setAttribute("class", "portline");
	g.appendChild(line);
	return g;
}

/**
 *        
 * 
 * @param pElmCtn
 * @param port
 * @param pPos
 */
function drawSinglePortElement(port, pPos, id)
{
	var g = createSVGElement("g");
	g.setAttribute("id", id);
	var color = getPortColor(port.portState, port.alarmLevel);
	var px1 = pPos.x + 1;
	var px2 = pPos.x + (pPos.width-2) * 0.7;
	var px3 =  pPos.x + pPos.width-2;
	var py1 = pPos.y + 1;
	var py2 = pPos.y + pPos.height - 1;
	var points = px1 + "," + py1 + " " + px2 + "," + py1 + " " + (px2 + 1) + "," + pPos.y + " " + px3 + "," + pPos.y + " " 
    + px3 + "," + (py2 + 1) + " " + (px2 + 1) + "," + (py2 + 1) + " " + px2 + "," + py2 + " " + px1 + "," + py2;
	var pT1 = createSVGElement("polygon");
	pT1.setAttribute("points",points);
	pT1.setAttribute("class","waveport");
	pT1.style.setProperty("fill",color,"important");
	g.appendChild(pT1);

	px1 += 2;
	px2 -= 2;
	px3 = px2 + 2;
	py1 = pPos.y + 3;
	py2 = py1 + 2;
	var py3 = pPos.y + pPos.height - 5;
	var py4 = py3 + 2;
	var path = "M" + px1 + "," + py1 + " " + px2 + "," + py1 + " " +px2 + "," + py2 + " " + px3 + "," + py2 + " " 
    + px3 + "," + py3 + " " + px2 + "," + py3 + " " + px2 + "," + py4 + " " + px1 + "," + py4 + " " + px1 + "," + py2 + "Z";
	pT1 = createSVGElement("path");
	pT1.setAttribute("d",path);
	pT1.style.setProperty("opacity",'0.5',"important");
	g.appendChild(pT1);
	
	

	var x = pPos.x + pPos.width - 5;
	var line = createSVGElement("line");
	attr(line,{x1:x,y1:py1,x2:x,y2:py1 + 3});
	line.setAttribute("class", "portline");
	g.appendChild(line);
	
	line = createSVGElement("line");
	attr(line,{x1:x,y1:py1 + 4,x2:x,y2:py1 + 7});
	line.setAttribute("class", "portline");
	g.appendChild(line);
	
	line = createSVGElement("line");
	attr(line,{x1:x,y1:py4 - 8,x2:x,y2:py4 - 5});
	line.setAttribute("class", "portline");
	g.appendChild(line);
	
	line = createSVGElement("line");
	attr(line,{x1:x,y1:py4 - 3,x2:x,y2:py4});
	line.setAttribute("class", "portline");
	g.appendChild(line);
	return g;
}

/**
 *         
 * 
 * @param pElmCtn
 * @param port
 * @param pPos
 */
function drawEthPortElement(port, pPos, id)
{
	var g = createSVGElement("g");
	g.setAttribute("id", id);
	var color = getPortColor(port.portState, port.alarmLevel);
	var px1 = pPos.x + 1;
	var px2 = pPos.x + (pPos.width-1) * 0.75;
	var px3 = pPos.x + (pPos.width-1) * 0.9;
	var px4 = pPos.x + (pPos.width-1);
	var py1 = pPos.y + 1;
	var py2 = pPos.y + (pPos.height - 1) * 0.2;
	var py3 = pPos.y + (pPos.height - 1) * 0.3;
	var py4 = pPos.y + (pPos.height - 1) * 0.7;
	var py5 = pPos.y + (pPos.height - 1) * 0.8;
	var py6 = pPos.y + (pPos.height - 1);
	var points = px1 + "," + py1 + " " + px2 + "," + py1 + " " + px2 + "," + py2 + " " 
               + px3 + "," + py2 + " " + px3 + "," + py3 + " " + px4 + "," + py3 + " "
               + px4 + "," + py4 + " " + px3 + "," + py4 + " " + px3 + "," + py5 + " "
               + px2 + "," + py5 + " " + px2 + "," + py6 + " " + px1 + "," + py6;
	var pT1 = createSVGElement("polygon");
	pT1.setAttribute("points",points);
	pT1.setAttribute("class","ShowSlotPortPy");
	pT1.style.setProperty("fill",color,"important");
	g.appendChild(pT1);
	
	var x = px1 + 3;
	var line = createSVGElement("line");
	attr(line,{x1:x,y1:py1 + 4,x2:x,y2:py1 + 7});
	line.setAttribute("class", "portline");
	g.appendChild(line);
	
	line = createSVGElement("line");
	attr(line,{x1:x,y1:py1 + 8,x2:x,y2:py1 + 11});
	line.setAttribute("class", "portline");
	g.appendChild(line);
	
	line = createSVGElement("line");
	attr(line,{x1:x,y1:py1 + 12,x2:x,y2:py1 + 15});
	line.setAttribute("class", "portline");
	g.appendChild(line);
	
	line = createSVGElement("line");
	attr(line,{x1:x,y1:py1 + 16,x2:x,y2:py1 + 19});
	line.setAttribute("class", "portline");
	g.appendChild(line);

	line = createSVGElement("line");
	attr(line,{x1:x,y1:py1 + 20,x2:x,y2:py1 + 23});
	line.setAttribute("class", "portline");
	g.appendChild(line); 
	
	var width = px2 - px1 - 6;
	var height = (pPos.height - 1) * 0.7;
	line = createSVGElement("rect");
	attr(line,{x:x - 1,y:py1 + 4,width:width,height:height});
	line.style.setProperty("opacity",'0.5',"important");
	g.appendChild(line);
	
	var y = pPos.y + pPos.height / 2;
	line = createSVGElement("rect");
	attr(line,{x:px2 - 3,y:y - 4,width:2,height:3});
	line.style.setProperty("opacity",'0.5',"important");
	g.appendChild(line);
	
	line = createSVGElement("rect");
	attr(line,{x:px2 - 3,y:y + 1,width:2,height:3});
	line.style.setProperty("opacity",'0.5',"important");
	g.appendChild(line);
	
	return g;
}

/**
 *           
 * 
 * @param index
 * @param id
 * @param port
 * @param bPos
 * @param isHor
 * @returns
 */
function createPort(/* int */index,/* String */id,/* Object */bPos,/* boolean */isHor)
{
	var pPos = {x:0,y:0,width:0,height:0};
	if(isHor)
	{
		pPos.y = 0;
		pPos.width = PORT_SIZE;
		pPos.height = PORT_SIZE;
		pPos.x = pPos.width * index;
	}
	else
	{
		pPos.x = 0;
		pPos.width = PORT_SIZE;
		pPos.height = PORT_SIZE;
		pPos.y = pPos.width * index;
	}	

	var portCtn = createSVGElement("svg");

	if(index == PORT_MAX_NUMBER_COLUMN)
	{
		var x0 = pPos.x;
		var y0 = 1;
		var x1 = x0 + pPos.width;
		var y1 = y0 + 5;
		if(isHor)
		{
			pPos.width = pPos.width * 2;
			x0 = 1;
			y0 = pPos.y;
			x1 = x0 + 5;
			y1 = y0 + pPos.height;
			data = "M" + x0 + "," + y0 + " L" + x1 + "," + (y0 + y1) / 2 + " L" + x1 + "," + y1;
		}
		else
		{
			pPos.height = pPos.height * 2;
			data = "M" + x0 + "," + y0 + " L" + (x0 + x1) / 2 + "," + y1 + " L" + x1 + "," + y0;
		}

		attr(portCtn,extendObj(pPos,{id:id}));
		var ele = createSVGElement("path");
		attr(ele, {d:data});
		ele.setAttribute("class","SlotPort");
		portCtn.appendChild(ele);
	}
	else
	{
		attr(portCtn,extendObj(pPos,{id:id}));
		var portElement = createSVGElement("rect");
		attr(portElement,{width:"100%",height:"100%"});
		portElement.setAttribute("class","SlotPort");
		portElement.setAttribute("port", "1");
		var color = getAlarmColor(7);
		portElement.style.setProperty("fill",color,"important");
		portCtn.appendChild(portElement);
	}

	return portCtn;
}

/**
 *         
 * 
 * @param index
 * @param id
 * @param port
 * @param bPos
 * @param isHor
 * @returns
 */
function createSubBoard(/* int */index,/* String */id,/* Object */bPos,/* boolean */isHor)
{
	var subBoard = {};
	var pPos = {x:0,y:0,width:0,height:0};
	if(isHor)
	{
		pPos.y = 0;
		pPos.width = SUB_BOARD_X;
		pPos.height = SUB_BOARD_Y;
		pPos.x = (pPos.width + 16) * index;
	}
	else
	{
		pPos.x = 0;
		pPos.width = SUB_BOARD_Y;
		pPos.height = SUB_BOARD_X;
		pPos.y = (pPos.height + 16) * index;
	}	
	
	var subBoardCtn = createSVGElement("svg");
	
	attr(subBoardCtn,extendObj(pPos,{id:id}));

	var subElm = createSVGElement("rect");
	subElm.setAttribute("id",subBoardCtn.getAttribute("id") + BOARD_POSTFIX);
	subElm.setAttribute("class","SlotPhy");
	subElm.setAttribute("width","100%");
	subElm.setAttribute("height","100%");
	subElm.style.setProperty("fill",getBoardColor(0),"important");
	subBoardCtn.appendChild(subElm);
	subBoardCtn.setAttribute("rectid",subElm.getAttribute("id"));	

	subBoardCtn.setAttribute("osubboard",JSON.stringify(extendObj(subBoard,{isSubClick:1})));
	attachSVGEvent(subElm,"click",sub_slot_onclick);		

	return subBoardCtn;
}

/**
 *         
 * 
 * @param index
 * @param id
 * @param board
 * @returns
 */
function paintSubBoard(/* int */index,/* String */id,board,slotId)
{
	var subBoard = {};
	
	var fatherId = BOARD_PREFIX + slotId;
	var isHor = getSVGElement(fatherId).getAttribute("width") > getSVGElement(fatherId).getAttribute("height");
	
	var pPos = {x:0,y:0,width:0,height:0};
	if(isHor)
	{
		pPos.y = 0;
		pPos.width = SUB_BOARD_Y;
		pPos.height = SUB_BOARD_X;
		pPos.x = 0;
	}
	else
	{
		pPos.x = 0;
		pPos.width = SUB_BOARD_Y;
		pPos.height = SUB_BOARD_X;
		pPos.y = 0;
	}	
	
	var subBoardCtn = getSVGElement(SUB_BOARD_PREFIX + id);
	
	var subBoardAreaCtn = createSVGElement("svg");
	
	attr(subBoardAreaCtn,extendObj(pPos,{id:SUB_BOARD_AREA_PREFIX + id}));
	
	attachSVGEvent(subBoardAreaCtn,"mouseover",sub_board_onmouseover);
	attachSVGEvent(subBoardAreaCtn,"mouseout",sub_board_onmouseout);

	var subElm = createSVGElement("rect");
	subElm.setAttribute("id",subBoardAreaCtn.getAttribute("id") + BOARD_POSTFIX);
	subElm.setAttribute("class","SlotPhy");
	subElm.setAttribute("width","100%");
	subElm.setAttribute("height","100%");
	subElm.style.setProperty("fill",getSubBoardColor(board[1]),"important");
	subBoardAreaCtn.appendChild(subElm);
	subBoardAreaCtn.setAttribute("rectid",subElm.getAttribute("id"));	


	subBoardAreaCtn.setAttribute("osubboard",JSON.stringify(extendObj(subBoard,{isSubClick:0,slotId:board[4],boardName:board[2],boardType:board[3],subboardNum:1})));
		
	var subBoardTemp = new BoardDesObj();
    subBoardTemp.boardName = board[2];
    subBoardTemp.boardState = board[1];
    subBoardTemp.boardType = board[3];
    subBoardTemp.slotId = id;
    subBoardTemp.slotList = 0;
		
	subBoardAreaCtn.setAttribute("oboard",JSON.stringify(subBoardTemp));

	var boardtext = createSubBoardText(board,pPos);
	if(boardtext)
	{
		subBoardAreaCtn.appendChild(boardtext);
	}
	subBoardCtn.appendChild(subBoardAreaCtn);
	return subBoardCtn;
}

/**
 *         
 * 
 * @param index
 * @param id
 * @param board
 * @returns
 */
function modifySubBoard(/* int */index,/* String */id,board,slotId)
{
	var subBoardAreaCtn = getSVGElement(SUB_BOARD_AREA_PREFIX + id);
	
	var subElm = getSVGElement(subBoardAreaCtn.getAttribute("rectid"));
	
	subElm.style.setProperty("fill",getSubBoardColor(board[1]),"important");
		
	var subBoardTemp = new BoardDesObj();
    subBoardTemp.boardName = board[2];
    subBoardTemp.boardState = board[1];
    subBoardTemp.boardType = board[3];
    subBoardTemp.slotId = id;
    subBoardTemp.slotList = 0;
		
	subBoardAreaCtn.setAttribute("oboard",JSON.stringify(subBoardTemp));

}

/**
 *                        
 * 
 * @param slotId
 * @return
 */
function getSupportBoard(slotId, boardList)
{
	paintAddBoard(boardList,slotId);
}

/**
 *                            
 * 
 * @param slotId
 * @return
 */
function getSupportSubBoard(slotId, subBoardList)
{
	var boardList = [];


	paintAddSubBoard(subBoardList,slotId);
}

var currentSelectSlot;
/**
 *          
 * 
 * @param evt
 */
function slot_onclick(evt)
{
	var target = evt.target;
	var parentN = target.parentNode;

	if(parentN && parentN.getAttribute("id")
		&& parentN.getAttribute("id").indexOf(SLOT_PREFIX) >= 0)
	{
		if(currentSelectBoard)
		{
			var ele = getSVGElement(currentSelectBoard.getAttribute("rectid"));
			if(null != ele)
			{
				ele.setAttribute("class","SlotPhy");
			}
			currentSelectBoard = null;
		}
		if(currentSelectSlot)
		{
			setSlotRectClass(currentSelectSlot,"Slot");
		}
		$("deletebtn").disabled = true;
		$("deletebtn").setAttribute("deleteTarget", null);
		isServiceAccessiable(0);
		clickedSlot = -1;
		clickedBoardType = -1;
		
		currentSelectSlot = parentN;
		var slotId = parentN.getAttribute("id");
		slotId = slotId.substr(SLOT_PREFIX.length);
		currentSelectedSlotId = slotId;
		if(!btnRightArr.addboardbtn.right)
		{
			return ;
		}
		var rectObject = getSVGElement(SLOT_PREFIX + slotId);
		setSlotRectClass(rectObject,"SlotSelect");
		if(1 == SYSTEMCONF.getStatus())
		{
			setSlotRectClass(rectObject,"SlotSelectInteger");
		}
		querySupportBoard(slotId);
	}
}

/**
 *            
 * 
 * @param evt
 */
function sub_slot_onclick(evt)
{
	var target = evt.target;
	var parentN = target.parentNode;
	
	var boardState = JSON.parse(target.parentNode.parentNode.parentNode.getAttribute("oboard")).boardState;

	if(boardState == 2)
	{
		return;
	}
	if(parentN && parentN.getAttribute("id")
		&& parentN.getAttribute("id").indexOf(SUB_BOARD_PREFIX) >= 0)
	{
		if(currentSelectBoard)
		{
			var ele = getSVGElement(currentSelectBoard.getAttribute("rectid"));
			if(null != ele)
			{
				ele.setAttribute("class","SlotPhy");
			}
		}
		if(currentSelectSlot)
		{
			setSlotRectClass(currentSelectSlot,"Slot");
		}
		$("deletebtn").disabled = true;
		$("deletebtn").setAttribute("deleteTarget", null);
		isServiceAccessiable(0);
		clickedSlot = -1;
		clickedBoardType = -1;
		
		currentSelectSlot = parentN;
		var slotId = parentN.getAttribute("id");
		slotId = slotId.substr(SUB_BOARD_PREFIX.length);
		currentSelectedSlotId = slotId;
		if(!btnRightArr.addboardbtn.right)
		{
			return ;
		}
		var rectObject = getSVGElement(SUB_BOARD_PREFIX + slotId);
		setSlotRectClass(rectObject,"SlotSelect");
		if(1 == SYSTEMCONF.getStatus())
		{
			setSlotRectClass(rectObject,"SlotSelectInteger");
		}
		
		currentSelectSlot = getSVGElement(SUB_BOARD_PREFIX + slotId);
		currentSelectedSlotId = slotId;
		querySupportSubBoard(slotId, true);
	}
}

/**
 *          
 * 
 * @param supportBoard
 * @param slotId
 */
function paintAddBoard(supportBoard,slotId)
{
	lastClickedSlot = -1;
	destroyShowBoard();
	var boardSize = supportBoard.length;

	var oPos = calcAddBoardPostion(slotId, boardSize);
	var bCtn = createSVGElement("svg");
	attr(bCtn,extendObj(oPos,{id:BOARD_ADD_ID}));

	var bElm = createSVGElement("rect");
	bElm.setAttribute("class","AddSlotView");
	if(1 == SYSTEMCONF.getStatus())
	{
		bElm.setAttribute("class","AddSlotViewInteger");
	}
	attr(bElm,{width:"100%",height:"100%"});
	bCtn.appendChild(bElm);
	for(var rowidx = 0; rowidx < boardSize; rowidx++)
	{
		var addBoard = supportBoard[rowidx];
		extendObj(addBoard,{slotId:slotId});
		var slotC = createSVGElement("svg");
		var column = Math.floor(rowidx / BOARD_NUM_COLUMN);
	    var x = 2 + column * ADD_BOARD_WIDTH;
		var y = 1 + (rowidx - column * BOARD_NUM_COLUMN) * (ADD_BOARD_HEIGHT + 2);
		
		attr(slotC,{x:x,y:y,width:(ADD_BOARD_WIDTH - 4),height:ADD_BOARD_HEIGHT});
		slotC.setAttribute("addboard",JSON.stringify(addBoard));
		var slotElm = createSVGElement("rect");
		attr(slotElm,{width:"100%",height:"100%"});
		slotElm.setAttribute("class","AddSlot");
		var id = ADD_BOARD_PREFIX + addBoard.boardType;
		var txtcontent = addBoard.boardName;
		if(0 == rowidx && "1" == addBoard.physic)
		{
			id = id + "_0";
			txtcontent = RESOURCE["physicboard"];
		}
		slotElm.setAttribute("id", id);
		slotC.appendChild(slotElm);
		slotC.setAttribute("rectid",slotElm.getAttribute("id"));
		var slotText = createSVGElement("text");
		attr(slotText,{x:10,y:(ADD_BOARD_HEIGHT - 5)});
		if(isFF)
		{
			setFontSize(slotText, 10);
		}
		slotText.appendChild(createSVGText(txtcontent));
		
		attachSVGEvent(slotC,"mousemove",addboard_onmousemove);
		attachSVGEvent(slotC,"mouseout",addboard_onmouseout);
		attachSVGEvent(slotC,"click",addboard_onclick);
		slotC.appendChild(slotText);
		bCtn.appendChild(slotC);
	}
		
	getSVGElement("svgBoardview").appendChild(bCtn);
}

/**
 *            
 * 
 * @param supportBoard
 * @param slotId
 */
function paintAddSubBoard(supportBoard,slotId)
{
	lastClickedSlot = -1;
	destroyShowBoard();
	var boardSize = supportBoard.length;

	var oPos = calcAddSubBoardPostion(slotId, boardSize);
	var bCtn = createSVGElement("svg");
	attr(bCtn,extendObj(oPos,{id:BOARD_ADD_ID}));

	var bElm = createSVGElement("rect");
	bElm.setAttribute("class","AddSlotView");
	if(1 == SYSTEMCONF.getStatus())
	{
		bElm.setAttribute("class","AddSlotViewInteger");
	}
	attr(bElm,{width:"100%",height:"100%"});
	bCtn.appendChild(bElm);
	for(var rowidx = 0; rowidx < boardSize; rowidx++)
	{
		var addBoard = supportBoard[rowidx];
		extendObj(addBoard,{slotId:slotId});
		var slotC = createSVGElement("svg");
		var column = Math.floor(rowidx / BOARD_NUM_COLUMN);
	    var x = 2 + column * ADD_BOARD_WIDTH;
		var y = 1 + (rowidx - column * BOARD_NUM_COLUMN) * (ADD_BOARD_HEIGHT + 2);
		
		attr(slotC,{x:x,y:y,width:(ADD_BOARD_WIDTH - 4),height:ADD_BOARD_HEIGHT});
		slotC.setAttribute("addboard",JSON.stringify(addBoard));
		var slotElm = createSVGElement("rect");
		attr(slotElm,{width:"100%",height:"100%"});
		slotElm.setAttribute("class","AddSlot");
		var id = ADD_BOARD_PREFIX + addBoard.boardType;
		var txtcontent = addBoard.boardName;
		if(0 == rowidx && "1" == addBoard.physic)
		{
			id = id + "_0";
			txtcontent = RESOURCE["physicboard"];
		}
		slotElm.setAttribute("id", id);
		slotC.appendChild(slotElm);
		slotC.setAttribute("rectid",slotElm.getAttribute("id"));
		var slotText = createSVGElement("text");
		attr(slotText,{x:10,y:(ADD_BOARD_HEIGHT - 5)});
		if(isFF)
		{
			setFontSize(slotText, 10);
		}
		slotText.appendChild(createSVGText(txtcontent));
		
		attachSVGEvent(slotC,"mousemove",addboard_onmousemove);
		attachSVGEvent(slotC,"mouseout",addboard_onmouseout);
		attachSVGEvent(slotC,"click",addSubboard_onclick);
		slotC.appendChild(slotText);
		bCtn.appendChild(slotC);
	}
		
	getSVGElement("svgBoardview").appendChild(bCtn);
}

/**
 *         
 * 
 * @param evt
 */
function addboard_onclick(evt)
{
	bd05log('add board begin, date=' + new Date());
	var target = evt.target;
	var addboard = getTargetObject(target,"addboard");
	var oaddboard = JSON.parse(addboard.getAttribute("addboard"));
	destroyShowBoard();
	currentSelectSlot = null;
	addCard(oaddboard);
}

/**
 *           
 * 
 * @param evt
 */
function addSubboard_onclick(evt)
{
	bd05log('add board begin, date=' + new Date());
	var target = evt.target;
	var addboard = getTargetObject(target,"addboard");
	var oaddboard = JSON.parse(addboard.getAttribute("addboard"));
	destroyShowBoard();
	currentSelectSlot = null;
	addSubCard(oaddboard);
}

var currentMoveAddBoard;
function addboard_onmousemove(evt)
{
	var target = evt.target;

	var addboard = getTargetObject(target,"addboard");
	if(currentMoveAddBoard && addboard)
	{
		if(currentMoveAddBoard.getAttribute("id") == addboard.getAttribute("id"))
		{
			return;
		}
		if(currentMoveAddBoard.getAttribute("rectid") != "")
		{
			var rectObject = getSVGElement(currentMoveAddBoard.getAttribute("rectid"));
			if(rectObject && rectObject.getAttribute("class") == "AddSlotMove")
			{
				rectObject.setAttribute("class","AddSlot");
			}
		}
	}
	currentMoveAddBoard = addboard;
	var rectObject = getSVGElement(currentMoveAddBoard.getAttribute("rectid"));
	if(rectObject.getAttribute("class") == "AddSlot")
	{
		rectObject.setAttribute("class","AddSlotMove");
	}
	
}

function addboard_onmouseout(evt)
{
	var target = evt.target;
	if(currentMoveAddBoard)
	{
		if(currentMoveAddBoard.getAttribute("rectid") == "")
		{
			currentMoveAddBoard = null;
			return;
		}
		var cPos = getCurrentMoveBoardPoint(currentMoveAddBoard);
		if(!(evt.clientX >= cPos.x && evt.clientX <= (cPos.x + cPos.width)
			&& evt.clientY >= cPos.y && evt.clientY <=(cPos.y + cPos.height)))
		{
			var rectObject = getSVGElement(currentMoveAddBoard.getAttribute("rectid"));
			if(rectObject.getAttribute("class") == "AddSlotMove")
			{
				rectObject.setAttribute("class","AddSlot");
			}
			currentMoveAddBoard = null;
		}
	}
}

function getTargetObject(target,jsonname,value)
{
	if(target)
	{
		if(target.nodeName == "#document")
		{
			return null;
		}
		if(target.getAttribute(jsonname))
		{
			if((typeof(value) == "undefined" && target.getAttribute(jsonname) != "")
				|| (typeof(value) != "undefined" && target.getAttribute(jsonname) == value))
			{
				return target;
			}
		}
		return getTargetObject(target.parentNode,jsonname,value);
	}
	else
	{
		return target;
	}
}

/**
 * 
 */
function paintLine2AddBoard()
{
	var pos = getCurrentMoveBoardPoint(currentSelectSlot);
	var px = pos.x + pos.width/2 + 3;
	
	var py = pos.y + 10;
	if(pos.height < 20)
	{
		py = pos.y + pos.height/2;
	}
	var pathX = SHOW_BOARD_X;
	var pathY = 18;
	var sx = pathX - 5;
	var points = px+","+py+" "+sx+","+py+" "+sx+","+pathY+" "+pathX+","+pathY;
	var paths = createSVGElement("polyline");
	paths.setAttribute("points",points);
	paths.setAttribute("id","addBoardViewLine");
	paths.setAttribute("class","ShowPathLine");
	getSVGElement("svgBoardview").appendChild(paths);
}

/**
 *     
 * 
 * @param addboard
 */
function addCard(addboard)
{
	var slotId = addboard.slotId;
	var boardType = addboard.boardType;
	var slotList = addboard.slotList;
	currentAddBoard = addboard;
	var width = $("boardViewContainer").offsetWidth;
	var height = $("toolbar").offsetHeight;
	showWaitStatus(0,0,width,height);
	doAddBoard(slotList, slotId, boardType);
}

/**
 *       
 * 
 * @param addboard
 */
function addSubCard(addboard)
{
	var slotId = addboard.slotId;
	var subBoardType = addboard.boardType;
	var subBoardName = addboard.boardName;
	currentAddBoard = addboard;
	var width = $("boardViewContainer").offsetWidth;
	var height = $("toolbar").offsetHeight;
	showWaitStatus(0,0,width,height);
	doAddSubBoard(slotId, subBoardType,subBoardName);
}


/**
 *     
 * 
 * @param slotId
 */
function delCard(slotId)
{
	lastClickedSlot = -1;
	destroyShowBoard();
	var rectObject = getSVGElement(SLOT_PREFIX + slotId);
	setSlotRectClass(rectObject,"SlotPort");
	var card = getSVGElement(BOARD_PREFIX + slotId);
	var board = JSON.parse(card.getAttribute("oboard"));
	if(3 == board.boardState)
	{
		board.boardState = 2;
		var id = BOARD_PREFIX + slotId + BOARD_POSTFIX;
		bElm = getSVGElement(id);
        if(null != bElm)
        {
    		bElm.style.setProperty("fill",getBoardColor(board.boardState),"important");
        }
        var childs = card.childNodes;
        var child;
        for(var i = childs.length - 1; i >=0; i--)
        {
        	child = childs.item(i);
        	if("circle" == child.nodeName && "1" == child.getAttribute("alarm"))
        	{
        		child.setAttribute("display", "none");
        	}
        	if("svg" == child.nodeName && "1" == child.getAttribute("portlist"))
        	{
        		child.setAttribute("display", "none");
        	}
			if("svg" == child.nodeName && "1" == child.getAttribute("subBoardList"))
        	{
				for(var i = 1;i < 3;i++)
				{
					var tempSlot = "." + i;
					var subRectObject = getSVGElement(SUB_BOARD_PREFIX + slotId + tempSlot);
					
					if(null != subRectObject)
					{
						var subCard = getSVGElement(SUB_BOARD_AREA_PREFIX + slotId + tempSlot);
						if(null != subCard)
						{
							subRectObject.removeChild(subCard);
						}
					}
				}
        	}
        }
        var rect = getSVGElement(card.getAttribute("rectid"));
        rect.setAttribute("class", "SlotPhy");
        card.setAttribute("oboard", JSON.stringify(board));
	}
	else if(null != card)
	{
		rectObject.parentNode.removeChild(card);
	}
	setSlotRectClass(rectObject,"SlotUnselect");
}

/**
 *       
 * 
 * @param slotId
 */
function delSubCard(slotId)
{
	lastClickedSlot = -1;
	destroyShowBoard();
	var rectObject = getSVGElement(SUB_BOARD_PREFIX + slotId);

	var card = getSVGElement(SUB_BOARD_AREA_PREFIX + slotId);

	rectObject.removeChild(card);
	setSlotRectClass(rectObject,"SlotUnselect");
}

/**
 *         
 * 
 * @param board
 */
function paintBoardInfo(board)
{
	var portNum = board.portList.length;
	var x = SHOW_BOARD_COMMENTS_X;
	if(portNum > PORT_MAX_NUMBER_COLUMN)
	{
		x += BAR_WIDTH_DELTA;
	}
	var oPos = {x:x,y:SHOW_BOARD_COMMENTS_Y,width:SHOW_BOARD_COMMENTS_WIDTH,height:SHOW_BOARD_COMMENTS_HEIGHT};
	paintBoardComments(oPos, BOARD_COMMENTS_ID, RESOURCE["boardremark"] + board.comments, 40);
}

function paintBoardComments(oPos, id, text, dy)
{
	var bCtn = createSVGElement("svg");
	attr(bCtn,extendObj(oPos,{id:id}));
	var slotText = createSVGElement("text");
	attr(slotText,{x:0,y:15});
	setFontSize(slotText,10);

	var comments = text;
	if(null == comments)
	{
		comments = '';
	}
	if(null == dy || typeof(dy) == undefined || "" == dy)
	{
		dy = 0;
	}
	var boardComments = comments;
	var maxLen = 26;
	var strArray = splitString(boardComments, maxLen);
	var rowNum = 2;
	var needPopup = false;
	var len = strArray.length;
	if(strArray.length > rowNum)
	{
		needPopup = true;
		len = rowNum;
		var lstr = strArray[rowNum - 1];
		strArray[rowNum - 1] = lstr.substring(0, lstr.length - 3) + '...';
	}
	for(var i = 0; i < len; i++)
	{
		var tspan = createSVGElement("tspan");
		tspan.appendChild(createSVGText(strArray[i]));
		tspan.setAttribute("x","0");
		tspan.setAttribute("dy","15");
		if(i == 0)
		{
			tspan.setAttribute("dy","0");
		}            
		slotText.appendChild(tspan);
	}
	if(needPopup)
	{
		slotText.setAttribute("textcontent", boardComments);
		slotText.setAttribute("posX", oPos.x + 10);
		slotText.setAttribute("posY", dy);
		slotText.setAttribute("maxLen", maxLen);
		attachSVGEvent(slotText,"mouseover", showPortName);
		attachSVGEvent(slotText,"mouseout", hidePortName);		
	}
	
	bCtn.appendChild(slotText);
	getSVGElement("svgBoardview").appendChild(bCtn);
}

/**
 *                    
 * 
 * @param port
 */
function paintPortComments(port)
{
	var ele = getSVGElement(BOARD_COMMENTS_ID);
	if(null != ele)
	{
		ele.parentNode.removeChild(ele);
	}
	ele = getSVGElement(BOARD_DESC_ID);
	if(null != ele)
	{
		ele.parentNode.removeChild(ele);
	}
	var portNum = port.portNum;
	var x = SHOW_PORT_COMMENTS_X;
	if(portNum > PORT_MAX_NUMBER_COLUMN)
	{
		x += BAR_WIDTH_DELTA;
	}
	var oPos = {x:x,y:SHOW_PORT_COMMENTS_Y,width:SHOW_PORT_COMMENTS_WIDTH,height:SHOW_PORT_COMMENTS_HEIGHT};
	var bCtn = createSVGElement("svg");
	attr(bCtn,extendObj(oPos,{id:PORT_COMMENTS_ID}));
	var portText = createSVGElement("text");
	attr(portText,{x:0,y:15});
	setFontSize(portText,10);
	
	var tspan = createSVGElement("tspan");
	var content = port.slotId + "-" + port.boardName + "-" + port.portName;
	var txtcontent = content;
	var len = charLen(content);
	var maxLen = 25;
	if(len > maxLen)
	{
		txtcontent = content.substring(0,maxLen - 4);
		txtcontent += "...";
	}
	tspan.appendChild(createSVGText(RESOURCE["port"] + txtcontent));
	tspan.setAttribute("x","0");
	tspan.setAttribute("dy","0");
	tspan.setAttribute("textcontent",content);
	tspan.setAttribute("posY", "20");
	tspan.setAttribute("maxLen", maxLen);
	portText.appendChild(tspan);
	attachSVGEvent(portText,"mouseover", showPortName);
	attachSVGEvent(portText,"mouseout", hidePortName);

	if(1 == port.portState)
	{
		var portComments = RESOURCE["waveinfo"];	
		var len=charLen(portComments + port.waveLenInfo);
		if(len<30)
		{
		var tspan1 = createSVGElement("tspan");
		tspan1.appendChild(createSVGText(portComments + port.waveLenInfo));
		tspan1.setAttribute("x","0");
		tspan1.setAttribute("dy","20");
		tspan1.setAttribute("id","portwavelen");
		portText.appendChild(tspan1);	
		}
		else
		{
			var waveStr = port.waveLenInfo.split("/");
			var firstRow=waveStr[0]+"/"+waveStr[1]+"/"
			var tspan1 = createSVGElement("tspan");
			tspan1.appendChild(createSVGText(portComments + firstRow));
			tspan1.setAttribute("x","0");
			tspan1.setAttribute("dy","15");
			tspan1.setAttribute("id","portwavelen.0");
			portText.appendChild(tspan1);	
			
			var tspan2 = createSVGElement("tspan");
			tspan2.appendChild(createSVGText(waveStr[2]));
			tspan2.setAttribute("x","0");
			tspan2.setAttribute("dy","15");
			tspan2.setAttribute("id","portwavelen.1");
			portText.appendChild(tspan2);	
		}
	}
	bCtn.appendChild(portText);

	getSVGElement("svgBoardview").appendChild(bCtn);
}

function showPortName(evt)
{
	var ele = getSVGElement("portnamedetail");
	if(null != ele)
	{
		ele.parentNode.removeChild(ele);
	}
	var target = evt.target;
	var content = target.getAttribute("textcontent");
	if(null == content)
	{
		target = target.parentNode;
		content = target.getAttribute("textcontent");
	}
	var y = target.getAttribute("posY");
	if(null == y || typeof(y) == undefined || '' == y)
	{
		y = 20;
	}
	y = pInt(y);
	var x = target.getAttribute("posX");
	if(null == x || typeof(x) == undefined || '' == x)
	{
		x = SHOW_PORT_COMMENTS_X + 60;
	}
	x = pInt(x);
	var maxLen = pInt(target.getAttribute("maxLen"));
	if(charLen(content) > maxLen)
	{
		var strArray = splitString(content, maxLen);
		var rows = strArray.length;
		var width = maxLen * 7;
		var height = rows * 15 + 5;
		var txtbtn = createSVGElement("svg");
		attr(txtbtn,{x:x,y:y,width:width,height:height,id:"portnamedetail"});
		var rect = createSVGElement("rect");
		attr(rect,{width:"100%",height:"100%"});
		rect.setAttribute("class","portnamerect");
		txtbtn.appendChild(rect);
		var txt = createSVGElement("text");
		setFontSize(txt,10);

		for(var i = 0; i < rows; i++)
		{
			var tspan = createSVGElement("tspan");
			tspan.appendChild(createSVGText(strArray[i]));
			tspan.setAttribute("x","0");
			tspan.setAttribute("dy","15");
           
			txt.appendChild(tspan);
		}			
		txtbtn.appendChild(txt);
		getSVGElement("svgBoardview").appendChild(txtbtn);
	}
}

function showMenuName()
{
	
}

function hidePortName(evt)
{
	var ele = getSVGElement("portnamedetail");
	if(null != ele)
	{
		ele.parentNode.removeChild(ele);
	}
}

function button_onmouseout(evt)
{
	var target = evt.target;
	if(currentMoveAddBoard)
	{
		var cPos = getCurrentMoveBoardPoint(currentMoveAddBoard);
		if(!(evt.clientX >= cPos.x && evt.clientX <= (cPos.x + cPos.width)
			&& evt.clientY >= cPos.y && evt.clientY <=(cPos.y + cPos.height)))
		{
			var rectObject = currentMoveAddBoard.firstChild;
			var style = "ButtonStyle";
			if(1 == SYSTEMCONF.getStatus())
			{
				style = "ButtonStyleInteger";
			}
			rectObject.setAttribute("class", style);
			currentMoveAddBoard = null;
		}
	}
	var ele = getSVGElement("portnamedetail");
	if(null != ele)
	{
		ele.parentNode.removeChild(ele);
	}
}

function button_onmousemove(evt)
{	
	var target = evt.target;

	var button = getTargetObject(target,"type","button");
	if(currentMoveAddBoard && button)
	{
		if(currentMoveAddBoard.getAttribute("id") == button.getAttribute("id"))
		{
			return;
		}
		var rectObject = currentMoveAddBoard.firstChild;
		if(rectObject.getAttribute("class") == "ButtonStyleMove" || rectObject.getAttribute("class") == "ButtonStyleMoveInteger")
		{
			var style = "ButtonStyle";
			if(1 == SYSTEMCONF.getStatus())
			{
				style = "ButtonStyleInteger";
			}
			rectObject.setAttribute("class", style);
		}
	}
	currentMoveAddBoard = button;
	var rectObject = currentMoveAddBoard.firstChild;
	if(rectObject.getAttribute("class") == "ButtonStyle" || rectObject.getAttribute("class") == "ButtonStyleInteger")
	{
		var style = "ButtonStyleMove";
		if(1 == SYSTEMCONF.getStatus())
		{
			style = "ButtonStyleMoveInteger";
		}
		rectObject.setAttribute("class", style);
	}
}

function button_onmousedown(evt)
{
	var target = evt.target;
	var button = getTargetObject(target,"type","button");
	var rectObject = button.firstChild;
	var style = "ButtonStyleDown";
	if(1 == SYSTEMCONF.getStatus())
	{
		style = "ButtonStyleDownInteger";
	}
	rectObject.setAttribute("class", style);
}

function button_onmouseup(evt)
{
	var target = evt.target;
	var button = getTargetObject(target,"type","button");
	var rectObject = button.firstChild;
	var style = "ButtonStyle";
	if(1 == SYSTEMCONF.getStatus())
	{
		style = "ButtonStyleInteger";
	}
	rectObject.setAttribute("class", style);
}

/**
 *         
 * 
 * @param evt
 */
function delbtn_onclick(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	if((target.nodeName != 'DIV') && (target.nodeName != 'div'))
	{
		target = target.parentNode;
	}
	var param = target.getAttribute("deleteTarget");
	if('undefined' != param && null != param && '' != param)
	{
		if(param.indexOf("board_") > -1)
		{
			if(!btnRightArr.delboardbtn.right)
			{
				return;
			}
			$("deletebtn").className = "myborder2";
			var list = param.split(".");
			var len = list.length;
			var attrs = param.split("_");
			currentSelectBoard = null;
			if(len > 1)
			{
				var slotId = attrs[1];
				currentSelectedSlotId = slotId;

				window.confirm(RESOURCE["delboardhint"], "confirmOkSubBoard()", "confirmCancel()");
			}else
			{				
				var slotId = pInt(attrs[1]);
				currentSelectedSlotId = slotId;

				window.confirm(RESOURCE["delboardhint"], "confirmOkBoard()", "confirmCancel()");
			}
		}
		else if(param.indexOf("port_") > -1)
		{
	    	if(!btnRightArr.delportbtn.right)
	    	{
	    		return ;
	    	}
			$("deletebtn").className = "myborder2";
			window.confirm(RESOURCE["delporthint"], "confirmOkPort()", "confirmCancel()");
		}
	}
}

/**
 *         
 * 
 * @param id
 * @param name
 * @param clickfunc
 * @returns
 */
function createButton(index,id,posX,name,clickfunc)
{
	var slotC = createSVGElement("svg");
	attr(slotC,{x:2,y:2,width:170,height:20,id:id});
	slotC.setAttribute("type","button");
	var slotElm = createSVGElement("rect");
	var style = "ButtonStyle";
	if(1 == SYSTEMCONF.getStatus())
	{
		style = "ButtonStyleInteger";
	}
	attr(slotElm,{width:"100%",height:"100%"});
	slotElm.setAttribute("class", style);
	slotC.appendChild(slotElm);
	slotC.setAttribute("rectid",slotElm.getAttribute("id"));

	var slotText = createSVGElement("text");
	attr(slotText,{x:5,y:15});
	setFontSize(slotText, 10);
	var cLen = charLen(name);
	if(cLen == 0)
	{
		name = "UNKNOWN";
	}
	var maxLen = 25;
	if(cLen > maxLen)
	{
		txtcontent = name.substring(0,maxLen - 4);
		txtcontent += "...";
		slotText.appendChild(createSVGText(txtcontent));
		slotText.setAttribute("textcontent", name);
		var y = SHOW_BOARD_BUTTON_Y + 175 + 23 * index;
		slotText.setAttribute("posX", posX + 5);
		slotText.setAttribute("posY", y);
		slotText.setAttribute("maxLen", maxLen);
		attachSVGEvent(slotText,"mouseover", showPortName);
	}
	else
	{
		slotText.appendChild(createSVGText(name));
	}
	attachSVGEvent(slotC,"mousemove",button_onmousemove);
	attachSVGEvent(slotC,"mouseout",button_onmouseout);
	attachSVGEvent(slotC,"mousedown",button_onmousedown);
	attachSVGEvent(slotC,"mouseup",button_onmouseup);
	attachSVGEvent(slotC,"click",clickfunc);
	slotC.appendChild(slotText);
	return slotC;
}

/**
 *       
 */
function rightmenu_onclick(evt)
{
    var target = evt.target;
    var button = getTargetObject(target,"slotID");
    if(button)
    {
        var slotID = convertSlotToBigSlot(button.getAttribute("slotID"));
        var boardMenuID = button.getAttribute("boardMenuID");
 		if(slotID)
 		{
 			 boardMenuFunc(boardMenuID,slotID);
 		}
     }
}

/**
 *         
 */
function rightsubboardmenu_onclick(evt)
{
    var target = evt.target;
    var button = getTargetObject(target,"slotID");
    if(button)
    {
		var tempSlotid = button.getAttribute("slotID").split(".");
		var slotid = tempSlotid[0];
		var subSlotID = tempSlotid[1];
		
        var slotID = convertSlotToBigSlot(slotid);
        var boardMenuID = button.getAttribute("boardMenuID");
 		if(slotID)
 		{
 			 subBoardMenuFunc(boardMenuID,slotID,subSlotID);
 		}
     }
}

/**
 *     
 */
function paintOperationMenu(board,menuIDs)
{
    var portNum = board.portList.length;
	var posX = SHOW_BOARD_BUTTON_X+15;
	var widthx = SHOW_BOARD_BUTTON_WIDTH+70;
	if(portNum > PORT_MAX_NUMBER_COLUMN)
	{
		posX += BAR_WIDTH_DELTA;
	}
	  
	var boardMenuIDs = menuIDs.split(",");
	var oPos = {x:posX,y:SHOW_BOARD_BUTTON_Y+150,width:widthx,height:boardMenuIDs.length*25};
	var bCtn = createSVGElement("svg");
		
	attr(bCtn,extendObj(oPos,{id:BOARD_RIGHT_MENU}));
		
	for(var i=0;i<boardMenuIDs.length;i++)
	{
		 var boardMenuNameID="boardMenu_"+boardMenuIDs[i];
		 var rigthMenu = createButton(i,"boardMenu."+boardMenuIDs[i],posX,RESOURCE[boardMenuNameID],rightmenu_onclick);
		 rigthMenu.setAttribute("slotID",board.slotId);
		 rigthMenu.setAttribute("boardMenuID",boardMenuIDs[i]);
		 rigthMenu.setAttribute("y",23*i);
		 bCtn.appendChild(rigthMenu);
	}

	getSVGElement("svgBoardview").appendChild(bCtn);
}

/**
 *       
 */
function paintOperationSubBoardMenu(board,menuIDs)
{
    var portNum = board.portList.length;
	var posX = SHOW_BOARD_BUTTON_X+15;
	var widthx = SHOW_BOARD_BUTTON_WIDTH+70;
	if(portNum > PORT_MAX_NUMBER_COLUMN)
	{
		posX += BAR_WIDTH_DELTA;
	}
	  
	var boardMenuIDs = menuIDs.split(",");
	var oPos = {x:posX,y:SHOW_BOARD_BUTTON_Y+150,width:widthx,height:boardMenuIDs.length*25};
	var bCtn = createSVGElement("svg");
		
	attr(bCtn,extendObj(oPos,{id:BOARD_RIGHT_MENU}));
		
	for(var i=0;i<boardMenuIDs.length;i++)
	{
		 var boardMenuNameID="boardMenu_"+boardMenuIDs[i];
		 var rigthMenu = createButton(i,"boardMenu."+boardMenuIDs[i],posX,RESOURCE[boardMenuNameID],rightsubboardmenu_onclick);
		 rigthMenu.setAttribute("slotID",board.slotId);
		 rigthMenu.setAttribute("boardMenuID",boardMenuIDs[i]);
		 rigthMenu.setAttribute("y",23*i);
		 bCtn.appendChild(rigthMenu);
	}

	getSVGElement("svgBoardview").appendChild(bCtn);
}
/**
 *          
 */
function boardMenuFunc(boardMenuID,slotID)
{
    var xml = createboardFuncXML(boardMenuID,slotID);
	if(xml == null)
	{
		return;
	}
	var urlstr = "../../../../../../linkInterFuncServlet?neid=" + neid + "&prohandler=0&switchtype=5";
	loadXMLdoc(urlstr, "POST", true, boardMenuFuncCallback, null, "inputdata="+xml);
}

/**
 *            
 */
function subBoardMenuFunc(boardMenuID,slotID,subSlotID)
{
    var xml = createsubBoardFuncXML(boardMenuID,slotID,subSlotID);
	if(xml == null)
	{
		return;
	}
	var urlstr = "../../../../../../linkInterFuncServlet?neid=" + neid + "&prohandler=0&switchtype=5";
	loadXMLdoc(urlstr, "POST", true, subBoardMenuFuncCallback, null, "inputdata="+xml);
}

/**
 *   
 */
function  createboardFuncXML(boardMenuID,slotID)
{
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param","neid",neid);
	row.appendChild(param);
	param = new tagElement("param","optixNEID",optixNEID);
	row.appendChild(param);
	param = new tagElement("param","sessionid",sessionID);
	row.appendChild(param);
    param = new tagElement("param","funcid",boardMenuID);
	row.appendChild(param);
	param = new tagElement("param","slotid",slotID);
	row.appendChild(param);
	    
	business.appendChild(row);
	root.getRoot().appendChild(business);
	    
	return root.toString();
}

/**
 *       
 */
function  createsubBoardFuncXML(boardMenuID,slotID,subSlotID)
{
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param","neid",neid);
	row.appendChild(param);
	param = new tagElement("param","optixNEID",optixNEID);
	row.appendChild(param);
	param = new tagElement("param","sessionid",sessionID);
	row.appendChild(param);
    param = new tagElement("param","funcid",boardMenuID);
	row.appendChild(param);
	param = new tagElement("param","slotid",slotID);
	row.appendChild(param);
	param = new tagElement("param","subSlotID",subSlotID);
	row.appendChild(param);
	
	business.appendChild(row);
	root.getRoot().appendChild(business);
	    
	return root.toString();
}

function boardMenuFuncCallback()
{
 
}

function subBoardMenuFuncCallback()
{
 
}

/**
 *    confirm      
 */
function confirmCancel()
{
	$("deletebtn").className = "myborder1";
}

/**
 *    confirm      
 */
function confirmOkBoard()
{
	destroyTooltip();
	var width = $("boardViewContainer").offsetWidth;
	var height = $("toolbar").offsetHeight;
	showWaitStatus(0,0,width,height);
	doDelBoard(currentSelectedSlotId);
}

/**
 *    confirm      -  
 */
function confirmOkSubBoard()
{
	destroyTooltip();
	var width = $("boardViewContainer").offsetWidth;
	var height = $("toolbar").offsetHeight;
	showWaitStatus(0,0,width,height);
	doDelSubBoard(currentSelectedSlotId);
}

/**
 *    confirm      
 */
function confirmOkPort()
{	
	var width = $("boardViewContainer").offsetWidth;
	var height = $("toolbar").offsetHeight;
	showWaitStatus(0,0,width,height);
	var param = $("deletebtn").getAttribute("deleteTarget");
	if(param.indexOf("port_") > -1)
	{
		var attrs = param.split("_");
		var slotid = pInt(attrs[1]);
		var portid = pInt(attrs[2]);
	    doDeletePort(slotid, portid);
	}
}
