loadXMLdoc("../../../../../../conf/system.xml","GET",false,EncapsulateSConf);
var language = SYSTEMCONF.getLanguage();
getResourse("../../../../../../res/necommres_"+ language +".xml"); //      
getResourse("../../../../../necommon/res/subrackres_"+ language +".xml"); //      
getResourse("../../../../../../res/validatestring_"+ language +".xml"); //      


var subrackID = getNeProperty(self).subrackID;
var blModify = false;
if(subrackID != null && typeof(subrackID) != "undefined" && subrackID >= 0)
{
	blModify = true;
	document.title = RESOURCE["modifysubrack"];
}
else
{
	document.title = RESOURCE["addsubrack"];
}
var table = new  CTable();
var win = window.dialogArguments;
var NETYPE_8800 = "68";//8800     
var NETYPE_8800_2 = "74";//8800     

    
function init()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];   
	$("applyBtn").value = RESOURCE["applybutton"];   
	table.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
	if(blModify)
	{
		var currentSubrack = win.getSubrack(subrackID);
		var atom = new Atom("span");
		atom.setValue(getNeProperty(self).subrackID);
		table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);
		atom = new Atom("span");
		atom.setValue(RESOURCE["TYPE_" + currentSubrack.logicSubrackType]);
		table.addAttrRow("subrackType", RESOURCE["subrackType"], atom);
		atom = new Atom("text");
		atom.element.maxLength = 256;
		checkInputData(atom.element, 256);
		table.addAttrRow("subrackMemo",RESOURCE["subrackMemo"], atom);
		
		if( currentSubrack.logicSubrackType == NETYPE_8800_2 || currentSubrack.logicSubrackType == NETYPE_8800)
		{
			initCrossOption(atom,true);

			var crossTypeXml = createCrossTypeXML();
			
			loadXMLdoc("../../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_SHELFCROSSTYPE, "POST", false,queryShelfCrossTypeCallBack, null,"inputdata="+crossTypeXml);
		}
		else
		{
			atom = new Atom("select");
			atom.addOption("-", -1);
			table.addAttrRow("crossType",RESOURCE["crossType"], atom);
			atom.element.disabled = true;
	
			atom = new Atom("select");
			atom.addOption("-", -1);
			table.addAttrRow("crossCapacity",RESOURCE["crossCapacity"], atom);	
			atom.element.disabled = true;
		}
	}
	else
	{
		var atom = new Atom("select");
		var existSubrackIDArr = win.Tab.getAllTabsID();
		for(var i = 1; i <= win.MAX_SUBRACK_NUM; i++)
		{
			if(!existSubrackIDArr.contains(i)) // i       
			{
				atom.addOption(i, i);
			}
		}
		table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);
		
	
		atom = new Atom("select");
	
		table.addAttrRow("subrackType",RESOURCE["subrackType"], atom);
		atom.addOption(RESOURCE["TYPE_51"], 51);

		if( compare(win.nePro["neversion"],"5.51.05.10") > 0 )
		{
			atom.addOption(RESOURCE["TYPE_68"], 68);
      atom.addOption(RESOURCE["TYPE_74"], 74);
		}
		else
		{
			if( win.nePro["neType"] == NETYPE_8800 )
			{
				atom.addOption(RESOURCE["TYPE_68"], 68);
			}
		}
		
		atom.element.onchange = function()
		{
			if( table.getAttrValue("subrackType") == "74" || table.getAttrValue("subrackType") == "68")
			{
				table.getAtom("crossType").element.disabled = false;
				table.getAtom("crossCapacity").element.disabled = false;
			}
			else
			{
				table.getAtom("crossType").element.disabled = true;
				table.getAtom("crossCapacity").element.disabled = true;
			}
		}
		
		atom = new Atom("text");
		atom.element.maxLength = 256;
		checkInputData(atom.element, 256);
		table.addAttrRow("subrackMemo",RESOURCE["subrackMemo"], atom);
		
		initCrossOption(atom,true);
	
	}
	document.body.insertBefore(table.getTable(), $("AddTable"));
}


/**
 *           xml  
 */
function createAddXML()
{ 
	var subrackID = table.getAttrValue("subrackID"); //          ID
	var subrackType = table.getAttrValue("subrackType"); //            
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	
	var root = new inputxml("datainterface"); 
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var param = new tagElement("param"); 
	param.setAttribute("name", "neID");
	param.setAttribute("value",win.neid);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackID");
	if(subrackID.indexOf("-")!=-1)
	{
		subrackID = subrackID.split("-")[0];
	}
	param.setAttribute("value",subrackID);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackType");
	param.setAttribute("value",subrackType);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "memo");
	param.setAttribute("value",subrackMemo);
	row.appendChild(param);
	
	
	if( (table.getAttrValue("subrackType") == "74" ||table.getAttrValue("subrackType") == "68") && 
			table.getAtom("crossType") != null && 
			table.getAtom("crossCapacity") != null )
	{
		var crossType = table.getAttrValue("crossType");
		var crossCapacity = table.getAttrValue("crossCapacity");
		
		param = new tagElement("param"); 
		param.setAttribute("name", "crossType");
		param.setAttribute("value",crossType);
		row.appendChild(param);
		param = new tagElement("param"); 
		param.setAttribute("name", "crossCapacity");
		param.setAttribute("value",crossCapacity);
		row.appendChild(param);
	}
	
	
	
	bussiness.appendChild(row); 
	root.getRoot().appendChild(bussiness);
	return root.toString();	
}


/**
 *        
 */
function addSubrack(btnFlg)
{
	if(btnFlg && $("applyBtn").disabled)
	{
		win.SHOW_SUBRACK_DIALOG = false;
		xcloseDialog(); //                        
		return;
	}
		
	var subrackID = table.getAttrValue("subrackID"); //          ID
	if(subrackID.indexOf("-")!=-1)
	{
		subrackID = subrackID.split("-")[0];
	}
	if(subrackID == null || subrackID == "")
	{
		alert(RESOURCE["cannotadd"]);
		return;
	}
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	if(subrackMemo == null)
	{
		alert(RESOURCE["memonotnull"]);
		return;
	}
	if(!checkValidateXMLString(subrackMemo))
	{
		return;
	}	
	var existSubrackIDArr = win.Tab.getAllTabsID();
	if(existSubrackIDArr.contains(subrackID)) //          ,     
	{
		alert(RESOURCE["subrackExist"]); //                   
		return;
	}
	
	$("okBtn").disabled = true;
	$("applyBtn").disabled = true;
	var addXML = createAddXML(); //        xml
	var paramArr = [];
	paramArr[0] = subrackID;
	paramArr[1] = table.getAttrValue("subrackType");
	paramArr[2] = table.getAttrValue("subrackMemo");
	paramArr[3] = btnFlg;
	
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="+TECMDCODE_ADD_SUBRACK, "POST", false,addSubrackCallBack, paramArr,"inputdata="+addXML);
}

function doSubrack(btnFlg)
{
	if(blModify)
	{
		modifySubrack(btnFlg);
	}
	else
	{
		addSubrack(btnFlg);
	}
}

/**
 *       
 */
function modifySubrack(btnFlg)
{
	if(btnFlg && $("applyBtn").disabled)
	{
		xcloseDialog(); //                        
		return;
	}
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	if(subrackMemo == null)
	{
		alert(RESOURCE["memonotnull"]);
		return;
	}
	if(!checkValidateXMLString(subrackMemo))
	{
		return;
	}	
	$("okBtn").disabled = true;
	$("applyBtn").disabled = true;
	var modifyXML = createAddXML(); //        xml
	var paramArr = [];
	paramArr[0] = subrackID;
	paramArr[1] = table.getAttrValue("subrackType");
	paramArr[2] = table.getAttrValue("subrackMemo");
	paramArr[3] = btnFlg;
	
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="+TECMDCODE_SET_SUBRACK_NAME, "POST", false,modifySubrackCallBack, paramArr,"inputdata="+modifyXML);

}

function modifySubrackCallBack(doc,paramArr)
{
	var addData = EncapsulateData(doc); //       
	if(addData.getSErrorCode() != 0) //    
	{
		win.showErrorDialog(addData); 
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		return;
	}
	win.refreshShowAfterModify(paramArr[0], paramArr[1],paramArr[2]); //      Tab   
	if(paramArr[3]) //    
	{
		xcloseDialog(); //     
	}
	else
	{
		$("okBtn").disabled = false;
		$("applyBtn").disabled = true;
	}
}

/**
 *             
 */
function addSubrackCallBack(doc, paramArr)
{
	var addData = EncapsulateData(doc); //       
	showErrorDialog(addData); 
		
	if(addData.getSErrorCode() != 0 && addData.getSErrorCode() != 1) //    
	{
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		return;
	}
	
	win.refreshShowAfterAddTab(paramArr[0], paramArr[1],paramArr[2]); //      Tab   
	if(paramArr[3] && addData.getSErrorCode() == 0) //    
	{
		xcloseDialog(); //     
	}
	else
	{
		$("okBtn").disabled = false;
		var subrackIDAtom = table.getAtom("subrackID").element;
		subrackIDAtom.options.remove(subrackIDAtom.selectedIndex);
		if(subrackIDAtom.options.length > 0)
		{
			$("applyBtn").disabled = false;
		}
	}
}


/**
*               
*/
function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "subrackID"; //         ID
	openErrPage("../../../../../../page/", data.getError(), errArr);
	errArr = null;
}

/**
*           
*/
function cancelBtnAction()
{
	win.SHOW_SUBRACK_DIALOG = false;
	xcloseDialog();//     
}

function checkInputData(obj,maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);        
    }
    
    obj.onkeydown = function()
    {
    	  var letterFlg = forbidSignInput();//      
    	  if(!letterFlg)
    	  {
    	      return letterFlg;
    	  }
    	  var code=event.keyCode!=0?event.keyCode:event.charCode;
    	  if(!event.shiftKey && !event.ctrlKey && (code <= 36 || code >= 41) && code != 9 || (event.shiftKey && code != 16))
    	  {
    	      $("applyBtn").disabled = false;
    	  }
    }
}

function forbidSignInput()
{
    var key = event.keyCode!=0?event.keyCode:event.charCode;
        
    if(event.shiftKey)
    {
        if(key == 188 || key == 222)//   <       
        {
            return false;
        }
    }
    return true;
}


function initCrossOption(atom,disableFlag)
{
		atom = new Atom("select");
		atom.addOption(RESOURCE["crossType0"], 0);
		atom.addOption(RESOURCE["crossType1"], 1);
		atom.addOption(RESOURCE["crossType2"], 2);
		atom.addOption(RESOURCE["crossType3"], 3);
		atom.element["onchange"] = function()
	    {
			$("applyBtn").disabled = false;
	    }
    if (compare(win.nePro["neversion"], "5.51.08.10") >= 0) 
    {
        atom.addOption(RESOURCE["crossType4"], 4);
        atom.addOption(RESOURCE["crossType5"], 5);
        atom.addOption(RESOURCE["crossType6"], 6);
        atom.addOption(RESOURCE["crossType7"], 7);
    }
		table.addAttrRow("crossType",RESOURCE["crossType"], atom);
		atom.element.disabled = disableFlag;

		atom = new Atom("select");
		atom.addOption(RESOURCE["crossCapacity0"], 0);
		atom.addOption(RESOURCE["crossCapacity1"], 360);
		atom.addOption(RESOURCE["crossCapacity7"], 640);
		atom.addOption(RESOURCE["crossCapacity2"], 720);
		atom.addOption(RESOURCE["crossCapacity3"], 1280);
		atom.addOption(RESOURCE["crossCapacity4"], 2560);
		atom.element["onchange"] = function()
	    {
			$("applyBtn").disabled = false;
	    }
		table.addAttrRow("crossCapacity",RESOURCE["crossCapacity"], atom);	
		atom.element.disabled = disableFlag;
}


function init1588V2(atom, subtrackType)
{
    if (compare(win.nePro["neversion"], "5.51.08.10") >= 0) 
    {
        /* JIRA TRANSV1R9C00-6219, modify by xieli 00208063 begin */
    	if (subtrackType == 110) // 1832    
		{
			atom.clearOptions();
			atom.addOption("-", -1);
			atom.element.disabled = true;
		}
		else // 1832    
		{
        	atom.element.disabled = false;
        	atom.clearOptions();
			atom.addOption(RESOURCE["ID_ENABLE"], 1);
        	atom.addOption(RESOURCE["ID_DISABLE2"], 0);
		}
        /* JIRA TRANSV1R9C00-6219, modify by xieli 00208063 end */
    }
}
function createCrossTypeXML()
{
	var subrackID = table.getAttrValue("subrackID"); //          ID
	var subrackType = table.getAttrValue("subrackType"); //            
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	
	var root = new inputxml("datainterface"); 
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var param = new tagElement("param"); 
	param.setAttribute("name", "neID");
	param.setAttribute("value",win.neid);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackID");
	param.setAttribute("value",subrackID);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackType");
	param.setAttribute("value",subrackType);
	row.appendChild(param);
	
	bussiness.appendChild(row); 
	root.getRoot().appendChild(bussiness);
	return root.toString();	
}


function queryShelfCrossTypeCallBack(doc)
{
	var data = EncapsulateData(doc); //       
    if (data.getSErrorCode() != 0 && data.getSErrorCode() != 1) 
    {
        return;
    }
    
	for( var i=0; i<data.getDataRowLength(); i++ )
	{
		var theKey = data.getDataRowParam(i, "licensetype");
		var theVal = data.getDataRowParam(i, "licensecapacity");
        var shelf1588 = data.getDataRowParam(i, "self1588");
        var sdhlowcross = data.getDataRowParam(i, "sdhlowcross");
		
		if( theKey == "1" )
		{
			var crsTypeAtom = table.getAtom("crossType");
			if( crsTypeAtom != null )
			{
				crsTypeAtom.setValue(theVal);
			}
		}
        if (theKey == "2") 
        {
            var crsCapcAtom = table.getAtom("crossCapacity");
            if (crsCapcAtom != null) 
            {
                crsCapcAtom.setValue(theVal);
            }
        }
        if (shelf1588 && shelf1588 != "" && table.getAtom("1588v2") != null) 
        {
            table.getAtom("1588v2").setValue(shelf1588);
        }
        if (sdhlowcross && sdhlowcross != "" && table.getAtom("sdhlowcross") != null) 
        {
            table.getAtom("sdhlowcross").setValue(sdhlowcross);
        }
    }
    var currentSubrack = win.getSubrack(subrackID);
    if (!isSupportCross(currentSubrack.logicSubrackType)) 
    {
        table.getAtom("crossType").addOption("-", -1);
        table.getAtom("crossType").setValue(-1);
        table.getAtom("crossType").element.disabled = true;
        table.getAtom("crossCapacity").addOption("-", -1);
        table.getAtom("crossCapacity").setValue(-1);
        table.getAtom("crossCapacity").element.disabled = true;
    }
}

/**
 *         
 * @param {Object} subracktype
 */
function isSupportCross(subracktype)
{
    var bResult = false;
    
    if (subracktype == NETYPE_8800 ||
    subracktype == NETYPE_8800_2 ||
    subracktype == NETYPE_8800_16 ||
    subracktype == NETYPE_8800_32E ||
    subracktype == NETYPE_8800_64E ||
    subracktype == NETYPE_1832_STD) 
    {
        bResult = true;
    }
    return bResult;
}
/**
*               
*/
function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
	var tempArr = data.getError().rowErrors;
	var size = data.getBErrLength();
	for(var i = 0;i < size;i++)
	{
		var tempObj = tempArr[i].errorObj;
		if(tempObj["subrackID"] != null)
		{
			tempObj["subrackID"] = RESOURCE["subrackID"] + ":" + tempObj["subrackID"];
		}
		if (tempObj["licensetype"] != null && parseInt(tempObj["licensetype"]) == 2)
		{
			tempObj["subrackID"] += "-" + RESOURCE["crossCapacity"];
		}
	}	
	errArr[1] = "subrackID"; //         ID
	openErrPage("../../../../../../page/", data.getError(), errArr);
	errArr = null;
}
