/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.device.ngwdm.bdmgr_r7c02;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Vector;

public class TEOneKeyAddBoardAction
extends TENEExplorerBean {
    private static final String SLOT_ID_PARAM = "slotID";
    private static final String BOARD_TYPE_PARAM = "boardType";
    private static final int ONE_BOARD_TIME = 6;
    private static final int ERROR_CODE_38881 = 38881;

    public int getTimeOut() {
        return this.TIME_OUT;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        try {
            int size = operationList.size();
            for (int index = 0; index < size; ++index) {
                Operation addBoardOperation = (Operation)operationList.get(index);
                Part part = Definitions.getParam((Part[])addBoardOperation.getInput().getPart(), (String)SLOT_ID_PARAM);
                int slotid = Integer.parseInt(part.getValue());
                part = Definitions.getParam((Part[])addBoardOperation.getInput().getPart(), (String)BOARD_TYPE_PARAM);
                int boardType = Integer.parseInt(part.getValue());
                String addBoardErrorCode = addBoardOperation.getOutput(0).getFault(0).getCode();
                if (!addBoardErrorCode.equals("0")) continue;
                this.addBoard(slotid, boardType);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Batch Add memery Board Fault!", (Throwable)e);
            this.outputData.getErrorMessage().setErrorcode(String.valueOf(2));
            this.outputData.getErrorMessage().setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)2));
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(new Integer(38881));
        return errorCodeList;
    }

    private void addBoard(int slotid, int boardType) {
        try {
            TENE neObj;
            Vector<TEBoard> boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
            if (null == boardList) {
                boardList = new Vector<TEBoard>();
            }
            if (null != (neObj = TENEListMgr.getInstance().getNE(this.neid))) {
                boardList.remove(neObj.getBoard(slotid));
            }
            boardList.add(new TEBoard(this.neid, slotid, boardType));
            TENEListMgr.getInstance().getNE(this.neid).setLastBoardModifyTime();
            TENEListMgr.getInstance().getNE(this.neid).setBoardList(boardList);
            TEQueryLogicPort.queryExistLogicPort((int)this.neid, (int)slotid, (int)boardType);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Add memery Board Fault!", (Throwable)e);
            return;
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(subfunc.getCode());
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode != 0) {
                loginfo.setResult(2);
            } else {
                loginfo.setResult(0);
            }
            if (errorCode == 2) {
                for (int i = outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
                    if (outputData.getBussinessParams().getRowParams(i).getRowErrorsCount() <= 0) continue;
                    errorCode = Integer.parseInt(outputData.getBussinessParams().getRowParams(i).getRowErrors(0).getErrorMessage().getErrorcode());
                    break;
                }
            }
            loginfo.setErrCode(errorCode);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            loginfo.setLocation(ipAddress);
            StringBuffer operDesStr = new StringBuffer();
            int slotid = 0;
            String boardNameStr = "";
            int pcount = inputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < pcount; ++i) {
                String subrackName = "";
                slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(i).getParam(SLOT_ID_PARAM).getValue());
                int iboardType = Integer.parseInt(inputData.getBussinessParams().getRowParams(i).getParam(BOARD_TYPE_PARAM).getValue());
                boardNameStr = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, iboardType);
                subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid);
                if (!subrackName.equals("")) {
                    subrackName = subrackName + "-";
                }
                operDesStr.append(subrackName).append(TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid)).append("-").append(boardNameStr).append(" ");
            }
            loginfo.setOperateDesc(operDesStr.toString());
            loginfo.setOperateName(subfunc.getSubFuncDes(neid));
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            loginfo.setOperateObject(operObj);
            loginfo.setUserID(0);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            TELogMgr.writeLog((TELogInfo)loginfo);
        }
        catch (NumberFormatException e1) {
            TELogFactory.getNormalLogger().error("Write Log Fail!", (Throwable)e1);
        }
        catch (IndexOutOfBoundsException e2) {
            TELogFactory.getNormalLogger().error("Write Log Fail!", (Throwable)e2);
        }
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        ArrayList logBdNotInstall = this.getLogBdNotInstalled(neid);
        BussinessParams bparams = inputData.getBussinessParams();
        bparams.clearRowParams();
        TEBoard lgbd2 = null;
        for (TEBoard lgbd2 : logBdNotInstall) {
            RowParams rParams = new RowParams();
            Param param_NEID = new Param();
            param_NEID.setName("neid");
            param_NEID.setValue(String.valueOf(lgbd2.getNEID()));
            rParams.addParam(param_NEID);
            Param param_slotID = new Param();
            param_slotID.setName(SLOT_ID_PARAM);
            param_slotID.setValue(String.valueOf(lgbd2.getSlotID()));
            rParams.addParam(param_slotID);
            Param param_boardType = new Param();
            param_boardType.setName(BOARD_TYPE_PARAM);
            param_boardType.setValue(String.valueOf(lgbd2.getBoardType()));
            rParams.addParam(param_boardType);
            bparams.addRowParams(rParams);
        }
        this.TIME_OUT = 6 * bparams.getRowParamsCount() + 10;
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    private ArrayList getLogBdNotInstalled(int neID) {
        TENE currentNE = TENEListMgr.getInstance().getNE(neID);
        Vector logicBdVec = currentNE.getClonedBoardList();
        Vector phyBdVec = currentNE.getClonedPhyBoardList();
        ArrayList<TEBoard> logBdInstallList = new ArrayList<TEBoard>();
        TEBoard lgBoard = null;
        TEBoard phyBoard = null;
        boolean isInstallLgBd = false;
        for (int phybdIdx = 0; phybdIdx < phyBdVec.size(); ++phybdIdx) {
            isInstallLgBd = false;
            phyBoard = (TEBoard)phyBdVec.get(phybdIdx);
            for (int lgbdIndex = 0; lgbdIndex < logicBdVec.size(); ++lgbdIndex) {
                lgBoard = (TEBoard)logicBdVec.get(lgbdIndex);
                if (lgBoard.getSlotID() != phyBoard.getSlotID()) continue;
                isInstallLgBd = true;
                break;
            }
            if (isInstallLgBd) continue;
            logBdInstallList.add(phyBoard);
        }
        return logBdInstallList;
    }
}

