/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.device.ngwdm.bdmgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.necommon.fault.TEAlarmAdapterCache;
import com.huawei.nglct.nemgr.ngwdm.TENE_NGWDM;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Vector;

public class TEAddBoardAction
extends TENEExplorerBean {
    private static final String SLOT_ID_PARAM = "slotID";
    private static final String BOARD_TYPE_PARAM = "boardType";
    private static final int BOARD_EXIST_ERROR = 38665;
    public int slotid;
    private int boardType;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        if (this.outputData.getErrorMessage().getErrorcode().equals(String.valueOf(0))) {
            this.addBoard();
        }
        RowParams rowparams = null;
        if (null != this.outputData.getBussinessParams() && this.outputData.getBussinessParams().getRowParamsCount() > 0 && (rowparams = this.outputData.getBussinessParams().getRowParams(0)).getRowErrorsCount() > 0 && rowparams.getRowErrors(0).getErrorMessage().getErrorcode().equals(String.valueOf(38665))) {
            TENE_NGWDM subNEObj = (TENE_NGWDM)TENEListMgr.getInstance().getNE(neid);
            subNEObj.queryBoard();
        }
    }

    private void addBoard() {
        try {
            Vector boardList = TENEListMgr.getInstance().getNE(this.neid).getBoardList();
            Operation operation = (Operation)this.operationList.get(0);
            Part part = Definitions.getParam((Part[])operation.getInput().getPart(), (String)SLOT_ID_PARAM);
            this.slotid = Integer.parseInt(part.getValue());
            part = Definitions.getParam((Part[])operation.getInput().getPart(), (String)BOARD_TYPE_PARAM);
            this.boardType = Integer.parseInt(part.getValue());
            boardList.add(new TEBoard(this.neid, this.slotid, this.boardType));
            TEAlarmAdapterCache.getInstatce().queryNeBoardMode(this.neid, this.slotid, this.boardType);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Add memery Board Fault!", (Throwable)e);
            return;
        }
    }

    public boolean isNeedOperationlog(String ipAddress) {
        try {
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(this.subfunc.getCode());
            int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
            loginfo.setResult(errorCode);
            if (errorCode == 2) {
                errorCode = Integer.parseInt(this.outputData.getBussinessParams().getRowParams(0).getRowErrors(0).getErrorMessage().getErrorcode());
            }
            loginfo.setErrCode(errorCode);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            loginfo.setLocation(ipAddress);
            String boardName = TENEListMgr.getInstance().getNE(this.neid).getBoard(this.slotid).getBoardName();
            String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotid);
            if (!"".equals(subrackName)) {
                subrackName = subrackName + "-";
            }
            loginfo.setOperateDesc(subrackName + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotid) + "-" + boardName);
            loginfo.setOperateName(this.subfunc.getDes());
            loginfo.setOperateObject(String.valueOf(this.neid));
            loginfo.setResult(Integer.parseInt(this.outputData.getErrorMessage().getErrorcode()));
            loginfo.setUserID(0);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            TELogMgr.writeLog((TELogInfo)loginfo);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Write Log Fail!", (Throwable)e);
            return false;
        }
        return false;
    }
}

