 var availableTimeslotTable;
var selectedTimeslotTable;

var language = SYSTEMCONF.getLanguage();
var win = getParentWindow();
document.title=RESOURCE["createVirtualInterface"];

/**
 *      
 * @param  
 * @return  
 */
function initBody()
{
	initTable();
	
	queryTimeslot(win.availableTimeslot);
	
    $("okbutton").value = RESOURCE["okbutton"];
    
    $("cancelbutton").value = RESOURCE["cancelbutton"];
}

/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
	initAvaiableTimeslotTable();
	initSelectedTimeslotTable()
}

function initAvaiableTimeslotTable()
{
	$("avaiablets").innerHTML = RESOURCE["availabletimeslot"];
	loadXMLdoc("../../conf/ason/vc4timeslottable_" + language + ".xml", "GET", false, EncapsulateTable, null);
	availableTimeslotTable = new SortTable();
	availableTimeslotTable.setImage("../../../../../images/");
	
	availableTimeslotTable.isUsedForSelectList = true;
	createTableHead(availableTimeslotTable, window.tableconf[0]); 
	$("avaiabletstable").appendChild(availableTimeslotTable.getTable());  
	
	availableTimeslotTable.setBodyHeight("380px");
	
	availableTimeslotTable.setOnRowSelectHandler(linkTableRowSelectHandler); 
}

function initSelectedTimeslotTable()
{
	$("selectedts").innerHTML = RESOURCE["selectedtimeslot"];
	loadXMLdoc("../../conf/ason/vc4timeslottable_" + language + ".xml", "GET", false, EncapsulateTable, null);
	selectedTimeslotTable = new SortTable();
	selectedTimeslotTable.setImage("../../../../../images/");
	
	selectedTimeslotTable.isUsedForSelectList = true;
	createTableHead(selectedTimeslotTable, window.tableconf[1]); 
	
	selectedTimeslotTable.setBodyHeight("380px");
	
	$("selectedtstable").appendChild(selectedTimeslotTable.getTable());  
	selectedTimeslotTable.setOnRowSelectHandler(viTableRowSelectHandler); 
}

function queryTimeslot(data)
{
	availableTimeslotTable.clearTableData();
	
	createTableBody(availableTimeslotTable,window.tableconf[0],data,RESOURCE);
	
	refreshSelectionButtonState();
}


/**
 *          
 * @param rows:      
 * @return  
 */
function linkTableRowSelectHandler(rows)
{
	refreshSelectionButtonState();
}

/**
 *          
 * @param rows:      
 * @return  
 */
function viTableRowSelectHandler(rows)
{
	refreshSelectionButtonState();
}

function refreshSelectionButtonState()
{
	$("moveToRightBtn").disabled = (availableTimeslotTable.getSelectedRows().length == 0);
	$("moveAllToRightBtn").disabled = (availableTimeslotTable.getDataRowLength() == 0);
	$("moveToLeftBtn").disabled = (selectedTimeslotTable.getSelectedRows().length == 0);
	$("moveAllToLeftBtn").disabled = (selectedTimeslotTable.getDataRowLength() == 0);
}

/*****************************************
 *                            
*******************************************/                                                                        
function moveDataFromAToZ(tableA, tableZ, tableAConfig, tableZConfig, isSortable)
{
    var selectrows;
    var datainterface = new DataInterface();
    var ptag;
    var obj;
    
    selectrows = tableA.getSelectedRows();
    
    for(var i = selectrows.length - 1; i >= 0; i--)
    {
    	obj = new Object();
        
        ptag = new ParamTag();
        ptag.value = tableA.getCellStoreValue(selectrows[i], "timeSlot", "timeSlot");
        obj["timeSlot"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = tableA.getCellStoreValue(selectrows[i], "timeSlotId", "timeSlotId");
        obj["timeSlotId"] = ptag;
        
        datainterface.rows[i] = obj;
        
        tableA.deleteRow(selectrows[i]);//                
    }
    
    tableA.adjustDataRows(); //        
    createTableBody(tableZ, tableZConfig, datainterface, RESOURCE);
    if(isSortable)
    {
        tableZ.sortRows(tableZ.getHeadCell("timeSlotId").element, 1);
    }
    adjustTableLayout(tableA,tableAConfig,0);
    
    refreshSelectionButtonState();
}

function moveToRight()
{
	moveDataFromAToZ(availableTimeslotTable, selectedTimeslotTable, window.tableconf[0], window.tableconf[1], false);
}

function moveToLeft()
{
	moveDataFromAToZ(selectedTimeslotTable, availableTimeslotTable, window.tableconf[1], window.tableconf[0], true);
}

function moveAllToRight()
{
	availableTimeslotTable.selectAllRows();
	moveToRight();
}

function moveAllToLeft()
{
	selectedTimeslotTable.selectAllRows();
	moveToLeft();
}

function pressOKButton()
{
	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_ASON_CREATE_VIRTUAL_INTERFACE+"&nmUser="+win.winobj["nmUser"];
	loadXMLdoc(url,"POST",false,callbackVirtualInterfaceCreate,null,"inputdata="+createVirtualInterfaceXMLInfo(win.winobj["neid"],win.winobj["slotid"],win.portid));	
}

function createVirtualInterfaceXMLInfo(neid, slotid, portid)
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
         
    row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);   
    
    param = new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name","portid");
    param.setAttribute("value",portid);
    row.appendChild(param);   
    
    param = new tagElement("param");
    param.setAttribute("name","timeslot");
    param.setAttribute("value",selectedTimeslotTable.getDataRowLength());
    row.appendChild(param); 
    
    param = new tagElement("param");
    param.setAttribute("name","timeslotstring");
    param.setAttribute("value",getSelectedTimeslotString());
    row.appendChild(param); 
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);    
    return root.toString();
}

function getSelectedTimeslotString()
{
	var retValue = "";
	var size = selectedTimeslotTable.getDataRowLength();
	for(var i = 0; i < size; i++)
    {
		retValue += selectedTimeslotTable.getCellStoreValue(i, "timeSlotId", "timeSlotId");
		if(i < (size - 1))
		{
			retValue += ",";
		}
    }
	
	return retValue;
}

function callbackVirtualInterfaceCreate(doc)
{
	var data = EncapsulateData(doc);
	
	if(0 == data.getSErrorCode())
	{
		win.querySDHTELink();
		xcloseDialog();
	}
	else
	{
		showOperResult(data);
	}
}


/**
 *       
 * @param data:            errArr:       
 * @return  
 */
function showOperResult(data)
{
	var errArr = [];//           
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	errArr[3] = "portid";
	
	openErrPage("../../../../../page/",data.getError(),errArr);
}
