 var winobj = getNeProperty(self);
var switchControlTable;
var countObj;
var hasQueryRight;
var hasDowngradeRight;
var allDegradeData = [];

/**
 *             
 * @param  
 * @return  
 */
function initBody()
{
	initTable();
	initButton();
	if(SYSTEMCONF.getStatus() == 1)
	{
	    querySwitchControl();//         
    }
}

/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
	switchControlTable = new SortTable();
	
    switchControlTable.setImage("../../../../../images/");
       
    createTableHead(switchControlTable, window.tableconf[0]);   
    
    $("tablecomponent").appendChild(switchControlTable.getTable());
    
    switchControlTable.setBodyHeight(getComponetHeight($("tablecomponent"),90)+"px");
    
    $("tablecomponent").oncontextmenu = popuMenuHandler;  
    
    switchControlTable.setOnRowSelectHandler(rowSelectHandler); 
    
    countObj = new TableDataCount(); 
    $("dataCount").appendChild(countObj.getCountArea());    
    
    switchControlTable.setBodyWidth("1200px","160%");
    adjustTableLayout(switchControlTable,window.tableconf[0],0);
}

 /**
 *               
 * @param data: 
 * @return  
 */
window.onresize=function()
{
   switchControlTable.setBodyHeight(getComponetHeight($("tablecomponent"),90)+"px");
}


/**
 *          
 * @param rows:      
 * @return  
 */
function rowSelectHandler(rows)
{
    countObj.setSelectedCount(rows.length);
}

/**
 *          
 * @param  
 * @return  
 */
function initButton()
{
	$("queryBtn").value = RESOURCE["querybutton"];
    $("printBtn").value = RESOURCE["printbutton"];
    
    var url = "../../../../../securityServlet?neID="+winobj["neid"]+"&nmUser="+winobj["nmUser"];
    loadXMLdoc(url,"POST",false,rightHandle,null,"inputdata="+createQueryRightXMLInfo());	

}

/**
 *            XML  
 * @param  
 * @return  
 */
function createQueryRightXMLInfo()
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
         
	row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","sfid");
    param.setAttribute("value",TECMDCODE_OSN_QUERY_SC_LSP_XC);
    row.appendChild(param);    
    bussiness.appendChild(row);
    
	row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","sfid");
    param.setAttribute("value",TECMDCODE_OSN_DEGRADE_SC_LSP_XC);
    row.appendChild(param);    
    bussiness.appendChild(row);
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *             
 * @param doc:         
 * @return  
 */
function rightHandle(doc)
{
	 var data = EncapsulateData(doc);
     var right = data.getDataRowParam(0,"right");
     if(right == 1)
     {
     	hasQueryRight = true;//               	
     }
     else
     {
     	hasQueryRight = false;//        
     }
     
     right = data.getDataRowParam(1,"right");
     if(right == 1)
     {
     	hasDowngradeRight = true;//               	
     }
     else
     {
     	hasDowngradeRight = false;//        
     }     
}

/**
 *          
 * @param  
 * @return  
 */
function querySwitchControl()
{
	if(!hasQueryRight)
	{
		return;
	}
	setBtnStatus([$("queryBtn"),$("printBtn")],true);
	
	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_OSN_QUERY_SC_LSP_XC+"&nmUser="+winobj["nmUser"];
	
  loadXMLdoc(url,"POST",true,callbackQuerySwitchControl,null,"inputdata="+createQueryXMLInfo(winobj["neid"]));
    
}

/**
 *                 
 * @param doc:          
 * @return  
 */
function callbackQuerySwitchControl(doc)
{
	var data = EncapsulateData(doc);
	
	if(0 == data.getSErrorCode())
	{
		switchControlTable.clearTableData();
		
		createTableBody(switchControlTable,window.tableconf[0],data,RESOURCE);
		initTableSort(switchControlTable,"srcNode");
		countObj.setTotalCount(switchControlTable.getDataRowLength());//         count;
		countObj.setSelectedCount(0); //           
	}
	
	setBtnStatus([$("queryBtn"),$("printBtn")],false);
	showOperResult(data);	
}

/**
 *          
 * @param  
 * @return  
 */
function downgradeSwitchControl()
{
	
	hideMenu();
		
	if(!confirm(RESOURCE["downgradeSignC"]))
	{
		return;
	}
	
	if(!confirm(RESOURCE["makeTrueDowngradeSC"]))
	{
		return;
	}
	
	setBtnStatus([$("queryBtn"),$("printBtn")],true);
	
	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_OSN_DEGRADE_SC_LSP_XC+"&nmUser="+winobj["nmUser"];
	
    loadXMLdoc(url,"POST",true,callbackDowngrade,null,"inputdata="+createDowngradeXMLInfo());	

}

/**
 *               XML  
 * @param  
 * @return  
 */
function createDowngradeXMLInfo()
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    
    var degradeRows = switchControlTable.getSelectedRows();
    allDegradeData = [];
    
    for(var i = 0; i < degradeRows.length; i++)
    {
    	row = new tagElement("row-params");
	    param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",winobj["neid"]);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","srcNode");
	    param.setAttribute("value",switchControlTable.getCellStoreValue(degradeRows[i],"srcNode","srcNode"));
	    row.appendChild(param); 
	    
	    
	    param = new tagElement("param");
	    param.setAttribute("name","sinkNode");
	    param.setAttribute("value",switchControlTable.getCellStoreValue(degradeRows[i],"sinkNode","sinkNode"));
	    row.appendChild(param);
	    
	    
	    param = new tagElement("param");
	    param.setAttribute("name","lspIndex");
	    param.setAttribute("value",switchControlTable.getCellStoreValue(degradeRows[i],"lspIndex","lspIndex"));
	    row.appendChild(param);
	   
	    
	    param = new tagElement("param");
	    param.setAttribute("name","xcIndex");
	    param.setAttribute("value",switchControlTable.getCellStoreValue(degradeRows[i],"xcIndex","xcIndex"));
	    row.appendChild(param);
	    
	    
	    allDegradeData.push(switchControlTable.getCellStoreValue(degradeRows[i],"xcIndex","xcIndex"));
	    
 	    bussiness.appendChild(row); 
    }      
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *                 
 * @param doc:          
 * @return  
 */
function callbackDowngrade(doc)
{//debugger;
	var data = EncapsulateData(doc);
    
    var errorXCIndex = [];

    for(var i = data.getBErrLength()-1; i >= 0; i--)
    {
    	errorXCIndex.push[data.getBErrParam(i,"xcIndex")];
		data.getError().rowErrors[i].errorObj["xcIndex"] = window.tableconf[0].getColFromColId("xcIndex").name + ":"+ data.getError().rowErrors[i].errorObj["xcIndex"];
    	
    }
    
    showOperResult(data,["xcIndex"]); 
     
    if(data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
    {
	    for(var rowIndex = 0; rowIndex < switchControlTable.getDataRowLength(); rowIndex++)
	    {
	    	var xcIndex = switchControlTable.getCellStoreValue(rowIndex,"xcIndex","xcIndex");
		    if(allDegradeData.contains(xcIndex) && !errorXCIndex.contains(xcIndex)) 
		    {
		    	switchControlTable.deleteRow(rowIndex);
		    }
	    }
    	switchControlTable.adjustDataRows();
    }  
    
	countObj.setTotalCount(switchControlTable.getDataRowLength());//         count;
	countObj.setSelectedCount(switchControlTable.getSelectedRowCount()); //           

	setBtnStatus([$("queryBtn"),$("printBtn")],false);   //       
}

/**
 *            
 * @param  
 * @return  
 */
function printSignallingInfo()
{
	if(0 == switchControlTable.getDataRowLength())
	{
		alert(RESOURCE["NO_DATA"]);
		return
	}
	openPrintPage("../../../../../page/",RESOURCE["asonscMg"],"switchControlTable",true,winobj["nmUserName"]);	
}

/**
 *          
 * @param evt      
 * @return  
 */
function popuMenuHandler(evt)
{
	if(!evt)
  	{
  	  evt= window.event;	
  	}
  	 
    var elem = (evt.target) ? evt.target : evt.srcElement;   

    if(elem!= null&&elem.blur)
    {
    	elem.blur();	  	
    }
   
   while(elem != null)
	 {
	    if(elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
   } 
  
	if(elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		  return;
	}  
	
	var rowid= elem.parentNode.rowIndex;
    var rows =elem.parent.getSelectedRows();
    var colid = elem.colid;
    if(rows.contains(rowid))
    {
    	createFuncPopupMenu(rows,evt);    	
    }    
}

/**
 *           
 * @param rows:     evt      
 * @return  
 */
function createFuncPopupMenu(rows,evt)
{
     removejsDOMmenu();
     var cursorMenu1 = new jsDOMenu(200);    
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["downgradeSC"],"",downgradeSwitchControl,null,hasDowngradeRight));      	
     setPopUpMenu(cursorMenu1);
     showMenu(evt); 	
}

/**
 * Tab      
 * @param 
 * @return  
 */
function tabSelectHandler()
{
	querySwitchControl();//         
}


