 var querysfid = TECMDCODE_ASON_QUERY_VIRTUAL_INTERFACE;
var createsfid = TECMDCODE_ASON_CREATE_VIRTUAL_INTERFACE;
var deletesfid = TECMDCODE_ASON_DELETE_VIRTUAL_INTERFACE;

var telinktable;
var virtualinterfacetable;

var language = SYSTEMCONF.getLanguage();
var winobj = getNeProperty(self);

var hasQueryRight = false;
var hasCreateRight = false;
var hasDeleteRight = false;

var availableTimeslot;

/**
 *      
 * @param  
 * @return  
 */
function initBody()
{
	initTable();
	initButton();
	querySDHTELink(); 
}

/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
	initTELinkTable();
	initVirtualInterfaceTable()
	adjustHeight();
}

function initTELinkTable()
{
	$("telinklabel").innerHTML = RESOURCE["telink"];
	loadXMLdoc("../../conf/ason/virtuallinkmanagetelinktable_" + language + ".xml", "GET", false, EncapsulateTable, null);
	telinktable = new SortTable();
	telinktable.setImage("../../../../../images/");
	createTableHead(telinktable, window.tableconf[0]); 
	$("telinktable").appendChild(telinktable.getTable());  
	telinktable.setSingleChoiceFlg(true); 
	telinktable.setOnRowSelectHandler(linkTableRowSelectHandler); 
}

function initVirtualInterfaceTable()
{
	$("virtualinterfacelabel").innerHTML = RESOURCE["virtualinterface"];
	loadXMLdoc("../../conf/ason/virtualinterfacetable_" + language + ".xml", "GET", false, EncapsulateTable, null);
	virtualinterfacetable = new SortTable();
	virtualinterfacetable.setImage("../../../../../images/");
	createTableHead(virtualinterfacetable, window.tableconf[1]); 
	$("virtualinterfacetable").appendChild(virtualinterfacetable.getTable());  
	virtualinterfacetable.setOnRowSelectHandler(viTableRowSelectHandler); 
}

 /**
 *               
 * @param data: 
 * @return  
 */
window.onresize=function()
{
	adjustHeight();
}

function adjustHeight()
{
	var totalHeight = getComponetHeight($("tablecomponent"),200);
	telinktable.setBodyHeight(totalHeight*0.6+"px");
	virtualinterfacetable.setBodyHeight(totalHeight*0.38+"px");
}

/**
 *          
 * @param rows:      
 * @return  
 */
function linkTableRowSelectHandler(rows)
{
	$("sellinkrows").innerText = rows.length;
	
	clearSelectRows(virtualinterfacetable);
	
	refreshButtonState();
}

/**
 *          
 * @param rows:      
 * @return  
 */
function viTableRowSelectHandler(rows)
{
	$("selvirows").innerText = rows.length;
	
	clearSelectRows(telinktable);
	
	refreshButtonState();
}

/**
 *          
 * @param  
 * @return  
 */
function initButton()
{
	$("queryBtn").value = RESOURCE["querybutton"];
    $("deleteBtn").value = RESOURCE["deletebutton"]; 
    $("createBtn").value = RESOURCE["createvirtualinterface"];
    $("printBtn").value = RESOURCE["printbutton"]; 
    
    var url = "../../../../../securityServlet?neID="+winobj["neid"]+"&nmUser="+winobj["nmUser"];
    loadXMLdoc(url,"POST",false,rightHandle,null,"inputdata="+createQueryRightXMLInfo());	
}

/**
 *            XML  
 * @param  
 * @return  
 */
function createQueryRightXMLInfo()
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
         
    row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","sfid");
    param.setAttribute("value",createsfid);
    row.appendChild(param);   
    bussiness.appendChild(row);
    
	row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","sfid");
    param.setAttribute("value",querysfid);
    row.appendChild(param);    
    bussiness.appendChild(row);
    
    row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","sfid");
    param.setAttribute("value",deletesfid);
    row.appendChild(param);    
    bussiness.appendChild(row);

    root.getRoot().appendChild(bussiness);    
    return root.toString();
}

/**
 *             
 * @param doc:         
 * @return  
 */
function rightHandle(doc)
{
	 var data = EncapsulateData(doc);
     var right = data.getDataRowParam(0,"right");
     hasCreateRight = (right == 1);
     right = data.getDataRowParam(1,"right");
     hasQueryRight = (right == 1);
     right = data.getDataRowParam(2,"right");
     hasDeleteRight = (right == 1);
     
     refreshButtonState();
}

/**
 *           
 * @return
 */
function querySDHTELink()
{
	if(!hasQueryRight)
	{
		return;
	}
	
	setBtnStatus([$("queryBtn"),$("printBtn")],true);
	
	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_OSN_GET_VIR_IF+"&nmUser="+winobj["nmUser"];
	loadXMLdoc(url,"POST",false,callbackQuery,null,"inputdata="+createQueryXMLInfo(winobj["neid"],winobj["slotid"]));	
}

/**
 *         
 * @param doc
 * @return
 */
function callbackQuery(doc)
{
	$("totallinkrows").innerText = 0;
	$("sellinkrows").innerText = 0;
	
	$("vitotalrows").innerText = 0;
	$("selvirows").innerText = 0;
	
	var data = EncapsulateData(doc);
	
	var telinkRowCounter = 0;
	var virtualInterfaceRowCounter = 0;
	
	var teLinkDataInterface = new DataInterface();
	var virtualInterfaceDataInterface = new DataInterface();
	
	if(0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{
		for(var i = 0; i < data.getDataRowLength(); i++)
		{
			var timeslot = data.rows[i]["timeslot"].value;
			if(!timeslot)
			{
				teLinkDataInterface.addDataRowAt(telinkRowCounter++, data.rows[i]);
			}
			else
			{
				virtualInterfaceDataInterface.addDataRowAt(virtualInterfaceRowCounter++, data.rows[i]);
			}
		}
		
		telinktable.clearTableData();
		createTableBody(telinktable,window.tableconf[0],teLinkDataInterface,RESOURCE);
		
		virtualinterfacetable.clearTableData();
		createTableBody(virtualinterfacetable,window.tableconf[1],virtualInterfaceDataInterface,RESOURCE);
	}
	else
	{
		var errArr = [];//           
		errArr[0] = "nename";
		errArr[1] = "slotid";
		errArr[2] = "boardname";
		showOperResult(data, errArr);
	}
	
	$("totallinkrows").innerText = telinktable.getDataRowLength();
	$("sellinkrows").innerText = 0;
	
	$("vitotalrows").innerText = virtualinterfacetable.getDataRowLength();
	$("selvirows").innerText = 0;
	
	refreshButtonState();
}


/**
 *       
 * @return
 */
function createVirtualInterface()
{
	if(!hasCreateRight)
	{
		return;
	}
	
	queryTimeslot();
}

/**
 *         
 * @return
 */
function queryTimeslot()
{
	var rows = telinktable.getSelectedRows();
	
	var portid = telinktable.getCellStoreValue(rows[0], "portid", "portid");

	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_ASON_QUERY_VC4_TIMESLOT+"&nmUser="+winobj["nmUser"];
	
	loadXMLdoc(url,"POST",false,callbackTimeslotQuery,null,"inputdata="+createTimeslotQueryXMLInfo(winobj["neid"],winobj["slotid"],portid));	
}

function createTimeslotQueryXMLInfo(neid, slotid, portid)
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
         
    row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);   
    
    param = new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name","portid");
    param.setAttribute("value",portid);
    row.appendChild(param);    
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);    
    return root.toString();
}

/**
 *            
 * @param doc:          
 * @return  
 */
function callbackTimeslotQuery(doc)
{
	var data = EncapsulateData(doc);
	
	var usedTimeslot = getUsedTimeslot();
	
	availableTimeslot = new DataInterface();
	
	var dataRowLength = 0;
	
	if(0 == data.getSErrorCode())
	{
		for(var i = 0; i < data.getDataRowLength(); i++)
		{
			if(!usedTimeslot.contains(data.rows[i]["timeSlotId"].value))
			{
				availableTimeslot.addDataRowAt(dataRowLength++, data.rows[i]);
			}
		}
		if(availableTimeslot.getDataRowLength() == 0)
		{
			showMessageDialog(RESOURCE["InvalidSlot"]);
		}
		else
		{
			xshowModalDialog("createvirtualinterface.html", RESOURCE["createVirtualInterface"], 560, 480,
					"../../../../images/", false, true);
		}
	}
	else
	{
		showOperResult(data);	
	}
}

/**
 *              
 * @return          
 */
function getUsedTimeslot()
{
	var usedTimeslotStr = "";
	
	var rows = telinktable.getSelectedRows();
	portid = telinktable.getCellStoreValue(rows[0], "portid", "portid");
	
	for(var i = 0; i < virtualinterfacetable.getDataRowLength(); i++)
	{
		if(portid == virtualinterfacetable.getCellStoreValue(i, "portid", "portid"))
		{
			var timeslotArray = virtualinterfacetable.getCellStoreValue(i, "timeslotstring", "timeslotstring").split(",");
			for(var j = 0; j < timeslotArray.length; j++)
			{
				if(timeslotArray[j].indexOf("-") == -1)
				{
					usedTimeslotStr += timeslotArray[j] + ",";
				}
				else
				{
					var timeslotsutstr = timeslotArray[j].split("-");
					for(var k = parseInt(timeslotsutstr[0]); k <= parseInt(timeslotsutstr[1]); k ++)
					{
						usedTimeslotStr += k + ",";
					}
				}
			}
		}
	}

	usedTimeslotStr = usedTimeslotStr.substring(0, usedTimeslotStr.length-1);	
	usedTimeslot = usedTimeslotStr.split(",");
	
	return usedTimeslot;
}

/**
 *           
 * @param hexnum
 * @return
 */
function hexConvert(hexnum)
{
	if(hexnum == "00000000")
	{
		hexnum = "/" ;
	}
	else
	{
		hexnum = "0x" + hexnum ;
	}
	return hexnum ;
}

/**
 *       
 * @return
 */
function refreshButtonState()
{
	$("createBtn").disabled = (!hasCreateRight) ||  (telinktable.getSelectedRows().length == 0);
	$("queryBtn").disabled = (!hasQueryRight);
	$("deleteBtn").disabled = (!hasDeleteRight) || (virtualinterfacetable.getSelectedRows().length == 0);
	$("printBtn").disabled = (!hasQueryRight) || (virtualinterfacetable.getDataRowLength() == 0);
}

/**
 *       
 * @return
 */
function deleteVirtualInterface()
{
	if(!hasDeleteRight)
	{
		return;
	}

	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_ASON_DELETE_VIRTUAL_INTERFACE+"&nmUser="+winobj["nmUser"];
	
	loadXMLdoc(url,"POST",false,callbackDeleteOperation,null,"inputdata="+createDeleteXMLInfo());		
}

function createDeleteXMLInfo()
{
	var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    
	for(var i = 0; i < virtualinterfacetable.getSelectedRows().length; i ++)
	{
		var sourceindex = virtualinterfacetable.getCellStoreValue(virtualinterfacetable.getSelectedRows()[i], "sourceindex", "sourceindex");
		sourceindex = sourceindex.replace("0x", "");
		
	    row = new tagElement("row-params");
	    param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",winobj["neid"]);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","index");
	    param.setAttribute("value",sourceindex);
	    row.appendChild(param);
	    bussiness.appendChild(row);
	}
	
    root.getRoot().appendChild(bussiness);    
    return root.toString();
}

function callbackDeleteOperation(doc)
{
	var data = EncapsulateData(doc);
	showOperResult(data);
	querySDHTELink(); 	
}

function clearSelectRows(tablename)
{
	var selectedRows = tablename.getSelectedRows();
	
	for(var i = 0; i < selectedRows.length; i ++)
	{
		tablename.setRowNoneSelect(selectedRows[i]);
	}
}

function printVirtualInterface()
{
	if(0 == virtualinterfacetable.getDataRowLength())
	{
		showMessageDialog(RESOURCE["NO_DATA"]);
		return
	}
	openPrintPage("../../../../../page/",RESOURCE["virtualinterface"],",virtualinterfacetable",true,winobj["nmUserName"]);
}

function showMessageDialog(msg)
{
	var allerror = new AllError();
	
	var eTag = new ErrorTag();
	eTag.code = 2;
	eTag.info = "Operation failed";
	allerror.s_error = eTag;
	
	var reobj = new RowError();
	var eTag = new ErrorTag();
	eTag.info = msg;
	reobj.error = eTag;
	
	var rows = telinktable.getSelectedRows();
	var nename = telinktable.getCellStoreValue(rows[0], "source", "nename");
	reobj.errorObj["nename"]= nename;	
	errArr = [];//           
	errArr[0] = "nename";//           
	allerror.rowErrors[0] = reobj;
	openErrPage("../../../../../page/",allerror,errArr);
}
