var win = getParentWindow();
var neid = win.neid;
var nmuser = win.nmuser;

/*
Get neid from url param
*/
function getNeID()
{
  return neid;
}

/*
Handler response data,construct table data
*/
function refreshTableCallBack(doc)
 {
	for ( var i = 0; i < st0.getDataRowLength(); i++) {
		st0.deleteRow(i);
	}
	st0.adjustDataRows();

	document.getElementById("querybtn").disabled = false;
	if (rightArray[0] == 1) {
		document.getElementById("newbtn").disabled = false;
	}

	var dinterface = EncapsulateData(doc);
	if (dinterface.getSErrorCode() != 0) {
		var errArr = [];
		errArr[0] = "nename";
		openErrPage("../../../../../page/", dinterface.getError(), errArr)
		return;
	}

	for ( var i = 0; i < dinterface.getDataRowLength(); i++) {
		var obj = dinterface.rows[i];
		obj.ID = {};
		obj.ID.value = obj["destip"].value;
		obj["destip"].value = convertNumToIpaddr(obj["destip"].value);
		obj["mask"].value = convertNumToIpaddr(obj["mask"].value);
		obj["gateway"].value = convertNumToIpaddr(obj["gateway"].value);
	}

	createTableBody(st0, window.tableconf[0], dinterface, RESOURCE);
}

/*
 * create request data
 */
function createQueryXmlData()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    var neid=getNeID();    
    param.setAttribute("value",neid);
    row.appendChild(param);
    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

function refreshBefore()
{
	document.getElementById("querybtn").disabled = true;
  document.getElementById("newbtn").disabled = true;
  document.getElementById("deletebtn").disabled = true;
	window.setTimeout(refreshTable, 10);
}

/*
refresh table data
*/
function refreshTable()
 {
	if (0 == SYSTEMCONF.getDemo()) {
		var xml = createQueryXmlData();

		loadXMLdoc("../../../../../neExlorerServlet?sfid="
				+ TECMDCODE_ASON_GET_LIM_ROUTE + "&flag=1&nmUser=" + nmuser
				+ "&timestamp=" + new Date().getTime(), "POST", true,
				refreshTableCallBack, null, "inputdata=" + xml);
	} else {
		alert("not impl");

	}
}


function tableSelectHandler(rows)
{
	if (rightArray[2] == 0 || rows.length == 0)
	{
		$("deletebtn").disabled = true;
		return;
	}
	else
	{
		$("deletebtn").disabled = false;
	}
}

/*
create ecc link table
*/
function createTable()
{
	  st0 = new SortTable();
    st0.setImage("../../../../../images/");  
    createTableHead(st0, window.tableconf[0]);
    st0.setOnRowSelectHandler(tableSelectHandler);
    $("tablecontainer").appendChild(st0.getTable());	
    st0.setBodyHeight(getTableHeight($("tablecontainer"),st0)+"px");
}

/*
Add route
*/
function showAddRouteDialog()
{	
		xshowModalDialog("../ason_v2r7c01/addiproute.html", RESOURCE["ID_ADDSTATICROUTE"], 500, 220, "../../../../images/")	
}


function createDeleteXmlData()
{
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");
	var neid=getNeID(); 

  for(var i=0; i<rows.length; i++)
  {
		var row = new tagElement("row-params");
		var destneid = st0.getCellStoreValue(rows[i], "ID", "ID");

		var destip1 = st0.getCellStoreValue(rows[i], "destip", "destip");
		var mask1 = st0.getCellStoreValue(rows[i], "mask", "mask");
		var gateway1 = st0.getCellStoreValue(rows[i], "gateway", "gateway");
		var destip = hexToTen(convertIpaddrToHexcode(destip1));
		var mask = hexToTen(convertIpaddrToHexcode(mask1));
		var gateway = hexToTen(convertIpaddrToHexcode(gateway1));
		
		var param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",neid);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name","destip");
		param.setAttribute("value",destip);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name","gateway");
		param.setAttribute("value",gateway);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name","mask");
		param.setAttribute("value",mask);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name","type");
		param.setAttribute("value",0);
		row.appendChild(param);
		
		business.appendChild(row);

	}
	root.getRoot().appendChild(business);
	return root.toString();   	
}

var rows;
/*
Delete ip route
*/
function deleteRoute()
{
	 rows = st0.getSelectedRows();
	 if (rows.length == 0) 
	 {
	 	 return;
	 } 
	 
	 var xml=createDeleteXmlData();
	 
	 $("deletebtn").disabled=true;
	 loadXMLdoc("../../../../../neExlorerServlet?sfid="+TECMDCODE_ASON_SET_LIM_ROUTE+"&flag=1&nmUser="+nmuser+"&timestamp="+new Date().getTime(),"POST", true, deleteRouteCallBack, null, "inputdata="+xml);
	 
}

function deleteRouteCallBack(doc)
{
	$("deletebtn").disabled=false;
	var dinterface = EncapsulateData(doc);
	
	refreshBefore();
	
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../../page/", dinterface.getError(), errArr);
}

/*
set button and title text
*/
function setButtonText()
{	
     $("newbtn").value=RESOURCE["newbutton"];	
     $("querybtn").value=RESOURCE["querybutton"];	
     $("deletebtn").value=RESOURCE["deletebutton"];	
     $("deletebtn").disabled=true;
}

/*
Set button click event handler
*/
function setButtonHandler()
{  
     $("newbtn").onclick=showAddRouteDialog;
     $("querybtn").onclick=refreshBefore;
     $("deletebtn").onclick=deleteRoute;
}

/*
window onload handler
*/
window.onload=function()
 {
	setButtonText();
	setButtonHandler();
	createTable();

	sendRightInfo();
	if (!$("querybtn").disabled) {
		refreshBefore();
	}
}	


window.onresize=function()
{
	st0.setBodyHeight(getTableHeight($("tablecontainer"),st0)+"px");
}

/**
 *       
 * @param  
 * @return  
 */ 
function sendRightInfo()
{
	var url = "../../../../../securityServlet?neID="+neid+"&nmUser="+ nmuser;
	loadXMLdoc(url,"POST",true,rightHandleBack,null,"inputdata=" + createRightXML());
}

/**
 *           XML
 * @param  
 * @return  
 */ 
function createRightXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;;
	var thirdlevel=null;
	
	secondlevel = new tagElement("row-params"); //bean         	
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","newbtn");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value", TECMDCODE_ASON_SET_LIM_ROUTE);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	
	
	secondlevel = new tagElement("row-params"); //bean         	
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","querybtn");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value", TECMDCODE_ASON_GET_LIM_ROUTE);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	
	secondlevel = new tagElement("row-params"); //bean         	
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","deletebtn");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value", TECMDCODE_ASON_SET_LIM_ROUTE);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
		
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();
}

/*
 *                0-   1-   2-  
 */
var rightArray = new Array();

/**
 *           
 * @param  
 * @return  
 */ 
function rightHandleBack(doc)
 {
	var data = EncapsulateData(doc);

	for ( var i = 0; i < data.getDataRowLength(); i++) //        
	{
		var right = data.getDataRowParam(i, "right");

		rightArray[i] = right;

		if (0 == right) {
			$(data.getDataRowParam(i, "btnID")).disabled = true;
		} else {
			$(data.getDataRowParam(i, "btnID")).disabled = false;
		}
	}
}


function convertInvalidValue(valuestr)
{
	if(null != valuestr && "" == valuestr)
	{
		return "-";
	}else
	{
		return valuestr;
	}
}
