 
var rsvpTable;

var urlObject = getNeProperty(self);//the URL object of this page 
var neID = urlObject.neid; //network element id
var nmUsrID = urlObject.nmUser ;//network manager userID, write operation log and check right
var nmUserName = urlObject.nmUserName ;//network manager userName
var btnRightArr = new Object();//save to button right

var authenType = new Object();
authenType[0] = "none";
authenType[1] = "proclaimer";
authenType[2] = "md5";

var NUM_ZERO = 0;
var CODE_FAULT = 2; //operation fault erroeCode 
var CODE_PARTSUCC = 1;//part success errorCode
var CODE_SUCC = 0;//operation success errorCode


/**
 * initialize this page
 * @param data: NO
 * @return NO
 */
function initPage()
{	
	initTable();   //initialize the rsvpTable
	initButton();   //initialize buttons
	
	var rightURL = "../../../../../../securityServlet?neID=" + neID + "&nmUser=" + nmUsrID;
	getRightInfo(urlObject, btnRightArr);//call the function which come from the right.js file, get function right;
	
	doQuery();    //run query
}

/**
 * initialize rsvpTable
 * @param data:NO
 * @return NO
 */
function initTable()
{
	rsvpTable = new SortTable();        
    rsvpTable.setImage("../../../../../../images/");
    createTableHead(rsvpTable, window.tableconf[0]);
    rsvpTable.setOnRowSelectHandler(rowSelectHandler);//rows of the rsvpTable selected event
    rsvpTable.setOnCellEditHandler(handleCellDbClickEvent);//cells of the rsvpTable edited event
    document.getElementById("tablediv").appendChild(rsvpTable.getTable());
    rsvpTable.setBodyHeight(getComponetHeight($("tablediv"),60)+"px");
    rsvpTable.setBodyWidth(window.tableconf[0].width,window.tableconf[0].percent,0);
} 

/**
 * enable the delete button  change sleceted rows
 * @param selectedNum  
 * @return NO
 */
function rowSelectHandler(selectedNum)
{		
	var rows = rsvpTable.getSelectedRowCount();
    document.getElementById("deletebtn").disabled = (rows ? !btnRightArr.deletebtn.right : true);
    handleStatisticInfo(rows);
}

/**
 * applybtn enabled status
 */
function handleCellDbClickEvent()
{
	document.getElementById("applybtn").disabled = !btnRightArr.applybtn.right;
}

/**
 * statistic how many rows be selected and total rows fo the rsvpTable
 * @param selectedNum 
 * @return NO
 */
function handleStatisticInfo(selectedNum)
{
	var totalNum = rsvpTable.getDataRowLength();//get total rows
	document.getElementById("totalrows").innerHTML = totalNum ;//display total rows on this page
	
	document.getElementById("selrows").innerHTML = selectedNum ;//display selected rows on this page
}

/**
 * initialize button enable status
 * @param data:NO
 * @return NO
 */
 function initButton()
 {
    document.getElementById("querybtn").value = RESOURCE["querybutton"];
    document.getElementById("newbtn").value = RESOURCE["newbutton"];
    document.getElementById("applybtn").value = RESOURCE["applybutton"];
    document.getElementById("deletebtn").value = RESOURCE["deletebutton"];
    document.getElementById("printbtn").value = RESOURCE["printbutton"];	
    document.getElementById("totalrowsword").innerHTML = RESOURCE["totalrows"];	
    document.getElementById("selrowsword").innerHTML = RESOURCE["selrows"];	
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_CP_PARAMETER);//come form macrores.js
    btnRightArr.newbtn = new BtnRightObj("newbtn", TECMDCODE_SET_CP_PARAMETER);//come form macrores.js
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_CP_PARAMETER);//come form macrores.js
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_SET_CP_PARAMETER);// come form macrores.js
    
 }  

 /**
  * operate query 
  * @param data:no
  * @return no
  */
function doQuery()
{	
    document.getElementById("querybtn").disabled = !btnRightArr.querybtn.right;
    document.getElementById("newbtn").disabled = !btnRightArr.querybtn.right;
    document.getElementById("deletebtn").disabled = true;
    document.getElementById("applybtn").disabled = true;
    document.getElementById("printbtn").disabled = true;
    
    
    if(!btnRightArr.querybtn.right)
    {
    	return;
    }
    
    setBtnStatus(false);//set disabled buttons status   
    
    var queryURL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_OSN_GET_RSVP_IDENTIFY +"&nmUser="+nmUsrID;
    var xmlData = constructQueryXML();//construct query XML
    loadXMLdoc(queryURL, "POST", true, handleQueryBack, null, "inputdata="+xmlData);//send query request      
}


 

/**
 * construct query XML
 * @param data: no
 * @return xml
 */
function constructQueryXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");  
    
    var thirdlevel = new tagElement("param");              
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",neID);
    secondlevel.appendChild(thirdlevel);       
    
    firstlevel.appendChild(secondlevel);
    
    root.getRoot().appendChild(firstlevel);
    
    return root.toString();
} 
 
/**
 * handle callback function of query
 * @param doc 
 * @return no
 */
function handleQueryBack(doc)
{
	var data = EncapsulateData(doc);
	
	if( CODE_FAULT != data.getSErrorCode() )
	{
		rsvpTable.clearTableData();//clear rsvpTable data
		createTableBody(rsvpTable, window.tableconf[0], data, RESOURCE);//Display The Page Data
	}
	
	handleQueryErrInfo(data);//hanlde query error
	
	document.getElementById("querybtn").disabled = !btnRightArr.querybtn.right;
	document.getElementById("newbtn").disabled = !btnRightArr.newbtn.right;	
	document.getElementById("printbtn").disabled = !btnRightArr.querybtn.right;
		
	handleStatisticInfo(NUM_ZERO);	
	
	addListenser();
}

function addListenser()
{
	var cell;
	for(var i = 0,len = rsvpTable.getDataRowLength();i<len;i++)
	{
		cell = rsvpTable.getCell(i,"authenType");
		cell.element.editElement.element.onchange = function()
		{
			var index = this.parentNode.parentNode.rowIndex;
			var codecell = rsvpTable.getCell(index, "authenCode");
			if (parseInt(this.value) == 2)
			{
				rsvpTable.setCellValue(codecell, "authenCode", "AOSV100R002");
				rsvpTable.setAtomValue(rsvpTable.getCellShow(index,"authenCode"),"AOSV100R002");
			}
			else if (parseInt(this.value) == 1)
			{
			    rsvpTable.setCellValue(codecell, "authenCode", "");
				rsvpTable.setAtomValue(rsvpTable.getCellShow(index,"authenCode"),"");
			}
			codecell.element.style.backgroundColor = "#d0f946";
			codecell.element.modify = true;
		}
		
		cell = rsvpTable.getCell(i,"authenCode");
		cell.element.editElement.element.maxLength = 64;
		cell.element.editElement.element.onkeyup = function()
        {            				
            return calStrSinoLen(this, 64);
        }				
    }
}

/**
 * operate modify
 * @param no
 * @return no
 */
function doApply()
{	
	var xmlData = constructApplyXML();
	if (xmlData == null) return;
	
	if(!confirm(RESOURCE["comfirminfo"]))
	{
		return;
	}
	
	setBtnStatus(false);
	var applyURL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_OSN_SET_RSVP_IDENTIFY +"&nmUser="+nmUsrID;//? come form macrores.js
	loadXMLdoc(applyURL, "POST", true, handleApplyBack, null, "inputdata="+xmlData);//send modify request
}

/**
 * construct modify XML
 * @param data: no
 * @return xml
 */
function constructApplyXML()
{
    var root = new inputxml("datainterface");
    var firstLevel = new tagElement("bussiness-params");
    
    var secondLevel, thirdLevel;  
    
    for( var i = 0, size = rsvpTable.getDataRowLength(); i < size; i++ )
    {
    	if( rsvpTable.getModify(i) )
    	{    		
    		secondLevel = new tagElement("row-params");
    		
    		thirdLevel = new tagElement("param");
    		thirdLevel.setAttribute("name", "neid");
    		thirdLevel.setAttribute("value", neID);
    		secondLevel.appendChild(thirdLevel);
    		
    		thirdLevel = new tagElement("param");
    		thirdLevel.setAttribute("name", "neighborNode");
    		thirdLevel.setAttribute("value", rsvpTable.getCellStoreValue(i, "neighborNode", "neighborNode"));
    		secondLevel.appendChild(thirdLevel);
    		
    		thirdLevel = new tagElement("param");
    	    thirdLevel.setAttribute("name", "neighborNodeIP");
    	    thirdLevel.setAttribute("value", rsvpTable.getCellShow(i, "neighborNode").getValue());
    	    secondLevel.appendChild(thirdLevel);
    		
    		thirdLevel = new tagElement("param");
    		thirdLevel.setAttribute("name", "authenType");
    		thirdLevel.setAttribute("value", rsvpTable.getCellStoreValue(i, "authenType", "authenType"));
    		secondLevel.appendChild(thirdLevel);
    		
    		thirdLevel = new tagElement("param");
    		thirdLevel.setAttribute("name", "authenCode");
    		var authCode = rsvpTable.getCellStoreValue(i, "authenCode", "authenCode");
    		if (authCode.trim() == "")
    		{
    			alert(RESOURCE["authcodenull"]);
    			return null;
    		}
    		thirdLevel.setAttribute("value", authCode);
    		secondLevel.appendChild(thirdLevel);
    		
    		thirdLevel = new tagElement("param");
    		thirdLevel.setAttribute("name", "operType");
    		thirdLevel.setAttribute("value", "0");
    		secondLevel.appendChild(thirdLevel);
    		
    		firstLevel.appendChild(secondLevel);
    	}
    }
    
    root.getRoot().appendChild(firstLevel);
    
    return root.toString();
}

/**
 * handle callback function of modify
 * @param doc 
 * @return no
 */
function handleApplyBack(doc)
{
	var data = EncapsulateData(doc);
	var applybtnStatus = !( CODE_SUCC != data.getSErrorCode());
	document.getElementById("applybtn").disabled = applybtnStatus;
		
	refreshTableState(rsvpTable, window.tableconf[0], data);//Call the function of the common.js file
	
	document.getElementById("querybtn").disabled = false;
	document.getElementById("newbtn").disabled = false;
	document.getElementById("printbtn").disabled = false;
	rowSelectHandler();//change the deletebtn status
	handleErrInfo(data);
	
}

/**
 * operate delete
 * @param no
 * @return no
 */
function doDelete()
{	
	if( NUM_ZERO == rsvpTable.getSelectedRowCount())
	{
		alert(RESOURCE["noselected"]);
		return;
	}
	
	if(!confirm(RESOURCE["iscofirmdelete"]))
	{
		return;
	}
	
	document.getElementById("deletebtn").disabled = true;
	
	var xmlData = constructDeleteXML();
	var deleteURL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_OSN_SET_RSVP_IDENTIFY +"&nmUser="+nmUsrID;//? come form macrores.js
	loadXMLdoc(deleteURL, "POST", true, handleDeleteBack, null, "inputdata="+xmlData);//send delete request
}

/**
 * construct delete XML
 * @param data: no
 * @return xml
 */
function constructDeleteXML()
{
	var root = new inputxml("datainterface");
    var firstLevel = new tagElement("bussiness-params");
    var selectedRows = rsvpTable.getSelectedRows();
    
    var secondLevel, thirdLevel;  
    
    for( var i = 0, size = selectedRows.length; i < size; i++ )
    {
    	secondLevel = new tagElement("row-params");    		
    	thirdLevel = new tagElement("param");
    	thirdLevel.setAttribute("name", "neid");
    	thirdLevel.setAttribute("value", neID);
    	secondLevel.appendChild(thirdLevel);
    		
    	thirdLevel = new tagElement("param");
    	thirdLevel.setAttribute("name", "neighborNode");
    	thirdLevel.setAttribute("value", rsvpTable.getCellStoreValue(selectedRows[i], "neighborNode", "neighborNode"));
    	secondLevel.appendChild(thirdLevel);
    	
    	thirdLevel = new tagElement("param");
    	thirdLevel.setAttribute("name", "neighborNodeIP");
    	thirdLevel.setAttribute("value", convertNumToIpaddr(rsvpTable.getCellStoreValue(selectedRows[i], "neighborNode", "neighborNode")));
    	secondLevel.appendChild(thirdLevel);
    	
    	thirdLevel = new tagElement("param");
    	thirdLevel.setAttribute("name", "authenType");
    	thirdLevel.setAttribute("value", NUM_ZERO);
    	secondLevel.appendChild(thirdLevel);
    		
    	thirdLevel = new tagElement("param");
    	thirdLevel.setAttribute("name", "authenCode");
    	thirdLevel.setAttribute("value", "");
    	secondLevel.appendChild(thirdLevel);
  	
  		thirdLevel = new tagElement("param");
  		thirdLevel.setAttribute("name", "operType");
  		thirdLevel.setAttribute("value", "2");
  		secondLevel.appendChild(thirdLevel);
    		
    	firstLevel.appendChild(secondLevel);
    	
    }
    
    root.getRoot().appendChild(firstLevel);
    
    return root.toString();
}

/**
 * handle callback function of delete
 * @param doc 
 * @return no
 */
function handleDeleteBack(doc)
{
	var data = EncapsulateData(doc);
	var bigError = data.getSErrorCode();
	var selectedRows = rsvpTable.getSelectedRows();
	var neighborNode;
	
	if(CODE_PARTSUCC == bigError)//part of Susscess
	{
		for(var i = 0, errLen = data.getError().getRowErrLength(); i < errLen; i++)
		{
			for(var j = 0, size = selectedRows.length; j < size; j++)
			{
				neighborNode = rsvpTable.getCellStoreValue(selectedRows[j], "neighborNode", "neighborNode");
				if(neighborNode == data.getError().getRowKey(i, "neighborNode"))
				{
					selectedRows.splice(j, 1);
					break;
				}
			}
		}
	}
	
	if( (CODE_PARTSUCC == bigError) || (CODE_SUCC == bigError)) 
	{
		for(var k = selectedRows.length -1; k >= 0; k--)
		{
			rsvpTable.deleteRow(selectedRows[k]);
		}
		
		rsvpTable.adjustDataRows();
		adjustTableLayout(rsvpTable, window.tableconf[0], rsvpTable.getDataRowLength());		
	}
	
	handleErrInfo(data);
	handleStatisticInfo(rsvpTable.getSelectedRowCount());
	
	if(CODE_SUCC != bigError)
	{
	    document.getElementById("deletebtn").disable = false;
	}
}

/**
 * operate create
 * @param no
 * @return no
 */
function doCreate()
{
	xshowModalDialog('rsvpcreatedlg.html', RESOURCE["rsvpcreatetitle"], 400, 185, '../../../../../../images/');
}

/**
 * handle query error
 * @param data
 * @return no
 */
function handleQueryErrInfo(data)
{
	var errArr = [];//define errors object
	errArr.push("nename");
	
	openErrPage("../../../../../../page/", data.getError(), errArr);//open the error page
}

/**
 * handle operate error
 */
function handleErrInfo(data)
{	
	var errArr = [];//define errors object
	errArr.push("neighborNode");
	
    var errData = data.getError();
    var neightborNode;
    
    for ( var i = 0, len = errData.getRowErrLength(); i < len; i++ )
    {
    	neightborNode = errData.getRowKey(i, "neighborNode");
    	errData.rowErrors[i].errorObj["neighborNode"] = convertNumToIpaddr(neightborNode);
    }
	
	openErrPage("../../../../../../page/", errData, errArr);//open the error page
}

/**
 * print table data
 * @param data:no
 * @return no
 */
function doPrint()
{	
    if(NUM_ZERO == rsvpTable.getDataRowLength())
    {
        alert(RESOURCE["nodata"]);//           
        return;
    }
    openPrintPage('../../../../../../page/', RESOURCE['rsvp'],'rsvpTable',true,nmUserName);
}

/**
 * insert rsvp data created into the table
 */
function addCreatedRSVPData(datainterface, neighborNode)
{	
	var neightborNodeExist;
	var exist = false;
	for (var i = 0, len = rsvpTable.getDataRowLength(); i < len; i++)
	{
		neightborNodeExist = rsvpTable.getCellStoreValue(i, "neighborNode", "neighborNode");
		if(neightborNodeExist == neighborNode)
		{
			exist = true;
			rsvpTable.element.datarows[i].element.cols["authenType"].element.currentValue["authenType"] = datainterface.rows[0]["authenType"].value;
			rsvpTable.element.datarows[i].element.cols["authenType"].element.showElement.setValue(RESOURCE[authenType[datainterface.rows[0]["authenType"].value]]);
			rsvpTable.element.datarows[i].element.cols["authenType"].element.storeValue["authenType"] = datainterface.rows[0]["authenType"].value;
			rsvpTable.element.datarows[i].element.cols["authenCode"].element.currentValue["authenCode"] = datainterface.rows[0]["authenCode"].value;
			rsvpTable.element.datarows[i].element.cols["authenCode"].element.showElement.setValue(datainterface.rows[0]["authenCode"].value);
			rsvpTable.element.datarows[i].element.cols["authenCode"].element.storeValue["authenCode"] = datainterface.rows[0]["authenCode"].value;
			break;
		}
	}
	
	if(!exist)
	{
	    createTableBody(rsvpTable, window.tableconf[0], datainterface, RESOURCE);//display the page data
	    rsvpTable.sortRows(rsvpTable.getHeadCell("neighborNode").element, 1);
	    handleStatisticInfo(NUM_ZERO);
	}
			
}


/**
 * set buttons status
 * @param enableStatus boolean
 * @return
 */
function setBtnStatus(enableStatus)
{
	document.getElementById("querybtn").disabled = !enableStatus;
	document.getElementById("newbtn").disabled = !enableStatus;
	document.getElementById("deletebtn").disabled = !enableStatus;
	document.getElementById("applybtn").disabled = !enableStatus;
	document.getElementById("printbtn").disabled = !enableStatus;
}

/**
 * if this page size be changed, then change the rsvpTable size
 * @param data:no
 * @return no
 */
window.onresize = function()
{
	 rsvpTable.setBodyHeight(getComponetHeight($("tablediv"),75)+"px");
}

/**
 * evict table object
 * @param no
 * @return no
 */
window.onunload = function()
{
	clearSortTable(rsvpTable);//call this function of the table_new.js file
}

/**
 *    
 * @param obj:     key:key 
 * @return String      
 */
function convertMsg(res, obj, key)
{	
	if("function" == (typeof obj))	
	{
		return obj(key);
	}
	else //       
	{
		if(null == obj)
		{
			return key;
		}
		var resValue = res[obj[key]];
		if(null == resValue)
		{
			resValue = INVALIDATE_STR;
		}		
		return resValue;
	}
}
