 
var parentWin = getParentWindow();//the parent page of this page

var cTable;


var authenType = new Object();
authenType[1] = RESOURCE["proclaimer"];
authenType[2] = RESOURCE["md5"];

var MAXLENGTH_AUTHENCODE = 64; // authenCode max length

var CODE_FAULT = 2; //operation fault erroeCode 
var CODE_PARTSUCC = 1;//part success errorCode
var CODE_SUCC = 0;//operation success errorCode

document.oncontextmenu = returnFalse;

window.onload = initPage;

document.title = RESOURCE["rsvpcreatetitle"];

/**
 * initialize this page
 * @param no
 * @return no
 */
function initPage()
{
	initCTable();//initialize the table of rsvp
	initButton();//initialize the button's text;
}

/**
 * initialize buttons text
 * @param no
 * @return no
 */
function initCTable()
{	
	cTable = new CTable();
	cTable.addHead(RESOURCE["ID00_ATTRIBUTE"], RESOURCE["ID00_VALUE"]);
	
	var atom = new Atom("text");
	validateIp(atom.element);
	atom.element.onkeydown = handleApplyBtnStatus;
	cTable.addAttrRow("neighborNode", RESOURCE["neighborNode"], atom);
	
	atom = new Atom("select");
	for(i in authenType)
	{
		atom.addOption(authenType[i], i);
	}
	cTable.addAttrRow("authenType", RESOURCE["authenType"], atom);
	
	atom = new Atom("text");
	atom.element.maxLength = MAXLENGTH_AUTHENCODE;
	atom.element.onkeyup = function()
    {            				
		return calStrSinoLen(this, MAXLENGTH_AUTHENCODE);
    }
	cTable.addAttrRow("authenCode", RESOURCE["authenCode"], atom);
	
	document.getElementById("rsvpcreatetable").appendChild(cTable.getTable());
}

/**
 * initialize buttons
 * @param no
 * @return no 
 */
function initButton()
{
	document.getElementById("okbtn").value = RESOURCE["okbutton"];
	document.getElementById("cancelbtn").value = RESOURCE["cancelbutton"];
	document.getElementById("applybtn").value = RESOURCE["applybutton"];
}

/**
 * neighborNode is modified, the applybtn's status is enable
 * @param no
 * @return no
 */
function handleApplyBtnStatus()
{	
	document.getElementById("applybtn").disabled = false;
}

/**
 * handle operate error
 * @param data 
 * @return no
 */
function handleErrInfo(data)
{
	var errArr = [];//define errors object
	errArr.push("nename");
	errArr.push("neighborNode");
	
	var errData = data.getError();
    var neightborNode;
    
	for ( var i = 0, len = errData.getRowErrLength(); i < len; i++ )
    {
    	neightborNode = errData.getRowKey(i, "neighborNode");
    	errData.rowErrors[i].errorObj["neighborNode"] = convertNumToIpaddr(neightborNode);
    }
	openErrPage("../../../../../../page/", errData, errArr);//open the error page
}

/**
 * create RSVP
 * @param btnFlag identify that user operate okbtn or applybtn
 * @return no 
 */
function createRSVP(btnFlag)
{
	if(!checkData())
	{
		return;
	}
	
	setButtonStatus(false);
	
	var xmlData = constructCreateRSVPXML();
	var createURL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_OSN_SET_RSVP_IDENTIFY +"&nmUser="+parentWin.nmUsrID;//? come form macrores.js
	loadXMLdoc(createURL, "POST", true, handleCreateRSVPBack, btnFlag, "inputdata="+xmlData);//send create RSVP MD5 request
}

/**
 * check input data
 */
function checkData()
{
	var neighborNode = cTable.getAttrValue("neighborNode");
	if("" == neighborNode)
	{
	    alert(RESOURCE["noputinneightborNode"]);
	    return false;	
	}
	var authenType = parseInt(cTable.getAttrValue("authenType"));
	var authCode = cTable.getAttrValue("authenCode");
	if (parseInt(authenType) == 2 && "" == authCode.trim())
	{
		alert(RESOURCE["authcodenull"]);
    	return false;
	}
	
	return true;
}


/**
 * construct create RSVP XML
 * @param no
 * @return XML
 */
function constructCreateRSVPXML()
{	
    var root = new inputxml("datainterface"); //    datainterface    
	var firstLevel = new tagElement("bussiness-params"); //         
	var secondLevel = new tagElement("row-params"); //         
	  
    var thirdLevel = new tagElement("param");
    thirdLevel.setAttribute("name", "neid");
    thirdLevel.setAttribute("value", parentWin.neID);
    secondLevel.appendChild(thirdLevel);//        
    
    thirdLevel = new tagElement("param");
    thirdLevel.setAttribute("name", "neighborNode");
    thirdLevel.setAttribute("value", parseInt(convertIpaddrToHexcode(cTable.getAttrValue("neighborNode")), 16));
    secondLevel.appendChild(thirdLevel);
    
    thirdLevel = new tagElement("param");
    thirdLevel.setAttribute("name", "neighborNodeIP");
    thirdLevel.setAttribute("value", cTable.getAttrValue("neighborNode"));
    secondLevel.appendChild(thirdLevel);
    
    thirdLevel = new tagElement("param");
    thirdLevel.setAttribute("name", "authenType");
    thirdLevel.setAttribute("value", cTable.getAttrValue("authenType"));
    secondLevel.appendChild(thirdLevel);
    
    thirdLevel = new tagElement("param");
    thirdLevel.setAttribute("name", "authenCode");
    thirdLevel.setAttribute("value", cTable.getAttrValue("authenCode"));
    secondLevel.appendChild(thirdLevel);
	
		thirdLevel = new tagElement("param");
		thirdLevel.setAttribute("name", "operType");
		thirdLevel.setAttribute("value", "1");
		secondLevel.appendChild(thirdLevel);
    
    firstLevel.appendChild(secondLevel);
    
    root.getRoot().appendChild(firstLevel);
    
    return root.toString();
}

/**
 * handle create rsvp callback
 * @param doc 
 * @param btnFlag
 * @return no
 */
function handleCreateRSVPBack(doc, btnFlag)
{
	var data = EncapsulateData(doc);
	
	if(CODE_SUCC != data.getSErrorCode())
	{
	    handleErrInfo(data);
	    setButtonStatus(true);
	}
	else
	{
		var datainterface = constructRSVPData();	
		parentWin.addCreatedRSVPData(datainterface, parseInt(convertIpaddrToHexcode(cTable.getAttrValue("neighborNode")), 16));
		parentWin.addListenser();
		
		if(btnFlag == "okbtn")
		{
			xcloseDialog();
		}
		else
		{
			document.getElementById("okbtn").disabled = false;
			document.getElementById("cancelbtn").disabled = false;
			document.getElementById("applybtn").disabled = true;
		}
	}
}

/**
 * construct RSVP MD5 Table Data created
 * @param no
 * @return DataInterface
 */
function constructRSVPData()
{
	var datainterface = new DataInterface();
	var obj = new Object();
	
	var ptag = new ParamTag();
	ptag.value = parseInt(convertIpaddrToHexcode(cTable.getAttrValue("neighborNode")), 16);
	obj["neighborNode"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = cTable.getAttrValue("authenType");
	obj["authenType"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = cTable.getAttrValue("authenCode");
	obj["authenCode"] = ptag;
	
	datainterface.rows[0] = obj;
	
	return datainterface;
}

/**
 * operate okbtn
 * @param no
 * @return no 
 */
function doOk()
{
	if(document.getElementById("applybtn").disabled)
	{
		xcloseDialog();
		return;
	}
	
	createRSVP("okbtn");
}

/**
 * operate applybtn
 * @param no
 * @return no
 */
function doApply()
{
	createRSVP("applybtn");
}

/**
 * set button status
 * @param btnStatus true or false 
 * @return no
 */
function setButtonStatus(btnStatus)
{
	document.getElementById("okbtn").disabled = !btnStatus;
	document.getElementById("cancelbtn").disabled = !btnStatus;
	document.getElementById("applybtn").disabled = !btnStatus;
}
 
