 var winobj = getNeProperty(self);
var ospfProtoMgrTable;
var countObj;
var hasQueryRight;
var hasSetRight;


/**
 *    OSPF      
 * @param  
 * @return  
 */
function initBody()
{

	initTable();
	initButton();
	if(SYSTEMCONF.getStatus() == 1)
	{
	    queryOSPFProtocol(); //    OSPF   
    }
}

/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
	ospfProtoMgrTable = new SortTable();
	
    ospfProtoMgrTable.setImage("../../../../../images/");
    
    ospfProtoMgrTable.setOnCellEditHandler(cellEditHandler);
    
    ospfProtoMgrTable.setOnRowSelectHandler(rowSelectHandler);
    
    createTableHead(ospfProtoMgrTable, window.tableconf[0]);   
    
    $("tablecomponent").appendChild(ospfProtoMgrTable.getTable());
   
    ospfProtoMgrTable.setBodyHeight(getComponetHeight($("tablecomponent"),60)+"px");
    
    $("tablecomponent").oncontextmenu = popupMenuHandler;  
    
    countObj = new TableDataCount(); 
    $("dataCount").appendChild(countObj.getCountArea()); 
}

 /**
 *               
 * @param data: 
 * @return  
 */
window.onresize=function()
{
   ospfProtoMgrTable.setBodyHeight(getComponetHeight($("tablecomponent"),60)+"px");
}


/**
 *          
 * @param  
 * @return  
 */
function initButton()
{
	$("queryBtn").value = RESOURCE["querybutton"];
    $("applyBtn").value = RESOURCE["applybutton"]; 
    $("printBtn").value = RESOURCE["printbutton"];
    
    var url = "../../../../../securityServlet?neID="+winobj["neid"]+"&nmUser="+winobj["nmUser"];
    loadXMLdoc(url,"POST",false,rightHandle,null,"inputdata="+createQueryRightXMLInfo());	
}

/**
 *            XML  
 * @param  
 * @return  
 */
function createQueryRightXMLInfo()
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
         
	row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","sfid");
    param.setAttribute("value",TECMDCODE_QUERY_OSPF_PROTOCOL);
    row.appendChild(param);    
    bussiness.appendChild(row);
    
	row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name","sfid");
    param.setAttribute("value",TECMDCODE_SET_OSPF_PROTOCOL);
    row.appendChild(param);    
    bussiness.appendChild(row);
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *             
 * @param doc:         
 * @return  
 */
function rightHandle(doc)
{
	 var data = EncapsulateData(doc);
     var right = data.getDataRowParam(0,"right");
     if(right == 1)
     {
     	hasQueryRight = true;//               	
     }
     else
     {
     	hasQueryRight = false;//        
     }
     right = data.getDataRowParam(1,"right");
     if(right == 1)
     {
     	hasSetRight = true;//               	
     }
     else
     {
     	hasSetRight = false;//        
     	setTableDisabled(window.tableconf[0]);
     }     
}

/**
 *          
 * @param  
 * @return  
 */
function cellEditHandler()
{
	if(!hasSetRight)
	{
		return;
	}
	else
	{
		$("applyBtn").disabled = false; //         
	}
}

/**
 *              
 * @param rows:      
 * @return  
 */
function rowSelectHandler(rows)
{
    countObj.setSelectedCount(rows.length);
}

/**
 *       
 * @param  
 * @return  
 */
function queryOSPFProtocol()
{
	if(!hasQueryRight)
	{
		return;
	}
	setBtnStatus([$("queryBtn"),$("applyBtn"),$("printBtn")],true);

	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_OSPF_PROTOCOL+"&nmUser="+winobj["nmUser"];
	
    loadXMLdoc(url,"POST",true,callbackQueryASONProto,null,"inputdata="+createQueryXMLInfo(winobj["neid"]));
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackQueryASONProto(doc)
{
	var data = EncapsulateData(doc);
	
	if(0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{
		ospfProtoMgrTable.clearTableData();
		
		createTableBody(ospfProtoMgrTable,window.tableconf[0],data,RESOURCE);
		initTableSort(ospfProtoMgrTable,"port");
		setTableCellEdit();
		countObj.setTotalCount(ospfProtoMgrTable.getDataRowLength());
		countObj.setSelectedCount(0);
	}
	
	setBtnStatus([$("queryBtn"),$("printBtn")],false);

	showOperResult(data);	

}

/**
 *       
 * @param  
 * @return  
 */
function setOSPFProtocol()
{
	if(!confirm(RESOURCE["setOSPFProtocol"]))
	{
		return;
	}
	var setXMLInfo = createSetXMLInfo();
	if(null == setXMLInfo)
	{
		setBtnStatus([$("applyBtn")],true);
		return;
	}
	setBtnStatus([$("queryBtn"),$("applyBtn"),$("printBtn")],true);
	
	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_SET_OSPF_PROTOCOL+"&nmUser="+winobj["nmUser"];
	
   loadXMLdoc(url,"POST",true,callbackSetASONProto,null,"inputdata="+setXMLInfo);	
}

/**
 *            XML  
 * @param  
 * @return  
 */
function createSetXMLInfo()
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var hasModify = false;
 
    for(var i = 0; i < ospfProtoMgrTable.getDataRowLength(); i++)
    {
    	if(!ospfProtoMgrTable.getModify(i))
    	{
    		continue;
    	}
    	hasModify = true;
	    row = new tagElement("row-params");
	    
	    param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",winobj["neid"]);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","slotid");
	    param.setAttribute("value",ospfProtoMgrTable.getCellStoreValue(i,"port","slotid"));
	    param.setAttribute("modifyFlag","false");
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","port");
	    param.setAttribute("value",ospfProtoMgrTable.getCellStoreValue(i,"portID","port"));
	    param.setAttribute("modifyFlag","false");
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","ospfname");
	    param.setAttribute("value",ospfProtoMgrTable.getCellStoreValue(i,"ospfname","ospfname"));
	    param.setAttribute("modifyFlag","false");
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","iftype");
	    param.setAttribute("value",ospfProtoMgrTable.getCellStoreValue(i,"iftype","iftype"));
	    param.setAttribute("modifyFlag","false");
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","ospfFlag");
	    param.setAttribute("value",ospfProtoMgrTable.getCellStoreValue(i,"ospfFlag","ospfFlag"));
	    param.setAttribute("modifyFlag",ospfProtoMgrTable.getCellModify(i,"ospfFlag"));
	    row.appendChild(param);

	    param = new tagElement("param");
	    param.setAttribute("name","ospfFlagStr");
	    param.setAttribute("value",ospfProtoMgrTable.getAtomValue(ospfProtoMgrTable.getCell(i,"ospfFlag").element.showElement));
	    row.appendChild(param); 
	    
	    
	    bussiness.appendChild(row); 
    }   
    if(!hasModify)
    {
    	return null;
    }   
    root.getRoot().appendChild(bussiness);

    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackSetASONProto(doc)
{
	var data = EncapsulateData(doc); 
	
    refreshTableState(ospfProtoMgrTable, window.tableconf[0], data);
    
    showOperResult(data,["nename","slotid","boardname","portname"]);
    
    if(0 != data.getSErrorCode())
	{
		setBtnStatus([$("applyBtn")],false);   	
	}	
	setBtnStatus([$("queryBtn"),$("printBtn")],false);   //       
}

/**
 *         
 * @param  
 * @return  
 */
function printOSPFProtocol()
{
	if(0 == ospfProtoMgrTable.getDataRowLength())
	{
		alert(RESOURCE["NO_DATA"]);
		return
	}
	openPrintPage("../../../../../page/",RESOURCE["asonProtoMgr"],"ospfProtoMgrTable",true,winobj["nmUserName"]);
}

/**
 * Tab      
 * @param 
 * @return  
 */
function tabSelectHandler()
{
	queryOSPFProtocol(); //    OSPF   
}

/**
 *           
 * @param 
 * @return  
 */
function setTableCellEdit()
{
	
	for(i = 0 , stlen = ospfProtoMgrTable.getDataRowLength(); i < stlen ; i++)
	{
		if("0" != ospfProtoMgrTable.getCellStoreValue(i,"ospfFlag","ospfFlag") && "1" != ospfProtoMgrTable.getCellStoreValue(i,"ospfFlag","ospfFlag"))
		{
			ospfProtoMgrTable.setCellValue(ospfProtoMgrTable.getCell(i,"ospfFlag"),"ospfFlag","-");
			ospfProtoMgrTable.getCellShow(i,"ospfFlag").setValue("-");
			ospfProtoMgrTable.setCellIsEdit(ospfProtoMgrTable.getCell(i,"ospfFlag"),0);
		}
	}
}
