 
loadXMLdoc("../../../../../conf/system.xml", "GET", false, EncapsulateSConf);
loadXMLdoc("../../conf/ason_v2r7c01/ospfauthentication_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
getResourse("../../res/ason/ospfmgr_"+ SYSTEMCONF.getLanguage() +".xml");

var obj,neid,st;
var btnRightArr = new Object(); //right object
var authTypeStr = new Object();
authTypeStr[0] = RESOURCE["none"];
authTypeStr[1] = RESOURCE["text"];
authTypeStr[2] = RESOURCE["md5"];

var TECMDCODE_OSPF_GET_AUTH = 0;
var TECMDCODE_OSPF_SET_AUTH = 0;
var TECMDCODE_OSPF_PRT_AUTH = 0;
var nmUserName = getNeProperty(parent).nmUserName ;//          

window.onload = function()
{
		obj = getNeProperty(top);
		neid = obj["neid"];
		
		initTable();
		initRight();
		initButton();
		
		if (btnRightArr["querybtn"].right)
		{
		}
}

function initTable()
{
		st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    $("authtable").appendChild(st.getTable());
    $("authtable").oncontextmenu = popupMenuHandler;
    st.setBodyHeight(getTableHeight($("authtable"), st) + "px");
}

function initButton()
{
		$("querybtn").value = RESOURCE["querybtn"];
		$("applybtn").value = RESOURCE["applybtn"];
		$("printbtn").value = RESOURCE["printbtn"];
		
		$("applybtn").disabled = true;
		
		$("totalrow").innerHTML = RESOURCE["totalrow"];
		$("selrow").innerHTML = RESOURCE["selectedrow"];
}

function initRight()
{
	btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_CP_PARAMETER);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_CP_PARAMETER);
    btnRightArr.printbtn = new BtnRightObj("printbtn", TECMDCODE_QUERY_CP_PARAMETER);
    
    getRightInfo(obj, btnRightArr);
    initrightbtn(btnRightArr);
}

function tabSelectHandler()
{
    if(btnRightArr.querybtn.right)
    {
  	   getAuthentication();
    }
}

function rowSelectHandler()
{
		$("totalrownum").innerHTML = st.getDataRowLength();
		$("selrownum").innerHTML = st.getSelectedRows().length;
}

function setCellIsEditFalse(index)
{
	var authTypeCell = st.getCell(index,"authType");
	st.setCellIsEdit(authTypeCell,0);
	var authCodeCell = st.getCell(index,"authCode");
	st.setCellIsEdit(authCodeCell,0);
}

function cellEditHandler(param)
{
	var index = st.getSelectedRows()[0]; //      
	var authType = st.getCellStoreValue(index,"authType","authType");
	var cell = st.getCell(index, "authCode");
    
		switch (authType)
		{
				case "1": //      
				{
						editelement = cell.element.editElement.element;
						editelement.onkeyup = function()
            			{
            	  			return calStrSinoLenCheck(this, 8);
            			}
						break;
				}
				case "2": //MD5    
				{
						editelement = cell.element.editElement.element;
						editelement.onkeyup = function()
            			{
            				
            	  			return calStrSinoLenCheck(this, 64);
            			}
						break;
				}
		}
		$("applybtn").disabled = !btnRightArr.applybtn.right;		
}

function getAuthentication()
{
		$("querybtn").disabled = true;
		$("applybtn").disabled = true;
		
		var xmldata = createGetXml();
		var urlstr = "../../../../../neExlorerServlet?sfid="+TECMDCODE_OSN_GET_OSPF_IDENTIFY+"&nmUser="+obj["nmUser"];
		loadXMLdoc(urlstr, "POST", false, callbackGet, null, "inputdata="+xmldata);
}

function createGetXml()
{
		var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    var keys = new Array("neid", "slotid", "port");
    var vals = new Array(neid, "0", "0", "0");
    
    business.appendChild(createRow(keys, vals));
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackGet(doc)
{
		$("querybtn").disabled = false;
		
		var data = EncapsulateData(doc);
		if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
		{
				st.clearTableData();
				createTableBody(st, window.tableconf[0], data, RESOURCE);
		}
		
		$("totalrownum").innerHTML = st.getDataRowLength();
		$("selrownum").innerHTML = 0;
		
		showErrorDialog(data,"GET");
		
		for (var i=0,len=st.getDataRowLength(); i<len; i++)
		{			
			var authType = st.getCellStoreValue(i, "authType", "authType");
			var authCode = unescape(st.getCellStoreValue(i, "authCode", "authCode"));
			var codeCell = st.getCell(i, "authCode");
			st.setCellValue(codeCell, "authCode", authCode);
			st.getCellShow(i, "authCode").element.innerHTML = authCode;
			authCodeHandler(authType, codeCell, false);
			st.getCellEdit(i, "authType").element.onchange = changeHandler;
			if(!btnRightArr.applybtn.right)
			{
				setCellIsEditFalse(i);
			}
		}
}

function setAuthentication()
{
		$("querybtn").disabled = true;
		$("applybtn").disabled = true;
		var xmldata = createSetXml();

		if (xmldata != null && confirm(RESOURCE["comfirminfo"]))
		{
			var urlstr = "../../../../../neExlorerServlet?sfid="+TECMDCODE_OSN_SET_OSPF_IDENTIFY+"&nmUser="+obj["nmUser"];
			loadXMLdoc(urlstr, "POST", false, callbackSet, null, "inputdata="+xmldata);

		}
		else
		{
			$("querybtn").disabled = !btnRightArr.querybtn.right;
			$("applybtn").disabled = !btnRightArr.applybtn.right;
		}
}

function createSetXml()
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    for (var i=0,len=st.getDataRowLength(); i<len; i++)
    {
    		if (!st.getModify(i))
    		{
    				continue;
    		}
    		
    		var slotid = st.getCellStoreValue(i, "port", "slotid");
    		var portid = st.getCellStoreValue(i, "port", "portname");
    		portid = portid.substring(0, portid.indexOf("("));
    		var iftype = st.getCellStoreValue(i, "iftype", "iftype");
    		var authType = st.getCellStoreValue(i, "authType", "authType");
    		var authCode = st.getCellStoreValue(i, "authCode", "authCode");

    		
    		var portStr = st.getCellShow(i,"port").getValue();
    		var authTypeStr = st.getCellShow(i,"authType").getValue();
    		var authCodeStr = st.getCellShow(i,"authCode").getValue();
    		if (authType != 0 && authCode.trim() == "")
    		{
    			alert(RESOURCE["authcodenull"]);
    			return null;
    		}

    		/*AU9D42594                
    		  AU9D42940   OSPF MD5                   
    		*/
    		if ( authCode == 'undefined' )
    		{
    		    authCode = "";
    		}

    		var keys = new Array("neid", "slotid", "port", "iftype", "pathnum", "authType", "authCode", "portStr","authTypeStr", "authCodeStr");
    		var vals = new Array(neid, slotid, portid, iftype, "0", authType, escape(authCode),portStr,authTypeStr,authCodeStr);
    		
    		business.appendChild(createRow(keys, vals));
    }
    
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackSet(doc)
{
		$("querybtn").disabled = false;
		
		var data = EncapsulateData(doc);
		var errCode = data.getSErrorCode();
		if (errCode == 0 || errCode == 1)
		{
				refreshTableState(st, window.tableconf[0], data);
		}
		
		if (errCode != 0)
		{
				$("applybtn").disabled = false;
		}
		
		showErrorDialog(data,"SET");
}

function printAuth()
{
		if (st.getDataRowLength() <= 0)
		{
				alert(RESOURCE["nodata"]);
				return;
		}
		
		openPrintPage('../../../../../page/', RESOURCE['printAuth'],'st',true,nmUserName);
}

function createRow(keyParams, valParams)
{
    var row = new tagElement("row-params");
    var param;
    
    for (var i=0; i<keyParams.length; i++)
    {
     		param = new tagElement("param");    
		    param.setAttribute("name", keyParams[i]);
		    param.setAttribute("value", valParams[i]);
		    row.appendChild(param);
    }
    
    return row;
}

function showErrorDialog(di,operType)
{
    var errArr = [];
    if(operType == "SET")
    {   
    	errArr[0] = "slotid";
    	errArr[1] = "boardname";
    	errArr[2] = "portname";
    }
    else
    {
        errArr[0] = "nename";
    }
    openErrPage("../../../../../page/", di.getError(), errArr);
    errArr = null;
}

window.onresize = function()
{
		if (document.body)
		{
				st.setBodyHeight(getTableHeight($("authtable"), st) + "px");
		}
}

function changeHandler()
{
		var rowindex = this.parentNode.parentNode.rowIndex;
		var cell = st.getCell(rowindex, "authCode")
		authCodeHandler(this.value, cell, true);
}

function authCodeHandler(authType, cell, isChange)
{
	if (isChange)
	{
		cell.element.showElement.setValue("");
		cell.element.storeValue["authCode"] = "";
		cell.element.currentValue["authCode"] = "";
	}
		switch (authType)
		{
				case "0": //   
				{
				                st.setCellIsEdit(cell,0);
						cell.element.disabled = true;
						cell.element.showElement.setValue("-");						
						cell.element.style.backgroundColor = "";
						break;
				}
				case "1": //      
				{
				                st.setCellIsEdit(cell,1);
						cell.element.disabled = false;
						cell.element.style.backgroundColor = "#FFFFFF";
									
						break;
				}
				case "2": //MD5    
				{
				                st.setCellIsEdit(cell,1);
						cell.element.disabled = false;
						cell.element.style.backgroundColor = "#FFFFFF";
						break;
				}
		}
}
