/**
 *  16       IP        
 * @param hexValue:16    
 * @return ipStr:IP        
 */
function hexConvertToIPStr(hexValue)
{
	removeSpace(hexValue);//            ;	
	var ipStr = "";//        
	var len = hexValue.length;
	if(len > 8) //   8 
	{
		hexValue = hexValue.substring(0,8);
	}
	else if(len < 8)
	{
		for(var i = 0; i < len; i++)
		{
			hexValue += "0";
		}
	}
	
	for (var i = 0; i < hexValue.length; i+=2)
	{		
	    var tmpValue = hexValue.substring(i,i+2);	    
        tmpValue = parseInt(tmpValue,16);
	    ipStr += tmpValue + ".";	    
	}
	return ipStr.substring(0,ipStr.length-1);
}

/**
 *  IP           16    
 * @param ipValue:IP        
 * @return hexValue:16    
 */
function ipStrConvertTohex(ipValue)
{
	var hexValue = "";
	var hexArr = ipValue.split(".");
	var ipStr = "";//        
	
	if(hexArr.length < 4) //  4     0
	{
		for(var i = hexArr.length; i < 4; i++)
		{
			hexArr.push("0");
		}
	}
	for (var i = 0; i < 4; i++)
	{		
	    hexValue += toHex(hexArr[i]);   
	}
	return hexValue;
}

/**
 *        
 * @param btnArr:       disabledFlag:    
 * @return  
 */
function setBtnStatus(btnArr,disabledFlag)
{
	for(var i = 0; i < btnArr.length; i++)
	{
		btnArr[i].disabled = disabledFlag;
	}
}

/**
 *       XML  
 * @param neid:  ID slotid   ID
 * @return  
 */
function createQueryXMLInfo(neid,slotid)
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    if(null != slotid)
    {
	    param = new tagElement("param");
	    param.setAttribute("name","slotid");
	    param.setAttribute("value",slotid);
	    row.appendChild(param);
    }
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *       
 * @param data:            errArr:       
 * @return  
 */
function showOperResult(data,errArr)
{
	if(null == errArr)
	{
		errArr = [];//           
		errArr[0] = "nename";//           
	}
	openErrPage("../../../../../page/",data.getError(),errArr);
}

/**
 *   common.js               
 * @param res:     obj     /   key:     
 * @return String      
 */
function convertMsg(res,obj,key)
{
	if("function" == (typeof obj))	
	{
		return obj(key);
	}
	else //       
	{
		if(null == obj)
		{
			return key;
		}
		var resValue = obj[key];
		if(null == resValue)
		{
			resValue = "/";
		}		
		return resValue;
	}
}

/**
 *            
 * @param tc TableConf:          
 * @return  
 */
function setTableDisabled(tc)
{
	if(null == tc)
	{
		return;
	}
	for(var i = 0, len = tc.getColsLength(); i < len; i++)
	{
		tc.colArray[i].cell.isEdit = 0;
	}
}

/**
 *         
 * @param  
 * @return  
 */
function TableDataCount()
{
    var countAreaObj = document.createElement("div");
    countAreaObj.style.marginTop="10px";  
    this.countArea = countAreaObj;
    
	var totalLableObj = document.createElement("lable");
	totalLableObj.appendChild(document.createTextNode(RESOURCE["countrows"]))
	countAreaObj.appendChild(totalLableObj);
	this.totalLable = totalLableObj;
	
	var totalCountObj = document.createElement("lable");
	totalCountObj.appendChild(document.createTextNode("0"));
	countAreaObj.appendChild(totalCountObj);
	this.totalCount = totalCountObj;
	
	var selectLableObj = document.createElement("lable");
	selectLableObj.appendChild(document.createTextNode("   "+RESOURCE["seleterows"]))
	countAreaObj.appendChild(selectLableObj);	
	this.selectLable = selectLableObj;
	
	var selectCountObj = document.createElement("lable");
	selectCountObj.appendChild(document.createTextNode("0"));
	countAreaObj.appendChild(selectCountObj);	
	this.selectCount = selectCountObj;
}

/**
 *         
 * @param  
 * @return  
 */
TableDataCount.prototype.getCountArea = function()
{
	return this.countArea;
}

/**
 *      
 * @param totalNum    
 * @return  
 */
TableDataCount.prototype.setTotalCount = function(totalNum)
{
	this.totalCount.removeChild(this.totalCount.firstChild);
	this.totalCount.appendChild(document.createTextNode(totalNum));
}

/**
 *        
 * @param selectedNum      
 * @return  
 */
TableDataCount.prototype.setSelectedCount = function(selectedNum)
{
	this.selectCount.removeChild(this.selectCount.firstChild);
	this.selectCount.appendChild(document.createTextNode(selectedNum));
}

/**
 *        ,    Shelf1()-12-12FIU-1(IN/OUT)
 * @param str1 str2
 * @return int
 */
function comparePort(str1,str2)
{
	if(str1.indexOf("-") == -1 || str2.indexOf("-") == -1)
	{
		return compare(str1,str2);
	}

	var str1Arr = str1.split("-");
	var str2Arr = str2.split("-");
	if(str1Arr.length < 3 || str2Arr.length < 3  || str1Arr.length != str2Arr.length)
	{
		return compare(str1,str2);
	}
	
	var shelf1=0;
	var shelf2=0;
	var slot1=0;
	var slot2=0;
	var port1=0;
	var port2=0;

	if(str1Arr.length == 3 && str2Arr.length == 3)
	{
		if(SYSTEMCONF.getLanguage() == "zh")
		{
			shelf1 = parseInt(str1Arr[0].substring(2));
			shelf2 = parseInt(str2Arr[0].substring(2));
	  }
	  else
	  {
	  	shelf1 = parseInt(str1Arr[0].substring(5));
	  	shelf2 = parseInt(str2Arr[0].substring(5));
	  }
		slot1 = parseInt(str1Arr[1]);
	  slot2 = parseInt(str2Arr[1]);
	  port1 = parseInt(str1Arr[2]);
	  port2 = parseInt(str2Arr[2]);
	}
  else
	{
		if(SYSTEMCONF.getLanguage() == "zh")
		{
			shelf1 = parseInt(str1Arr[0].substring(2,str1Arr[0].indexOf('(')));
			shelf2 = parseInt(str2Arr[0].substring(2,str2Arr[0].indexOf('(')));
	  }
	  else
	  {
	  	shelf1 = parseInt(str1Arr[0].substring(5,str1Arr[0].indexOf('(')));
	  	shelf2 = parseInt(str2Arr[0].substring(5,str2Arr[0].indexOf('(')));
	  }
	  slot1 = parseInt(str1Arr[1]);
	  slot2 = parseInt(str2Arr[1]);
	  port1 = parseInt(str1Arr[3].substring(0,str1Arr[3].indexOf('(')));
	  port2 = parseInt(str2Arr[3].substring(0,str2Arr[3].indexOf('(')));
	}
	
	if(shelf1 > shelf2)
	{
		return 1;
	}
	else if(shelf1 < shelf2)
	{
		return -1;
	}
	
	if(slot1 > slot2)
	{
		return 1;
	}
	else if(slot1 < slot2)
	{
		return -1;
	}
	else
	{
		if(port1 > port2)
		{
			return 1;
		}
		else if(port1 < port2)
		{
			return -1;
		}
		return 0;
	}
}

/**
 *        ,     1-1
 * @param str1 str2
 * @return int
 */
function comparePort2(str1,str2)
{
	if(str1.indexOf("-") == -1 || str2.indexOf("-") == -1)
	{
		return compare(str1,str2);
	}
	var str1Arr = str1.split("-");
	var str2Arr = str2.split("-");
	var slot1 = parseInt(str1Arr[0]);
	var port1 = parseInt(str1Arr[1]);	
	var slot2 = parseInt(str2Arr[0]);
	var port2 = parseInt(str2Arr[1]);	
	
	if(slot1 > slot2)
	{
		return 1;
	}
	else if(slot1 < slot2)
	{
		return -1;
	}
	else
	{
		if(port1 > port2)
		{
			return 1;
		}
		else if(port1 < port2)
		{
			return -1;
		}
		return 0;
	}
}

/**
 *        ,     NE60-Shelf1()-11-11ND2-52(ODU1LP2/ODU1LP2)
 * @param str1 str2
 * @return int
 */
function comparePort3(str1,str2)
{
	if(str1.indexOf("-") == -1 || str2.indexOf("-") == -1)
	{
		return compare(str1,str2);
	}
	str1 = str1.substring(str1.indexOf("-")+1);
	str2 = str2.substring(str2.indexOf("-")+1);
	return comparePort(str1,str2);

}	
/**
 *        ,       0(subrack)-1-12FIU-1(IN/OUT)
 * @param str1 str2
 * @return int
 */
function comparePort4(str1,str2)
{
	return comparePort(str1,str2);
}	

/**
 *        ,     NE(9-30)-Shelf1()-11-11ND2-52(ODU1LP2/ODU1LP2)
 * @param str1 str2
 * @return int
 */
function comparePort5(str1,str2)
{
	var str1Array = str1.split("-");
	var str2Array = str2.split("-");
	var compareStr1 = isNaN(str1Array[0])?str1Array[0]:parseInt(str1Array[0]);
	var compareStr2 = isNaN(str2Array[0])?str2Array[0]:parseInt(str2Array[0]);
	if(str1Array.length == 1 && str2Array.length == 1)
	{
		return compare(compareStr1, compareStr2);
	}
	else
	{
		if(compareStr1 != compareStr2)
		{
			if(isNaN(compareStr1) || isNaN(compareStr2))
			{
				compareStr1 = compareStr1 + "";
				compareStr2 = compareStr2 + "";
			}
			return compare(compareStr1,compareStr2);
		}
		var value1 = str1Array[str1Array.length - 1];
		var value2 = str2Array[str2Array.length - 1];
		value1 = value1.indexOf("(") > 0 ? parseInt(value1.substring(0,value1.indexOf("("))):parseInt(value1);
		value2 = value2.indexOf("(") > 0 ? parseInt(value2.substring(0,value2.indexOf("("))):parseInt(value2);
		return compare(value1,value2);
	}
}
	
function compareTimeslot(str1,str2)
{
	if(str1.indexOf(":") == -1 || str2.indexOf(":") == -1)
	{
		return compare(str1,str2);
	}
	
	var str1Arr = str1.split(":");
	var str2Arr = str2.split(":");
	var timeslot1 = parseInt(str1Arr[1]);
	var timeslot2 = parseInt(str2Arr[1]);	
	if(timeslot1 > timeslot2)
	{
		return 1;
	}
	else if(timeslot1 < timeslot2)
	{
		return -1;
	}
	return 0;
}
/**
 *      ,     
 * @param st defaultSortCol
 * @return void
 */
function initTableSort(st,defaultSortCol)
{
     if(!st.element.colsArray.selectedId)
    {
  	   st.element.colsArray.selectedId = defaultSortCol;
  	   st.element.colsArray.imgflag = 1;
    }
    st.sortRows(st.element.headRow.element.cols[st.element.colsArray.selectedId].element,st.element.colsArray.imgflag);
}

function convertSinkSlot(slotid)
{
	var tmpstr = "";
	var subrackId = getSubrackIDFromSlot(slotid);
	if (subrackId != 0)
	{
		tmpstr = subrackId + "-";
	}
	tmpstr += getSlotIDFromSlot(slotid);
	return tmpstr;
}
