 
loadXMLdoc("../../../../../conf/system.xml", "GET", false, EncapsulateSConf);
loadXMLdoc("../../conf/ason_v2r7c01/ospfipaddr_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
getResourse("../../res/ason/ospfmgr_"+ SYSTEMCONF.getLanguage() +".xml");
getResourse("../../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml");

var obj,neid,st;
var btnRightArr = new Object(); //right object
var nmUserName = getNeProperty(parent).nmUserName ;//          

window.onload = function()
{
		obj = getNeProperty(top);
		neid = obj["neid"];
		
		initTable();
		initRight();
		initButton();
		
		if (btnRightArr["querybtn"].right)
		{
		}
}

function initTable()
{
		st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    $("ipaddrtable").appendChild(st.getTable());
    $("ipaddrtable").oncontextmenu = popupMenuHandler;
    st.setBodyHeight(getTableHeight($("ipaddrtable"), st) + "px");
}

function initButton()
{
		$("querybtn").value = RESOURCE["querybtn"];
		$("applybtn").value = RESOURCE["applybtn"];
		$("printbtn").value = RESOURCE["printbtn"];
		
		$("applybtn").disabled = true;
		
		$("totalrow").innerHTML = RESOURCE["totalrow"];
		$("selrow").innerHTML = RESOURCE["selectedrow"];
}

function initRight()
{
	btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_CP_PARAMETER);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_CP_PARAMETER);
    btnRightArr.printbtn = new BtnRightObj("printbtn", TECMDCODE_QUERY_CP_PARAMETER);
    
    getRightInfo(obj, btnRightArr);
    initrightbtn(btnRightArr);
}

function tabSelectHandler()
{
    if(!$("querybtn").disabled)
    {
  			getOspfIpAddr();
    }
}

function rowSelectHandler()
{
		$("totalrownum").innerHTML = st.getDataRowLength();
		$("selrownum").innerHTML = st.getSelectedRows().length;
}


function setCellIsEditFalse(index)
{
	var ip = st.getCell(index,"ip");
	st.setCellIsEdit(ip,0);
	var mask = st.getCell(index,"mask");
	st.setCellIsEdit(mask,0);
}

function cellEditHandler(param)
{
	if(param.colid == "ip" && param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
	 	var index = param.rowindex;
	 	if (hexToTen(convertIpaddrToHexcode((param.value))) != 0)
	 	{
	 		var cell = st.getCell(index, "mask");
	 		cell.element.style.backgroundColor = "#d0f946";
	 		st.setCellIsEdit(cell, "1");
	 		st.getCellElement(index, "mask").ondblclick = cellondbclick;
			cell.element.modify = true;
	 	}
	 	else
	 	{
	 		var cell = st.getCell(index, "mask");
			cell.element.style.backgroundColor = "";
			st.setCellIsEdit(cell, "0");
			st.getCellElement(index, "mask").ondblclick = null;
			
			cell.element.modify = false;
			st.setCellValue(cell, "mask", "0.0.0.0");
			st.setAtomValue(st.getCellShow(index,"mask"),"0.0.0.0");
	 	}
	}
	$("applybtn").disabled = !btnRightArr.applybtn.right;
}

function getOspfIpAddr()
{
		$("querybtn").disabled = true;
		$("applybtn").disabled = true;
		
		var xmldata = createGetXml();
		var urlstr = "../../../../../neExlorerServlet?sfid="+TECMDCODE_OSN_QUEYT_ETHSNDIP+"&nmUser="+obj["nmUser"];
		loadXMLdoc(urlstr, "POST", false, callbackGet, null, "inputdata="+xmldata);
}

function createGetXml()
{
		var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    var keys = new Array("neid");
    var vals = new Array(neid);
    
    business.appendChild(createRow(keys, vals));
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackGet(doc)
{
		$("querybtn").disabled = false;
		
		var data = EncapsulateData(doc);
		
		if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
		{
				st.clearTableData();
				
				for (var i=0,len=data.getDataRowLength(); i<len; i++)
				{
						var ipVal = data.getDataRowParam(i, "ip");
						var maskVal = data.getDataRowParam(i, "mask");
						
						data.rows[i]["ip"].value = convertNumToIpaddr(ipVal);
						data.rows[i]["mask"].value = convertNumToIpaddr(maskVal);
				}
				
				createTableBody(st, window.tableconf[0], data, RESOURCE);
		}
		
		$("totalrownum").innerHTML = st.getDataRowLength();
		$("selrownum").innerHTML = st.getSelectedRows().length;
		
		showErrorDialog(data);
		
		for (var i=0,len=st.getDataRowLength(); i<len; i++)
		{
				var ip = hexToTen(convertIpaddrToHexcode(st.getCellStoreValue(i, "ip", "ip")));
				if (ip == 0)
				{
					var cell = st.getCell(i, "mask");
					cell.element.style.backgroundColor = "";
					st.setCellIsEdit(cell, "0");
					st.getCellElement(i, "mask").ondblclick = null;
				}
				var ipCell = st.getCellEdit(i, "ip").element;
				var maskCell = st.getCellEdit(i, "mask").element;
				validateIp(ipCell, true);
				validateIp(maskCell, true);
				if(!btnRightArr.applybtn.right)
				{
					setCellIsEditFalse(i);
				}
				
	    }
		
}

function setOspfIpAddr()
{
		$("querybtn").disabled = true;
		$("applybtn").disabled = true;
		
		var xmldata = createSetXml();
		var urlstr = "../../../../../neExlorerServlet?sfid="+TECMD_LAN_SET_SNDIPMASK+"&nmUser="+obj["nmUser"];
		loadXMLdoc(urlstr, "POST", false, callbackSet, null, "inputdata="+xmldata);
}

function createSetXml()
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    for (var i=0,len=st.getDataRowLength(); i<len; i++)
    {
    	if (!st.getModify(i))
    	{
    		continue;
    	}
    	var keys = new Array("neid");
    	var vals = new Array(neid);

    	var ipStr = st.getCellStoreValue(i, "ip", "ip");
    	keys.push("ip");
    	vals.push(hexToTen(convertIpaddrToHexcode(ipStr)));
    	
    	var maskStr = st.getCellStoreValue(i, "mask", "mask");
    	keys.push("mask");
    	vals.push(hexToTen(convertIpaddrToHexcode(maskStr)));
    	
    	business.appendChild(createRow(keys, vals));
    }
    
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackSet(doc)
{
		$("querybtn").disabled = false;
		
		var data = EncapsulateData(doc);		
		showErrorDialog(data);
		
		var errCode = data.getSErrorCode();
		if (errCode == 0)
		{
				refreshTableState(st, window.tableconf[0], data);
		}
		else if (errCode == 1)
		{
			for (var i = 0, m = data.getBErrLength(); i < m; i++)
			{
				if(typeof(data.errObj.rowErrors[i].errorObj["ip"]) != "undefined")
				{
					data.errObj.rowErrors[i].errorObj["ip"] = convertNumToIpaddr(data.getBErrParam(i, "ip"));
				}
				if(typeof(data.errObj.rowErrors[i].errorObj["mask"]) != "undefined")
				{
					data.errObj.rowErrors[i].errorObj["mask"] = convertNumToIpaddr(data.getBErrParam(i, "mask"));
				}
			}
			refreshTableState(st, window.tableconf[0], data);
		}
		
		if (errCode != 0)
		{
				$("applybtn").disabled = false;
		}		
}

function printIpAddr()
{
		if (st.getDataRowLength() <= 0)
		{
				alert(RESOURCE["nodata"]);
				return;
		}
		
		openPrintPage('../../../../../page/', RESOURCE['printIpAddr'],'st',true,nmUserName);
}

function createRow(keyParams, valParams)
{
    var row = new tagElement("row-params");
    var param;
    
    for (var i=0; i<keyParams.length; i++)
    {
     		param = new tagElement("param");    
		    param.setAttribute("name", keyParams[i]);
		    param.setAttribute("value", valParams[i]);
		    row.appendChild(param);
    }
    
    return row;
}

function showErrorDialog(di)
{
		var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", di.getError(), errArr);
    errArr = null;
}

window.onresize = function()
{
		if (document.body)
		{
				st.setBodyHeight(getTableHeight($("ipaddrtable"), st) + "px");
		}
}
