/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ason.ngwdm.beanplugin.TERsvpMd5DbMgr;
import com.huawei.nglct.po.embeddednemgrmo.TERsvpMd5MOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public class TERsvpMd5ScriptHandler
implements TEScriptHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        return this.writeExportDataToScript(neID, item);
    }

    private int writeExportDataToScript(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<TERsvpMd5MOPO> rsvpMd5MOList = TERsvpMd5DbMgr.getRsvpMd5FromDB(neID, errRet);
        if (0 != errRet.getResult()) {
            return 1092743443;
        }
        if (null == rsvpMd5MOList || rsvpMd5MOList.isEmpty()) {
            logger.info("rsvpMd5InfoMO is null! neID->" + neID);
            return 0;
        }
        for (TERsvpMd5MOPO mo : rsvpMd5MOList) {
            TEScriptCmd cmd = this.constractScriptCmd(mo, item);
            if (null == cmd) continue;
            TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
        }
        return 0;
    }

    private TEScriptCmd constractScriptCmd(TERsvpMd5MOPO mo, int item) {
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(item);
        String nodeId = mo.getNodeId();
        String authCode = mo.getAuthCode();
        char[] c = authCode.toCharArray();
        if (c.length > 0) {
            c[0] = (char)(c[0] - 32);
        }
        authCode = String.valueOf(c);
        cmd.addPara("node_id", nodeId, true, false);
        cmd.addPara("auth_code", authCode, true, false);
        return cmd;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }
}

