/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ason.ngwdm.beanplugin.TEOspfipDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.TEOspfipMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public class TEOspfipScriptHandler
implements TEScriptHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        return this.writeExportDataToScript(neID, item);
    }

    private int writeExportDataToScript(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TEOspfipMOPO ospfipMO = TEOspfipDbMgr.getOspfIpMOFromDB(neID, errRet);
        if (0 != errRet.getResult()) {
            return 1092743443;
        }
        if (null == ospfipMO) {
            logger.info("tpidMO is null! neID->" + neID);
            return 0;
        }
        TEScriptCmd cmd = this.constractScriptCmd(ospfipMO, item);
        if (null == cmd) {
            return 0;
        }
        return TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
    }

    private TEScriptCmd constractScriptCmd(TEOspfipMOPO ospfipMO, int item) {
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(item);
        String sndIpStr = ospfipMO.getSndip();
        String sndsubmask = ospfipMO.getSndsubmask();
        try {
            cmd.addPara("sndip", sndIpStr, true, false);
            cmd.addPara("sndsubmask", sndsubmask, true, false);
        }
        catch (Exception e) {
            logger.error("parse netpId fail!", (Throwable)e);
        }
        return cmd;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }
}

