/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ason.ngwdm.beanplugin.TEOspfProtocolDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.TEAsonOspfProtocolMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class TEOspfProtocolScriptHandler
implements TEScriptHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();
    private static final Map<Long, String> PR_ENABLE = new HashMap<Long, String>();
    private static final Map<Long, String> PR_LIM_CTRL_CHNL_TYPE = new HashMap<Long, String>();

    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        return this.writeExportDataToScript(neID, item);
    }

    private int writeExportDataToScript(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<TEAsonOspfProtocolMOPO> moList = TEOspfProtocolDbMgr.getMOFromDB(neID, errRet);
        if (0 != errRet.getResult()) {
            return 1092743443;
        }
        if (null == moList || moList.isEmpty()) {
            logger.info("tpidMO is null! neID->" + neID);
            return 0;
        }
        for (TEAsonOspfProtocolMOPO mo : moList) {
            TEScriptCmd cmd = this.constractScriptCmd(mo, item);
            if (null == cmd) {
                return 0;
            }
            TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
        }
        return 0;
    }

    private TEScriptCmd constractScriptCmd(TEAsonOspfProtocolMOPO mo, int item) {
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(item);
        try {
            cmd.addPara("board", Long.toHexString(mo.getBoard()), false, false);
            cmd.addPara("subboard", String.valueOf(mo.getSubboard()), false, false);
            cmd.addPara("port", String.valueOf(mo.getPort()), false, false);
            cmd.addPara("cctype", PR_LIM_CTRL_CHNL_TYPE.get(mo.getCctype()), false, false);
            cmd.addPara("channel", String.valueOf(mo.getChannel()), false, false);
            cmd.addPara("flag", PR_ENABLE.get(mo.getFlag()), false, false);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
        }
        return cmd;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }

    static {
        PR_ENABLE.put(0L, "disable");
        PR_ENABLE.put(1L, "enable");
        PR_LIM_CTRL_CHNL_TYPE.put(1L, "PM_RES");
        PR_LIM_CTRL_CHNL_TYPE.put(4L, "OSC_D4_D12");
        PR_LIM_CTRL_CHNL_TYPE.put(5L, "ETH");
        PR_LIM_CTRL_CHNL_TYPE.put(7L, "SDH_D4_D12");
        PR_LIM_CTRL_CHNL_TYPE.put(13L, "GCC0_18");
        PR_LIM_CTRL_CHNL_TYPE.put(14L, "GCC1_24");
    }
}

