/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ason.ngwdm.beanplugin.TEOSPFAuthIdentifyDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.TEOSPFAuthIdentifyMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class TEOSPFAuthIdentifyScriptHandler
implements TEScriptHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();
    private static final Map<Long, String> PR_LIM_CTRL_CHNL_TYPE = new HashMap<Long, String>();
    private static final Map<Long, String> PR_LIM_AUTH_TYPE;

    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        return this.writeExportDataToScript(neID, item);
    }

    private int writeExportDataToScript(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<TEOSPFAuthIdentifyMOPO> ospfMOList = TEOSPFAuthIdentifyDbMgr.getOSPFAuthIdentifyFromDB(neID, errRet);
        if (0 != errRet.getResult()) {
            return 1092743443;
        }
        if (null == ospfMOList || ospfMOList.isEmpty()) {
            logger.info("ospfAuthIdentifyMO is null! neID->" + neID);
            return 0;
        }
        for (TEOSPFAuthIdentifyMOPO mo : ospfMOList) {
            TEScriptCmd cmd = this.constractScriptCmd(mo, item);
            if (null == cmd) continue;
            TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
        }
        return 0;
    }

    private TEScriptCmd constractScriptCmd(TEOSPFAuthIdentifyMOPO mo, int item) {
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(item);
        long board = mo.getBoard();
        long subBoard = mo.getSubboard();
        long port = mo.getPort();
        long ctrliftype = mo.getCtrliftype();
        long channelno = mo.getChannelno();
        long authtype = mo.getAuthtype();
        String authCode = mo.getAuthCode();
        if (!authCode.equals("")) {
            char[] c = authCode.toCharArray();
            if (c.length > 0) {
                c[0] = (char)(c[0] - 32);
            }
            authCode = String.valueOf(c);
        }
        cmd.addPara("board", Long.toHexString(board), false, false);
        cmd.addPara("subboard", String.valueOf(subBoard), false, false);
        cmd.addPara("port", String.valueOf(port), false, false);
        cmd.addPara("chnl_type", PR_LIM_CTRL_CHNL_TYPE.get(ctrliftype), false, false);
        cmd.addPara("channel", String.valueOf(channelno), false, false);
        cmd.addPara("authtype", PR_LIM_AUTH_TYPE.get(authtype), false, false);
        cmd.addPara("key", authCode, true, false);
        return cmd;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }

    static {
        PR_LIM_CTRL_CHNL_TYPE.put(1L, "PM_RES");
        PR_LIM_CTRL_CHNL_TYPE.put(4L, "OSC_D4_D12");
        PR_LIM_CTRL_CHNL_TYPE.put(5L, "ETH");
        PR_LIM_CTRL_CHNL_TYPE.put(7L, "SDH_D4_D12");
        PR_LIM_CTRL_CHNL_TYPE.put(13L, "GCC0_18");
        PR_LIM_CTRL_CHNL_TYPE.put(14L, "GCC1_24");
        PR_LIM_AUTH_TYPE = new HashMap<Long, String>();
        PR_LIM_AUTH_TYPE.put(0L, "none");
        PR_LIM_AUTH_TYPE.put(1L, "simple");
        PR_LIM_AUTH_TYPE.put(2L, "md5");
    }
}

