/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ason.ngwdm.beanplugin.TELmpAdmStatusDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.TELmpAdmStatusMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public class TELmpAdmStatusScriptHandler
implements TEScriptHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        return this.writeExportDataToScript(neID, item);
    }

    private int writeExportDataToScript(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<TELmpAdmStatusMOPO> lmpAdmStatusMOList = TELmpAdmStatusDbMgr.getLmpAdmStatusFromDB(neID, errRet);
        if (0 != errRet.getResult()) {
            return 1092743443;
        }
        if (null == lmpAdmStatusMOList || lmpAdmStatusMOList.isEmpty()) {
            logger.info("lmpAdmStatusMOPO is null! neID->" + neID);
            return 0;
        }
        for (TELmpAdmStatusMOPO mo : lmpAdmStatusMOList) {
            TEScriptCmd cmd = this.constractScriptCmd(mo, item);
            if (null == cmd) continue;
            TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
        }
        return 0;
    }

    private TEScriptCmd constractScriptCmd(TELmpAdmStatusMOPO mo, int item) {
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(item);
        long slotId = mo.getBoard();
        long subboard = mo.getSubboard();
        long port = mo.getPort();
        String payload = mo.getPayload();
        String adminstatus = mo.getAdminstatus();
        cmd.addPara("board", "0x" + Long.toHexString(slotId), false, false);
        cmd.addPara("subboard", Long.toString(subboard), false, false);
        cmd.addPara("port", Long.toString(port), false, false);
        cmd.addPara("payload", payload, false, false);
        cmd.addPara("adminstatus", adminstatus, false, false);
        return cmd;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }
}

