/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ason.ngwdm.beanplugin.TEAddLmpCCDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.TELmpAddCCMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public class TELmpAddCCScriptHandler
implements TEScriptHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        return this.writeExportDataToScript(neID, item);
    }

    private int writeExportDataToScript(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<TELmpAddCCMOPO> lmpAddCCMOList = TEAddLmpCCDbMgr.getLmpAddCCMoFromDB(neID, errRet);
        if (0 != errRet.getResult()) {
            return 1092743443;
        }
        if (null == lmpAddCCMOList || lmpAddCCMOList.isEmpty()) {
            logger.info("lmpAdmStatusMOPO is null! neID->" + neID);
            return 0;
        }
        for (TELmpAddCCMOPO mo : lmpAddCCMOList) {
            TEScriptCmd cmd = this.constractScriptCmd(mo, item);
            if (null == cmd) continue;
            TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
        }
        return 0;
    }

    private TEScriptCmd constractScriptCmd(TELmpAddCCMOPO lmpAddCCMO, int item) {
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(item);
        long slotid = lmpAddCCMO.getBoard();
        long port = lmpAddCCMO.getPort();
        String destaddrIp = lmpAddCCMO.getRemoteaddr();
        String nexthopaddrIp = lmpAddCCMO.getNexthopaddr();
        try {
            cmd.addPara("board", "0x" + Long.toHexString(slotid), false, false);
            cmd.addPara("subboard", String.valueOf(lmpAddCCMO.getSubboard()), false, false);
            cmd.addPara("port", Long.toString(port), false, false);
            cmd.addPara("remoteaddr", destaddrIp, true, false);
            cmd.addPara("nexthopaddr", nexthopaddrIp, true, false);
        }
        catch (Exception e) {
            logger.error("parse netpId fail!", (Throwable)e);
        }
        return cmd;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }
}

