/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ason.ngwdm.beanplugin.TEAsonDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.TERsvpMd5MOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TERsvpMd5DbMgr
extends TEAsonDbMgr {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();

    private TERsvpMd5DbMgr() {
    }

    public static List<TERsvpMd5MOPO> getRsvpMd5FromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TERsvpMd5DbMgr.getRsvpMd5FromDB";
        normalLogger.info("TERsvpMd5DbMgr.getRsvpMd5FromDB: begin.");
        ArrayList<TERsvpMd5MOPO> rsvpMd5List = new ArrayList<TERsvpMd5MOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TERsvpMd5DbMgr.logNullNEError(neID);
                TERsvpMd5DbMgr.setOperFail(neID, errRet, 1090596385);
                TERsvpMd5DbMgr.logFuncEnd("TERsvpMd5DbMgr.getRsvpMd5FromDB");
                return rsvpMd5List;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TERsvpMd5MOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TERsvpMd5MOPO.class);
        }
        catch (Exception e) {
            TERsvpMd5DbMgr.logExceptionOnGet(neID, e);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, 1092743443);
            TERsvpMd5DbMgr.logFuncEnd("TERsvpMd5DbMgr.getRsvpMd5FromDB");
            return rsvpMd5List;
        }
        if (null == dbResult) {
            TERsvpMd5DbMgr.logNullErrorOnGet(neID);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, 1092743443);
            TERsvpMd5DbMgr.logFuncEnd("TERsvpMd5DbMgr.getRsvpMd5FromDB");
            return rsvpMd5List;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    rsvpMd5List.add((TERsvpMd5MOPO)obj);
                }
            }
        } else {
            TERsvpMd5DbMgr.logRetCodeErrorOnGet(neID, retCode);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, retCode);
        }
        TERsvpMd5DbMgr.logFuncEnd("TERsvpMd5DbMgr.getRsvpMd5FromDB");
        return rsvpMd5List;
    }

    public static void delRsvpMd5FromDB(int neID, TERsvpMd5MOPO rsvpMd5MO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TERsvpMd5DbMgr.delRsvpMd5FromDB";
        normalLogger.info("TERsvpMd5DbMgr.delRsvpMd5FromDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)rsvpMd5MO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)rsvpMd5MO);
        }
        catch (Exception e) {
            normalLogger.error("delete arp from db fail! neID->" + neID, (Throwable)e);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, 1092743443);
            TERsvpMd5DbMgr.logFuncEnd("TERsvpMd5DbMgr.delRsvpMd5FromDB");
            return;
        }
        if (null == dbResult) {
            TERsvpMd5DbMgr.logNullErrorOnDel(neID);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, 1092743443);
            TERsvpMd5DbMgr.logFuncEnd("TERsvpMd5DbMgr.delRsvpMd5FromDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TERsvpMd5DbMgr.logRetCodeErrorOnDel(neID, retCode);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, retCode);
        }
        TERsvpMd5DbMgr.logFuncEnd("TERsvpMd5DbMgr.delRsvpMd5FromDB");
    }

    public static void delAllRsvpMd5FromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TERsvpMd5DbMgr.delAllRsvpMd5FromDB";
        normalLogger.info("TERsvpMd5DbMgr.delAllRsvpMd5FromDB: begin.");
        List<TERsvpMd5MOPO> rsvpMd5List = TERsvpMd5DbMgr.getRsvpMd5FromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TERsvpMd5DbMgr.logRetCodeErrorOnDel(neID, retCode);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, retCode);
        }
        for (TERsvpMd5MOPO rsvpMd5 : rsvpMd5List) {
            TERsvpMd5DbMgr.delRsvpMd5FromDB(neID, rsvpMd5, errRet);
        }
        TERsvpMd5DbMgr.logFuncEnd("TERsvpMd5DbMgr.delAllRsvpMd5FromDB");
    }

    public static void createRsvpMd5ToDB(int neID, TERsvpMd5MOPO rsvpMd5MO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEArpDBMgr.createArpToDB";
        normalLogger.info("TEArpDBMgr.createArpToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)rsvpMd5MO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)rsvpMd5MO);
        }
        catch (Exception e) {
            TERsvpMd5DbMgr.logExceptionErrorOnCreate(neID, e);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, 1092743443);
            TERsvpMd5DbMgr.logFuncEnd("TEArpDBMgr.createArpToDB");
            return;
        }
        if (null == dbResult) {
            TERsvpMd5DbMgr.logNullErrorOnCreate(neID);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, 1092743443);
            TERsvpMd5DbMgr.logFuncEnd("TEArpDBMgr.createArpToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TERsvpMd5DbMgr.logRetCodeErrorOnCreate(neID, retCode);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, retCode);
        }
        TERsvpMd5DbMgr.logFuncEnd("TEArpDBMgr.createArpToDB");
    }

    public static void updateRsvpMd5MOToDB(int neID, TERsvpMd5MOPO rsvpMd5MO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TERsvpMd5DbMgr.updateRsvpMd5MOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TERsvpMd5DbMgr.updateRsvpMd5MOToDB");
        if (null == rsvpMd5MO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)rsvpMd5MO) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)rsvpMd5MO);
        }
        catch (Exception e) {
            TERsvpMd5DbMgr.logExceptionErrorOnUpdate(neID, e);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TERsvpMd5DbMgr.updateRsvpMd5MOToDB");
            return;
        }
        if (null == dbResult) {
            TERsvpMd5DbMgr.logNullErrorOnUpdate(neID);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TERsvpMd5DbMgr.updateRsvpMd5MOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TERsvpMd5DbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TERsvpMd5DbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TERsvpMd5DbMgr.updateRsvpMd5MOToDB");
    }
}

