/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ason.ngwdm.beanplugin.TEAsonDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.TELmpAdmStatusMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class TELmpAdmStatusDbMgr
extends TEAsonDbMgr {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();
    private static Map signalTypeMap = new HashMap();

    private TELmpAdmStatusDbMgr() {
    }

    public static String getSignalType(int signalType) {
        return (String)signalTypeMap.get(signalType);
    }

    public static String getAdminStatus(int adminstatus) {
        switch (adminstatus) {
            case 1: {
                return "admin_up";
            }
            case 2: {
                return "admin_down";
            }
        }
        return "";
    }

    public static List<TELmpAdmStatusMOPO> getLmpAdmStatusFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TELmpAdmStatusDbMgr.getLmpAdmStatusFromDB";
        normalLogger.info("TELmpAdmStatusDbMgr.getLmpAdmStatusFromDB: begin.");
        ArrayList<TELmpAdmStatusMOPO> LmpAdmStatusList = new ArrayList<TELmpAdmStatusMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TELmpAdmStatusDbMgr.logNullNEError(neID);
                TELmpAdmStatusDbMgr.setOperFail(neID, errRet, 1090596385);
                TELmpAdmStatusDbMgr.logFuncEnd("TELmpAdmStatusDbMgr.getLmpAdmStatusFromDB");
                return LmpAdmStatusList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TELmpAdmStatusMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TELmpAdmStatusMOPO.class);
        }
        catch (Exception e) {
            TELmpAdmStatusDbMgr.logExceptionOnGet(neID, e);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, 1092743443);
            TELmpAdmStatusDbMgr.logFuncEnd("TELmpAdmStatusDbMgr.getLmpAdmStatusFromDB");
            return LmpAdmStatusList;
        }
        if (null == dbResult) {
            TELmpAdmStatusDbMgr.logNullErrorOnGet(neID);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, 1092743443);
            TELmpAdmStatusDbMgr.logFuncEnd("TELmpAdmStatusDbMgr.getLmpAdmStatusFromDB");
            return LmpAdmStatusList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    LmpAdmStatusList.add((TELmpAdmStatusMOPO)obj);
                }
            }
        } else {
            TELmpAdmStatusDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, retCode);
        }
        TELmpAdmStatusDbMgr.logFuncEnd("TELmpAdmStatusDbMgr.getLmpAdmStatusFromDB");
        return LmpAdmStatusList;
    }

    public static void delLmpAdmStatusFromDB(int neID, TELmpAdmStatusMOPO LmpAdmStatusMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TELmpAdmStatusDbMgr.delLmpAdmStatusFromDB";
        normalLogger.info("TELmpAdmStatusDbMgr.delLmpAdmStatusFromDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)LmpAdmStatusMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)LmpAdmStatusMO);
        }
        catch (Exception e) {
            normalLogger.error("delete lmpAdmStatus from db fail! neID->" + neID, (Throwable)e);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, 1092743443);
            TELmpAdmStatusDbMgr.logFuncEnd("TELmpAdmStatusDbMgr.delLmpAdmStatusFromDB");
            return;
        }
        if (null == dbResult) {
            TELmpAdmStatusDbMgr.logNullErrorOnDel(neID);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, 1092743443);
            TELmpAdmStatusDbMgr.logFuncEnd("TELmpAdmStatusDbMgr.delLmpAdmStatusFromDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TELmpAdmStatusDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, retCode);
        }
        TELmpAdmStatusDbMgr.logFuncEnd("TELmpAdmStatusDbMgr.delLmpAdmStatusFromDB");
    }

    public static void delAllLmpAdmStatusFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TELmpAdmStatusDbMgr.delAllLmpAdmStatusFromDB";
        normalLogger.info("TELmpAdmStatusDbMgr.delAllLmpAdmStatusFromDB: begin.");
        List<TELmpAdmStatusMOPO> lmpAdmStatusList = TELmpAdmStatusDbMgr.getLmpAdmStatusFromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TELmpAdmStatusDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, retCode);
        }
        for (TELmpAdmStatusMOPO LmpAdmStatusMO : lmpAdmStatusList) {
            TELmpAdmStatusDbMgr.delLmpAdmStatusFromDB(neID, LmpAdmStatusMO, errRet);
        }
        TELmpAdmStatusDbMgr.logFuncEnd("TELmpAdmStatusDbMgr.delAllLmpAdmStatusFromDB");
    }

    public static void createLmpAdmStatusToDB(int neID, TELmpAdmStatusMOPO LmpAdmStatusMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TELmpAdmStatusDbMgr.createLmpAdmStatusToDB";
        normalLogger.info("TELmpAdmStatusDbMgr.createLmpAdmStatusToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)LmpAdmStatusMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)LmpAdmStatusMO);
        }
        catch (Exception e) {
            TELmpAdmStatusDbMgr.logExceptionErrorOnCreate(neID, e);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, 1092743443);
            TELmpAdmStatusDbMgr.logFuncEnd("TELmpAdmStatusDbMgr.createLmpAdmStatusToDB");
            return;
        }
        if (null == dbResult) {
            TELmpAdmStatusDbMgr.logNullErrorOnCreate(neID);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, 1092743443);
            TELmpAdmStatusDbMgr.logFuncEnd("TELmpAdmStatusDbMgr.createLmpAdmStatusToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TELmpAdmStatusDbMgr.logRetCodeErrorOnCreate(neID, retCode);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, retCode);
        }
        TELmpAdmStatusDbMgr.logFuncEnd("TELmpAdmStatusDbMgr.createLmpAdmStatusToDB");
    }

    public static void updateLmpAdmStatusMOToDB(int neID, TELmpAdmStatusMOPO LmpAdmStatusMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TELmpAdmStatusDbMgr.updateLmpAdmStatusMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TELmpAdmStatusDbMgr.updateLmpAdmStatusMOToDB");
        if (null == LmpAdmStatusMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)LmpAdmStatusMO) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)LmpAdmStatusMO);
        }
        catch (Exception e) {
            TELmpAdmStatusDbMgr.logExceptionErrorOnUpdate(neID, e);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TELmpAdmStatusDbMgr.updateLmpAdmStatusMOToDB");
            return;
        }
        if (null == dbResult) {
            TELmpAdmStatusDbMgr.logNullErrorOnUpdate(neID);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TELmpAdmStatusDbMgr.updateLmpAdmStatusMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TELmpAdmStatusDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TELmpAdmStatusDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TELmpAdmStatusDbMgr.updateLmpAdmStatusMOToDB");
    }

    static {
        signalTypeMap.put(1, "GE");
        signalTypeMap.put(2, "Any");
        signalTypeMap.put(3, "ODU1");
        signalTypeMap.put(4, "ODU2");
        signalTypeMap.put(5, "ODU3");
        signalTypeMap.put(6, "ODU5G");
        signalTypeMap.put(7, "OTU1");
        signalTypeMap.put(8, "OTU2");
        signalTypeMap.put(9, "OTU3");
        signalTypeMap.put(10, "OTU5G");
        signalTypeMap.put(11, "OCh");
        signalTypeMap.put(12, "OMS");
        signalTypeMap.put(42, "ODU0");
        signalTypeMap.put(43, "VC4");
        signalTypeMap.put(45, "SDH-MS");
        signalTypeMap.put(51, "FIBER");
        signalTypeMap.put(52, "ODUX");
        signalTypeMap.put(53, "ODU4");
        signalTypeMap.put(54, "ODU0/ODU1");
        signalTypeMap.put(55, "ODU0/ODU1/ODU2");
        signalTypeMap.put(56, "ODU0/ODU1/ODU2/ODU3");
        signalTypeMap.put(57, "ODU1/ODU2");
        signalTypeMap.put(58, "ODU1/ODU2/ODU3");
        signalTypeMap.put(59, "ODU2/ODU3");
        signalTypeMap.put(67, "ODUflex");
        signalTypeMap.put(68, "ODU0/ODU1/ODU2/ODUflex");
        signalTypeMap.put(70, "ODU0/ODU1/ODU2/ODU3/ODUflex");
        signalTypeMap.put(75, "ODU0/ODU1/ODU2/ODU3/ODU4/ODUflex");
        signalTypeMap.put(76, "OTU4");
        signalTypeMap.put(79, "N*OTU2");
        signalTypeMap.put(65534, "NONE");
        signalTypeMap.put(0, "-");
    }
}

