/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import org.slf4j.Logger;

public abstract class TEAsonDbMgr {
    public static final Logger normalLogger = TELogFactory.getNormalLogger();

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEAsonDbMgr.getObjName(objName));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName[i]);
        }
        return objNameBuffer.toString();
    }

    public static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEAsonDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode).getErrList());
    }

    protected static void logNullNEError(int neID) {
        normalLogger.error("ne is null! neID->" + neID);
    }

    public static void logNullErrorOnGet(int neID) {
        normalLogger.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    public static void logExceptionOnGet(int neID, Exception e) {
        normalLogger.error("get mo from db fail! neID->" + neID, (Throwable)e);
    }

    protected static void logRetCodeErrorOnUpdate(int neID, int retCode) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    protected static void logNullErrorOnUpdate(int neID) {
        normalLogger.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    protected static void logExceptionErrorOnUpdate(int neID, Exception e) {
        normalLogger.error("update mo to db device fail! neID->" + neID, (Throwable)e);
    }

    protected static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    protected static void logFuncEnd(String funcName) {
        normalLogger.info(funcName + ": end.");
    }

    public static void logNullErrorOnCreate(int neID) {
        normalLogger.error("create mo to db device fail! neID->" + neID);
    }

    public static void logNullErrorOnDel(int neID) {
        normalLogger.error("delete mo from db device fail! neID->" + neID);
    }

    protected static void logRetCodeErrorOnDel(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    public static void logRetCodeErrorOnCreate(int neID, int retCode) {
        String tipStr = String.format("create mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    protected static void logExceptionErrorOnCreate(int neID, Exception e) {
        normalLogger.error("create  fail! neID->" + neID, (Throwable)e);
    }
}

