/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.ason_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TECharsetConverter;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.zip.InflaterOutputStream;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class TEUncompressSDHLsp {
    private static TEUncompressSDHLsp instance;

    public static TEUncompressSDHLsp getInstance() {
        if (instance == null) {
            return new TEUncompressSDHLsp();
        }
        return instance;
    }

    private TEUncompressSDHLsp() {
    }

    private static byte convert(String hex) {
        int val = Integer.valueOf(hex, 16);
        return (byte)(val > 127 ? val - 256 : val);
    }

    public static byte[] unZipString2Bytes(String res) {
        byte[] msg = new byte[res.length() / 2];
        int len = res.length();
        for (int i = 0; i < len; i += 2) {
            msg[i / 2] = TEUncompressSDHLsp.convert(res.substring(i, i + 2));
        }
        int srclen = IOStreamConvertor.readInt((byte[])msg, (int)8);
        byte[] srcData = new byte[srclen];
        System.arraycopy(msg, 12, srcData, 0, srclen);
        return srcData;
    }

    public static byte[] unZipCompress(byte[] res) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InflaterOutputStream zos = new InflaterOutputStream(bos);
            zos.write(res);
            zos.close();
            return bos.toByteArray();
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("unZipCompress failed!", (Throwable)ex);
            return null;
        }
    }

    public void refactor(Operation oper, int neid) {
        ArrayList<Output> tempOutput = new ArrayList<Output>();
        int outPutCount = oper.getOutputCount();
        StringBuilder cont = new StringBuilder("");
        try {
            for (int counter = 0; counter < outPutCount; ++counter) {
                int m_sequence = Integer.valueOf(oper.getOutput()[counter].getPart(0).getValue());
                int m_totoalnum = Integer.valueOf(oper.getOutput()[counter].getPart(1).getValue());
                String content = oper.getOutput()[counter].getPart(4).getValue();
                cont.append(content);
                if (m_sequence != m_totoalnum || cont.length() <= 0) continue;
                byte[] data = TEUncompressSDHLsp.unZipCompress(TEUncompressSDHLsp.unZipString2Bytes(cont.toString()));
                Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
                Operation tmpOper = definitions.getOperation(oper.getName() + "_AFTER_UNCOMPRESS");
                Output modelOut = tmpOper.getOutput(0);
                int outTotalLen = this.getOutTotalLen(tmpOper.getOutput()[0]);
                int outCount = data.length / outTotalLen;
                for (int i = 0; i < outCount; ++i) {
                    Output out = (Output)modelOut.clone();
                    byte[] tmp = new byte[outTotalLen];
                    System.arraycopy(data, i * outTotalLen, tmp, 0, outTotalLen);
                    this.addData(neid, out, tmp);
                    tempOutput.add(out);
                }
                cont = new StringBuilder("");
            }
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("TEUncompressSDHLsp refactor failed!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("TEUncompressSDHLsp refactor failed!", (Throwable)e);
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("TEUncompressSDHLsp refactor failed!", (Throwable)e);
        }
        oper.clearOutput();
        for (int i = 0; i < tempOutput.size(); ++i) {
            oper.addOutput((Output)tempOutput.get(i));
        }
    }

    private void addData(int neid, Output out, byte[] data) {
        int i = 0;
        Fault fault = out.getFault(0);
        fault.setCode(String.valueOf(IOStreamConvertor.readUnsignedShort((byte[])data, (int)i)));
        i += 2;
        int paraLen = out.getPartCount();
        for (int paraIndex = 0; paraIndex < paraLen; ++paraIndex) {
            Part curPart = out.getPart(paraIndex);
            String paraType = curPart.getType();
            int len = curPart.getLength();
            byte[] tmp = len <= 0 ? new byte[data.length - i] : new byte[len];
            System.arraycopy(data, i, tmp, 0, tmp.length);
            i += tmp.length;
            if ("BYTE".equalsIgnoreCase(paraType)) {
                curPart.setValue(String.valueOf(tmp[0]));
                continue;
            }
            if ("INT".equalsIgnoreCase(paraType)) {
                curPart.setValue(String.valueOf(IOStreamConvertor.readUnsignedShort((byte[])tmp, (int)0)));
                continue;
            }
            if ("LONG".equalsIgnoreCase(paraType)) {
                curPart.setValue(String.valueOf(IOStreamConvertor.readInt((byte[])tmp, (int)0)));
                continue;
            }
            if ("VAR".equalsIgnoreCase(paraType)) {
                curPart.setValue(TECharsetConverter.getInstance().convertByteToString(neid, tmp));
                continue;
            }
            if ("PROTOTYPE".equalsIgnoreCase(paraType)) {
                StringBuffer hexStr = new StringBuffer("");
                String strUnit = "";
                int jLen = tmp.length;
                for (int j = 0; j < jLen; ++j) {
                    strUnit = Integer.toHexString(tmp[j]).toUpperCase();
                    if (strUnit.length() < 2) {
                        strUnit = "0" + strUnit;
                    } else if (strUnit.length() > 2) {
                        strUnit = strUnit.substring(strUnit.length() - 2);
                    }
                    hexStr.append(strUnit);
                }
                curPart.setValue(hexStr.toString());
                continue;
            }
            curPart.setValue(TECharsetConverter.getInstance().convertByteToString(neid, tmp).trim());
        }
    }

    private int getOutTotalLen(Output out) {
        int length = 0;
        int len = out.getPartCount();
        for (int i = 0; i < len; ++i) {
            length += out.getPart(i).getLength();
        }
        return length += out.getFault()[0].getLength();
    }
}

