/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.ason_v2r8c01;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.ArrayList;

public class TEQuerySdhXCInfo
extends TENEExplorerBean {
    private static final int LEVEL_VC12 = 1;
    private static final int LEVEL_VC3 = 2;
    private String CASCADENUM = "";
    private String GRANNULARITY = "";

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        RowParams[] rowParamArray = inputData.getBussinessParams().getRowParams();
        for (int i = 0; i < rowParamArray.length; ++i) {
            String paramValue;
            RowParams params = rowParamArray[i];
            Param param = params.getParam("cascadeNum");
            this.CASCADENUM = paramValue = param.getValue();
            param = params.getParam("granularity");
            this.GRANNULARITY = paramValue = param.getValue();
        }
        ArrayList list = super.getOperation(neid, subFunc, inputData, memeryData);
        return list;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        RowParams rowparams = null;
        super.handleMessage(neid, operationList, subfunc);
        int srcSlotid = 0;
        int sinkSlotid = 0;
        int srcPortid = 0;
        int sinkPortid = 0;
        int srcAU4 = 0;
        int sinkAU4 = 0;
        int srcLowPath = 0;
        int sinkLowPath = 0;
        String tmpSrcLowPath = "";
        String tmpSinkLowPath = "";
        int cascadeNum = Integer.parseInt(this.CASCADENUM);
        int granularity = Integer.parseInt(this.GRANNULARITY);
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        int rowlen = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowlen; ++i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            if (null == rowparams || 0 == rowparams.getParamCount()) continue;
            srcSlotid = Integer.parseInt(rowparams.getParam("srcSlotid").getValue());
            sinkSlotid = Integer.parseInt(rowparams.getParam("sinkSlotid").getValue());
            srcPortid = Integer.parseInt(rowparams.getParam("srcPort").getValue());
            sinkPortid = Integer.parseInt(rowparams.getParam("sinkPort").getValue());
            rowparams.getParam("srcPort").setValue(TEQuerySdhXCInfo.handlePortname(neObj.getNodeID(), srcSlotid, srcPortid));
            rowparams.getParam("sinkPort").setValue(TEQuerySdhXCInfo.handlePortname(neObj.getNodeID(), sinkSlotid, sinkPortid));
            srcAU4 = Integer.parseInt(rowparams.getParam("srcAU4").getValue());
            sinkAU4 = Integer.parseInt(rowparams.getParam("sinkAU4").getValue());
            tmpSrcLowPath = rowparams.getParam("srcLowPath").getValue();
            srcLowPath = "".equals(tmpSrcLowPath) ? Integer.parseInt(rowparams.getParam("srcTimeslot").getValue()) : Integer.parseInt(tmpSrcLowPath);
            tmpSinkLowPath = rowparams.getParam("sinkLowPath").getValue();
            sinkLowPath = "".equals(tmpSinkLowPath) ? Integer.parseInt(rowparams.getParam("sinkTimeslot").getValue()) : Integer.parseInt(tmpSinkLowPath);
            Param srcparam = new Param("srcTimeslot", "");
            Param sinkparam = new Param("sinkTimeslot", "");
            if (srcAU4 == 0) {
                srcparam.setValue("/");
            } else if (cascadeNum > 0) {
                srcparam.setValue(TEQuerySdhXCInfo.getCascadeTimeSlotName(srcAU4, cascadeNum));
            } else {
                srcparam.setValue(TEQuerySdhXCInfo.getTimeSlotName(srcAU4, srcLowPath, granularity));
            }
            rowparams.addParam(srcparam);
            if (sinkAU4 == 0) {
                sinkparam.setValue("/");
            } else if (cascadeNum > 0) {
                sinkparam.setValue(TEQuerySdhXCInfo.getCascadeTimeSlotName(sinkAU4, cascadeNum));
            } else {
                sinkparam.setValue(TEQuerySdhXCInfo.getTimeSlotName(sinkAU4, sinkLowPath, granularity));
            }
            rowparams.addParam(sinkparam);
        }
    }

    public static String getCascadeTimeSlotName(int hlvSlot, int cascadeNum) {
        StringBuffer buf = new StringBuffer();
        if (cascadeNum > 0) {
            buf.append("VC4:");
            buf.append(hlvSlot);
            buf.append('-').append(hlvSlot + cascadeNum - 1);
        } else {
            buf.append("VC4:");
            buf.append(hlvSlot);
        }
        return buf.toString();
    }

    public static String getTimeSlotName(int hlvSlot, int llvSlot, int type) {
        StringBuffer buf = new StringBuffer();
        if (hlvSlot > 0) {
            buf.append("VC4:");
            buf.append(hlvSlot);
        }
        if (llvSlot > 0) {
            switch (type) {
                case 1: {
                    buf.append('-').append("VC12:");
                    break;
                }
                case 2: {
                    buf.append('-').append("VC3:");
                    break;
                }
            }
            buf.append(llvSlot);
        }
        return buf.toString();
    }

    public static String handlePortname(String nodeid, int nmslotid, int portid) {
        String boardName = "";
        String portName = "";
        int boardType = 0;
        TENE neObj = null;
        neObj = TENEListMgr.getInstance().getNE(nodeid);
        if (null == neObj) {
            return "/";
        }
        int slotid = TEBoardUtil.getSlotIDFromSlot((int)neObj.getNEID(), (int)nmslotid);
        if (slotid == 0) {
            return "UNKNOWN";
        }
        String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)neObj.getNEID(), (int)nmslotid);
        if (!"".equals(subrackname)) {
            subrackname = subrackname + "-";
        }
        boardType = TEConfigurationDataMgr.getInstance().getBoardType(neObj.getNEID(), nmslotid);
        boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neObj.getNEID(), boardType);
        portName = "UNKNOWN";
        if (portid != 0) {
            portName = TEConfigurationDataMgr.getInstance().getPortName(neObj.getNEID(), nmslotid, boardType, portid);
        }
        return subrackname + slotid + "-" + boardName + "-" + portName;
    }
}

