/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.ason_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ason.ngwdm.ason_v2r8c01.TEQuerySdhTeLink;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TEQuerySdhOspfTeLink
extends TEQuerySdhTeLink {
    private TENE ne = null;
    private static final int VAR_2M = 2468;
    private static final String DISPLY_MODE_VC4 = "1";
    private static final String DISPLY_MODE_VC3 = "2";
    private static final String DISPLY_MODE_VC12 = "3";
    private static final String DISPLY_MODE_KBPS = "4";
    String[] dataToConvertArray = new String[]{"maxfreenoprotect"};
    private String displaymode = "4";

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        RowParams[] rowParamArray = inputData.getBussinessParams().getRowParams();
        for (int i = 0; i < rowParamArray.length; ++i) {
            String paramValue;
            RowParams params = rowParamArray[i];
            Param param = params.getParam("displaymode");
            this.displaymode = paramValue = param.getValue();
        }
        ArrayList list = super.getOperation(neid, subFunc, inputData, memeryData);
        return list;
    }

    @Override
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        boolean ifSuccess = this.removeUnrelatedTeLinks(operationList, filterErrorCodeList);
        if (!ifSuccess) {
            return;
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        BussinessParams bp = this.outputData.getBussinessParams();
        RowParams[] rpArray = bp.getRowParams();
        this.ne = TENEListMgr.getInstance().getNE(neid);
        for (int i = 0; i < rpArray.length; ++i) {
            RowParams rp = rpArray[i];
            if (rp == null || rp.getRowErrorsCount() > 0) continue;
            this.processNeName(rp);
            this.processSrcslotportAndsinkslotport(rp);
            this.processSrcindexAndsinkindex(rp, "index", "sinkindex");
            this.processDisplayValue(rp);
        }
    }

    private boolean removeUnrelatedTeLinks(ArrayList operationList, ArrayList filterErrorCodeList) {
        Operation queryLinkCMD = (Operation)operationList.get(0);
        Operation queryNodeIDCMD = (Operation)operationList.get(1);
        if (0 != Integer.parseInt(queryNodeIDCMD.getOutput(0).getFault(0).getCode())) {
            operationList.remove(0);
            super.handleMessage(this.neid, operationList, this.subfunc, filterErrorCodeList);
            return false;
        }
        if (0 != Integer.parseInt(queryLinkCMD.getOutput(0).getFault(0).getCode())) {
            operationList.remove(1);
            super.handleMessage(this.neid, operationList, this.subfunc, filterErrorCodeList);
            return false;
        }
        String nodeID = queryNodeIDCMD.getOutput(0).getPartValue("nodeID");
        operationList.remove(1);
        for (int i = queryLinkCMD.getOutputCount() - 1; i >= 0; --i) {
            if (0 != Integer.parseInt(queryLinkCMD.getOutput(i).getFault(0).getCode()) || nodeID.equals(queryLinkCMD.getOutput(i).getPartValue("sourcenode"))) continue;
            queryLinkCMD.removeOutput(i);
        }
        return true;
    }

    private void processNeName(RowParams rp) {
        Param srcNenameParam = rp.getParam("srcNename");
        if (srcNenameParam == null) {
            srcNenameParam = new Param();
            srcNenameParam.setName("srcNename");
        }
        String neName = this.ne.getNEName();
        srcNenameParam.setValue(neName);
    }

    private void processSrcslotportAndsinkslotport(RowParams rp) {
        Param srcslotportParam = rp.getParam("srcslotport");
        if (srcslotportParam == null) {
            srcslotportParam = new Param();
            srcslotportParam.setName("srcslotport");
            srcslotportParam.setValue("-");
        } else {
            String srcNode = rp.getParam("sourcenode").getValue();
            String srcslotportValue = srcslotportParam.getValue();
            String finalValue = this.convertRawSlotportvalueToStrValue(srcNode, srcslotportValue);
            srcslotportParam.setValue(finalValue);
        }
        Param sinkslotportParam = rp.getParam("sinkslotport");
        if (sinkslotportParam == null) {
            sinkslotportParam = new Param();
            sinkslotportParam.setName("sinkslotport");
            sinkslotportParam.setValue("-");
        } else {
            String sinkNode = rp.getParam("sinknode").getValue();
            String sinkslotportValue = sinkslotportParam.getValue();
            String finalValue = this.convertRawSlotportvalueToStrValue(sinkNode, sinkslotportValue);
            sinkslotportParam.setValue(finalValue);
        }
    }

    private void processDisplayValue(RowParams rp) {
        String dsplyModeValue = this.displaymode;
        if (dsplyModeValue == null || "".equals(dsplyModeValue)) {
            dsplyModeValue = DISPLY_MODE_KBPS;
        }
        for (int i = 0; i < this.dataToConvertArray.length; ++i) {
            String tmpStringItem = this.dataToConvertArray[i];
            Param tmpParam = rp.getParam(tmpStringItem);
            String tmpValue = tmpParam.getValue();
            long tmpIntValue = Long.parseLong(tmpValue);
            long finalIntValue = -1L;
            finalIntValue = DISPLY_MODE_VC4.equals(dsplyModeValue) ? tmpIntValue / 2468L / 63L : (DISPLY_MODE_VC3.equals(dsplyModeValue) ? tmpIntValue / 2468L / 21L : (DISPLY_MODE_VC12.equals(dsplyModeValue) ? tmpIntValue / 2468L : tmpIntValue));
            tmpParam.setValue("" + finalIntValue);
        }
    }

    private String convertRawSlotportvalueToStrValue(String nodeid, String hexValue) {
        if (hexValue == null || "".equals(hexValue)) {
            return "Unknown";
        }
        TENE neObj = null;
        try {
            neObj = TENEListMgr.getInstance().getNE(nodeid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("do ne.getNodeID() failed", (Throwable)e);
        }
        if (neObj == null) {
            return "Unknown";
        }
        String slotportStr = this.ascToStr(hexValue);
        String[] strArray = slotportStr.split(",");
        int shelfid = 0;
        int nmslotid = 0;
        int portid = 0;
        if (strArray.length > 2) {
            shelfid = Integer.parseInt(strArray[0].split("=")[1].trim());
            nmslotid = TEBoardUtil.neToSlotIDNM((int)shelfid, (int)Integer.valueOf(strArray[1].split("=")[1].trim()));
            portid = Integer.parseInt(strArray[2].split("=")[1].trim());
        }
        if (nmslotid == 0 || portid == 0) {
            return "/";
        }
        String boardName = "";
        String portName = "";
        int boardType = 0;
        StringBuffer strSlotPort = new StringBuffer();
        String subrackname = "";
        int nodeNEID = neObj.getNEID();
        boardType = TEConfigurationDataMgr.getInstance().getBoardType(nodeNEID, nmslotid);
        boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(nodeNEID, boardType);
        portName = TEConfigurationDataMgr.getInstance().getPortName(nodeNEID, nmslotid, boardType, portid);
        subrackname = TEBoardUtil.getSubrackNameFromSlot((int)nodeNEID, (int)nmslotid);
        if (!"".equals(subrackname)) {
            strSlotPort.append(subrackname);
            strSlotPort.append("-");
        }
        strSlotPort.append(strArray[1].split("=")[1].trim());
        strSlotPort.append("-");
        strSlotPort.append(boardName);
        strSlotPort.append("-");
        strSlotPort.append(portName);
        return strSlotPort.toString();
    }

    private String ascToStr(String ascStr) {
        int ascStrLen = ascStr.length() / 2;
        byte[] slotportArray = new byte[ascStrLen];
        int i = 0;
        int j = 0;
        while (i < ascStrLen - 1) {
            slotportArray[i] = (byte)Integer.parseInt(ascStr.substring(j, j + 2), 16);
            ++i;
            j += 2;
        }
        String slotportStr = new String(slotportArray);
        return slotportStr;
    }

    @Override
    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(40544);
        return errorCodeList;
    }
}

