/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.ason_v2r7c01;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ason.ngwdm.ason.TEASONWriteLog;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TEOSPFCtrlLink
extends TEASONWriteLog {
    private static final String ETH_TYPE = "8";
    private static final String P2MP_TYPE = "65536";
    private static final String DISABLED_FLAG = "0";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        RowParams[] rows;
        ArrayList<Output> ctrlIfOutputs = new ArrayList<Output>();
        this.queryLocalControlInterface(neid, ctrlIfOutputs);
        if (!ctrlIfOutputs.isEmpty()) {
            Output[] outputArr = ((Operation)operationList.get(0)).getOutput();
            int i = outputArr.length;
            outputArr = Arrays.copyOf(outputArr, i + ctrlIfOutputs.size());
            for (Output cop : ctrlIfOutputs) {
                Output op = (Output)outputArr[0].clone();
                op.setPartValue("index", cop.getPartValue("index"));
                op.setPartValue("ospfname", cop.getPartValue("ospfname"));
                op.setPartValue("slotid", cop.getPartValue("slotid"));
                op.setPartValue("port", cop.getPartValue("port"));
                op.setPartValue("iftype", cop.getPartValue("iftype"));
                op.setPartValue("pathnum", cop.getPartValue("pathnum"));
                op.setPartValue("address", cop.getPartValue("address"));
                op.setPartValue("subnetmask", cop.getPartValue("subnetmask"));
                op.setPartValue("ospftype", cop.getPartValue("ospftype"));
                op.setPartValue("ospfstatus", cop.getPartValue("ospfstatus"));
                op.setPartValue("ospfFlag", cop.getPartValue("ospfFlag"));
                op.setPartValue("sinknode", "00000000");
                op.setPartValue("sinksubCardId", "255");
                op.setPartValue("sinkslotid", DISABLED_FLAG);
                op.setPartValue("sinkport", DISABLED_FLAG);
                outputArr[i++] = op;
            }
            ((Operation)operationList.get(0)).setOutput(outputArr);
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        block1: for (RowParams row : rows = this.outputData.getBussinessParams().getRowParams()) {
            if (null == row || null == row.getParam("ospfFlag")) continue;
            row.getParam("ospfFlag").setValue("1");
            for (Output cop : ctrlIfOutputs) {
                if (!cop.getPartValue("index").equals(row.getParam("index").getValue())) continue;
                row.getParam("ospfFlag").setValue(cop.getPartValue("ospfFlag"));
                continue block1;
            }
        }
    }

    private void queryLocalControlInterface(int neid, List<Output> ctrlIfOutputs) {
        Operation tempOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ION_LIM_GET_CTRL_IF");
        ArrayList<Operation> tempOperations = new ArrayList<Operation>();
        tempOperations.add(tempOperation);
        tempOperation.getInput().setPartValue("slotid", DISABLED_FLAG);
        tempOperation.getInput().setPartValue("subCardId", "255");
        tempOperation.getInput().setPartValue("port", DISABLED_FLAG);
        tempOperation.getInput().setPartValue("iftype", DISABLED_FLAG);
        tempOperation.getInput().setPartValue("pathnum", DISABLED_FLAG);
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, tempOperations, this.getTimeOut());
        if (result.retCode == 0) {
            Output[] outputArr;
            for (Output output : outputArr = ((Operation)tempOperations.get(0)).getOutput()) {
                if (!this.isEthernetType(output) || !DISABLED_FLAG.equals(output.getPartValue("ospfFlag"))) continue;
                if (P2MP_TYPE.equals(output.getPartValue("ospftype"))) {
                    output.setPartValue("ospftype", "5");
                }
                ctrlIfOutputs.add(output);
            }
        }
    }

    private boolean isEthernetType(Output output) {
        return ETH_TYPE.equals(output.getPartValue("ospftype")) || P2MP_TYPE.equals(output.getPartValue("ospftype"));
    }
}

