/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.ngwdm.ason;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ason.ngwdm.ason.TEASONCommon;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TECreateControlChannel
extends TENEExplorerBean {
    private TEResourceUtil res = null;

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                loginfo.setUserID(userID);
            }
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateName(subfunc.getSubFuncDes(neid));
            loginfo.setOperateObject("");
            loginfo.setOperateDesc(this.applyControlPanelDetail(inputData));
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                loginfo.setOperateObject(String.valueOf(neid));
            } else {
                loginfo.setOperateObject(neObj.getNEName());
            }
            if (errorCode == 0) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            } else if (errorCode == 2 || errorCode == 1) {
                loginfo.setResult(errorCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    loginfo.setErrCode(errorCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    loginfo.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    loginfo.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(loginfo);
                    break;
                }
            } else {
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String applyControlPanelDetail(Datainterface inputData) {
        StringBuffer strBuf = new StringBuffer();
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"neId").getValue());
        StringBuffer filePath = new StringBuffer();
        filePath.append("ason").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ason").append(File.separator).append("createcontrolchannel_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neId, (StringBuffer)filePath);
        strBuf.append(this.res.getString("slotid")).append(Datainterface.getParam((Param[])params, (String)"slotid").getValue()).append("\u00a3\u00ac");
        strBuf.append(this.res.getString("port")).append(Datainterface.getParam((Param[])params, (String)"port").getValue()).append("\u00a3\u00ac");
        strBuf.append(this.res.getString("destaddr")).append(TEASONCommon.hexConvertIPStr(Datainterface.getParam((Param[])params, (String)"destaddr").getValue())).append("\u00a3\u00ac");
        strBuf.append(this.res.getString("nexthop")).append(TEASONCommon.hexConvertIPStr(Datainterface.getParam((Param[])params, (String)"nexthop").getValue()));
        return strBuf.toString();
    }
}

