loadXMLdoc("../../../../../conf/system.xml","GET",false,EncapsulateSConf);
language = SYSTEMCONF.getLanguage();
getResourse("../../../../../res/commonres_" + language +".xml");
getResourse("../../../res/boardreport_" + language +".xml");

var nebdAttr = new Array();
nebdAttr[0] = "boardoutposition";
nebdAttr[1] = "boardinposition";
nebdAttr[-1] = "unknown";

var st = new SortTable();


function initInfoPage(isBoardInfopage)
{
	setBtnValue();
	initTableHead(isBoardInfopage);
	
	if(isBoardInfopage)
	{
        refreshBdInfoTbl();	
	}
	else
	{
        refreshSlotIfoTbl(true);
	} 
}

function initTableHead(isBoardInfopage)
{
    if(isBoardInfopage)
	{
        loadXMLdoc("../../../conf/ne_attribute/report/boardinfotable_" + language + ".xml", "GET", false, EncapsulateTable, null);
    }
    else
    {
        loadXMLdoc("../../../conf/ne_attribute/report/slotinfotable_" + language + ".xml", "GET", false, EncapsulateTable, null);
    }
    st.setImage("../../../../../images/");
    st.setBodyHeight(410);
    createTableHead(st, window.tableconf[0]);
    if(isBoardInfopage)
    {
        document.body.insertBefore(st.getTable(), document.getElementById("boardBtnDiv"));
    }
    else
    {
        document.body.insertBefore(st.getTable(), document.getElementById("slotBtnDiv"));
    }   
}

function setBtnValue()
{
    document.getElementById("queryBtn").value = RESOURCE["querybutton"];
    document.getElementById("printBtn").value = RESOURCE["printbutton"];
    document.getElementById("saveAsFileBtn").value = RESOURCE["savefile"];
    if(document.getElementById("statisticBtn"))
    {
        document.getElementById("statisticBtn").value = RESOURCE["statistic"];
    }
    
}

function createQueryXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neID");
    thirdlevel.setAttribute("value",getNeProperty(top)["neid"]);
    secondlevel.appendChild(thirdlevel);
    firstlevel.appendChild(secondlevel);
    
    root.getRoot().appendChild(firstlevel);
    
    var xml = root.toString();
    return xml;
}

function refreshTblData(doc,firstFlag)
{
    var diObj = EncapsulateData(doc);
    
    st.clearTableData();
    if(!firstFlag)
    {
        handleErrCode(diObj);
    }
    if(0 == diObj.getSErrorCode() || 1 == diObj.getSErrorCode())
    {
        createTableBody(st, window.tableconf[0], diObj, RESOURCE);
        var tempHC;
        for(var collength = 0; collength < st.getTable().colsArray.length; collength++)
        {
            tempHC = st.getHeadCell(st.getTable().colsArray[collength]);
            if(1 == tempHC.element.isSort)
            {
                tempHC.element["onclick"] = function()
                {
                    st.sortRows(this);
                    adjustOrder();
                }
            }
        }
        adjustOrder();//                    
    }
    setButtonStatus(false);    
}

function setButtonStatus(disableFlg)
{
    document.getElementById("queryBtn").disabled = disableFlg;
    document.getElementById("printBtn").disabled = disableFlg;
    document.getElementById("saveAsFileBtn").disabled = disableFlg;;
    if(document.getElementById("statisticBtn"))
    {
        document.getElementById("statisticBtn").disabled = disableFlg;;
    }
}

function adjustOrder(objIndex)
{
    for(var i = 0, stlen = st.getDataRowLength(); i < stlen; i++)
    {
        st.setAtomValue(st.getCellShow(i,"serialNum"), i+1);
        st.setCellValue(st.getCell(i, "serialNum"), "serialNum", i+1);
    }

}

function handleErrCode(diObj)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotId";
    errArr[2] = "boardname";
    openErrPage("../../../../../page/", diObj.getError(), errArr);
    errArr = null;
}


function refreshBdInfoTbl()
{
    var sendurl = "../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_BD_VER+"&flag=1";
    var xml = createQueryXML();
    setButtonStatus(true);
    loadXMLdoc(sendurl, "POST", true, refreshTblData, false, "inputdata="+xml);
}


function refreshSlotIfoTbl(firstFlag)
{
    var sendurl = "../../../../../neExlorerServlet?sfid="+TECMDCODE_GETNESLOTINFO+"&flag=1";
    var xml = createQueryXML();
    setButtonStatus(true);
    loadXMLdoc(sendurl, "POST", true, refreshTblData, firstFlag, "inputdata="+xml);
}

function countBoardNum()
{
    var boardNum = st.getDataRowLength();//                     
    var logicBdNum = 0;//              
    var physicBdNum = 0;//              
    var boardNotFixedNum = 0;//                
    var BOARD_OUT_OPSITION = 0;
    
    if(boardNum > 0)
    {
        for(var i = 0; i < boardNum; i++)
        {
            if(null != st.getCellCurrentValue(i, "neLogicBd", "neLogicBd"))
            {
                logicBdNum++;
            }
            if(null != st.getCellCurrentValue(i, "nePhysicsBd", "nePhysicsBd"))
            {
                physicBdNum++;
            }
            if(BOARD_OUT_OPSITION == st.getCellStoreValue(i, "nebdAttr", "nebdAttr"))
            {
                boardNotFixedNum++;
            }
        }
    }
    sendurl = "bdCountPage.html?logicBdNum=" + logicBdNum + "&physicBdNum=" + physicBdNum + "&boardNotFixedNum=" + boardNotFixedNum;
    window.open(sendurl,"bdCountPage");
}

function initPage()
{
    document.getElementById("tableTitleDiv").innerHTML = RESOURCE["countBdResource"];
    var countTbl = document.getElementById("countTbl");
    var newrow = countTbl.insertRow(-1);
    var newcell;
    var winObj = getNeProperty(self);
    
    newcell = newrow.insertCell(-1);
	newcell.innerHTML = RESOURCE["bdType"];		
	
	newcell = newrow.insertCell(-1);
	newcell.innerHTML = RESOURCE["phyBdNum"];
	
	newcell = newrow.insertCell(-1);
	newcell.innerHTML = RESOURCE["logicBdNum"];
	
	newcell = newrow.insertCell(-1);
	newcell.innerHTML = RESOURCE["notFixedNum"];
	
	newrow = countTbl.insertRow(-1);
	
	newcell = newrow.insertCell(-1);
	newcell.innerHTML = RESOURCE["inall"];
	
	newcell = newrow.insertCell(-1);
	newcell.innerHTML = winObj["physicBdNum"];
	
	newcell = newrow.insertCell(-1);
	newcell.innerHTML = winObj["logicBdNum"];
	
	newcell = newrow.insertCell(-1);
	newcell.innerHTML = winObj["boardNotFixedNum"];
}
