var winurlobj = getNeProperty(self);
var st;
var neid = winurlobj["neid"];
var bdType = winurlobj["boardType"];

var BOARD_ELOM = 1620;
var BDTYPE_TN96TQX = "2350";
var BDTYPE_TN96TOA = "2348";
var ODUFlex = "2560";

var boardworlmodel = [];
boardworlmodel["162"] = RESOURCE["connectmode"];//  
boardworlmodel["163"] = RESOURCE["alonemode"];//   
var isBoardModelChanged = false;

var neMode;
var CONNECT_MODE = "162";
var ALONE_MODE = "163";
var OPRSUCC = 0;
var PARTSUCC = 1;
var isSupportBoardMode = true;
var portOptions = [];

window.onresize=function()
{
    st.setBodyHeight(getComponetHeight($("tabletemp"),100)+"px");
}	    

function init()
{
	getBoardModeResource();
	
	$("boardModelField").appendChild(document.createTextNode(RESOURCE["boardworkmodel"]));
	$("boardModelLable").appendChild(document.createTextNode(RESOURCE["boardworkmodel"]));
	$("portworkmodelField").appendChild(document.createTextNode(RESOURCE["portworkmodel"]));
	
	st = new SortTable();
	st.setImage("../../../../images/");
	tc = window.tableconf[0];
	createTableHead(st, tc);
	st.setOnCellEditHandler(cellEditHandler);
	st.setBodyHeight(getComponetHeight($("tabletemp"),100)+"px");
	$("tablecomponent").appendChild(st.getTable());
	$("tablecomponent").oncontextmenu = popupMenuHandler;

	$("querybtn").value=RESOURCE["querybutton"];
	$("applybtn").value=RESOURCE["applybutton"];
       
	query();
}

function getBoardModeResource()
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;  
	
	var xmlstr = createResourceQueryXML();  
	var urlreq ="../../../../neExlorerServlet?sfid="+ TECMDCODE_QUERY_PORTMODE_RESOURCE +"&nmUser="+winurlobj["nmUser"];        
	loadXMLdoc(urlreq, "POST",false,handleBoardModeBackQuery,null,"inputdata="+xmlstr);
}

function createResourceQueryXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name","neid");
	param.setAttribute("value",winurlobj["neid"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name","slotid");
	param.setAttribute("value",winurlobj["slotid"]);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBoardModeBackQuery(doc)
{
	
	var data = EncapsulateData(doc);
	var options = data.getDataRowOptions(0,"BoardMode");
	if (options == null || options.length == 0)
	{
		isSupportBoardMode = false;
		return;
	}
	for (var i=0,len= options.length;i<len;i++)
	{
		var value = options[i];
		var resouse = "boardmode_"+value;
		$("boardModelSel").options[i] = new Option(RESOURCE[resouse], value);
	}
}

function boardModelSelFun()
{
    if(neMode != "" + $("boardModelSel").value)
    {
	    isBoardModelChanged = true;
	    $("applybtn").disabled = false; 
    }
    else
    {
        $("applybtn").disabled = true; 
    }
}

function query()
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;  
	
	var xmlstr = createQueryXML();  
	var urlreq ="../../../../neExlorerServlet?sfid="+ TECMDCODE_OTN_QUERY_PORTMODE +"&nmUser="+winurlobj["nmUser"];        
	loadXMLdoc(urlreq, "POST",false,handleBackQuery,null,"inputdata="+xmlstr);
}

function createQueryXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name","neid");
	param.setAttribute("value",winurlobj["neid"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name","slotid");
	param.setAttribute("value",winurlobj["slotid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name","port");
	param.setAttribute("value","0");
	row.appendChild(param);	
	
	param = new tagElement("param");
	param.setAttribute("name","supportBoardMode");
	param.setAttribute("value",isSupportBoardMode);
	row.appendChild(param);	
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackQuery(doc)
{	
	var data = EncapsulateData(doc);
	
	/*
	 *             V1R3C00   4       
	 * 1:52TOM            
	 * 2:54TOA,54THA              
	 * 3:ELOM               
	 *                    
	 */
	if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode())
	{
		var boardMode = data.getDataRowParam(0, "W32BD_ATTR_SUBBDTYPE");
		if(boardMode == "")
		{
			$("boardmodeldiv").style.display = "none";
		}
		else
		{
			neMode = boardMode;
			$("boardModelSel").value = boardMode;			
		}
		
	}
	var portTableFlag = false;
	for (var i=0,len = data.getDataRowLength();i<len;i++)
	{
		var options = data.getDataRowOptions(i,"portworkmodel");
		var portid = data.getDataRowParam(i, "port");
		
		/*
		 * DTS2012021601233    96TQX    ODUflex      
		 *                     
		 */
		var boardType = data.getDataRowParam(i, "boardtype");
		if (BDTYPE_TN96TQX == boardType || BDTYPE_TN96TOA == boardType)
		{
			for (var index = 0; index < options.length; index++)
			{
				if (ODUFlex == options[index])
				{
					options.splice(index, 1);
					break;
				}
			}
		}
		
		portOptions[portid] = options;
		if (options != null && options.length != 0)
		{
			portTableFlag = true;
			
		}
	
	}
	if (portTableFlag == false)
	{
        $("tabletemp").style.display = "none";
	}
	else
	{
		$("tabletemp").style.display = "";
	}
	st.clearTableData();
	createTableBody(st, window.tableconf[0], data, RESOURCE);


	for(var i = 0, len = data.getBErrLength();i < len;i++)
	{
		var tempObj = data.getError().rowErrors[i].errorObj;
		if(tempObj["attrId"] == "W32BD_ATTR_SUBBDTYPE")
		{
			tempObj["operateObj"] = RESOURCE["queryboard"];
		}
		else
		{
			tempObj["operateObj"] = RESOURCE["queryport"];
		}
	}
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	errArr[3] = "operateObj";
	openErrPage("../../../../page/", data.getError(), errArr);
	
	$("querybtn").disabled = false;
}


function addListener()
{
	var boardModel = $("boardModelSel").value;
	for(var i = 0,len = st.getDataRowLength(); i < len; i++)
	{
			var portid = st.getCellStoreValue(i, "portid", "port");
			var portModeCell = st.getCellEdit(i,"portworkmodel");
			
			portModeCellAddOption(boardModel,portid,portModeCell);
	}
}
	
function cellEditHandler(param)
{
	var colid = param.colid;
	var st = param.st;
	var rowindex = param.rowindex;
	if((param.stage == TABLE_CONSTANT.BEFOREEDIT) && (colid == "portworkmodel"))
	{
		var boardModel = $("boardModelSel").value;
		var portid = st.getCellStoreValue(param.rowindex, "portid", "port");
		var portModeCell = st.getCellEdit(param.rowindex,"portworkmodel");

		portModeCellAddOption(boardModel,portid,portModeCell);
	}

	$("applybtn").disabled = false;
}

function modify()
{	
	var xmlstr = createModifyXML();
	if (null == xmlstr)
	{
    	  return;
	}
    
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	  
	var urlreq ="../../../../neExlorerServlet?sfid=" + TECMDCODE_OTN_SET_PORTMODE +"&nmUser="+winurlobj["nmUser"];        
	loadXMLdoc(urlreq, "POST",false,handleBackModify, null,"inputdata="+xmlstr);
}

function createModifyXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	if(isBoardModelChanged)
	{
		var row = new tagElement("row-params");
		
		var param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name","slotid");
		param.setAttribute("value",winurlobj["slotid"]);
		row.appendChild(param);
				
		param = new tagElement("param");
		param.setAttribute("name","W32BD_ATTR_SUBBDTYPE");
		param.setAttribute("value",boardModelSel.value);
		row.appendChild(param);		
		
		bussiness.appendChild(row);
	}
    else
    {
    	for(var rowindex = 0, length = st.getDataRowLength(); rowindex < length; rowindex++)
    	{
    		if(!st.getModify(rowindex))
    		{
    		    continue;
    		}
    
    		var row = new tagElement("row-params");
    
    		var param = new tagElement("param");
    		param.setAttribute("name","neid");
    		param.setAttribute("value",neid);
    		row.appendChild(param);
    
    		param = new tagElement("param");
    		param.setAttribute("name","slotid");
    		param.setAttribute("value",st.getCellStoreValue(rowindex,"portid","slotid"));
    		row.appendChild(param);
    		
    		param = new tagElement("param");
    		param.setAttribute("name","port");
    		param.setAttribute("value",st.getCellStoreValue(rowindex,"portid","port"));
    		row.appendChild(param);
    
    		param = new tagElement("param");
    		param.setAttribute("name","portworkmodel");
    		param.setAttribute("value",st.getCellStoreValue(rowindex,"portworkmodel","portworkmodel"));
    		row.appendChild(param);
    
    		bussiness.appendChild(row);
    	}
    }
    
	if(bussiness.childNodes.length == 0)
	{
		return null;
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackModify(doc)
{
	$("querybtn").disabled = false;
	isBoardModelChanged = false;
    
	var data = EncapsulateData(doc); 
    
	if (OPRSUCC != data.getError().getGlobleECode())
	{
		for(var i = 0, size = data.getBErrLength();i < size;i++)
		{
			var tempObj = data.getError().rowErrors[i].errorObj;
			if(tempObj["attrId"] == "W32BD_ATTR_SUBBDTYPE")
			{
				tempObj["operateObj"] = RESOURCE["setboard"];
				isBoardModelChanged = true;
			}
			else
			{
				tempObj["operateObj"] = RESOURCE["setport"];
			}
		}
		var errArr = [];
		errArr[0] = "nename";
		errArr[1] = "slotid";
		errArr[2] = "boardname";
		errArr[3] = "portname";
		errArr[4] = "operateObj";
		openErrPage("../../../../page/", data.getError(), errArr);
        
		$("applybtn").disabled = false;
	}

		query();
}

function portworkmodel(paramData)
{
	
	if(paramData == 65535)
	{
		return RESOURCE["WOKRMODE_65535"];
	}
	var boardModel = "";
	if($("boardmodeldiv").style.display != "none")
	{
		boardModel = $("boardModelSel").value;
	}	
	return RESOURCE["WOKRMODE" + boardModel + "_" + paramData];
}

function portModeCellAddOption(boardModel,portid,portModeCell)
{
	var options = portOptions[portid];
	if (options == null)
	{
		return;
	}
	portModeCell.clearOptions();
	for (var i=0,len=options.length;i<len;i++)
	{		
		var portValue = options[i];
		var resource = "WOKRMODE" + boardModel + "_" + portValue;
		portModeCell.addOptionObj(new Option(RESOURCE[resource], portValue));
	}
}

function popupMenuHandler(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    var elem = (evt.target) ? evt.target : evt.srcElement;
    
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }   
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent || elem.editElement == null) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (rows.contains(rowid)) 
    {
    	
	     if(rows.length > 1)
	     {
	  	    return;
	     }
	    var boardModel = $("boardModelSel").value;
		var portid = st.getCellStoreValue(rowid, "portid", "port");
		var portModeCell = st.getCellEdit(rowid,"portworkmodel");
		portModeCellAddOption(boardModel,portid,portModeCell);    	
    }
}
