var st = null;

var urlObject = getNeProperty(self);//the URL object of this page 
var neID = urlObject.neid; //network element id
var nmUsrID = urlObject.nmUser ;//network manager userID, write operation log and check right
var nmUserName = urlObject.nmUserName ;//network manager userName
var btnRightArr = new Object();//save to button right


var CODE_FAULT = 2; //operation fault erroeCode 
var CODE_PARTSUCC = 1;//part success errorCode
var CODE_SUCC = 0;//operation success errorCode
var querySFID = TECMDCODE_GET_RACK_UNITE_MODE;//
var applySFID = TECMDCODE_SET_RACK_UNITE_MODE;//

var subrackUnite = [];
subrackUnite[0] = "tree";
subrackUnite[1] = "ring";

/**
 * initialize this page
 * @param data: NO
 * @return NO
 */
function initPage()
{
	initTable();   //initialize the rsvpTable
	initButton();   //initialize buttons
	
	var rightURL = "../../../../securityServlet?neID=" + neID + "&nmUser=" + nmUsrID;
	getRightInfo(urlObject, btnRightArr);//call the function which come from the right.js file, get function right;
	
	doQuery();    //run query
}

/**
 * initialize rsvpTable
 * @param data:NO
 * @return NO
 */
function initTable()
{	
	st = new SortTable();        
  st.setImage("../../../../images/");
  createTableHead(st, window.tableconf[0]);
  
  st.setOnCellEditHandler(handleCellDbClickEvent);//cells of the rsvpTable edited event
  $("tablediv").appendChild(st.getTable());
  $("tablediv").oncontextmenu = popupMenuHandler;
  st.setBodyHeight(getComponetHeight($("tablediv"),75)+"px");
}

function handleCellDbClickEvent()
{
	$("applybtn").disabled = !btnRightArr.applybtn.right;
}


/**
 * initialize button enable status
 * @param data:NO
 * @return NO
 */
 function initButton()
 {
    $("querybtn").value = RESOURCE["querybutton"];
    
    $("applybtn").value = RESOURCE["applybutton"];
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", querySFID);
    
    btnRightArr.applybtn = new BtnRightObj("applybtn", applySFID);
    
    
 }  

 /**
  * operate query 
  * @param data:no
  * @return no
  */
function doQuery()
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;    
    $("applybtn").disabled = true;        
    
    if(!btnRightArr.querybtn.right)
    {
    	return;
    }
    
    setBtnStatus(false);//set disabled buttons status   
    
    var queryURL = "../../../../neExlorerServlet?sfid=" + querySFID +"&nmUser="+nmUsrID;
    var xmlData = constructQueryXML();//construct query XML
    loadXMLdoc(queryURL, "POST", true, handleQueryBack, null, "inputdata="+xmlData);//send query request      
}

/**
 * construct query XML
 * @param data: no
 * @return xml
 */
function constructQueryXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");  
    
    var thirdlevel = new tagElement("param");              
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",neID);
    secondlevel.appendChild(thirdlevel);       
    
    firstlevel.appendChild(secondlevel);
    
    root.getRoot().appendChild(firstlevel);
    
    return root.toString();
} 
 
/**
 * handle callback function of query
 * @param doc 
 * @return no
 */
function handleQueryBack(doc)
{
	var data = EncapsulateData(doc);
	
	if( CODE_FAULT != data.getSErrorCode() )
	{
		st.clearTableData();//clear rsvpTable data
		createTableBody(st, window.tableconf[0], data, RESOURCE);//Display The Page Data		
	}
	
	handleErrInfo(data);//hanlde query error
	
	$("querybtn").disabled = !btnRightArr.querybtn.right;
	$("applybtn").disabled = true;	
}

/**
 * operate modify
 * @param no
 * @return no
 */
function doApply()
{		
	setBtnStatus(false);
	
	var xmlData = constructApplyXML();
	var applyURL = "../../../../neExlorerServlet?sfid=" + applySFID +"&nmUser="+nmUsrID;//? come form macrores.js
	loadXMLdoc(applyURL, "POST", true, handleApplyBack, null, "inputdata="+xmlData);//send modify request
}

/**
 * construct modify XML
 * @param data: no
 * @return xml
 */
function constructApplyXML()
{
  var root = new inputxml("datainterface");
  var firstLevel = new tagElement("bussiness-params");
    
  var secondLevel, thirdLevel;  
    
	secondLevel = new tagElement("row-params");
    		
	thirdLevel = new tagElement("param");
	thirdLevel.setAttribute("name", "neid");
	thirdLevel.setAttribute("value", neID);
	secondLevel.appendChild(thirdLevel);
    		
	thirdLevel = new tagElement("param");
	thirdLevel.setAttribute("name", "subrackunite");
	var subrackunite = st.getCellStoreValue(0, "subrackunite", "subrackunite");
	if("undefined" == typeof(subrackunite))
	{
		subrackunite = "0";
	}
	thirdLevel.setAttribute("value", subrackunite);
	secondLevel.appendChild(thirdLevel);
	
	thirdLevel = new tagElement("param");
	thirdLevel.setAttribute("name", "subrackuniteres");
	thirdLevel.setAttribute("value", subrackUnite[subrackunite]);
	secondLevel.appendChild(thirdLevel);
    		
	firstLevel.appendChild(secondLevel);

    
  root.getRoot().appendChild(firstLevel);
    
  return root.toString();
}

/**
 * handle callback function of modify
 * @param doc 
 * @return no
 */
function handleApplyBack(doc)
{	
	var data = EncapsulateData(doc);
	var applybtnStatus = !( CODE_SUCC != data.getSErrorCode());
	$("applybtn").disabled = applybtnStatus;
	$("querybtn").disabled = false;
	
	handleErrInfo(data);
	
	refreshTableState(st, window.tableconf[0], data);//Call the function of the common.js file
}


/**
 * set buttons status
 * @param enableStatus boolean
 * @return
 */
function setBtnStatus(enableStatus)
{
	$("querybtn").disabled = !enableStatus;
	$("applybtn").disabled = !enableStatus;
}

/**
 * handle operate error
 */
function handleErrInfo(data)
{
	var errArr = [];//define errors object
	errArr.push("nename");	
	
	openErrPage("../../../../page/", data.getError(), errArr);//open the error page
}
