 var SLM_LMU_BOARDTYPE = 1229; //LMU    
var SLM_LOA_BOARDTYPE = 1228; //LOA    
var SLM_LSU_BOARDTYPE = 1227; //LSU    
var SLM_LMI_BOARDTYPE = 1226; //LMI    

var SLM_TNB2LMU_BOARDTYPE = 1628; //LMU2    
var SLM_TNB2LAS_BOARDTYPE = 1629; //LAS2    
var SLM_TNB2LMI_BOARDTYPE = 1630; //LMI2    

/**
 * TESLMNE        
 * @param neid
 * @return  
 */
function TESLMNE(neid)
{
	this.neid = neid;
	this.neName = "";
	this.lmuPortList = [];
	this.lasPortList = [];
	this.lmiPortList = [];
}

/**
 *       
 * @param  
 * @return  
 */
TESLMNE.prototype.toString = function()
{	
	return this.neName;
}

/**
 * TESLMNE     
 * @param otherNE
 * @return boolean
 */
TESLMNE.prototype.setNEName = function(neName)
{	
	this.neName = neName;	
}

/**
 * TESLMNE equals   
 * @param otherNE
 * @return boolean
 */
TESLMNE.prototype.equals = function(otherNE)
{	
	if (this.neid == otherNE.neid)
	{
		return true;
	}
	return false;
}

TESLMNE.prototype.setLMUPortList = function(lmuPortList)
{
	this.lmuPortList = lmuPortList;
}

TESLMNE.prototype.setLASPortList = function(lasPortList)
{
	this.lasPortList = lasPortList;
}

TESLMNE.prototype.setLMIPortList = function(lmiPortList)
{
	this.lmiPortList = lmiPortList;
}

/**
 * TEPort        
 * @param neid, neName, slotId, boardName, boardType, portId, portName
 * @return  
 */
function TEPort(neid, neName, slotId, boardName, boardType, portId, portName)
{
	this.neid = neid;
	this.neName = neName;
	this.slotId = slotId;
	this.boardName = boardName;
	this.boardType = boardType;
	this.portId = portId;
	this.portName = portName;
	this.probeWaveArrays = [];
	this.loadingWaveArrays = [];
}

function TEWaveInfo(waveType, waveNo)
{
	this.waveType = waveType;
	this.waveNo = waveNo;
}

TEPort.prototype.addProbeWave = function(waveType, waveNo)
{
	var waveInfo = new TEWaveInfo(waveType, waveNo);
	this.probeWaveArrays.push(waveInfo);
}

TEPort.prototype.addLoadingWave = function(waveType, waveNo)
{
	var waveInfo = new TEWaveInfo(waveType, waveNo);
	this.loadingWaveArrays.push(waveInfo);
}

/**
 * TEPort equals   
 * @param otherPort
 * @return boolean
 */
TEPort.prototype.equals = function(otherPort)
{	
	if (this.neid == otherPort.neid && this.slotId == otherPort.slotId && this.portId == otherPort.portId)
	{
		return true;
	}
	return false;
}
/**
 *    LMU  
 * @param  
 * @return  
 */
TEPort.prototype.isLMUBoard = function()
{
	if (this.boardType == SLM_LMU_BOARDTYPE)
	{
		return true;
	}
	
	return false;
}
/**
 *    LOA  
 * @param  
 * @return  
 */
TEPort.prototype.isLOABoard = function()
{
	if (this.boardType == SLM_LOA_BOARDTYPE)
	{
		return true;
	}
	return false;
}
/**
 *    LSU  
 * @param  
 * @return  
 */
TEPort.prototype.isLSUBoard = function()
{
	if (this.boardType == SLM_LSU_BOARDTYPE)
	{
		return true;
	}
	return false;
}
/**
 *    LMI  
 * @param  
 * @return  
 */
TEPort.prototype.isLMIBoard = function()
{
	if (this.boardType == SLM_LMI_BOARDTYPE)
	{
		return true;
	}
	return false;
}

/**
 *    LMU  
 * @param  
 * @return  
 */
TEPort.prototype.isTNB2LMUBoard = function()
{
	if (this.boardType == SLM_TNB2LMU_BOARDTYPE)
	{
		return true;
	}
	
	return false;
}
/**
 *    LOA  
 * @param  
 * @return  
 */
TEPort.prototype.isTNB2LASBoard = function()
{
	if (this.boardType == SLM_TNB2LAS_BOARDTYPE)
	{
		return true;
	}
	return false;
}
/**
 *    LMI  
 * @param  
 * @return  
 */
TEPort.prototype.isTNB2LMIBoard = function()
{
	if (this.boardType == SLM_TNB2LMI_BOARDTYPE)
	{
		return true;
	}
	return false;
}

/**
 *        
 * @param  
 * @return  
 */
TEPort.prototype.toString = function()
{	
	var portMapping = this.slotId + "-" + this.boardName + "-" + this.portName;
	return portMapping;
}
