
var buType = new Object();
buType["1"] = "OADM_BU";
buType["2"] = "Fiber_pair_BU";
buType["3"] = "OEQ";
var DIRECTION_EAST = 1;
var DIRECTION_WEST = 0;
var newLineSrcTable; //            
var newLineSinkTable;
var rptTable;
var buTable;
var parentWin = getParentWindow(); //         
var winurlobj = parentWin.winurlobj;

var SLM_DEFAULT_SEGMENT_NUM = 0;
var SLM_MIN_REPEATER_NUM = "0";
var SLM_MAX_REPEATER_NUM = "299";
var SLM_DEFAULT_REPEATER_NUM = 4;
var SLM_LENGTH_REPEATER_NUM = 3;

var SLM_DEFAULT_BUNUM = 0;
var SLM_MIN_BUNUM = "0";
var SLM_MAX_BUNUM = "50";

var availableLineData = parentWin.availableLine;//       
var availablePortData = parentWin.availablePort;//      (     )
var availablePortOtherNE = parentWin.availablePortOtherNE;// (       )
var buNameAndTypeMap = parentWin.availBuNameTypeMap;
var lmuPortWaveLen = parentWin.lmuPortWaveLen;// LMU          
var neid = parentWin.neid;
var lmuPortData; //    LMU   
var loaPortData; //    LOA    
var lmiPortData; //    LMU   
var curNEInfo;

var sinkNEList;
var SLM_LINEMGR_MAX_REMARK_LENGTH = 63;
var lineID;
var BAND_TYPE_DEFAULT = "1";

var DEFAULT_SEGMENT_NUM = "--";
var INVALID_VALUE = "/";

var sinkLineInfo = null;
var sinkAvailableLineData = null;

var initDataList = [];
var curDataList = [];
var isModifyBUTable = false;
var isModifyRptTable = false;
var isModifyPortTable = false;

var UNKNOWN = "UNKNOWN";

var sync = true;

var fiberLengthList = [];

/**var SLM_DEFAULT_PROBO_WAVE_BAND = ;
 var SLM_MIN_PROBO_WAVE_BAND = ;
 var SLM_MAX_PROBO_WAVE_BAND = ;
 var SLM_DEFAULT_LOADING_WAVE_BAND = ;
 var SLM_MIN_PROBO_LOADING_BAND = ;
 var SLM_MAX_PROBO_LOADING_BAND = ;
 */
loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
loadXMLdoc("../../../../help/" + SYSTEMCONF.getLanguage() + "/helpidresource.xml", "GET", false, EncapsulateHelpConfig);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/slmlinemgr_u2kv1r3c00/slmlinemgr_" + SYSTEMCONF.getLanguage() + ".xml");
loadXMLdoc("../../conf/slmlinemgr_u2kv1r3c00/slmcreatebutable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);
document.title = RESOURCE["modifyLineTitle"];
/**
 *            
 * @param   
 * @return   
 */
function init()
{


		if (!isIE)
		{
			sync = false;
		}
		
	  var selectedRow = parentWin.slmLineTable.getSelectedRows();
	  if (0 != selectedRow.length) 
    {
    	  var srcNEID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "srcNEID", "srcNEID");
        
        if (srcNEID == parentWin.neid)
        {
        	lineDirection = 1;
        }
        else
        {
        	lineDirection = 0;
        }
        
    }
    
    initAvaiablePort();
    
    getWaveLength();
    
    initBtn();
    initNewLineTable();
    initRptTable();
    initBUTable();
    initOtherInfo();
    
    initBUInfo();
}

function initOtherInfo()
{
    var selectedRow = parentWin.slmLineTable.getSelectedRows();
    lineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
    
    var data = createInitOtherInfoXML();
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_GET_MARINELINE + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST", false, callbackInitOtherInfoData, null, "inputdata=" + data);
}

function initBUInfo()
{
    var selectedRow = parentWin.slmLineTable.getSelectedRows();
    lineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
    
    var data = createInitOtherInfoXML();
    
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_GET_UNDERSEA + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST",sync, callbackBUInfoData, null, "inputdata=" + data);
}

function callbackInitOtherInfoData(doc)
{
    var data = EncapsulateData(doc);
    buTable.clearTableData();
    var errorCode = data.getSErrorCode();
    
    if (0 == errorCode || 1 == errorCode) 
    {
        rptTable.getAtom("repeaterNum").setValue(data.getDataRowParam(0, "spanNum") - 1);
        rptTable.getAtom("segmentNum").setValue(data.getDataRowParam(0, "spanNum"));
        rptTable.getAtom("buEquipmentNum").setValue(data.getDataRowParam(0, "eqptNum"));
        
        var selectedRow = parentWin.slmLineTable.getSelectedRows();
        var lineRemark = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "remark", "remark");
        
        if (null != lineRemark) 
        {
            rptTable.getAtom("remark").setValue(lineRemark);
        }
        else 
        {
            rptTable.getAtom("remark").setValue("");
        }
        
	      initDataList.push(rptTable.getAtom("repeaterNum").getValue());
	      initDataList.push(rptTable.getAtom("segmentNum").getValue());
	      initDataList.push(rptTable.getAtom("remark").getValue());
	      initDataList.push(rptTable.getAtom("buEquipmentNum").getValue());
        
    }
    else 
    {
    }
}

function callbackBUInfoData(doc)
{
    fiberLengthList = [];
    var data = EncapsulateData(doc);
    buTable.clearTableData();
    var errorCode = data.getSErrorCode();
    
    if (0 == errorCode || 1 == errorCode) 
    {
    	  var segmentNum = data.getDataRowParam(0, "spanNum");
    	  
    	  for (var i = 2, len = parseInt(segmentNum) + 2; i < len; i++)
				{
		      var crossspan = new TESLMLineCrossSpan(data.getDataRowParam(i, "spanNo"), (parseFloat(data.getDataRowParam(i, "fiberLength")) / 10).toFixed(1));
          fiberLengthList.push(crossspan);
				}
    	  
    	  for(var i = parseInt(segmentNum) + 2; i < data.getDataRowLength(); i++)
        {
        	var row = data.rows[i];
        	var eqptPos = row["eqptPos"].value;
        	if (null != eqptPos && 0 != eqptPos)
        	{
        		row["eqptPos"].value = (parseFloat(eqptPos) / 10).toFixed(1);
        	}
        }
        
        for (var i = parseInt(segmentNum) + 1; i >= 0; i--)
        {
        	data.rows.removeAt(i);        
        }
        
        createTableBody(buTable, window.tableconf[0], data, RESOURCE);
        addCellEvent();
    }
    else 
    {
    }
}

/**
 *        
 * @param neid
 * @return   
 */
function TESLMLineCrossSpan(spanNo, fiberLength)
{
	this.spanNo = spanNo;
	this.fiberLength = fiberLength;
}

/**
 *                           XML   
 * @param   
 * @return   
 */
function createInitOtherInfoXML()
{
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    var selectedRow = parentWin.slmLineTable.getSelectedRows();
    var srcneid = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "srcNEID", "srcNEID");
    if (null == srcneid || UNKNOWN == srcneid)
    {
    	srcneid = 0;
    }
    param = new tagElement("param");
    param.setAttribute("name", "srcneid");
    param.setAttribute("value", srcneid);
    row.appendChild(param);
    
    var sinkneid = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "sinkNEID", "sinkNEID")
    if (null == sinkneid || UNKNOWN == sinkneid)
    {
    	sinkneid = 0;
    }
    param = new tagElement("param");
    param.setAttribute("name", "sinkneid");
    param.setAttribute("value", sinkneid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lineID");
    param.setAttribute("value", lineID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "eqptId");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
	  param.setAttribute("name", "spanNo");
	  param.setAttribute("value", "0");
	  row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    
    return root.toString();
}

/**
 *            
 * @param   
 * @return   
 */
function initAvaiablePort()
{
    initAvaliablePortSrcNE();
    initAvaliablePortOtherNE();
}

/**
 *                  
 * @param   
 * @return   
 */
function initAvaliablePortSrcNE()
{
    curNEInfo = new TESLMNE(neid);
    lmuPortData = [];
    loaPortData = [];
    lmiPortData = [];
    curNEInfo.lmuPortList = lmuPortData;
    curNEInfo.lasPortList = loaPortData;
    curNEInfo.lmiPortList = lmiPortData;
    
    var availableObj = {};
    if (null != availablePortData) 
    {
        for (var i = 0, len = availablePortData.getDataRowLength(); i < len; i++) 
        {
            curNEInfo.setNEName(availablePortData.getDataRowParam(i, "neName"));
            
            if ((SLM_TNB2LAS_BOARDTYPE == parseInt(availablePortData.getDataRowParam(i, "boardType")))
                && (10 == parseInt(availablePortData.getDataRowParam(i, "portId"))))
            {
            	continue;
            }
            
            switch (parseInt(availablePortData.getDataRowParam(i, "boardType")))
            {
                case SLM_TNB2LMU_BOARDTYPE:
                    lmuPortData.push(createTEPort(availablePortData, lmuPortWaveLen, i));
                    break;
                case SLM_TNB2LAS_BOARDTYPE:
                    loaPortData.push(createTEPort(availablePortData, lmuPortWaveLen, i));
                    break;
                case SLM_TNB2LMI_BOARDTYPE:
                    lmiPortData.push(createTEPort(availablePortData, lmuPortWaveLen, i));
                    break;
                default:
                    continue;
            }
        }
    }
    if (null != availableLineData) 
    {
        var selectedRow = parentWin.slmLineTable.getSelectedRows();
        var pLineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
        
        for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++) 
        {
            var aLineID = availableLineData.getDataRowParam(index, "lineID");
            if (pLineID == aLineID) 
            {
                continue;
            }
            
            var lasPort = getLASPortFromLineData(neid, index, availableLineData);
            
            refreshTEPort(lasPort.neid, lasPort.slotId, lasPort.portId, loaPortData);

            var lmiPort = getLMIPortFromLineData(neid, index, availableLineData);
            
            refreshTEPort(lmiPort.neid, lmiPort.slotId, lmiPort.portId, lmiPortData);
        }
    }
}

/**
 *                  
 * @param   
 * @return   
 */
function initAvaliablePortOtherNE()
{
    sinkNEList = [];
    var tmpNEID;
    var neInfo;
    if (null != availablePortOtherNE) 
    {
        var selectedRow = parentWin.slmLineTable.getSelectedRows();
        var pLineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
        
        for (var i = 0, len = availablePortOtherNE.getDataRowLength(); i < len; i++) 
        {
            tmpNEID = parseInt(availablePortOtherNE.getDataRowParam(i, "neid"));
            
            if (!haveNEData(tmpNEID, sinkNEList)) 
            {
                neInfo = new TESLMNE(tmpNEID);
                neInfo.setNEName(availablePortOtherNE.getDataRowParam(i, "neName"));
                neInfo.lmuPortList = [];
                neInfo.lasPortList = [];
                neInfo.lmiPortList = [];
                sinkNEList.push(neInfo);
            }
            neInfo = getNEInfoData(tmpNEID, sinkNEList);
            
            if ((SLM_TNB2LAS_BOARDTYPE == parseInt(availablePortOtherNE.getDataRowParam(i, "boardType")))
                && (10 == parseInt(availablePortOtherNE.getDataRowParam(i, "portId"))))
            {
            	continue;
            }
            
            switch (parseInt(availablePortOtherNE.getDataRowParam(i, "boardType")))
            {
                case SLM_TNB2LMU_BOARDTYPE:
                    neInfo.lmuPortList.push(createTEPort(availablePortOtherNE, lmuPortWaveLen, i));
                    break;
                case SLM_TNB2LAS_BOARDTYPE:
                    neInfo.lasPortList.push(createTEPort(availablePortOtherNE, lmuPortWaveLen, i));
                    break;
                case SLM_TNB2LMI_BOARDTYPE:
                    neInfo.lmiPortList.push(createTEPort(availablePortOtherNE, lmuPortWaveLen, i));
                    break;
                default:
                    continue;
            }
        }
        
        if (null == neInfo)
        {
        	return;
        }
        
        var selectedNE;
        
        var selectedRow = parentWin.slmLineTable.getSelectedRows();
        if (0 != selectedRow.length) 
		    {
		        var sinkNEID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "sinkNEID", "sinkNEID");
		        if ("0" == lineDirection)
		        {
		        	sinkNEID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "srcNEID", "srcNEID");
		        }
		        if (sinkNEID != neid) 
		        {
		            var tmpNE = getNEInfoFromNEList(sinkNEID, sinkNEList);
		            if (null != tmpNE) 
		            {
		                selectedNE = tmpNE;
		            }
		        }
		    }
		    
		    if (null == selectedNE)
		    {
		    	for (var index = sinkNEList.length - 1; index >= 0 ; index--) 
	        {
	          sinkNEList.splice(index, 1);
	        }
		    	return;
		    }
		    
		    for (var index = sinkNEList.length - 1; index >= 0 ; index--) 
        {
        	if (selectedNE.neid != sinkNEList[index].neid)
        	{
        		sinkNEList.splice(index, 1);
        	}
        }
		    
		    querySinkLineInfo(selectedNE.neid);
 
        neInfo = getNEInfoData(selectedNE.neid, sinkNEList);
        
	      for (var index = 0, indexLen = sinkAvailableLineData.getDataRowLength(); index < indexLen; index++) 
	      {
	        var aLineID = sinkAvailableLineData.getDataRowParam(index, "lineID");
          if (pLineID == aLineID) 
          {
              continue;
          }
            
	        var lasPort = getLASPortFromLineData(selectedNE.neid, index, sinkAvailableLineData);
	            
	        refreshTEPort(lasPort.neid, lasPort.slotId, lasPort.portId, neInfo.lasPortList);

	        var lmiPort = getLMIPortFromLineData(selectedNE.neid, index, sinkAvailableLineData);
	            
	        refreshTEPort(lmiPort.neid, lmiPort.slotId, lmiPort.portId, neInfo.lmiPortList);
	      }
    }
}

/**
 *             
 * @param   
 * @return   
 */
function querySinkLineInfo(neid)
{
	var data = createQuerySinkLineInfoXML(neid)
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_LINEINFO + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", false, callbackQuerySinkLineInfoData, null, "inputdata="+data);

}
/**
 *                XML   
 * @param   
 * @return   
 */
function createQuerySinkLineInfoXML(neid)
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", "0");
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *                        
 * @param doc
 * @return   
 */
function callbackQuerySinkLineInfoData(doc)
{	
	var data = EncapsulateData(doc);
  
  sinkAvailableLineData = data;
}

/**
 *         
 * @param   
 * @return   
 */
function initBtn()
{
    $("okBtn").value = RESOURCE["okBtn"];
    $("cancelBtn").value = RESOURCE["cancelBtn"];
}

/**
 *            
 * @param   
 * @return   
 */
function initNewLineTable()
{   
    initNewLineSrcTable();
    initNewLineSinkTable();
}

/**
 *           
 * @param   
 * @return   
 */
function initNewLineSrcTable()
{
    var selectedRow = parentWin.slmLineTable.getSelectedRows();
    
    newLineSrcTable = new CTable();
    newLineSrcTable.addHead(RESOURCE["attrCol"], RESOURCE["valueCol"]);
    
    var cTableAtom = null;
    var cTableAtomEle = null;
    
    
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element;
    var tmpNEList = [];
    tmpNEList.push(curNEInfo);
    createNEOption(cTableAtomEle, tmpNEList);
    cTableAtomEle.disabled = true;
    newLineSrcTable.addAttrRow("srcNE", RESOURCE["srcNE"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    createOption(cTableAtomEle, lmuPortData);
    var lmuPort = null;
    if (0 != selectedRow.length) 
    {
        var lmuMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "curNELMUInfo", "curNELMUInfo");
        var vline = selectOptionTEPort(cTableAtomEle, lmuMap);
        
        if (cTableAtomEle.options.length > 0)
        {
        	cTableAtomEle.options[vline].selected = true;
        }
    }
    cTableAtomEle.onchange = srcLMUListener;
    newLineSrcTable.addAttrRow("lineMonitorUnit", RESOURCE["lineMonitorUnit"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    createOption(cTableAtomEle, loaPortData);
    if (0 != selectedRow.length) 
    {
        var loaMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "curNELASInfo", "curNELASInfo");
        var vline = selectOptionTEPort(cTableAtomEle, loaMap);
        if (cTableAtomEle.options.length > 0)
        {
        	cTableAtomEle.options[vline].selected = true;
        }
    }
    newLineSrcTable.addAttrRow("lineAmplifierUnit", RESOURCE["lineAmplifierUnit"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = true;
    createOption(cTableAtomEle, lmiPortData);
    if (0 != selectedRow.length) 
    {
        var lmiMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "curNELMIInfo", "curNELMIInfo");
        var vline = selectOptionTEPortLMI(cTableAtomEle, lmiMap);
        if (cTableAtomEle.options.length > 0)
        {
        	cTableAtomEle.options[vline].selected = true;
        }
    }
    newLineSrcTable.addAttrRow("lineInterfaceUnit", RESOURCE["lineInterfaceUnit"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    var lmuTEPort = getTEPort(newLineSrcTable.getAtom("lineMonitorUnit").getValue(), lmuPortData);
    
    var probeWaveBand = "srcProbeWaveBand";
    var probeWaveIndex = "srcProbeWaveIndex";
    var loadingWaveBand = "srcLoadingWaveBand";
    var loadingWaveIndex = "srcLoadingWaveIndex";
    if ("0" == lineDirection)
    {
	    probeWaveBand = "sinkProbeWaveBand";
	    probeWaveIndex = "sinkProbeWaveIndex";
	    loadingWaveBand = "sinkLoadingWaveBand";
	    loadingWaveIndex = "sinkLoadingWaveIndex";
    }
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    createProbeWaveTypeOption(cTableAtomEle, lmuTEPort);
    cTableAtomEle.onchange = srcProbeWaveTypeListener;
    if (0 != selectedRow.length) 
    {
        var srcProbeWaveBand = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], probeWaveBand, probeWaveBand);
        var vline = 0;
        if (DEFAULT_SEGMENT_NUM != srcProbeWaveBand)
        {
        	vline = selectBandTypeOption(cTableAtomEle, bandTypeID(srcProbeWaveBand));
        }
        if (cTableAtomEle.options.length > 0)
        {
        	cTableAtomEle.options[vline].selected = true;
        }
    }
    else 
    {
    }
    newLineSrcTable.addAttrRow("probeWaveType", RESOURCE["probeWaveType"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (0 != selectedRow.length) 
    {
        var srcProbeWaveBand = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], probeWaveBand, probeWaveBand);
        var srcProbeWaveIndex = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], probeWaveIndex, probeWaveIndex);
        var vline = 0;
        
        if (DEFAULT_SEGMENT_NUM != srcProbeWaveBand)
        {
        	createProbeWaveLengthOption(cTableAtomEle, bandTypeID(srcProbeWaveBand), lmuTEPort);
        	vline = selectWaveLengthOption(cTableAtomEle, srcProbeWaveIndex);
        	
        	if (cTableAtomEle.options.length > 0)
	        {
	        	cTableAtomEle.options[vline].selected = true;
	        }
	        
	        if (DEFAULT_SEGMENT_NUM == srcProbeWaveIndex || INVALID_VALUE == srcProbeWaveIndex)
	        {
	        	cTableAtom.addOption(INVALID_VALUE, 0);
	        	if (cTableAtomEle.options.length > 0)
		        {
		        	cTableAtomEle.options[cTableAtomEle.options.length - 1].selected = true;
		        }
	        }
        }
        else
        {
        	cTableAtom.addOption("-", 0);
        	cTableAtomEle.options[vline].selected = true;
        }
         
    }
    else 
    {
        createWaveLengthOption(cTableAtomEle, BAND_TYPE_DEFAULT);
    }
    newLineSrcTable.addAttrRow("probeWaveNo", RESOURCE["probeWaveNo"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    createLoadingWaveTypeOption(cTableAtomEle, lmuTEPort);
    cTableAtomEle.onchange = srcLoadingWaveTypeListener;
    if (0 != selectedRow.length) 
    {
        var srcLoadingWaveBand = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], loadingWaveBand, loadingWaveBand);
        var vline = 0;
        if (DEFAULT_SEGMENT_NUM != srcProbeWaveBand)
        {
        	vline = selectBandTypeOption(cTableAtomEle, bandTypeID(srcLoadingWaveBand));
        }
        if (cTableAtomEle.options.length > 0)
        {
        	cTableAtomEle.options[vline].selected = true;
        }
    }
    else 
    {
        cTableAtomEle.options[BAND_TYPE_DEFAULT].selected = true;
    }
    newLineSrcTable.addAttrRow("loadingWaveType", RESOURCE["loadingWaveType"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (0 != selectedRow.length) 
    {
        var srcLoadingWaveBand = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], loadingWaveBand, loadingWaveBand);
        var srcLoadingWaveIndex = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], loadingWaveIndex, loadingWaveIndex);
        var vline = 0;
        if (DEFAULT_SEGMENT_NUM != srcProbeWaveBand)
        {
        	createLoadingWaveLengthOption(cTableAtomEle, bandTypeID(srcLoadingWaveBand), lmuTEPort);
          vline = selectWaveLengthOption(cTableAtomEle, srcLoadingWaveIndex);
          
          if (cTableAtomEle.options.length > 0)
	        {
	        	cTableAtomEle.options[vline].selected = true;
	        }
	        
	        if (DEFAULT_SEGMENT_NUM == srcLoadingWaveIndex || INVALID_VALUE == srcLoadingWaveIndex)
	        {
	        	cTableAtom.addOption(INVALID_VALUE, 0);
	        	if (cTableAtomEle.options.length > 0)
		        {
		        	cTableAtomEle.options[cTableAtomEle.options.length - 1].selected = true;
		        }
	        }
        }
        else
        {
        	cTableAtom.addOption("-", 0);
        	cTableAtomEle.options[vline].selected = true;
        }
    }
    else 
    {
        createWaveLengthOption(cTableAtomEle, BAND_TYPE_DEFAULT);
    }
    newLineSrcTable.addAttrRow("loadingWaveNo", RESOURCE["loadingWaveNo"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    var newLineTable = newLineSrcTable;
    if ("0" == lineDirection)
    {
    	$("newLineSinkTable").appendChild(newLineSrcTable.getTable());
    }
    else
    {
    	$("newLineSrcTable").appendChild(newLineSrcTable.getTable());
    }
}

/**
 *           
 * @param   
 * @return   
 */
function initNewLineSinkTable()
{
    var selectedRow = parentWin.slmLineTable.getSelectedRows();
    newLineSinkTable = new CTable();
    newLineSinkTable.addHead(RESOURCE["attrCol"], RESOURCE["valueCol"]);
    
    var cTableAtom = null;
    var cTableAtomEle = null;
    
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element;
    var tmpNEList = [];
    var selectedNE;
    var selectedNEIndex = 0;
    
    if (0 != selectedRow.length) 
    {
        var sinkNEID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "sinkNEID", "sinkNEID");
        
        if ("0" == lineDirection)
        {
        	sinkNEID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "srcNEID", "srcNEID");
        }
        
        if (sinkNEID != neid) 
        {
            var tmpNE = getNEInfoFromNEList(sinkNEID, sinkNEList);
            if (null != tmpNE) 
            {
                cTableAtom.setValue(tmpNE);
                selectedNE = tmpNE;
            }
        }
    }
    
    if (null == selectedNE)
    {
    	cTableAtom.addOption("-", 0);
    	cTableAtomEle.options[0].selected = true;
    }
    else
    {
    	createNEOption(cTableAtomEle, sinkNEList);
    }
    cTableAtomEle.disabled = true;
    newLineSinkTable.addAttrRow("sinkNE", RESOURCE["sinkNE"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (null != selectedNE)
    {
    	createOption(cTableAtomEle, selectedNE.lmuPortList);
	    if (0 != selectedRow.length) 
	    {
	        var lmuMap = getLMUPortMapping(parentWin.slmLineTable, availableLineData, neid);
	        /*var sinkLMUPortData = selectedNE.lmuPortList;
	         if (null != lmuMap)
	         {
	         cTableAtom.setValue(getTEPort(lmuMap,selectedNE.lmuPortList));
	         }*/
	        var vline = selectOptionTEPort(cTableAtomEle, lmuMap);
	        cTableAtomEle.options[vline].selected = true;
	        if (cTableAtomEle.options.length > 0)
          {
        	  cTableAtomEle.options[vline].selected = true;
          }
	    }
    }
    else
    {
    	cTableAtom.addOption("-", 0);
    }
    
    cTableAtomEle.onchange = sinkLMUListener;
    newLineSinkTable.addAttrRow("lineMonitorUnit", RESOURCE["lineMonitorUnit"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (null != selectedNE)
    {
	    createOption(cTableAtomEle, selectedNE.lasPortList);
	    if (0 != selectedRow.length) 
	    {
	        var loaMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "sinkNELASInfo", "sinkNELASInfo");
	        /*var sinkLOAPortData = selectedNE.lasPortList;
	         if (null != loaMap)
	         {
	         cTableAtom.setValue(getTEPort(loaMap, selectedNE.lasPortList));
	         }*/
	        var vline = selectOptionTEPort(cTableAtomEle, loaMap);
	        if (cTableAtomEle.options.length > 0)
          {
        	  cTableAtomEle.options[vline].selected = true;
          }
	    }
    }
    else
    {
    	cTableAtom.addOption("-", 0);
    }
    newLineSinkTable.addAttrRow("lineAmplifierUnit", RESOURCE["lineAmplifierUnit"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    cTableAtom.setValue();
    cTableAtomEle.disabled = true;
    if (null != selectedNE)
    {
	    createOption(cTableAtomEle, selectedNE.lmiPortList);
	    if (0 != selectedRow.length) 
	    {
	        var lmiMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "sinkNELMIInfo", "sinkNELMIInfo");
	        var vline = selectOptionTEPortLMI(cTableAtomEle, lmiMap);
	        if (cTableAtomEle.options.length > 0)
          {
        	  cTableAtomEle.options[vline].selected = true;
          }
	    }
    }
    else
    {
    	cTableAtom.addOption("-", 0);
    }
    newLineSinkTable.addAttrRow("lineInterfaceUnit", RESOURCE["lineInterfaceUnit"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    
    var sinkNE = newLineSinkTable.getAtom("sinkNE").getValue();
    
    var lmuTEPort = null;
    if (null != selectedNE)
    {
        lmuTEPort = getLMITEPort(selectedNE.neid, newLineSinkTable.getAtom("lineMonitorUnit").getValue(), getNEInfoData(selectedNE.neid, sinkNEList).lmuPortList);	
    }
    
    var probeWaveBand = "sinkProbeWaveBand";
    var probeWaveIndex = "sinkProbeWaveIndex";
    var loadingWaveBand = "sinkLoadingWaveBand";
    var loadingWaveIndex = "sinkLoadingWaveIndex";
    if ("0" == lineDirection)
    {
	    probeWaveBand = "srcProbeWaveBand";
	    probeWaveIndex = "srcProbeWaveIndex";
	    loadingWaveBand = "srcLoadingWaveBand";
	    loadingWaveIndex = "srcLoadingWaveIndex";
    }
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (0 == sinkNE || null == lmuTEPort)
    {
    	cTableAtomEle.options.add(new Option("-", 0));
    }
    else
    {
	    createProbeWaveTypeOption(cTableAtomEle, lmuTEPort);
	    if (0 != selectedRow.length) 
	    {
	        var sinkProbeWaveBand = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], probeWaveBand, probeWaveBand);
	        var vline = selectBandTypeOption(cTableAtomEle, bandTypeID(sinkProbeWaveBand));
	        if (cTableAtomEle.options.length > 0)
	        {
	        	cTableAtomEle.options[vline].selected = true;
	        }
	    }
	    else 
	    {
	        cTableAtomEle.options[BAND_TYPE_DEFAULT].selected = true;
	    }
	    cTableAtomEle.onchange = sinkProbeWaveTypeListener;
    }
    newLineSinkTable.addAttrRow("probeWaveType", RESOURCE["probeWaveType"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (0 == sinkNE || null == lmuTEPort)
    {
    	cTableAtomEle.options.add(new Option("-", 0));
    }
    else
    {
	    if (0 != selectedRow.length) 
	    {
	        var sinkProbeWaveBand = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], probeWaveBand, probeWaveBand);
	        var sinkProbeWaveIndex = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], probeWaveIndex, probeWaveIndex);
	        createProbeWaveLengthOption(cTableAtomEle, bandTypeID(sinkProbeWaveBand), lmuTEPort);
	        var vline = selectWaveLengthOption(cTableAtomEle, sinkProbeWaveIndex);
	        if (cTableAtomEle.options.length > 0)
	        {
	        	cTableAtomEle.options[vline].selected = true;
	        }
	        
	        if (DEFAULT_SEGMENT_NUM == sinkProbeWaveIndex || INVALID_VALUE == sinkProbeWaveIndex)
	        {
	        	cTableAtom.addOption(INVALID_VALUE, 0);
	        	if (cTableAtomEle.options.length > 0)
		        {
		        	cTableAtomEle.options[cTableAtomEle.options.length - 1].selected = true;
		        }
	        }
	    }
	    else 
	    {
	        createWaveLengthOption(cTableAtomEle, BAND_TYPE_DEFAULT);
	    }
	  }
    newLineSinkTable.addAttrRow("probeWaveNo", RESOURCE["probeWaveNo"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (0 == sinkNE || null == lmuTEPort)
    {
    	cTableAtomEle.options.add(new Option("-", 0));
    }
    else
    {
	    createLoadingWaveTypeOption(cTableAtomEle, lmuTEPort);
	    cTableAtomEle.onchange = sinkLoadingWaveTypeListener;
	    if (0 != selectedRow.length) 
	    {
	        var sinkLoadingWaveBand = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], loadingWaveBand, loadingWaveBand);
	        var vline = selectBandTypeOption(cTableAtomEle, bandTypeID(sinkLoadingWaveBand));
	        if (cTableAtomEle.options.length > 0)
	        {
	        	cTableAtomEle.options[vline].selected = true;
	        }
	    }
	    else 
	    {
	        cTableAtomEle.options[BAND_TYPE_DEFAULT].selected = true;
	    }
	  }
    newLineSinkTable.addAttrRow("loadingWaveType", RESOURCE["loadingWaveType"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (0 == sinkNE || null == lmuTEPort)
    {
    	cTableAtomEle.options.add(new Option("-", 0));
    }
    else
    {
	    if (0 != selectedRow.length) 
	    {
	        var sinkLoadingWaveBand = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], loadingWaveBand, loadingWaveBand);
	        var sinkLoadingWaveIndex = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], loadingWaveIndex, loadingWaveIndex);
	        createLoadingWaveLengthOption(cTableAtomEle, bandTypeID(sinkLoadingWaveBand), lmuTEPort);
	        var vline = selectWaveLengthOption(cTableAtomEle, sinkLoadingWaveIndex);
	        if (cTableAtomEle.options.length > 0)
	        {
	        	cTableAtomEle.options[vline].selected = true;
	        }
	        
	        if (DEFAULT_SEGMENT_NUM == sinkLoadingWaveIndex || INVALID_VALUE == sinkLoadingWaveIndex)
	        {
	        	cTableAtom.addOption(INVALID_VALUE, 0);
	        	if (cTableAtomEle.options.length > 0)
		        {
		        	cTableAtomEle.options[cTableAtomEle.options.length - 1].selected = true;
		        }
	        }
	    }
	    else 
	    {
	        createWaveLengthOption(cTableAtomEle, BAND_TYPE_DEFAULT);
	    }
	  }
    newLineSinkTable.addAttrRow("loadingWaveNo", RESOURCE["loadingWaveNo"], cTableAtom);
    initDataList.push(cTableAtom.getValue());
    
    if (0 == sinkNE) 
    {
        newLineSinkTable.getAtom("lineMonitorUnit").element.disabled = true;
        newLineSinkTable.getAtom("lineAmplifierUnit").element.disabled = true;
        newLineSinkTable.getAtom("lineInterfaceUnit").element.disabled = true;
        newLineSinkTable.getAtom("probeWaveType").element.disabled = true;
        newLineSinkTable.getAtom("probeWaveNo").element.disabled = true;
        newLineSinkTable.getAtom("loadingWaveType").element.disabled = true;
        newLineSinkTable.getAtom("loadingWaveNo").element.disabled = true;
        
        newLineSinkTable.getAtom("probeWaveNo").addOption("-", 0);
        newLineSinkTable.getAtom("loadingWaveType").addOption("-", 0);
        newLineSinkTable.getAtom("loadingWaveNo").addOption("-", 0);
    }
    
    var newLineTable = newLineSrcTable;
    if ("0" == lineDirection)
    {
    	$("newLineSrcTable").appendChild(newLineSinkTable.getTable());
    }
    else
    {
    	$("newLineSinkTable").appendChild(newLineSinkTable.getTable());
    }
}

/**
 *              
 * @param   
 * @return   
 */
function srcLMUListener(evt)
{
	  var cTableAtomEle = null;
    var lmuTEPort = getTEPort(newLineSrcTable.getAtom("lineMonitorUnit").getValue(), lmuPortData);

    cTableAtomEle = newLineSrcTable.getAtom("probeWaveType").element;
    createProbeWaveTypeOption(cTableAtomEle, lmuTEPort);
    cTableAtomEle.onchange = srcProbeWaveTypeListener;
    
    cTableAtomEle = newLineSrcTable.getAtom("probeWaveNo").element;
    createProbeWaveLengthOption(cTableAtomEle, newLineSrcTable.getAtom("probeWaveType").getValue(), lmuTEPort);
    
    cTableAtomEle = newLineSrcTable.getAtom("loadingWaveType").element;
    createLoadingWaveTypeOption(cTableAtomEle, lmuTEPort);
    cTableAtomEle.onchange = srcLoadingWaveTypeListener;
    
    cTableAtomEle = newLineSrcTable.getAtom("loadingWaveNo").element;
    createLoadingWaveLengthOption(cTableAtomEle, newLineSrcTable.getAtom("loadingWaveType").getValue(), lmuTEPort);
}

/**
 *              
 * @param   
 * @return   
 */
function sinkLMUListener(evt)
{
	  var sinkNE = newLineSinkTable.getAtom("sinkNE").getValue();
	  var selectedNE = null;
   	for (var i = 0, len = sinkNEList.length; i < len; i++)
   	{
    	 var slmNE = sinkNEList[i];
    	 if (sinkNE == slmNE)
    	 {
    	   selectedNE = sinkNEList[i];
    	   break;
    	 }
    }
	  
	  var lmuTEPort = null;
    if (null != selectedNE)
    {
        lmuTEPort = getLMITEPort(selectedNE.neid, newLineSinkTable.getAtom("lineMonitorUnit").getValue(), getNEInfoData(selectedNE.neid, sinkNEList).lmuPortList);	
    }
	  
    var cTableAtomEle = null;
    
    if (null != lmuTEPort)
    {
    	cTableAtomEle = newLineSinkTable.getAtom("probeWaveType").element;
    	createProbeWaveTypeOption(cTableAtomEle, lmuTEPort);
      cTableAtomEle.onchange = sinkProbeWaveTypeListener;

      cTableAtomEle = newLineSinkTable.getAtom("probeWaveNo").element;
      createProbeWaveLengthOption(cTableAtomEle, newLineSinkTable.getAtom("probeWaveType").getValue(), lmuTEPort);
      
      cTableAtomEle = newLineSinkTable.getAtom("loadingWaveType").element;
      createLoadingWaveTypeOption(cTableAtomEle, lmuTEPort);
      cTableAtomEle.onchange = sinkLoadingWaveTypeListener;
      
      cTableAtomEle = newLineSinkTable.getAtom("loadingWaveNo").element;
      createLoadingWaveLengthOption(cTableAtomEle, newLineSinkTable.getAtom("loadingWaveType").getValue(), lmuTEPort);
    }
    else
    {
    	newLineSinkTable.getAtom("probeWaveType").addOption("-", 0);
    	newLineSinkTable.getAtom("probeWaveNo").addOption("-", 0);
    	newLineSinkTable.getAtom("loadingWaveType").addOption("-", 0);
    	newLineSinkTable.getAtom("loadingWaveNo").addOption("-", 0);
    }
}

/**
 *              
 * @param   
 * @return   
 */
function srcProbeWaveTypeListener(evt)
{
    var probeWaveType = newLineSrcTable.getAtom("probeWaveType").getValue();
    var cTableAtom = newLineSrcTable.getAtom("probeWaveNo");
    var cTableAtomEle = cTableAtom.element;
    createWaveLengthOption(cTableAtomEle, probeWaveType);
}

/**
 *              
 * @param   
 * @return   
 */
function srcLoadingWaveTypeListener(evt)
{
    var loadingWaveType = newLineSrcTable.getAtom("loadingWaveType").getValue();
    var cTableAtom = newLineSrcTable.getAtom("loadingWaveNo");
    var cTableAtomEle = cTableAtom.element;
    createWaveLengthOption(cTableAtomEle, loadingWaveType);
}

/**
 *              
 * @param   
 * @return   
 */
function sinkProbeWaveTypeListener(evt)
{
    var probeWaveType = newLineSinkTable.getAtom("probeWaveType").getValue();
    var cTableAtom = newLineSinkTable.getAtom("probeWaveNo");
    var cTableAtomEle = cTableAtom.element;
    createWaveLengthOption(cTableAtomEle, probeWaveType);
}

/**
 *              
 * @param   
 * @return   
 */
function sinkLoadingWaveTypeListener(evt)
{
    var loadingWaveType = newLineSinkTable.getAtom("loadingWaveType").getValue();
    var cTableAtom = newLineSinkTable.getAtom("loadingWaveNo");
    var cTableAtomEle = cTableAtom.element;
    createWaveLengthOption(cTableAtomEle, loadingWaveType);
}

/**
 *                 
 * @param   
 * @return   
 */
function initBUTable()
{
    buTable = new SortTable();
    buTable.setImage("../../../../images/");
    var lineTableOffset = 0;
    if (isIE) 
    {
        lineTableOffset = document.body.offsetHeight * 0.35;
    }
    else 
    {
        lineTableOffset = document.body.clientHeight * 0.35;
    }
    buTable.setBodyHeight(getComponetHeight($("buTable"), lineTableOffset) + "px");
    createTableHead(buTable, window.tableconf[0]);
	  buTable.setOnCellEditHandler(cellEditHandler);
    $("buTable").oncontextmenu = buPopupMenuHandler;
    $("buTable").appendChild(buTable.getTable());
}

/*
 * Add table popupmenu handler
 */

function buPopupMenuHandler(evt)
{	
	if (!evt)
	{
		evt = window.event;
	}

	var elem = (evt.target) ? evt.target : evt.srcElement;

	if (elem != null && elem.blur)
	{
		elem.blur();
	}

	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}

	if (elem == null || elem.tagName != 'TD' || null == elem.parent
			|| elem.editElement == null)
	{
		return;
	}

	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	
	if ("eqptName" == colid)
	{
		return;
	}
	
	var isColNotShowMenu = ((null != this.popupMenuExcludeCells) && (this.popupMenuExcludeCells.contains(colid)));
	if (rows.contains(rowid))
	{
		if (null != elem.editElement && 
			 	elem.isEdit == 1 && !isColNotShowMenu)
		{
			createTablePopupMenu(elem, evt);
			return;
		}

		for ( var i = 0; i < rows.length; i++)
		{
			var tmpElem = elem.parent.getCellElement(rows[i], colid);
			if (null != tmpElem.editElement && tmpElem.isEdit == 1 && !isColNotShowMenu)
			{
				createTablePopupMenu(tmpElem, evt);
				return;
			}
		}
	}
}

/**
 *                       added by l00104422
 * @param param
 * @return   
 */
function cellEditHandler(param)
{
	var cell;//     
	if (param.colid == "eqptPos")
	{
		var spanId = buTable.getCellStoreValue(param.rowindex, "spanId", "spanId");
    
    var fiberLength = 80.0;
    for (var j = 0, k = fiberLengthList.length; j < k; j++)
    {
        if (spanId == fiberLengthList[j].spanNo)
        {
        		fiberLength = fiberLengthList[j].fiberLength;
        		break;
        }
    }		
    cell = buTable.getCell(param.rowindex, "eqptPos");
    textCheck(cell.element.editElement.element, "0.1", fiberLength - 0.1);
    
	}
	
	  var rowindex = param["rowindex"];
	  var colID = param["colid"];
	  var stage = param["stage"];
	  
	  if(stage == TABLE_CONSTANT.BEFOREEDIT && colID == "eqptName")
	  {
	      var eqptNameCellEdit = buTable.getCellEdit(rowindex, colID);
	  	  
	  	  eqptNameCellEdit.element.options.length = 0;
	  	  
	  	  var selectedType = buTable.getCellStoreValue(rowindex, "eqptType", "eqptType");
	  	  if(3 != selectedType && 0 != buNameAndTypeMap.length)
	  	  {
	  	      var buNames = buNameAndTypeMap[selectedType];
	  	      if("" != buNames)
	  	      {
	  	          var buNameArr = buNames.split(",");
	  	          for(var i = 0; i < buNameArr.length; i++)
	  	          {
	  	              eqptNameCellEdit.addOption(buNameArr[i], buNameArr[i]);
	  	          }
	  	      }
	  	      
	  	  }
	  }
}

/**
 *               
 * @param   
 * @return   
 */
function initRptTable()
{
    rptTable = new CTable();
    
    var cTableAtom = null;
    var cTableAtomEle = null;
    
    cTableAtom = new Atom("text");
    cTableAtom.setValue(SLM_DEFAULT_REPEATER_NUM);
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = false;
    checkText(cTableAtomEle, SLM_MIN_REPEATER_NUM, SLM_MAX_REPEATER_NUM);
    cTableAtomEle.onblur = repeaterNumChangeListener;
    rptTable.addAttrRow("repeaterNum", RESOURCE["repeaterNum"], cTableAtom);
    
    cTableAtom = new Atom("text");
    cTableAtom.setValue(SLM_DEFAULT_REPEATER_NUM + 1);
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = true;
    rptTable.addAttrRow("segmentNum", RESOURCE["segmentNum"], cTableAtom);
    
    cTableAtom = new Atom("text");
    cTableAtom.setValue(SLM_DEFAULT_BUNUM);
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = false;
    checkText(cTableAtomEle, SLM_MIN_BUNUM, SLM_MAX_BUNUM);
    cTableAtomEle.onblur = buNumChangeListener;
    rptTable.addAttrRow("buEquipmentNum", RESOURCE["buEquipmentNum"], cTableAtom);
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = false;
    cTableAtomEle.onpaste = function()
	  {
		    return false;
	  }
    cTableAtom.element["onkeypress"] = function()
    {
        if (restrictByAllow(this,window.event,"\"`'\\=,:;?&!(){}[]<>/"))
        {
        	return calStrSinoLen(this,SLM_LINEMGR_MAX_REMARK_LENGTH);
        }
        else
        {
        	return false;
        }
    }
    cTableAtomEle.onkeyup = function()
    {
        return calStrSinoLen(this, SLM_LINEMGR_MAX_REMARK_LENGTH);        
    }
    
    rptTable.addAttrRow("remark", RESOURCE["remarkDiv"], cTableAtom);
    
    $("rptTable").appendChild(rptTable.getTable());
}

/**
 *                    
 * @param   
 * @return   
 */
function remarkLengthCheckListener(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    return calStrSinoLen(newLineSrcTable.getAtom("remark").element, SLM_LINEMGR_MAX_REMARK_LENGTH);
}

/**
 *    LMU           
 * @param   
 * @return   
 */
function lmuSelectListener(evt)
{
    newLineSrcTable.getAtom("lineAmplifierUnit").element.onchange = null;
    if (!evt) 
    {
        evt = window.event;
    }
    var slotId;
    var portId;
    var lmuPort = newLineSrcTable.getAttrValue("lineMonitorUnit");
    if (null != availableLineData) 
    {
        for (var i = 0, len = availableLineData.getDataRowLength(); i < len; i++) 
        {
            slotId = availableLineData.getDataRowParam(i, "lmuSlotId");
            portId = availableLineData.getDataRowParam(i, "lmuPortId");
            lmuSlotId = lmuPort.split("-")[0];
            lmuPortId = lmuPort.split("-")[2].split("(")[0];
            if (lmuSlotId == slotId && lmuPortId == portId) 
            {
                newLineSrcTable.setAttrValue("lineAmplifierUnit", getPort(availableLineData.getDataRowParam(i, "loaneid"), availableLineData.getDataRowParam(i, "loaSlotId"), availableLineData.getDataRowParam(i, "loaPortId"), loaPortData));
                break;
            }
        }
    }
    newLineSrcTable.getAtom("lineAmplifierUnit").element.onchange = loaSelectListener;
}

function neSelectListener(evt)
{


}

/**
 *    LOA           
 * @param   
 * @return   
 */
function loaSelectListener(evt)
{
    newLineSrcTable.getAtom("lineMonitorUnit").element.onchange = null;
    if (!evt) 
    {
        evt = window.event;
    }
    var slotId;
    var portId;
    var loaPort = newLineSrcTable.getAttrValue("lineAmplifierUnit");
    if (null != availableLineData) 
    {
        for (var i = 0, len = availableLineData.getDataRowLength(); i < len; i++) 
        {
            slotId = availableLineData.getDataRowParam(i, "loaSlotId");
            portId = availableLineData.getDataRowParam(i, "loaPortId");
            loaSlotId = loaPort.split("-")[0];
            loaPortId = loaPort.split("-")[2].split("(")[0];
            if (loaSlotId == slotId && loaPortId == portId) 
            {
                newLineSrcTable.setAttrValue("lineMonitorUnit", getPort(availableLineData.getDataRowParam(i, "lmuneid"), availableLineData.getDataRowParam(i, "lmuSlotId"), availableLineData.getDataRowParam(i, "lmuPortId"), lmuPortData));
                break;
            }
        }
    }
    newLineSrcTable.getAtom("lineMonitorUnit").element.onchange = lmuSelectListener;
}

/**
 *    LSU           
 * @param   
 * @return   
 */
function lsuSelectListener(evt)
{
    newLineSrcTable.getAtom("lineMonitorUnit").element.onchange = null;
    newLineSrcTable.getAtom("lineAmplifierUnit").element.onchange = null;
    if (!evt) 
    {
        evt = window.event;
    }
    var slotId;
    var portId;
    var lsuPort = newLineSrcTable.getAttrValue("lineSelectUnit");
    if (null != availableLineData) 
    {
        for (var i = 0, len = availableLineData.getDataRowLength(); i < len; i++) 
        {
            slotId = availableLineData.getDataRowParam(i, "lsuSlotId");
            lsuSlotId = lsuPort.split("-")[0];
            if (lsuSlotId == slotId) 
            {
                newLineSrcTable.setAttrValue("lineMonitorUnit", getPort(availableLineData.getDataRowParam(i, "lmuneid"), availableLineData.getDataRowParam(i, "lmuSlotId"), availableLineData.getDataRowParam(i, "lmuPortId"), lmuPortData));
                newLineSrcTable.setAttrValue("lineAmplifierUnit", getPort(availableLineData.getDataRowParam(i, "loaneid"), availableLineData.getDataRowParam(i, "loaSlotId"), availableLineData.getDataRowParam(i, "loaPortId"), loaPortData));
                break;
            }
        }
    }
    newLineSrcTable.getAtom("lineMonitorUnit").element.onchange = lmuSelectListener;
    newLineSrcTable.getAtom("lineAmplifierUnit").element.onchange = loaSelectListener;
}

/**
 *                 
 * @param   
 * @return   
 */
function lmiNESelectListener(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    var tmpLMIArray = [];
    var neid = newLineSrcTable.getAttrValue("lineInterfaceNE");
    for (var i = 0, len = lmiPortData.length; i < len; i++) 
    {
        if (neid == lmiPortData[i].neid) 
        {
            tmpLMIArray.push(lmiPortData[i]);
        }
    }
    createOption(newLineSrcTable.getAtom("lineInterfaceUnit").element, tmpLMIArray);
}

/**
 *            Option   
 * @param   
 * @return   
 */
function createLMIOption(neid)
{
    var tmpLMIArray = [];
    for (var i = 0, len = lmiPortData.length; i < len; i++) 
    {
        if (neid == lmiPortData[i].neid) 
        {
            tmpLMIArray.push(lmiPortData[i]);
        }
    }
    createOption(newLineSrcTable.getAtom("lineInterfaceUnit").element, tmpLMIArray);
}

/**
 *                        port    
 * @param optionArray, port
 * @return   
 */
function containPort(optionArray, port)
{
    for (var i = 0, len = optionArray.length; i < len; i++) 
    {
        if (port.neid == optionArray[i].value) 
        {
            return true;
        }
    }
    return false;
}

/*
function buNumChangeListener()
{
	  isModifyBUTable = true;
	  
    buTable.clearTableData();
    var buNumber = rptTable.getAtom("buEquipmentNum").getValue();
    if (null == buNumber) 
    {
        return;
    }
    var newData = new DataInterface();
    var obj;
    var ptag;
    for (var index = 0; index < buNumber; index++) 
    {
        obj = new Object();
        ptag = new ParamTag();
        ptag.value = "2";
        obj["eqptType"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = "";
        obj["eqptName"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = "";
        obj["spanId"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = "";
        obj["eqptPos"] = ptag;
        
        newData.rows.append(obj)
    }
    createTableBody(buTable, window.tableconf[0], newData, RESOURCE);
    addCellEvent();
}*/

function buNumChangeListener()
{
    
    var buTableRowLength = buTable.getDataRowLength();
    
    var buNumber = rptTable.getAtom("buEquipmentNum").getValue();
    if (null == buNumber) 
    {
        return;
    }
    
    if (buNumber > buTableRowLength)
    {
    	for (var i = 0, len = buNumber - buTableRowLength; i < len; i++)
    	{
    		addBuTableRow();
    	}
    }

    if (buNumber < buTableRowLength)
    {
    	for (var i = 0, len = buTableRowLength - buNumber; i < len; i++)
    	{
    		delBuTableRow();
    	}
    }

    addCellEvent();
}

function addBuTableRow()
{
	  var newData = new DataInterface();
    var obj;
    var ptag;
    
    obj = new Object();
    ptag = new ParamTag();
    ptag.value = "2";
    obj["eqptType"] = ptag;
        
    ptag = new ParamTag();
    ptag.value = "";
    obj["eqptName"] = ptag;
        
    ptag = new ParamTag();
    ptag.value = "";
    obj["spanId"] = ptag;
        
    ptag = new ParamTag();
    ptag.value = "";
    obj["eqptPos"] = ptag;
        
    newData.rows.append(obj);
    
    createTableBody(buTable, window.tableconf[0], newData, RESOURCE);
    buTable.adjustDataRows();
}

function delBuTableRow()
{
	  if (buTable.getDataRowLength() <= 0) 
    {
        return;
    }
    
    buTable.deleteRow(buTable.getDataRowLength() - 1);
    
    buTable.adjustDataRows();
}

/**
 *                     
 * @return   
 */
function addCellEvent()
{
    var cell;
    var editelement;
    
    var spanNumber = rptTable.getAtom("segmentNum").getValue();
    
    for (var i = 0, tbLen = buTable.getDataRowLength(); i < tbLen; i++)//        
     {
        cell = buTable.getCell(i, "eqptType");
        var eqptType = buTable.getCellStoreValue(i, "eqptType", "eqptType");
        cell.element.editElement.element["onchange"] = function()
        {
            var rowindex = this.parentNode.parentNode.rowIndex;
            var cpcel2 = buTable.getCell(rowindex, "eqptName");
            if (this.value != "3") 
            {
                buTable.setCellIsEdit(cpcel2, 1);
                cpcel2.element.showElement.setValue("");
                buTable.setCellValue(cpcel2, "eqptName", "");
                cpcel2.element.editElement.element.style.imeMode = "disabled";
                cpcel2.element.editElement.element.maxLength = 8;
                cpcel2.element.editElement.element["onkeypress"] = function()
                {
                    if (!restrict(this, event, "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")) 
                    {
                        return false;
                    }
                    return true;
                }
            }
            else 
            {
                buTable.setCellIsEdit(cpcel2, 0);
                cpcel2.element.showElement.setValue("");
                buTable.setCellValue(cpcel2, "eqptName", "");
            }
        }
        
        cell = buTable.getCell(i, "eqptName");
        if (eqptType == "3") 
        {
            buTable.setCellIsEdit(cell, 0);
            cell.element.showElement.setValue("");
            buTable.setCellValue(cell, "eqptName", "");
        }
        else 
        {
            buTable.setCellIsEdit(cell, 1);
            cell.element.editElement.element.style.imeMode = "disabled";
            cell.element.editElement.element.maxLength = 8;
            cell.element.editElement.element["onkeypress"] = function()
            {
                if (!restrict(this, event, "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")) 
                {
                    return false;
                }
                return true;
            }
        }
        
        cell = buTable.getCell(i, "spanId");
        textCheck(cell.element.editElement.element, "1", spanNumber, 1);
        var spanId = buTable.getCellStoreValue(i, "spanId", "spanId");
        /*
        cell.element.editElement.element["onkeyup"] = function()
        {
        	var rowindex = this.parentNode.parentNode.rowIndex;
          var fiberLength = 80.0;
	        for (var j = 0, k = fiberLengthList.length; j < k; j++)
	        {
	        	if (this.value == fiberLengthList[j].spanNo)
	        	{
	        		fiberLength = fiberLengthList[j].fiberLength;
	        		break;
	        	}
	        }
	        
	        var cell1 = buTable.getCell(rowindex, "eqptPos");
	        textCheck(cell1.element.editElement.element, "0.1", fiberLength - 0.1);
        }*/
        if (parseInt(spanId) > parseInt(spanNumber))
        {
        	cell.element.showElement.setValue("");
        	buTable.setCellValue(cell, "spanId", "");
        }
        
        var fiberLength = 80.0;
        for (var j = 0, k = fiberLengthList.length; j < k; j++)
        {
        	if (spanId == fiberLengthList[j].spanNo)
        	{
        		fiberLength = fiberLengthList[j].fiberLength;
        		break;
        	}
        }
        
        cell = buTable.getCell(i, "eqptPos");
        textCheck(cell.element.editElement.element, "0.1", fiberLength - 0.1);
        
        
        var isSameFlag = buTable.getCellStoreValue(i, "isSameFlag", "isSameFlag");
        if ("false" == isSameFlag)
        {
        	setCellColor(buTable, i, "eqptType");
        	setCellColor(buTable, i, "eqptName");
        	setCellColor(buTable, i, "spanId");
        	setCellColor(buTable, i, "eqptPos");
        }
    }
}

/**
 * Repeater               
 * @param   
 * @return   
 */
function repeaterNumChangeListener()
{
    if ("" == rptTable.getAttrValue("repeaterNum")) 
    {
        rptTable.setAttrValue("segmentNum", "");
        return;
    }
    rptTable.setAttrValue("segmentNum", parseInt(rptTable.getAttrValue("repeaterNum")) + 1);

    addCellEvent();
}


function isModifyBu()
{
	if(isModifyBUTable)
	{
		return true;
	}
	
	if (initDataList[19] != curDataList[19])
	{
		return true;
	}
	
	for (var rowIndex = 0, rowLen = buTable.getDataRowLength(); rowIndex < rowLen; rowIndex++)
	{
		if (buTable.getModify(rowIndex))
		{
			return true;
		}
	}
	return false;
}

function getCurPageData()
{
	curDataList.push(newLineSrcTable.getAtom("srcNE").getValue());
	curDataList.push(newLineSrcTable.getAtom("lineMonitorUnit").getValue());
	curDataList.push(newLineSrcTable.getAtom("lineAmplifierUnit").getValue());
	curDataList.push(newLineSrcTable.getAtom("lineInterfaceUnit").getValue());
	curDataList.push(newLineSrcTable.getAtom("probeWaveType").getValue());
	curDataList.push(newLineSrcTable.getAtom("probeWaveNo").getValue());
	curDataList.push(newLineSrcTable.getAtom("loadingWaveType").getValue());
	curDataList.push(newLineSrcTable.getAtom("loadingWaveNo").getValue());
	
	curDataList.push(newLineSinkTable.getAtom("sinkNE").getValue());
	curDataList.push(newLineSinkTable.getAtom("lineMonitorUnit").getValue());
	curDataList.push(newLineSinkTable.getAtom("lineAmplifierUnit").getValue());
	curDataList.push(newLineSinkTable.getAtom("lineInterfaceUnit").getValue());
	curDataList.push(newLineSinkTable.getAtom("probeWaveType").getValue());
	curDataList.push(newLineSinkTable.getAtom("probeWaveNo").getValue());
	curDataList.push(newLineSinkTable.getAtom("loadingWaveType").getValue());
	curDataList.push(newLineSinkTable.getAtom("loadingWaveNo").getValue());
	
	curDataList.push(rptTable.getAtom("repeaterNum").getValue());
	curDataList.push(rptTable.getAtom("segmentNum").getValue());
	curDataList.push(rptTable.getAtom("remark").getValue());
	curDataList.push(rptTable.getAtom("buEquipmentNum").getValue());
}

function isModifyRpt()
{
  /*
	for (var i = 4, len = 8; i < len; i++)
	{
		if (initDataList[i] != curDataList[i])
		{
			return true;
		}
	}
	
	for (var i = 12, len = 16; i < len; i++)
	{
		if (initDataList[i] != curDataList[i])
		{
			return true;
		}
	}*/
	
	for (var i = 16, len = initDataList.length - 1; i < len; i++)
	{
		if (initDataList[i] != curDataList[i])
		{
			return true;
		}
	}
	return false;
}

function isModifyPort()
{
  /*
	for (var i = 0, len = 4; i < len; i++)
	{
		if (initDataList[i] != curDataList[i])
		{
			return true;
		}
	}
	
	for (var i = 8, len = 12; i < len; i++)
	{
		if (initDataList[i] != curDataList[i])
		{
			return true;
		}
	}*/

  for (var i = 0, len = 16; i < len; i++)
	{
		if (initDataList[i] != curDataList[i])
		{
			return true;
		}
	}
	
	return false;
}

/**
 * @param   
 * @return   
 */
function doModifyLineInfo()
{
    getCurPageData();
    
    isModifyRptTable = isModifyRpt();
    isModifyPortTable = isModifyPort();
    isModifyBUTable = isModifyBu() || isModifyRptTable;
    
    if (!isModifyPortTable && !isModifyRptTable && !isModifyBUTable)
    {
    	xcloseDialog();
    }
   
    if (isModifyPortTable)
    {
	
	  var srcLasPort = newLineSrcTable.getAtom("lineAmplifierUnit").getValue();
	    var srcLmiPort = newLineSrcTable.getAtom("lineInterfaceUnit").getValue();
	    var sinkLasPort = newLineSinkTable.getAtom("lineAmplifierUnit").getValue();
	    var sinkLmiPort = newLineSinkTable.getAtom("lineInterfaceUnit").getValue();
	    
	    if("" == srcLasPort || "" == srcLmiPort || "" == sinkLasPort || "" == sinkLmiPort)
			{
				alert(RESOURCE["noAvailableResource"]);
				return;
			}
			
			var srcProbeWaveBand = newLineSrcTable.getAtom("probeWaveType").getValue();
	    var srcprobeWaveIndex = newLineSrcTable.getAtom("probeWaveNo").getValue();
	    var srcLoadingWaveBand = newLineSrcTable.getAtom("loadingWaveType").getValue();
	    var srcLoadingWaveIndex = newLineSrcTable.getAtom("loadingWaveNo").getValue();
	    
	    if("" == srcProbeWaveBand || "" == srcprobeWaveIndex || "" == srcLoadingWaveBand || "" == srcLoadingWaveIndex)
			{
				alert(RESOURCE["LMUBoardNotInPosition"]);
				return;
			}
		}
		
    if (isModifyBUTable)
    {
		
    var buNumber = rptTable.getAtom("buEquipmentNum").getValue();
		    var eqptNameList = [];
				for (var index = 0; index < buNumber; index++) 
		    {
					var spanId = buTable.getCellStoreValue(index, "spanId", "spanId");
			    var eqptType = buTable.getCellStoreValue(index, "eqptType", "eqptType");
			    var eqptPos = buTable.getCellStoreValue(index, "eqptPos", "eqptPos");
			    var eqptName = buTable.getCellStoreValue(index, "eqptName", "eqptName");
			    if ("3" != eqptType)
			    {
			    	eqptNameList.push(eqptName);
			    }
			    
			    
			    if (null == spanId || "" == spanId || "0" == spanId
			    || null == eqptType || "" == eqptType
			    || null == eqptPos || "" == eqptPos || "0" == eqptPos
			    || ((null == eqptName || "" == eqptName) && "3" != eqptType) || "NO NAME" == eqptName)
			    {
			    	alert(RESOURCE["eqmiswrong"]);
			    	return;
			    }
		    }
		    
		    var len = eqptNameList.length
		    for(var i = 0; i < len; i++)
		    {
		    	for(var j = 0; j < len; j++)
		    	{
		    		if (i == j)
		    		{
		    			continue;
		    		}
		    		
		    		if (eqptNameList[i] == eqptNameList[j])
		    		{
		    			alert(RESOURCE["eqmrepeated"]);
			    	  return;
		    		}
		    	}
		    }
		    
		    var eqptPosList = [];
				var isEqmatsamepos = false;
				for (var index = 0; index < buNumber; index++) 
				{
					var spanId = buTable.getCellStoreValue(index, "spanId", "spanId");
					var eqptPos = buTable.getCellStoreValue(index, "eqptPos", "eqptPos");
					
					for (var j = 0, k = eqptPosList.length; j < k; j++)
			    {
			    	if (spanId == eqptPosList[j].spanNo && eqptPos == eqptPosList[j].fiberLength)
			      {
			      	isEqmatsamepos = true;
			        break;
			      }
			    }
					
					if (isEqmatsamepos)
					{
						alert(RESOURCE["eqmatsamepos"]);
						return;
					}
					
					var crossspan = new TESLMLineCrossSpan(spanId, eqptPos);
					eqptPosList.push(crossspan);
				}
		}
		
    $("okBtn").disabled = true;
    $("cancelBtn").disabled = true;
    var data = createModifyLineXML();
    if (null == data) 
    {
        alert(RESOURCE["checkDataInfo"]);
        $("okBtn").disabled = false;
        $("cancelBtn").disabled = false;
        return;
    }
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_MODIFY_LINE + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST", sync, callbackModifyLineData, null, "inputdata=" + data);
}


function createModifyLineXML()
{
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var buNumber = rptTable.getAtom("buEquipmentNum").getValue();
    
    
    if (null != newLineSrcTable.getAtom("srcNE") && 0 != newLineSrcTable.getAtom("srcNE").getValue())
    {
    	  createSrcLineXML(buNumber, bussiness);	
    }
    
    if (0 != newLineSinkTable.getAtom("sinkNE").getValue()) 
    {
        createSinkLineXML(buNumber, bussiness);
    }
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

function createSinkLineXML(buNumber, bussiness)
{
    if (0 == buNumber) 
    {
        var row = new tagElement("row-params");
        createLineXMLData(row, newLineSinkTable, DIRECTION_WEST, newLineSrcTable);
        param = new tagElement("param");
        param.setAttribute("name", "eqptNum");
        param.setAttribute("value", "0");
        row.appendChild(param);
        bussiness.appendChild(row);
        return;
    }
    for (var index = 0; index < buNumber; index++) 
    {
        var row = new tagElement("row-params");
        createLineXMLData(row, newLineSinkTable, DIRECTION_WEST, newLineSrcTable);
        createLineBUXMLData(row, index, buNumber);
        bussiness.appendChild(row);
    }
}

function createSrcLineXML(buNumber, bussiness)
{
    if (0 == buNumber) 
    {
        var row = new tagElement("row-params");
        createLineXMLData(row, newLineSrcTable, DIRECTION_EAST, newLineSinkTable);
        param = new tagElement("param");
        param.setAttribute("name", "eqptNum");
        param.setAttribute("value", "0");
        row.appendChild(param);
        bussiness.appendChild(row);
        return;
    }
    for (var index = 0; index < buNumber; index++) 
    {
        var row = new tagElement("row-params");
        createLineXMLData(row, newLineSrcTable, DIRECTION_EAST, newLineSinkTable);
        createLineBUXMLData(row, index, buNumber);
        bussiness.appendChild(row);
    }
}

function createLineBUXMLData(row, index, buNumber)
{
    var param = new tagElement("param");
    param.setAttribute("name", "eqptNum");
    param.setAttribute("value", buNumber);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "eqptId");
    param.setAttribute("value", (index + 1));
    row.appendChild(param);
    
    var spanId = buTable.getCellStoreValue(index, "spanId", "spanId");
    var param = new tagElement("param");
    param.setAttribute("name", "spanId");
    param.setAttribute("value", spanId);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "eqptType");
    param.setAttribute("value", buTable.getCellStoreValue(index, "eqptType", "eqptType"));
    row.appendChild(param);
    
    var fiberLength = 80.0;
    for (var j = 0, k = fiberLengthList.length; j < k; j++)
    {
    	if (spanId == fiberLengthList[j].spanNo)
      {
      	fiberLength = fiberLengthList[j].fiberLength;
        break;
      }
    }
	  var eqptDistanceLength = fiberLength * 10;
	  var param = new tagElement("param");
	  param.setAttribute("name", "eqptDistanceLength");
	  param.setAttribute("value", eqptDistanceLength);
	  row.appendChild(param);
	  
    var param = new tagElement("param");
    param.setAttribute("name", "eqptDistance");
    param.setAttribute("value", parseFloat(buTable.getCellStoreValue(index, "eqptPos", "eqptPos")) * 10);
    row.appendChild(param);
    
    var eqptName = buTable.getCellStoreValue(index, "eqptName", "eqptName");
    if (null == eqptName)
    {
    	eqptName = "";
    }
    var param = new tagElement("param");
    param.setAttribute("name", "eqptName");
    param.setAttribute("value", eqptName);
    row.appendChild(param);
}

function getNEInfo(neName, direction)
{
    if (DIRECTION_EAST == direction) 
    {
        return curNEInfo;
    }
    else 
    {
        return getNEInfoFromNEListByNEName(neName, sinkNEList);
    }
}

function getOPNEInfo(neName, direction)
{
    if (DIRECTION_EAST == direction) 
    {
        return getNEInfoFromNEListByNEName(neName, sinkNEList);
    }
    else 
    {
        return curNEInfo;
    }
}

function createLineXMLData(row, createLineTable, direction, opCreateLineTable)
{
    var neStr = "srcNE";
    var opNEStr = "sinkNE"
    if (DIRECTION_WEST == direction) 
    {
        neStr = "sinkNE";
        opNEStr = "srcNE";
    }
    var neName = createLineTable.getAtom(neStr).getValue();
    var neInfo = getNEInfo(neName, direction);
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neInfo.neid);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "neName");
    param.setAttribute("value", neName);
    row.appendChild(param);
    
	  var selectedRow = parentWin.slmLineTable.getSelectedRows();
		var srcNEID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "srcNEID", "srcNEID");
		var sinkNEID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "sinkNEID", "sinkNEID");
	  if (null == srcNEID || UNKNOWN == srcNEID)
	  {
	  	srcNEID = 0;
	  }
	  param = new tagElement("param");
	  param.setAttribute("name", "srcneid");
	  param.setAttribute("value", srcNEID);
	  row.appendChild(param);
	    
	  if (null == sinkNEID || UNKNOWN == sinkNEID)
	  {
	    sinkNEID = 0;
	  }
	  param = new tagElement("param");
	  param.setAttribute("name", "sinkneid");
	  param.setAttribute("value", sinkNEID);
	  row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "lineID");
    param.setAttribute("value", lineID);
    row.appendChild(param);
    
    
    var lmuTEPort = getTEPort(createLineTable.getAtom("lineMonitorUnit").getValue(), neInfo.lmuPortList);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmuSlot");
    param.setAttribute("value", lmuTEPort.slotId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmuPortId");
    param.setAttribute("value", lmuTEPort.portId);
    row.appendChild(param);
    
    var lasTEPort = getTEPort(createLineTable.getAtom("lineAmplifierUnit").getValue(), neInfo.lasPortList);
    
    param = new tagElement("param");
    param.setAttribute("name", "lasSlot");
    param.setAttribute("value", lasTEPort.slotId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lasPort");
    param.setAttribute("value", lasTEPort.portId);
    row.appendChild(param);
    
    var lmiTEPort = getTEPort(createLineTable.getAtom("lineInterfaceUnit").getValue(), neInfo.lmiPortList);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmiSlot");
    param.setAttribute("value", lmiTEPort.slotId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmiPortId");
    param.setAttribute("value", lmiTEPort.portId);
    row.appendChild(param);
    
    var opNEName = opCreateLineTable.getAtom(opNEStr).getValue();
    
    var opNEInfo = getOPNEInfo(opNEName, direction);
    
    var opNEID = 0;
    if (null != opNEInfo) 
    {
        opNEID = opNEInfo.neid;
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "opNeID");
    param.setAttribute("value", opNEID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "opNEName");
    param.setAttribute("value", opNEName);
    row.appendChild(param);
    
    var opLMISlotId = 0;
    if (0 != opCreateLineTable.getAtom("lineInterfaceUnit").getValue()) 
    {
        var lmiTEPort = getTEPort(opCreateLineTable.getAtom("lineInterfaceUnit").getValue(), opNEInfo.lmiPortList);
        
        opLMISlotId = lmiTEPort.slotId;
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "opLmiSlot");
    param.setAttribute("value", opLMISlotId);
    row.appendChild(param);
    
    if ("0" == lineDirection && DIRECTION_WEST == direction)
    {
    	direction = DIRECTION_EAST;
    }
    
    if ("0" == lineDirection && DIRECTION_EAST == direction)
    {
    	direction = DIRECTION_WEST;
    }
    param = new tagElement("param");
    param.setAttribute("name", "lineDirection");
    param.setAttribute("value", direction);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "probeWaveBand");
    var tmpValue = createLineTable.getAtom("probeWaveType").getValue();
    if (null == tmpValue || "" == tmpValue) 
    {
        tmpValue = 0;
    }
    param.setAttribute("value", tmpValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "probeWaveIndex");
    tmpValue = createLineTable.getAtom("probeWaveNo").getValue();
    if (null == tmpValue || "" == tmpValue) 
    {
        tmpValue = 0;
    }
    param.setAttribute("value", tmpValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "loadingWaveBand");
    tmpValue = createLineTable.getAtom("loadingWaveType").getValue();
    if (null == tmpValue || "" == tmpValue) 
    {
        tmpValue = 0;
    }
    param.setAttribute("value", tmpValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "loadingWaveIndex");
    tmpValue = createLineTable.getAtom("loadingWaveNo").getValue();
    if (null == tmpValue || "" == tmpValue) 
    {
        tmpValue = 0;
    }
    param.setAttribute("value", tmpValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "spanNum");
    param.setAttribute("value", rptTable.getAtom("segmentNum").getValue());
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "lineRemark");
    param.setAttribute("value", rptTable.getAtom("remark").getValue());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isModifyPortTable");
    param.setAttribute("value", isModifyPortTable);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isModifyRptTable");
    param.setAttribute("value", isModifyRptTable);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isModifyBUTable");
    param.setAttribute("value", isModifyBUTable);
    row.appendChild(param);
}

/**
 *                   
 * @param doc
 * @return   
 */
function callbackModifyLineData(doc)
{
    var data = EncapsulateData(doc);
    var errorCode = data.getSErrorCode();
    if (0 == errorCode || 1 == errorCode) 
    {
        parentWin.doQueryLineInfo();
        
        if (0 == errorCode)
        {
          xcloseDialog();
        }
    }
    showOperResult(data);
    $("okBtn").disabled = false;
    $("cancelBtn").disabled = false;
}


/**
 *            
 * @param doc
 * @return   
 */
function doCancel()
{
    xcloseDialog();
}

/**
 *      LMI                           
 * @return   
 */
Object.prototype.toString = function()
{
    return this.neName;
}
