var bandTypeList = [];
bandTypeList[0] = "C+L";
bandTypeList[1] = "C";
bandTypeList[2] = "L";
bandTypeList[3] = "C320G";
bandTypeList[4] = "LMC";
bandTypeList[5] = "LML";
bandTypeList[6] = "CWDM";

var waveLengthList = null;

/**
 *                 
 */
var color_select = "#006098";  //dark green
var color_desel = "#ffffff";   //white
var color_nonedit = "#E8E8E8"; //grey
var color_edited = "#d0f946";  //green
var color_error = "#FF0000";  //red

/**
 *        
 */
var color_select1 = "#6f99a5";  //dark green
var color_desel1 = "#ffffff";   //white
var color_nonedit1 = "#E8E8E8"; //grey
var color_edited1 = "#d0f946";  //green

/**
 *        
 * @param    
 * @return    
 */
function setCellSelected(st, row, colid)
{
		var cell = st.getCellElement(row, colid);
		var color = color_desel1;
		
		if (st.getRowSelFlag(row))
		{
				color = color_select1;
		}
		else if (cell.isEdit == 0)
		{
				color = color_nonedit1;
		}
		else if (cell.modify)
		{
				color = color_edited1;
		}
		
		cell.style.backgroundColor = color;
}

/**
 *                 
 * @param    
 * @return    
 */
function setCellColor(st, row, colid)
{
		var cell = st.getCellElement(row, colid);
		var color = color_desel;
		
		if (cell.isEdit == 0)
		{
				color = color_select;
		}
		else
		{
				color = color_error;
		}
		
		cell.style.backgroundColor = color;
}


/**
 *       neid, slotId   portId                
 * @param    
 * @return    
 */
function getPort(neid, slotId, portId, portArray)
{
	for (var i = 0, len = portArray.length; i < len; i++)
	{
		if (neid == portArray[i].neid && slotId == portArray[i].slotId && portId == portArray[i].portId)
		{
			return portArray[i];
		}
	}
}
/**
 *       neid, slotId                (LSU      )
 * @param    
 * @return    
 */
function getLSUPort(neid, slotId, portArray)
{
	for (var i = 0, len = portArray.length; i < len; i++)
	{
		if (neid == portArray[i].neid && slotId == portArray[i].slotId)
		{
			return portArray[i];
		}
	}
}
/**
 *       neid    slotId   portId                        
 * @param    
 * @return    
 */
function refreshTEPort(neid, slotId, portId, portArray)
{
	for (var i = portArray.length - 1; i >= 0 ; i--)
	{
		if (neid == portArray[i].neid && slotId == portArray[i].slotId && portId == portArray[i].portId)
		{
			portArray.splice(i, 1);
			continue;
		}
	}
}
/**
 *       neid    slotId   portId                
 * @param    
 * @return    
 */
function getTEPortIndex(neid, slotId, portId, portArray)
{
	for (var i = 0, len = portArray.length; i < len; i++)
	{
		if (neid == portArray[i].neid && slotId == portArray[i].slotId && portId == portArray[i].portId)
		{
			return i;
		}
	}
	return -1;
}

/**
 *                EPort      
 * @param portMap
 * @param portArray
 * @return    
 */
function getTEPort(portMap, portArray)
{
	var slotId = portMap.split("-")[0];
	var portId = portMap.split("-")[2].split("(")[0];
	for(var i = 0, len = portArray.length; i < len; i++)
	{
		if(parseInt(slotId) == portArray[i].slotId && parseInt(portId) == portArray[i].portId)
		{
			return portArray[i];
		}
	}
	return null;
}

/**
 *                       MI TEPort      
 * @param portMap
 * @param portArray
 * @return    
 */
function getLMITEPort(neid, portMap, portArray)
{
	var slotId = portMap.split("-")[0];
	var portId = portMap.split("-")[2].split("(")[0];
	for(var i = 0, len = portArray.length; i < len; i++)
	{
		if(parseInt(neid) == portArray[i].neid && parseInt(slotId) == portArray[i].slotId && parseInt(portId) == portArray[i].portId)
		{
			return portArray[i];
		}
	}
	return null;
}
/**
 *     LSU          
 * @param    
 * @return    
 */

function getSelectUnit(selectedRow, availableLineData, lsuPortData)
{
	var lineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
	var neid;
	var slotId;
	for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++)
	{
		if(lineID == availableLineData.getDataRowParam(index, "lineID"))
		{
			neid = availableLineData.getDataRowParam(index, "lsuneid");
			slotId = availableLineData.getDataRowParam(index, "lsuSlotId");
		}
	}
	for (var i = 0, len = lsuPortData.length; i < len; i++)
	{
		if (neid == lsuPortData[i].neid && slotId == lsuPortData[i].slotId)
		{
			return lsuPortData[i];
		}
	}
	return null;
}
/**
 *     LMI          
 * @param    
 * @return    
 */
function getInterfaceNE(selectedRow, availableLineData, lmiPortData)
{
	var lineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
	var neid;
	var slotId;
	for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++)
	{
		if(lineID == availableLineData.getDataRowParam(index, "lineID"))
		{
			neid = availableLineData.getDataRowParam(index, "lmineid");
			slotId = availableLineData.getDataRowParam(index, "lmiSlotId");
		}
	}
	for (var i = 0, len = lmiPortData.length; i < len; i++)
	{
		if (parseInt(neid) == lmiPortData[i].neid)
		{
			return lmiPortData[i];
		}
	}
	return null;
}

/**
 *       TEPort      
 * @param data
 * @param index
 * @return    
 */
function createTEPort(data, lmuPortWaveLen, index)
{
	var neid = data.getDataRowParam(index, "neid");
	var neName = data.getDataRowParam(index, "neName");
	var slotId = data.getDataRowParam(index, "slotId");
	var boardType = data.getDataRowParam(index, "boardType");
	var boardName = data.getDataRowParam(index, "boardName");
	var portId = data.getDataRowParam(index, "portId");
	var portName = data.getDataRowParam(index, "portName");
	
	var tmpPort = new TEPort(neid, neName, slotId, boardName, boardType, portId, portName);
	if (null != lmuPortWaveLen)
	{
		getPortWaveLen(tmpPort, lmuPortWaveLen);	
	}
	return tmpPort;
}

/**
 *       TEPort      
 * @param data
 * @param index
 * @return    
 */
function addTEPort(tmpPort, lmuPortWaveLen)
{
	if (null != lmuPortWaveLen)
	{
		getPortWaveLen(tmpPort, lmuPortWaveLen);	
	}
	return tmpPort;
}

/**
 *              
 * @param portInfo
 * @param lmuPortWaveLen
 * @return    
 */
function getPortWaveLen(portInfo, lmuPortWaveLen)
{
	var lmuNEID;
	var lmuSlotID;
	var lmuPortID;
	var waveType;
	var waveNo;
	var boardType = portInfo.boardType;
	for (var i = 0, len = lmuPortWaveLen.getDataRowLength(); i < len; i++)
	{
		  if (SLM_TNB2LMU_BOARDTYPE == boardType)
		  {
		  	lmuNEID = parseInt(lmuPortWaveLen.getDataRowParam(i,"neid"));
	   	  lmuSlotID = parseInt(lmuPortWaveLen.getDataRowParam(i,"lmuSlot"));
		    lmuPortID = parseInt(lmuPortWaveLen.getDataRowParam(i,"lmuPort"));
		    lmuPath = parseInt(lmuPortWaveLen.getDataRowParam(i,"lmuPath"));
		    waveType = parseInt(lmuPortWaveLen.getDataRowParam(i,"waveType"));
		    waveNo = parseInt(lmuPortWaveLen.getDataRowParam(i,"waveNo"));
		    
		    if (lmuNEID == portInfo.neid && lmuSlotID == portInfo.slotId && lmuPortID == portInfo.portId)
		    {
		    	switch (lmuPath)
					{
						case 1:
							portInfo.addLoadingWave(waveType, waveNo);
							break;
						case 2:
							portInfo.addProbeWave(waveType, waveNo);
							break;
						case 3:
							portInfo.addProbeWave(waveType, waveNo);
							break;
						default:
							break;
					}
		    }
		  }	      
  }	
}

function getLASPortFromLineData(neid, index, availableLineData)
{
	var tmpNEID = availableLineData.getDataRowParam(index, "srcLasneid");
	var tmpSlotID = availableLineData.getDataRowParam(index, "srcLasSlotId");
	var tmpPortID = availableLineData.getDataRowParam(index, "srcLasPortId");
	
	if (tmpNEID != neid)
	{
		tmpNEID = availableLineData.getDataRowParam(index, "sinkLasneid");
		tmpSlotID = availableLineData.getDataRowParam(index, "sinkLasSlotId");
	  tmpPortID = availableLineData.getDataRowParam(index, "sinkLasPortId");
	}
	
	return new TEPort(tmpNEID, "", tmpSlotID, "", SLM_TNB2LAS_BOARDTYPE, tmpPortID, "");
}

function getLMIPortFromLineData(neid, index, availableLineData)
{
	var tmpNEID = availableLineData.getDataRowParam(index, "srcLmineid");
	var tmpSlotID = availableLineData.getDataRowParam(index, "srcLmiSlotId");
	var tmpPortID = availableLineData.getDataRowParam(index, "srcLmiPortId");
	
	if (tmpNEID != neid)
	{
		tmpNEID = availableLineData.getDataRowParam(index, "sinkLmineid");
		tmpSlotID = availableLineData.getDataRowParam(index, "sinkLmiSlotId");
	  tmpPortID = availableLineData.getDataRowParam(index, "sinkLmiPortId");
	}
	
	return new TEPort(tmpNEID, "", tmpSlotID, "", SLM_TNB2LMI_BOARDTYPE, tmpPortID, "");
}


function getNEInfoData(slmNEID, slmNEList)
{
	var tmpNEData = null;
	for(var i = 0, len = slmNEList.length; i < len; i++)
	{
		tmpNEData = slmNEList[i];
		if (slmNEID == tmpNEData.neid)
		{
			return tmpNEData;
		}
	}
	return null;
}


function haveNEData(slmNEID, slmNEList)
{
	var tmpNEData;
	for(var i = 0, len = slmNEList.length; i < len; i++)
	{
		tmpNEData = slmNEList[i];
		if (slmNEID == tmpNEData.neid)
		{
			return true;
		}
	}
	return false;
}

/**
 *        CTable                 ?
 * @param    
 * @return    
 */
function createOption(cTableAtomEle, portDataArray)
{
	cTableAtomEle.options.length = 0;
	for (var i = 0, len = portDataArray.length; i < len; i++)
	{
		var index = getInsertIndex(cTableAtomEle, portDataArray[i])
		if(-1 != index)
		{
			cTableAtomEle.options.add(new Option(portDataArray[i].toString(), portDataArray[i]), index);
		}
	}
}

/**
 *                     
 * @param cTableAtomEle
 * @param portMap
 * @return    
 */
function selectOptionLASSlot(cTableAtomEle, lasSlotId)
{
	if ("" == lasSlotId)
	{
		return 0;
	}
	
	if (0 == cTableAtomEle.options.length)
	{
		return 0;
	}
	
	for (var i = 0, len = cTableAtomEle.options.length; i < len; i++)
	{
		var opt = cTableAtomEle.options[i].value;
		
		var tmpSlotId = opt.split("-")[0];
		var tmpPortId = opt.split("-")[2].split("(")[0];
		
		if (lasSlotId == tmpSlotId)
		{
			return i;
		}
	}
	
	return 0;
}

/**
 *                     
 * @param cTableAtomEle
 * @param portMap
 * @return    
 */
function selectOptionTEPort(cTableAtomEle, portMap)
{
	if (null == portMap)
	{
		return 0;
	}
	
	if (0 == cTableAtomEle.options.length)
	{
		return 0;
	}
	
	var slotId = portMap.split("-")[0];
	var portId = portMap.split("-")[2].split("(")[0];
	
	for (var i = 0, len = cTableAtomEle.options.length; i < len; i++)
	{
		var opt = cTableAtomEle.options[i].value;
		
		var tmpSlotId = opt.split("-")[0];
		var tmpPortId = opt.split("-")[2].split("(")[0];
		
		if ((slotId == tmpSlotId) && (portId == tmpPortId))
		{
			return i;
		}
	}
	
	return 0;
}

/**
 *                     
 * @param cTableAtomEle
 * @param portMap
 * @return    
 */
function selectOptionTEPortLMI(cTableAtomEle, portMap)
{
	if (null == portMap)
	{
		return 0;
	}
	
	if (0 == cTableAtomEle.options.length)
	{
		return 0;
	}
	
	var slotId = portMap.split("-")[0];
	var portId = portMap.split("-")[2].split("(")[0];
	
	for (var i = 0, len = cTableAtomEle.options.length; i < len; i++)
	{
		var opt = cTableAtomEle.options[i].value;
		
		var tmpSlotId = opt.split("-")[0];
		var tmpPortId = opt.split("-")[2].split("(")[0];
		
		if (slotId == tmpSlotId)
		{
			return i;
		}
	}
	
	return 0;
}


/**
 *        CTable                 ?            )
 * @param    
 * @return    
 */
function createNullOption(cTableAtomEle)
{
	cTableAtomEle.options.length = 0;

	cTableAtomEle.options.add(new Option("-", 0));
}

/**
 *        CTable                 ?NE    ?
 * @param    
 * @return    
 */
function createNEOption(cTableAtomEle, sinkNEList)
{
	cTableAtomEle.options.length = 0;
	var slmNEInfo;
	for (var i = 0, len = sinkNEList.length; i < len; i++)
	{
		slmNEInfo = sinkNEList[i];
		var index = slmNEInfo.neid;
		if(-1 != index)
		{
			cTableAtomEle.options.add(new Option(slmNEInfo.toString(), slmNEInfo), index);
		}
	}
}

/**
 *        CTable                 ?            )
 * @param    
 * @return    
 */
function createProbeWaveTypeOption(cTableAtomEle, lmuTEPort)
{
	cTableAtomEle.options.length = 0;
	
	if (null == waveLengthList)
	{
		return;
	}
	
	for (var i = 0, len = waveLengthList.bandType.length; i < len; i++)
	{
		  if (null != waveLengthList.bandType[i].id)
		  {
		  	  for (var j = 0, k = lmuTEPort.probeWaveArrays.length; j < k; j++)
		  	  {
		  	  	var waveInfo = lmuTEPort.probeWaveArrays[j];
		  	  	if (waveInfo.waveType == waveLengthList.bandType[i].value)
		  	  	{
			        cTableAtomEle.options.add(new Option(waveLengthList.bandType[i].id, waveLengthList.bandType[i].value));
			        break;
		  	  	}
		  	  }
		  }
	}
}

/**
 *        CTable                 ?            )
 * @param    
 * @return    
 */
function createLoadingWaveTypeOption(cTableAtomEle, lmuTEPort)
{
	cTableAtomEle.options.length = 0;
	
	if (null == waveLengthList)
	{
		return;
	}
	
	for (var i = 0, len = waveLengthList.bandType.length; i < len; i++)
	{
		  if (null != waveLengthList.bandType[i].id)
		  {
		  	  for (var j = 0, k = lmuTEPort.loadingWaveArrays.length; j < k; j++)
		  	  {
		  	  	var waveInfo = lmuTEPort.loadingWaveArrays[j];
		  	  	if (waveInfo.waveType == waveLengthList.bandType[i].value)
		  	  	{
			        cTableAtomEle.options.add(new Option(waveLengthList.bandType[i].id, waveLengthList.bandType[i].value));
			        break;
		  	  	}
		  	  }
		  }
	}
}

/**
 *                     
 * @param cTableAtomEle
 * @param portMap
 * @return    
 */
function selectBandTypeOption(cTableAtomEle, bandType)
{
	if (null == bandType)
	{
		return 0;
	}
	
	if (0 == cTableAtomEle.options.length)
	{
		return 0;
	}
	
	for (var i = 0, len = cTableAtomEle.options.length; i < len; i++)
	{
		var opt = cTableAtomEle.options[i].value;
		
		if (bandType == opt)
		{
			return i;
		}
	}
	
	return 0;
}

/**
 *        CTable                 ?       )
 * @param    
 * @return    
 */
function createProbeWaveLengthOption(cTableAtomEle, bandTypeValue, lmuTEPort)
{
	cTableAtomEle.options.length = 0;
	
	if (null == waveLengthList)
	{
		return;
	}
	
  for (var i = 0, len = waveLengthList.bandType.length; i < len; i++)
	{
	    if (bandTypeValue == waveLengthList.bandType[i].value)
	    {
	    	for (var j = 0, k = waveLengthList.bandType[i].options.length; j < k; j++)
	    	{
	    		for (var a = 0, b = lmuTEPort.probeWaveArrays.length; a < b; a++)
		  	  {
		  	  	var waveInfo = lmuTEPort.probeWaveArrays[a];
		  	  	if ((waveInfo.waveType == waveLengthList.bandType[i].value)
		  	  	   && (waveInfo.waveNo == waveLengthList.bandType[i].options[j].value))
		  	  	{
			        cTableAtomEle.options.add(new Option(waveLengthList.bandType[i].options[j].text, waveLengthList.bandType[i].options[j].value));
		  	  	}
		  	  }
	    	}
	    }
	}
}

/**
 *        CTable                 ?       )
 * @param    
 * @return    
 */
function createLoadingWaveLengthOption(cTableAtomEle, bandTypeValue, lmuTEPort)
{
	cTableAtomEle.options.length = 0;
	
	if (null == waveLengthList)
	{
		return;
	}
	
  for (var i = 0, len = waveLengthList.bandType.length; i < len; i++)
	{
	    if (bandTypeValue == waveLengthList.bandType[i].value)
	    {
	    	for (var j = 0, k = waveLengthList.bandType[i].options.length; j < k; j++)
	    	{
	    		for (var a = 0, b = lmuTEPort.loadingWaveArrays.length; a < b; a++)
		  	  {
		  	  	var waveInfo = lmuTEPort.loadingWaveArrays[a];
		  	  	if ((waveInfo.waveType == waveLengthList.bandType[i].value)
		  	  	   && (waveInfo.waveNo == waveLengthList.bandType[i].options[j].value))
		  	  	{
			        cTableAtomEle.options.add(new Option(waveLengthList.bandType[i].options[j].text, waveLengthList.bandType[i].options[j].value));
		  	  	}
		  	  }
	    	}
	    }
	}
}

/**
 *                     
 * @param cTableAtomEle
 * @param portMap
 * @return    
 */
function selectWaveLengthOption(cTableAtomEle, waveLength)
{
	if (null == waveLength)
	{
		return 0;
	}
	
	if (0 == cTableAtomEle.options.length)
	{
		return 0;
	}
	
	for (var i = 0, len = cTableAtomEle.options.length; i < len; i++)
	{
		var opt = cTableAtomEle.options[i].text;
		
		if (waveLength == opt)
		{
			return i;
		}
	}
	
	return 0;
}

/**
 *                     
 * @param cTableAtomEle
 * @param portMap
 * @return    
 */
function bandTypeID(bandTypeValue)
{
	if (null == waveLengthList)
	{
		return 0;
	}
	
	for (var i = 0, len = waveLengthList.bandType.length; i < len; i++)
	{
		  if (bandTypeValue == waveLengthList.bandType[i].id)
		  {
		       return waveLengthList.bandType[i].value;
		  }
	}
	
	return 0;
}

/**
 *                         
 * @param    
 * @return    
 */
function getNEInfoFromNEList(neID, NEList)
{
	var tmpNEID;
	var slmNEInfo;
	for (var i = 0, len = NEList.length; i < len; i++)
	{
		slmNEInfo = sinkNEList[i];
		tmpNEID = slmNEInfo.neid;
		if (tmpNEID == neID)
		{
			return slmNEInfo;
		}
	}
	return null;
}

/**
 *                         
 * @param    
 * @return    
 */
function getNEInfoFromNEListByNEName(neName, NEList)
{
	var tmpNEID;
	var slmNEInfo;
	for (var i = 0, len = NEList.length; i < len; i++)
	{
		slmNEInfo = sinkNEList[i];
		tmpNEID = slmNEInfo.neName;
		if (tmpNEID == neName)
		{
			return slmNEInfo;
		}
	}
	return null;
}

/**
 *                   D\       ID       ID
 *                         LMU    (                                         ull)
 */
function getLMUPortMapping(slmLineTable, slmLineData, neid)
{
	var selectedRow = slmLineTable.getSelectedRows();
	var srcNEID = slmLineTable.getCellStoreValue(selectedRow[0], "srcNEID", "srcNEID");
	var sinkNEID = slmLineTable.getCellStoreValue(selectedRow[0], "sinkNEID", "sinkNEID");
	var lineID = slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
	if (neid == sinkNEID)
	{
		return null;
	}
	var tmpLineID;
	var tmpSinkNEID;
	var tmpSlotID;
	var tmpBoardName;
	var tmpPortName;
	for (var i = 0, len = slmLineData.getDataRowLength(); i < len; i++)
	{
		tmpLineID = slmLineData.getDataRowParam(i, "lineID");
		tmpSinkNEID = slmLineData.getDataRowParam(i, "sinkLmuneid");
		if (lineID == tmpLineID && sinkNEID == tmpSinkNEID)
		{
			tmpSlotID = slmLineData.getDataRowParam(i, "sinkLmuSlotId");
			tmpBoardName = slmLineData.getDataRowParam(i, "sinkLmuBoardName");
			tmpPortName = slmLineData.getDataRowParam(i, "sinkLmuPortName");
			return tmpSlotID + "-" + tmpBoardName + "-" + tmpPortName;
		}
	}
	return null;
}


/**
 *     option              
 * @param cTableAtomEle
 * @param portData
 * @return    
 */
function getInsertIndex(cTableAtomEle, portData)
{
	var slotId = parseInt(portData.slotId);
	var optionData = new Option(portData.toString(), portData);
	
	var portId = parseInt(portData.portId);
	var otherSlotId;
	var otherPortId;
	for (var i = 0, len = cTableAtomEle.options.length; i < len; i++)
	{
		var tmp = cTableAtomEle.options[i].value.split("-");
		otherSlotId = parseInt(tmp[0]);
		otherPortId = parseInt(tmp[2].split("(")[0]);
		if (slotId < otherSlotId)
		{
			return i;
		}
		else if(slotId == otherSlotId && portId == otherPortId)
		{
			return -1;
		}
	}  
	return cTableAtomEle.options.length;
}

/**
 *               ?
 * @param data:                         errArr:               ?
 * @return    
 */
function showOperResult(data, errArr)
{
	if (null == errArr)
	{
		errArr = [];//                         
		errArr[0] = "nename";//                        
	
		/*for(var i = 0, len = data.getBErrLength(); i < len; i++)
		{	
			data.getError().rowErrors[i].errorObj["lineID"] = RESOURCE["slmLineError"]+ data.getError().rowErrors[i].errorObj["lineID"];
		}	*/	
	}
	openErrPage("../../../../page/",data.getError(),errArr);
}


function waveLength()
{
	this.bandType = new Array();
}

function bandType()
{
	this.id = null;
	this.value = null;
	this.options = new Array();
	this.waveNoMap = new Array();
}

function getWaveLength()
{
	var xmlstr = createWaveLengthXML();
	urlreq = "../../../../neExlorerServlet?sfid=" + CFG_GET_WAVE_LENGTH_INFO;
	loadXMLdoc(urlreq, "POST", false, EncapsulateWave, null, "inputdata="+xmlstr);
}

function createWaveLengthXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params"); //bean                     ?
	
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",winurlobj.neid);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();	
}

function EncapsulateWave(doc)
{
	var waveLengthData = EncapsulateData(doc);
	waveLengthList = new waveLength();
  var bandtype = null;
  var waveNumMap = null;
  var options = null;
  var option = null;
  var optionName = null;
  var optionValue = null;
  var waveNO = null;
  var custWaveNO = null;
  for(var i = 0,size = waveLengthData.getDataRowLength(); i < size; i++)
  {
  	bandtype = new bandType();
  	var bandTypeParam = waveLengthData.getDataRowParam(i,"bandType");
  	bandtype.id = bandTypeList[bandTypeParam];
  	bandtype.value = bandTypeParam;
  	var waveLengthCount = Number(waveLengthData.getDataRowParam(i,"waveLengthCount"));
    for(var j = 0; j < waveLengthCount; j++)
    {
    		waveNO = waveLengthData.getDataRowParam(i,"waveNO" + j);
    		custWaveNO = waveLengthData.getDataRowParam(i,"custWaveNO" + j);
        optionName = waveLengthData.getDataRowParam(i,"waveLengthInfo" + j);
        optionValue = waveNO;
        option = new Option(optionName,optionValue);
        bandtype.options[bandtype.options.length] = option;      
        bandtype.waveNoMap[waveNO] = custWaveNO;
    }
    
    waveLengthList.bandType[i] = bandtype;
  }
}

function TESLMBoardRelation(neid, lineID, lmuSlotId, lasSlotId)
{
	this.neid = neid;
	this.lineID = lineID;
	this.lmuSlotId = lmuSlotId;
	this.lasSlotId = lasSlotId;
}

function getBoardRelationData(neid, index, availableLineData)
{
	var tmpLineID = availableLineData.getDataRowParam(index, "lineID");
	var tmpNEID = availableLineData.getDataRowParam(index, "srcLmuneid");
	var tmpLmuSlotId = availableLineData.getDataRowParam(index, "srcLmuSlotId");
	var tmpLasSlotId = availableLineData.getDataRowParam(index, "srcLasSlotId");
	
	if (tmpNEID != neid)
	{
		tmpNEID = availableLineData.getDataRowParam(index, "sinkLmuneid");
		tmpLmuSlotId = availableLineData.getDataRowParam(index, "sinkLmuSlotId");
	  tmpLasSlotId = availableLineData.getDataRowParam(index, "sinkLasSlotId");
	}
	
	return new TESLMBoardRelation(tmpNEID, tmpLineID, tmpLmuSlotId, tmpLasSlotId);
}

function deleteBoardRelation(neid, dataArray)
{
	for (var i = dataArray.length - 1; i >= 0; i--)
	{
		if (neid == dataArray[i].neid)
		{
			dataArray.splice(i, 1);
		}
	}
}
