var winurlobj = getNeProperty(self);

var btnRightArr = new Object();//           
var slmLineTable;//    (         )     
var slmlineInfoTabs;//    tab 
var availableLine =null; //          
var availablePort = null;//        (     )
var availablePortOtherNE = null;//             (      )
var lmuPortWaveLen = null;
var DEFAULT_SEGMENT_NUM = "--";
var INVALID_VALUE = "/";
var neid = winurlobj["neid"];
var availBuNameTypeMap = new Object();//    BU              

loadXMLdoc("../../../../conf/system.xml","GET",false,EncapsulateSConf);
loadXMLdoc("../../../../help/"+SYSTEMCONF.getLanguage()+"/helpidresource.xml", "GET", false,EncapsulateHelpConfig);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/slmlinemgr_u2kv1r3c00/slmlinemgr_" + SYSTEMCONF.getLanguage() + ".xml");

loadXMLdoc("../../conf/slmlinemgr_u2kv1r3c00/slmlinetable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);

var bandTypeList = [];
bandTypeList[0] = "C+L";
bandTypeList[1] = "C";
bandTypeList[2] = "L";
bandTypeList[3] = "C320G";
bandTypeList[4] = "LMC";
bandTypeList[5] = "LML";
bandTypeList[6] = "CWDM";

var sync = true;

var UNKNOWN = "UNKNOWN";

var isQuerySrcWaveBand = true;
var isQuerySinkWaveBand = true;

var tableDoc = null;

/**
 *         
 * @param   
 * @return   
 */
function init()
{
	if (!isIE)
	{
		sync = false;
	}
	
	initBtn();
	initTable();
	initLineInfoTabs();
	
	getWaveLength();
	
	setCursorWait();
	
	window.setTimeout("doQueryLineInfo()", 600);
}

/**
 *         tab 
 * @param   
 * @return   
 */
function initLineInfoTabs()
{
	slmlineInfoTabs = new Tabs();
  slmlineInfoTabs.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame2", "tabs_li_select");
  slmlineInfoTabs.addTab(1, RESOURCE["slmlinemgr_bottom"], "slmlinemgr_bottom.html");
  slmlineInfoTabs.addTab(2, RESOURCE["slmlineparam"], "slmlineparam.html");
  slmlineInfoTabs.addTab(3, RESOURCE["slmunderseaeqpt"], "slmunderseaeqpt.html");
  slmlineInfoTabs.selectTab(1);
  setTabsHeight(slmlineInfoTabs, getComponetHeight($("slmlineInfoTabs"), 70) + "px");    
  document.getElementById("slmlineInfoTabs").appendChild(slmlineInfoTabs.getTabs());
}

/********************** 
 *     tab                  
***********************/
function setTabsHeight(tabs, tabodyheight)
{
    for(var key in tabs.tabNodes)
    {
        tabs.tabNodes[key].body.style.height = tabodyheight;
    }
}

/**
 *               
 * @param   
 * @return   
 */
function initBtn()
{
	$("queryBtn").value = RESOURCE["queryBtn"];
	$("createBtn").value = RESOURCE["createBtn"];
	$("activeBtn").value = RESOURCE["activeBtn"];
	$("applyBtn").value = RESOURCE["applyBtn"];
	$("modifyBtn").value = RESOURCE["modifyBtn"];
	$("delBtn").value = RESOURCE["delBtn"];
	btnRightArr.queryBtn = new BtnRightObj("queryBtn", TECMDCODE_SLM_LINEMGR_QUERY_LINE);
	btnRightArr.createBtn = new BtnRightObj("createBtn", TECMDCODE_SLM_LINEMGR_CREATE_LINE);
	btnRightArr.activeBtn = new BtnRightObj("activeBtn", TECMDCODE_SLM_LINEMGR_ACTIVATE_BASELINE);
	btnRightArr.applyBtn = new BtnRightObj("applyBtn", TECMDCODE_SLM_LINEMGR_SET_LINE_PARAM);
	btnRightArr.modifyBtn = new BtnRightObj("modifyBtn", TECMDCODE_SLM_LINEMGR_MODIFY_LINE);
	btnRightArr.delBtn = new BtnRightObj("delBtn", TECMDCODE_SLM_LINEMGR_DELETE_LINE);
	
	sendRightInfo(); 
}
/**
 *               
 * @param   
 * @return   
 */
function initTable()
{
	slmLineTable = new SortTable();
	slmLineTable.setImage("../../../../images/");
	var lineTableOffset = 0;
	if (isIE)
	{
		lineTableOffset = document.body.offsetHeight * 0.50;
	}
	else
	{
		lineTableOffset = document.body.clientHeight * 0.50;
	}
  slmLineTable.setBodyHeight(getComponetHeight($("slmLineTable"), 440)+"px");
	createTableHead(slmLineTable, window.tableconf[0]); 
	slmLineTable.setOnRowSelectHandler(rowSelectHandler);
	$("slmLineTable").oncontextmenu = remarkMenuHandler
	$("slmLineTable").appendChild(slmLineTable.getTable());
	
}

function rowSelectHandler(rows)
{
		disableAllBtn();
 		var tabwindow = slmlineInfoTabs.getTabWindow(slmlineInfoTabs.selectTabid);//           Tab      
    if(rows.length > 0)//            
    {        
        var lineID = slmLineTable.getCellStoreValue(rows[rows.length-1], "lineID", "lineID");
        tabwindow.tabSelectHandler();
    }
}
/**
 *                     
 * @return   
 */
function addCellEvent()
{
    var cell;
    var editelement;
    
    for(var i = 0, tbLen = slmParamTable.getDataRowLength(); i < tbLen; i++)//        
    {
        cell = slmParamTable.getCell(i,"fiberType");//   fiberType     
        if(null != cell)
        {
            editelement = cell.element.editElement.element;//   fiberType             
            editelement.maxLength = SLM_LINEMGR_MAX_FIBERTYPE_LENGTH;//        text            
            
            editelement.onkeyup = function()
            {
            	  return calStrSinoLen(this, SLM_LINEMGR_MAX_FIBERTYPE_LENGTH);
            }
        }
				cell = slmParamTable.getCell(i, "refractiveRate");	
				textCheck(cell.element.editElement.element, SLM_LINEMGR_MIN_REFRACTIVE_RATE, SLM_LINEMGR_MAX_REFRACTIVE_RATE, 3);
				
			  cell = slmParamTable.getCell(i, "fiberLength");	
				textCheck(cell.element.editElement.element, SLM_LINEMGR_MIN_FIBER_LENGTH, SLM_LINEMGR_MAX_FIBER_LENGTH, 1);
			 
				cell = slmParamTable.getCell(i, "attenuation");	
				textCheck(cell.element.editElement.element, SLM_LINEMGR_MIN_ATTENUATION, SLM_LINEMGR_MAX_ATTENUATION, 2);
    }
}
/**
 *                      
 * @param param
 * @return   
 */
function cellEditHandler(param)
{
	$("applyBtn").disabled = !btnRightArr["applyBtn"].right;
}

	

/**
 *                   
 * @param evt
 * @return   
 */
function remarkMenuHandler(evt)
{
	if (!evt)
	{
		evt = window.event;
	}
	 var elem = (evt.target) ? evt.target : evt.srcElement;   
	if (elem != null && elem.blur)
    {
    	elem.blur();	  	
    }
    while (elem != null)
	{
		if (elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
    } 
    if (elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		return;
	} 
	var rowid= elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
	if (rows.length == 0)
	{
		return;
	}
    if (rows.contains(rowid))
	{
		createRemarkMenu(rows, evt); 
	}
}

function setRowsUnSelect(st, rowIndex)
{
	var obj = st.getRow(rowIndex).element;
	obj.className = "weightrow";
	obj.parent.selectTr = obj;
	obj.selectFlag = false;
}

SortTable.prototype.setRowUnSelect = function(index)
{
	var obj = this.getRow(index).element;
	obj.className = "weightrow";
	obj.parent.selectTr = obj;
	obj.selectFlag = false;
}

/**
 *             
 * @param   
 * @return   
 */
function createRemarkMenu(rows, evt)
{
	removejsDOMmenu();
	var menuSize = 150;
	var cursorMenu = new jsDOMenu(menuSize);
	cursorMenu.addMenuItem(new menuItem(RESOURCE["remarkTitle"], "", openRemrkDlg, true));
	setPopUpMenu(cursorMenu);
	showMenu(evt);
}
/**
 *               
 * @param   
 * @return   
 */
function openRemrkDlg()
{
	removejsDOMmenu();
	var dialogHeight = 175;//"175px";
	var dialogWidth = 275;//"275px";
	xshowModalDialog("slmlineremarkmodify.html", RESOURCE["remarkTitle"], dialogWidth, dialogHeight, "../../../../images/");
}

/**
 *              
 * @param   
 * @return   
 */
function sendRightInfo()
{
	var url = "../../../../securityServlet?neID="+winurlobj["neid"]+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url, "POST", sync, callbackRightInfoData, null, "inputdata=" + createRightInfoXML());

}
/**
 *                       XML   
 * @param   
 * @return         
 */
function createRightInfoXML()
{
	var root = new inputxml("datainterface")
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	for (var btnrightobj in btnRightArr)
	{
		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "btnId");
		param.setAttribute("value", btnRightArr[btnrightobj].btnId);
		row.appendChild(param)
		
		param = new tagElement("param");
		param.setAttribute("name", "sfid");
		param.setAttribute("value", btnRightArr[btnrightobj].sfid);
		row.appendChild(param)
		bussiness.appendChild(row);
	}
	root.getRoot().appendChild(bussiness);
	
	
	return root.toString();
}
/**
 *                    
 * @param doc 
 * @return   
 */
function callbackRightInfoData(doc)
{
	var data = EncapsulateData(doc);
	for (var i = 0, len = data.getDataRowLength(); i<len; i++)
	{
		var right = data.getDataRowParam(i,"right");
		
		
		var btnDisabled = parseInt(right)?false:true;
		$(data.getDataRowParam(i,"btnId")).disabled = btnDisabled;
		btnRightArr[data.getDataRowParam(i,"btnId")].right = !btnDisabled;
	}
}

/**
 *          
 * @param    
 * @return   
 */
function doQueryLineInfo()
{
	removejsDOMmenu(); 
	disableAllBtn();
	var data = createQueryLineInfoXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_LINE+ "&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url,"POST",sync,callbackQueryLineInfoData,null,"inputdata="+data);

}
/**
 *               XML   
 * @param   
 * @return   
 */
function createQueryLineInfoXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", DEFAULT_QUERY_LINEID);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *                
 * @param doc 
 * @return   
 */
function callbackQueryLineInfoData(doc)
{
	availableLine = null;
	var data = EncapsulateData(doc);
	
	tableDoc = doc;
	
	slmLineTable.clearTableData();
	var errorCode = data.getSErrorCode();
	availableLine = data;

	if (0 == errorCode || 1 == errorCode)
	{
		
		var newData = getPortMap(data); 
		createTableBody(slmLineTable, window.tableconf[0], newData, RESOURCE);
		if(!slmLineTable.element.colsArray.selectedId)
	  {
	  	 slmLineTable.element.colsArray.selectedId = "lineID";
	  	 slmLineTable.element.colsArray.imgflag = 1;
	  }
	  var td=slmLineTable.element.headRow.element.cols[slmLineTable.element.colsArray.selectedId].element; 
	  slmLineTable.sortRows(td,slmLineTable.element.colsArray.imgflag);
		
		if (0 < slmLineTable.getDataRowLength() && 0 == slmLineTable.getSelectedRowCount())
		{
			slmLineTable.setRowSelect(0);
			rowSelectHandler(slmLineTable.getSelectedRows());
			
		}
		else
		{
			
		  refreshBtnStatus();
		
			var tabwindow = slmlineInfoTabs.getTabWindow(slmlineInfoTabs.selectTabid);//           Tab      
 		  tabwindow.clearTable();
		}
		
		showErrorDialog(data);
		
	}
	else
	{
		slmlineInfoTabs.getTabWindow(1).tabSelectHandler();
		showErrorDialog(data);
		refreshBtnStatus();
	}

	refreshLineInfoTableStaData();
}

function refreshLineInfoTableStaData()
{
	var selectedRows = slmLineTable.getSelectedRows();
    $("upSelRows").innerHTML = selectedRows.length;
	$("uptotalrows").innerHTML = slmLineTable.getDataRowLength();
}

/**
 *        data        
 * @param data
 * @return newData
 */
function getPortMap(data)
{
	var newData = new DataInterface();
	var srcNEID;
	var sinkNEID;
	var slotId;
	var boardName;
	var portId;
	var portName;
	var neName;
	var probeWaveBand;
	var probeWaveIndex;
	var loadingWaveBand;
	var loadingWaveIndex;
	var lineDirection;
	for (var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		obj = new Object();
		ptag = new ParamTag();
		ptag.value = data.getDataRowParam(i, "lineID");
		obj["lineID"] = ptag;
		
		lineDirection = data.getDataRowParam(i, "lineDirection");
		if (neid != data.getDataRowParam(i, "srcLmuneid") && "1" == lineDirection)
		{
			lineDirection = 0;
		}
		ptag = new ParamTag();
		ptag.value = lineDirection;
		obj["lineDirection"] = ptag;
		
		ptag = new ParamTag();
		var srcLmiNEID = data.getDataRowParam(i, "srcSaveSinkLmineid");
		var srcSaveSinkneid = data.getDataRowParam(i, "srcSaveSinkneid");
		var srcLmuneid = data.getDataRowParam(i, "srcLmuneid");
		
    var isExistLMU = true;
		neName = data.getDataRowParam(i, "srcLmuNeName");
		slotId = data.getDataRowParam(i,"srcLmuSlotId");
		boardName = data.getDataRowParam(i, "srcLmuBoardName");
		portId = data.getDataRowParam(i, "srcLmuPortId");
		portName = data.getDataRowParam(i, "srcLmuPortName");

		ptag = new ParamTag();
		if ((null != neName && UNKNOWN != neName) 
		&& (null != slotId && 0 != slotId) 
		&& (null != boardName && UNKNOWN != boardName) 
		&& (null != portName && UNKNOWN != portName))
		{
			ptag.value = neName  + "-" + slotId + "-" + boardName + "-" + portName;
		}
		else if (null != srcSaveSinkneid && 0 != srcSaveSinkneid)
		{
			ptag.value = UNKNOWN;
    	isExistLMU = false;
		}
    else if (0 != srcLmiNEID && null != srcLmuneid && 0 == srcLmuneid)
    {
    	ptag.value = RESOURCE["theThirdDevice"];
    	isExistLMU = false;
    }
    else
    {
    	ptag.value = DEFAULT_SEGMENT_NUM;
    	isExistLMU = false;
    }
    obj["srcLMUUnit"] = ptag;
		
		neName = data.getDataRowParam(i, "srcLasNeName");
		slotId = data.getDataRowParam(i,"srcLasSlotId");
		boardName = data.getDataRowParam(i, "srcLasBoardName");
		portId = data.getDataRowParam(i, "srcLasPortId");
		portName = data.getDataRowParam(i, "srcLasPortName");

		ptag = new ParamTag();
		if ((null != neName && UNKNOWN != neName) 
		&& (null != slotId && 0 != slotId) 
		&& (null != boardName && UNKNOWN != boardName) 
		&& (null != portName && UNKNOWN != portName))
		{
			ptag.value = neName  + "-" + slotId + "-" + boardName + "-" + portName;
		}
		else if (null != srcSaveSinkneid && 0 != srcSaveSinkneid)
		{
			ptag.value = UNKNOWN;
		}
		else if (0 != srcLmiNEID && null != srcLmuneid && 0 == srcLmuneid)
    {
    	ptag.value = RESOURCE["theThirdDevice"];
    }
    else
    {
    	ptag.value = DEFAULT_SEGMENT_NUM;
    }
    obj["srcLASUnit"] = ptag;
		
		neName = data.getDataRowParam(i, "srcLmiNeName");
		slotId = data.getDataRowParam(i, "srcLmiSlotId");
		boardName = data.getDataRowParam(i, "srcLmiBoardName");
		portId = data.getDataRowParam(i, "srcLmiPortId");
		portName = data.getDataRowParam(i, "srcLmiPortName");

		ptag = new ParamTag();
		if ((null != neName && UNKNOWN != neName) 
		&& (null != slotId && 0 != slotId) 
		&& (null != boardName && UNKNOWN != boardName) 
		&& (null != portName && UNKNOWN != portName))
		{
			ptag.value = neName  + "-" + slotId + "-" + boardName + "-" + portName;
		}
		else if (null != srcSaveSinkneid && 0 != srcSaveSinkneid)
		{
			ptag.value = UNKNOWN;
		}
		else if (0 != srcLmiNEID && null != srcLmuneid && 0 == srcLmuneid)
    {
    	ptag.value = RESOURCE["theThirdDevice"];
    }
    else
    {
    	ptag.value = DEFAULT_SEGMENT_NUM;
    }
		obj["srcLMIUnit"] = ptag;
		
		probeWaveBand = data.getDataRowParam(i, "srcProbeWaveBand");
		ptag = new ParamTag();
		if (null != probeWaveBand && isExistLMU)
		{
			ptag.value = bandTypeList[probeWaveBand];
		}
    else
    {
    	ptag.value = DEFAULT_SEGMENT_NUM;
    }
		obj["srcProbeWaveBand"] = ptag;
		
		probeWaveIndex = data.getDataRowParam(i, "srcProbeWaveIndex");
		ptag = new ParamTag();
		if (null != probeWaveBand && isExistLMU && 0 != probeWaveIndex)
		{
			ptag.value = waveLengthList.bandType[probeWaveBand].options[probeWaveIndex - 1].text;
		}
		else if (0 == probeWaveIndex && null != srcLmuneid && 0 != srcLmuneid)
		{
			ptag.value = INVALID_VALUE
		}
    else
    {
    	ptag.value = DEFAULT_SEGMENT_NUM;
    }
    
		obj["srcProbeWaveIndex"] = ptag;
		
		loadingWaveBand = data.getDataRowParam(i, "srcLoadingWaveBand");
		ptag = new ParamTag();
		if (null != loadingWaveBand && isExistLMU)
		{
			ptag.value = bandTypeList[loadingWaveBand];
		}
    else
    {
    	ptag.value = DEFAULT_SEGMENT_NUM;
    }
		obj["srcLoadingWaveBand"] = ptag;
		
		loadingWaveIndex = data.getDataRowParam(i, "srcLoadingWaveIndex");
		ptag = new ParamTag();
		if (null != loadingWaveBand && isExistLMU && 0 != loadingWaveIndex)
		{
			ptag.value = waveLengthList.bandType[loadingWaveBand].options[loadingWaveIndex - 1].text;
		}
		else if (0 == loadingWaveBand && null != srcLmuneid && 0 != srcLmuneid)
		{
			ptag.value = INVALID_VALUE
		}
    else
    {
    	ptag.value = DEFAULT_SEGMENT_NUM;
    }
		obj["srcLoadingWaveIndex"] = ptag;
		
		ptag = new ParamTag();
		ptag.value = data.getDataRowParam(i, "remark");
		obj["remark"] = ptag;
		
		ptag = new ParamTag();
		ptag.value = data.getDataRowParam(i, "srcLmuneid");
		obj["srcNEID"] = ptag;
		
		ptag = new ParamTag();
		ptag.value = data.getDataRowParam(i, "sinkLmuneid");
		obj["sinkNEID"] = ptag;
		
		ptag = new ParamTag();
		
		var srcLmuNEID = data.getDataRowParam(i, "srcLmuneid");
		
		var sinkLmiNEID = data.getDataRowParam(i, "srcSaveSinkLmineid");
		var srcSaveSinkneid = data.getDataRowParam(i, "srcSaveSinkneid");
		var sinkLmuneid = data.getDataRowParam(i, "sinkLmuneid");
		isExistLMU = true;
		sinkNeName = data.getDataRowParam(i,"sinkLmuNeName");
		slotId = data.getDataRowParam(i,"sinkLmuSlotId");
		boardName = data.getDataRowParam(i, "sinkLmuBoardName");
		portId = data.getDataRowParam(i, "sinkLmuPortId");
		portName = data.getDataRowParam(i, "sinkLmuPortName");

		if ((null != sinkNeName && UNKNOWN != sinkNeName) 
		  && (null != slotId && 0 != slotId) 
		  && (null != boardName && UNKNOWN != boardName) 
		  && (null != portName && UNKNOWN != portName))
		{
			isExistLMU = true;
		}
		else if (null != srcSaveSinkneid && 0 != srcSaveSinkneid)
		{
    	isExistLMU = false;
		}
		else if (0 != sinkLmiNEID && null != sinkLmuneid && 0 != sinkLmuneid)
    {
    	isExistLMU = false;
    }
    else
    {
    	isExistLMU = false;
    }
		
		if (1 == lineDirection)
		{
			ptag = new ParamTag();
			ptag.value = data.getDataRowParam(i, "srcLmuSlotId") + "-" + data.getDataRowParam(i, "srcLmuBoardName")
				             + "-" + data.getDataRowParam(i, "srcLmuPortId");
			obj["curNELMUInfo"] = ptag;
			
			ptag = new ParamTag();
			ptag.value = data.getDataRowParam(i, "sinkLmuSlotId") + "-" + data.getDataRowParam(i, "sinkLmuBoardName") 
				            + "-" + data.getDataRowParam(i, "sinkLmuPortId");
			obj["sinkNELMUInfo"] = ptag;
			
			ptag = new ParamTag();
			var srcLasNEID = data.getDataRowParam(i, "srcLasneid");
			ptag.value = data.getDataRowParam(i, "srcLasSlotId") + "-" + data.getDataRowParam(i, "srcLasBoardName")
				              + "-" + data.getDataRowParam(i, "srcLasPortId");
			obj["curNELASInfo"] = ptag;
			
			ptag = new ParamTag();
			ptag.value = data.getDataRowParam(i, "sinkLasSlotId") + "-" + data.getDataRowParam(i, "sinkLasBoardName")
				              + "-" + data.getDataRowParam(i, "sinkLasPortId");
			obj["sinkNELASInfo"] = ptag;
			
			ptag = new ParamTag();
	    ptag.value = data.getDataRowParam(i, "srcLmiSlotId") + "-" + data.getDataRowParam(i, "srcLmiBoardName")
				             + "-" + data.getDataRowParam(i, "srcLmiPortId");
			obj["curNELMIInfo"] = ptag;
			
			ptag = new ParamTag();
			ptag.value = data.getDataRowParam(i, "sinkLmiSlotId") + "-" + data.getDataRowParam(i, "sinkLmiBoardName") 
				            + "-" + data.getDataRowParam(i, "sinkLmiPortId");
			obj["sinkNELMIInfo"] = ptag;
		}
		else
		{
			ptag = new ParamTag();
			ptag.value = data.getDataRowParam(i, "srcLmuSlotId") + "-" + data.getDataRowParam(i, "srcLmuBoardName")
				             + "-" + data.getDataRowParam(i, "srcLmuPortId");
			obj["sinkNELMUInfo"] = ptag;
			
			ptag = new ParamTag();
			ptag.value = data.getDataRowParam(i, "sinkLmuSlotId") + "-" + data.getDataRowParam(i, "sinkLmuBoardName") 
				            + "-" + data.getDataRowParam(i, "sinkLmuPortId");
			obj["curNELMUInfo"] = ptag;
			
			ptag = new ParamTag();
			var srcLasNEID = data.getDataRowParam(i, "srcLasneid");
			ptag.value = data.getDataRowParam(i, "srcLasSlotId") + "-" + data.getDataRowParam(i, "srcLasBoardName")
				              + "-" + data.getDataRowParam(i, "srcLasPortId");
			obj["sinkNELASInfo"] = ptag;
			
			ptag = new ParamTag();
			ptag.value = data.getDataRowParam(i, "sinkLasSlotId") + "-" + data.getDataRowParam(i, "sinkLasBoardName")
				              + "-" + data.getDataRowParam(i, "sinkLasPortId");
			obj["curNELASInfo"] = ptag;
			
			ptag = new ParamTag();
	    ptag.value = data.getDataRowParam(i, "srcLmiSlotId") + "-" + data.getDataRowParam(i, "srcLmiBoardName")
				             + "-" + data.getDataRowParam(i, "srcLmiPortId");
			obj["sinkNELMIInfo"] = ptag;
			
			ptag = new ParamTag();
			ptag.value = data.getDataRowParam(i, "sinkLmiSlotId") + "-" + data.getDataRowParam(i, "sinkLmiBoardName") 
				            + "-" + data.getDataRowParam(i, "sinkLmiPortId");
			obj["curNELMIInfo"] = ptag;
		}
		
		ptag = new ParamTag();
	  ptag.value = data.getDataRowParam(i, "srcLmineid");
		obj["srcLmineid"] = ptag;
		
		ptag = new ParamTag();
	  ptag.value = data.getDataRowParam(i, "srcLmiSlotId");
		obj["srcLmiSlotId"] = ptag;
		
		ptag = new ParamTag();
	  ptag.value = data.getDataRowParam(i, "srcLmiPortId");
		obj["srcLmiPortId"] = ptag;
		
		ptag = new ParamTag();
	  ptag.value = data.getDataRowParam(i, "sinkLmineid");
		obj["sinkLmineid"] = ptag;
		
		ptag = new ParamTag();
	  ptag.value = data.getDataRowParam(i, "sinkLmiSlotId");
		obj["sinkLmiSlotId"] = ptag;
		
		ptag = new ParamTag();
	  ptag.value = data.getDataRowParam(i, "sinkLmiPortId");
		obj["sinkLmiPortId"] = ptag;
		
		probeWaveBand = data.getDataRowParam(i, "sinkProbeWaveBand");
		ptag = new ParamTag();
		if (null != probeWaveBand && isExistLMU)
		{
			ptag.value = bandTypeList[probeWaveBand];
		}
		else
		{
			ptag.value = DEFAULT_SEGMENT_NUM;
		}
		obj["sinkProbeWaveBand"] = ptag;
		
		probeWaveIndex = data.getDataRowParam(i, "sinkProbeWaveIndex");
		ptag = new ParamTag();
		if (null != probeWaveBand && isExistLMU && 0 != probeWaveIndex)
		{
			ptag.value = waveLengthList.bandType[probeWaveBand].options[probeWaveIndex - 1].text;
		}
		else if (0 == probeWaveIndex && null != sinkLmuneid && 0 != sinkLmuneid)
		{
			ptag.value = INVALID_VALUE
		}
		else
		{
			ptag.value = DEFAULT_SEGMENT_NUM;
		}
		obj["sinkProbeWaveIndex"] = ptag;
		
		loadingWaveBand = data.getDataRowParam(i, "sinkLoadingWaveBand");
		ptag = new ParamTag();
		if (null != loadingWaveBand && isExistLMU)
		{
			ptag.value = bandTypeList[loadingWaveBand];
		}
		else
		{
			ptag.value = DEFAULT_SEGMENT_NUM;
		}
		obj["sinkLoadingWaveBand"] = ptag;
		
		loadingWaveIndex = data.getDataRowParam(i, "sinkLoadingWaveIndex");
		ptag = new ParamTag();
		if (null != loadingWaveBand && isExistLMU && 0 != loadingWaveIndex)
		{
			ptag.value = waveLengthList.bandType[loadingWaveBand].options[loadingWaveIndex - 1].text;
		}
		else if (0 == loadingWaveIndex && null != sinkLmuneid && 0 != sinkLmuneid)
		{
			ptag.value = INVALID_VALUE
		}
		else
		{
			ptag.value = DEFAULT_SEGMENT_NUM;
		}
		obj["sinkLoadingWaveIndex"] = ptag;
		
		ptag = new ParamTag();
		var isSame = data.getDataRowParam(i, "isSame");
		if (null == isSame || UNKNOWN == isSame)
		{
			isSame = "true";
		}
		ptag.value = isSame;
		obj["isSame"] = ptag;
		
		newData.rows.append(obj);
	}
	return newData;
}

/**
 *                                 
 * @param   
 * @return   
 */
function queryLineDetails()
{
	setLineTableStatus(true);
	var data = createQueryLineDetailsXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_LINE_DETAILS + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", sync, constructtblXML, null, "inputdata="+data);

}
/**
 *                            XML   
 * @param   
 * @return   
 */
function createQueryLineDetailsXML()
{
	var selectedRow = slmLineTable.getSelectedRows();
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	
  var pageparam = new tagElement("page-params");
  param = new tagElement("param");
  param.setAttribute("name","pageNum");
  if(document.getElementById("pagenum").value != "")
  {
      param.setAttribute("value",document.getElementById("pagenum").value);
  }
  else
  {
      param.setAttribute("value","1");
  }
  pageparam.appendChild(param);
    
    
  param = new tagElement("param");
  param.setAttribute("name","resultNumPerPage");
  param.setAttribute("value",document.getElementById("columnnum").value);
  pageparam.appendChild(param);
  root.getRoot().appendChild(pageparam);
    
	
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "segmentID");
	param.setAttribute("value", DEFAULT_QUERY_SEGMENTID);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *                         
 * @param doc
 * @return   
 */
function callbackQueryLineDetailsData(data)
{
	var segmentNum;
	
	var refractiveRate;//          0.001
	var fiberLength;   //           1
	var attenuation;   //       0.01
	
	if (0 == data.getSErrorCode())
	{
		for (var i = 0, len = data.getDataRowLength(); i < len; i++)
		{
			refractiveRate = (parseFloat(data.getDataRowParam(i, "refractiveRate")) / 1000).toFixed(3);
			fiberLength = (parseFloat(data.getDataRowParam(i, "fiberLength")) / 10).toFixed(1);
			attenuation = (parseFloat(data.getDataRowParam(i, "attenuation")) / 100).toFixed(2);
			data.rows[i]["refractiveRate"].value = refractiveRate;
			data.rows[i]["fiberLength"].value = fiberLength;
			data.rows[i]["attenuation"].value = attenuation;
		}
		createTableBody(slmParamTable, window.tableconf[1], data, RESOURCE);
		if(!slmParamTable.element.colsArray.selectedId)
	  {
	  	 slmParamTable.element.colsArray.selectedId = "segmentID";
	  	 slmParamTable.element.colsArray.imgflag = 1;
	  }
	  var td=slmParamTable.element.headRow.element.cols[slmParamTable.element.colsArray.selectedId].element; 
	  slmParamTable.sortRows(td,slmParamTable.element.colsArray.imgflag);
		
		
		addCellEvent();
	}
	else
	{
		showErrorDialog(data);
	}
	setLineTableStatus(false);
	refreshBtnStatus();
}
/**
 *            
 * @param   
 * @return   
 */
function doActivateLine() 
{
	removejsDOMmenu(); 
	if (!confirm(RESOURCE["confirmActivate"]))
	{
		return;
	}
	setCursorWait();
	setTableStatus(true);
	disableAllBtn();
	var data = createActivateLineXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_ACTIVATE_BASELINE + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackActivateLineData, null, "inputdata="+data);

}

/**
 *                        XML
 * @param   
 * @return   
 */
function createActivateLineXML()
{
	var selectedRow = slmLineTable.getSelectedRows();
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
	row.appendChild(param);
	

	var lineID = slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
	for(var index = 0, indexLen = availableLine.getDataRowLength(); index < indexLen; index++)
	{
		if(lineID == availableLine.getDataRowParam(index, "lineID"))
		{
			break;
		}
	}
	
	var srcLmineid = slmLineTable.getCellStoreValue(selectedRow[0], "srcLmineid", "srcLmineid");
	if (null == srcLmineid)
	{
		srcLmineid = 0;
	}
	var sinkLmineid = slmLineTable.getCellStoreValue(selectedRow[0], "sinkLmineid", "sinkLmineid");
	if (null == sinkLmineid)
	{
		sinkLmineid = 0;
	}
	
	var srcLmiSlotId = slmLineTable.getCellStoreValue(selectedRow[0], "srcLmiSlotId", "srcLmiSlotId");
	if (null == srcLmiSlotId)
	{
		srcLmiSlotId = 0;
	}
	var sinkLmiSlotId = slmLineTable.getCellStoreValue(selectedRow[0], "sinkLmiSlotId", "sinkLmiSlotId");
	if (null == sinkLmiSlotId)
	{
		sinkLmiSlotId = 0;
	}
	
	var srcLmiPortId = slmLineTable.getCellStoreValue(selectedRow[0], "srcLmiPortId", "srcLmiPortId");
	if (null == srcLmiPortId)
	{
		srcLmiPortId = 0;
	}
	var sinkLmiPortId = slmLineTable.getCellStoreValue(selectedRow[0], "sinkLmiPortId", "sinkLmiPortId");
	if (null == sinkLmiPortId)
	{
		sinkLmiPortId = 0;
	}
	
	param = new tagElement("param");
	param.setAttribute("name", "srcLmineid");
	param.setAttribute("value", srcLmineid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "srcLmiSlotId");
	param.setAttribute("value", srcLmiSlotId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "srcLmiPortId");
	param.setAttribute("value", srcLmiPortId);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "sinkLmineid");
	param.setAttribute("value", sinkLmineid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "sinkLmiSlotId");
	param.setAttribute("value", sinkLmiSlotId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "sinkLmiPortId");
	param.setAttribute("value", sinkLmiPortId);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	
	return root.toString();
}
function callbackActivateLineData(doc)
{
	var data = EncapsulateData(doc);
	if (0 == data.getSErrorCode())
	{
		alert(RESOURCE["activeSuccess"]);
	}
	else
	{
		showErrorDialog(data);
	}
	setTableStatus(false);
	refreshBtnStatus();
}
/**
 *    LMI   ID
 *           00104422
 *        AU9D17405
 * @param lineID
 * @return lmineid
 */
function getLMIneid(lineID)
{
	var lmineid = winurlobj["neid"];
	for (var index = 0, indexLen = availableLine.getDataRowLength(); index < indexLen; index++)
	{
		if(availableLine.getDataRowParam(index, "lineID") == lineID)
		{
			lmineid =  availableLine.getDataRowParam(index, "lmineid");
		}
	}
	return lmineid;
}
/**
 *           
 * @param   
 * @return   
 */
function doSetLineInfo ()
{
		var selectedRow = slmLineTable.getSelectedRows();
		if (0 != selectedRow.length) 
	  {
	      var isSame = slmLineTable.getCellStoreValue(selectedRow[0], "isSame", "isSame");
	      
	      if ("false" == isSame)
	      {
	      	alert(RESOURCE["lminotconsistant"]);
					return;
	      }
	  }
	  setCursorWait();
    disableAllBtn();
 		var tabwindow = slmlineInfoTabs.getTabWindow(slmlineInfoTabs.selectTabid);//           Tab      
 		tabwindow.doSetLineInfo();
}

/**
 *                         
 * @param   
 * @return   
 */
function doDeleteLine()
{
	removejsDOMmenu(); 
	if (!confirm(RESOURCE["confirmDelete"]))
	{
		return;
	}
	setCursorWait();
	setTableStatus(true);
	disableAllBtn();
	var selectedRow = slmLineTable.getSelectedRows();
	var data = createDeleteLineXML(selectedRow);
	var url = "../../../../neExlorerServlet?sfid=" +TECMDCODE_SLM_LINEMGR_DELETE_LINE + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackDeleteLineData, selectedRow, "inputdata="+data);

} 
/**
 *                   XML   
 * @param   
 * @return   
 */
function createDeleteLineXML(selectedRow)
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	var srcNEID = slmLineTable.getCellStoreValue(selectedRow[0], "srcNEID", "srcNEID");
	var sinkNEID = slmLineTable.getCellStoreValue(selectedRow[0], "sinkNEID", "sinkNEID");
	
	var opNeID = sinkNEID;
	
	if (srcNEID != winurlobj["neid"])
	{
		opNeID = srcNEID;
	}
	
	param = new tagElement("param");
	param.setAttribute("name", "opNeID");
	param.setAttribute("value", opNeID);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
} 
/**
 *                    
 * @param doc
 * @return   
 */
function callbackDeleteLineData(doc, selectedRow)
{
	var data = EncapsulateData(doc);
	if (0 == data.getSErrorCode())
	{
		alert(RESOURCE["deleteSuccess"]);
		
		
		slmlineInfoTabs.selectTab(1);
		var tabwindow = slmlineInfoTabs.getTabWindow(1);//           Tab      
		tabwindow.clearMarineLineBottomTable();
		doQueryLineInfo();
	}
	showErrorDialog(data);
	setTableStatus(false);
} 

/**
 *          
 * @param   
 * @return   
 */
function setCursorWait()
{
  slmlineInfoTabs.removeTabNodeHref();
	
	document.body.style.cursor = "wait";
}

/**
 *          
 * @param   
 * @return   
 */
function setCursorAuto()
{
	slmlineInfoTabs.enableHref();
	
	document.body.style.cursor = "auto";
}

/**
 *        
 * @param   
 * @return   
 */
function refreshBtnStatus()
{
	if(slmLineTable.getSelectedRowCount() == 1)
	{
		$("activeBtn").disabled = !btnRightArr["activeBtn"].right;
		$("modifyBtn").disabled = !btnRightArr["modifyBtn"].right;
		$("delBtn").disabled = !btnRightArr["delBtn"].right;
	}
	else
	{
		$("activeBtn").disabled = true;
		$("modifyBtn").disabled = true;
		$("delBtn").disabled = true;
	}
	$("queryBtn").disabled = !btnRightArr["queryBtn"].right;
	$("createBtn").disabled = !btnRightArr["createBtn"].right;
	
	$("applyBtn").disabled = true;
	if (2 == slmlineInfoTabs.selectTabid)
	{
		var tabwindow = slmlineInfoTabs.getTabWindow(2);
		var slmParamTable = tabwindow.slmParamTable;
		for (var rowIndex = 0, rowLen = slmParamTable.getDataRowLength(); rowIndex < rowLen; rowIndex++)
		{
			if (slmParamTable.getModify(rowIndex))
			{
				$("applyBtn").disabled = false;
				break;
			}
		}
	}

  setCursorAuto();
}
/**
 *          
 * @param   
 * @return   
 */
function queryAvailablePort()
{
	var data = createQueryAvailablePortXML()
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_AVAILABLE_PORT + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", false, callbackQueryAvailablePortData, null, "inputdata="+data);

}
/**
 *                XML   
 * @param   
 * @return   
 */
function createQueryAvailablePortXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param");
	param.setAttribute("name","neid");
	param.setAttribute("value",winurlobj["neid"]);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *                        
 * @param doc
 * @return   
 */
function callbackQueryAvailablePortData(doc)
{	
	availablePort = null;
	availablePortOtherNE = null;
	var data = EncapsulateData(doc);
	availablePort = getAvaliablePortData(data, neid);
	availablePortOtherNE = getAvaliablePortOtherNEData(data, neid);
	getAvailBUInfo(data);
}


/**
 *                        
 * @param   
 * @return   
 */
function openCreateLineDlg()
{
	removejsDOMmenu();
	
	queryAvailablePort();
	if(0 == availableLine.getDataRowLength() && 0 == availablePort.getDataRowLength())
	{
		alert(RESOURCE["noAvailableResource"]);
		return;
	}
	
	if(0 == availablePort.getDataRowLength())
	{
		alert(RESOURCE["noAvailableResource"]);
		return;
	}
	
	queryWaveBandHandler();
	
	if (!isQuerySrcWaveBand)
	{
		alert(RESOURCE["noAvailableResource"]);
		return;
	}

	var dialogHeight = 550;//"280px";
	var dialogWidth = 740;//"450px";
	
  if (SYSTEMCONF.getLanguage() != "zh") 
  {
      dialogHeight = 615;
      dialogWidth = 740;
  }
	
	xshowModalDialog("slmlinecreate.html", RESOURCE["createLineTitle"], dialogWidth, dialogHeight, "../../../../images/");
}

/**
 *                
 * @param   
 * @return   
 */
function queryWaveBandHandler()
{
	var data = createQueryWaveBandHandlerXML()
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_WAVELEN + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", false, callbackQueryWaveBandHandlerData, null, "inputdata="+data);
}

/**
 *                       
 *                   
 * @param   
 * @return   
 */
function callbackQueryWaveBandHandlerData(doc)
{
	var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
  lmuPortWaveLen = data;
	if(0 != data.getSErrorCode())
	{
		isQuerySrcWaveBand = false;
		isQuerySinkWaveBand = false;
		for (var i = 0, len = data.getDataRowLength(); i < len; i++)
 	  {
 	  	var tmpNEID = data.getDataRowParam(i, "neid");
			
			if (neid == tmpNEID)
			{
				isQuerySrcWaveBand = true;
				break;
			}
 	  }
 	  
 	  /*
 	  if (!isQuerySrcWaveBand)
 	  {
 	  	showErrorDialog(data);
 	  }*/
 	  
	}
	else
	{
		isQuerySrcWaveBand = true;
		isQuerySinkWaveBand = true;
	}
}

/**
 *                
 * @param   
 * @return   
 */
function createQueryWaveBandHandlerXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	getWaveLenQueryXMLDetail(availablePort, bussiness);
	getWaveLenQueryXMLDetail(availablePortOtherNE, bussiness);
	root.getRoot().appendChild(bussiness);		
	return root.toString();
}


/**
 *                    XML      
 * @param   
 * @return   
 */
function getWaveLenQueryXMLDetail(availablePortInfo, bussiness)
{
	var boardType;
	var neID;
	var lmuSlotID;
	var lmuPortID;
	for (var i = 0, len = availablePortInfo.getDataRowLength(); i < len; i++)
	{		
			boardType = parseInt(availablePortInfo.getDataRowParam(i,"boardType"));
			if (SLM_TNB2LMU_BOARDTYPE != boardType)
			{
				continue;
			}
			neID = parseInt(availablePortInfo.getDataRowParam(i,"neid"));
			lmuSlotID = parseInt(availablePortInfo.getDataRowParam(i,"slotId"));
			lmuPortID = parseInt(availablePortInfo.getDataRowParam(i,"portId"));
			var row = new tagElement("row-params");
			var param = null;
			
			param = new tagElement("param");
			param.setAttribute("name","neid");
			param.setAttribute("value",neID);
			row.appendChild(param);
			param = new tagElement("param");
			param.setAttribute("name","lmuSlot");
			param.setAttribute("value",lmuSlotID);
			row.appendChild(param);
			param = new tagElement("param");
			param.setAttribute("name","lmuPort");
			param.setAttribute("value",lmuPortID);
			row.appendChild(param);			
			param = new tagElement("param");
			param.setAttribute("name","lmuPath");
			param.setAttribute("value",0);
			row.appendChild(param);				
			bussiness.appendChild(row);
	}
}

/**
 *                  
 * @param   
 * @return   
 */
function openModifyDlg()
{
	var selectedRow = slmLineTable.getSelectedRows();
	if (0 != selectedRow.length) 
  {
      var isSame = slmLineTable.getCellStoreValue(selectedRow[0], "isSame", "isSame");
      
      if ("false" == isSame)
      {
      	alert(RESOURCE["lminotconsistant"]);
				return;
      }
  }
	
	removejsDOMmenu(); 
	queryAvailablePort();
	queryWaveBandHandler();
	var dialogHeight = 550;//"280px";
	var dialogWidth = 740;//"450px";
	
  if (SYSTEMCONF.getLanguage() != "zh") 
  {
      dialogHeight = 615;
      dialogWidth = 740;
  }
  
	xshowModalDialog("slmlinemodify.html", RESOURCE["modifyLineTitle"], dialogWidth, dialogHeight, "../../../../images/");
}

/**
 *             
 *        
 *       AU9D17370
 *                        
 * @param flg:      true                             
 * @return   
 */
function setTableStatus(flg)
{
	if(flg)
	{
		for (var i = 0, len = slmLineTable.getDataRowLength(); i < len; i++)
		{
			slmLineTable.getRow(i).element.onclick = null;
		}
	}
	else
	{
		for (var i = 0, len = slmLineTable.getDataRowLength(); i < len; i++)
		{
			slmLineTable.getRow(i).element.onclick = rowclick;
		}
	}
}
/**
 *              
 * @param flg:      true                             
 * @return   
 */
function setLineTableStatus(flg)
{
	if(flg)
	{
		for (var i = 0, len = slmLineTable.getDataRowLength(); i < len; i++)
		{
			slmLineTable.getRow(i).element.onclick = null;
		}
	}
	else
	{
		for (var i = 0, len = slmLineTable.getDataRowLength(); i < len; i++)
		{
			slmLineTable.getRow(i).element.onclick = rowclick;
		}
	}
}
/**
 *          
 * @return   
 */
function disableAllBtn()
{
	$("queryBtn").disabled = true;
	$("createBtn").disabled = true;
	$("activeBtn").disabled = true;
	$("applyBtn").disabled = true;
	$("modifyBtn").disabled = true;
	$("delBtn").disabled = true;
}


function showErrorDialog(dinterface)
{
  	removejsDOMmenu();
    var errArr = [];
    errArr[0] = "nename";
    
    var errorObj = null;
    var errstrArr = new Array();
    var errstr;
    for(var i = dinterface.getBErrLength() - 1; i >= 0; i--)
	  {	
	  	  errorObj = dinterface.getError().rowErrors[i].errorObj;
	  	  errstr = errorObj["nename"] + dinterface.getError().getRowCode(i);
	  	  if(errstrArr.contains(errstr))
	  	  {
	  	      dinterface.getError().rowErrors.splice(i, 1);
	  	  }
	  	  else
	  	  {
	  	      errstrArr[errstrArr.length] = errstr;
	  	  }
	  }
    openErrPage("../../../../page/", dinterface.getError(), errArr);

}



function firstpage()
{
    document.getElementById("pagenum").value = 1;
    queryLineDetails();
}

function pageup()
{
    document.getElementById("pagenum").value = parseInt(document.getElementById("pagenum").value)-1;
    queryLineDetails();
}

function pagedown()
{
    document.getElementById("pagenum").value = parseInt(document.getElementById("pagenum").value) + 1;
    queryLineDetails();
}

function lastpage()
{
	var str = document.getElementById("pagestatus").innerHTML;
    document.getElementById("pagenum").value = str.split("/")[1];
    queryLineDetails();
}


function constructtblXML(doc)
{
    for(var i=0; i< slmParamTable.getDataRowLength(); i++)
    {
        slmParamTable.deleteRow(i);
    }
    slmParamTable.adjustDataRows();
    
    var dinterface = EncapsulateData(doc);
	  
    if("pageNum" in dinterface.page)
    {
        var total = document.getElementById("totalitem");
        total.removeChild(total.childNodes[0]);
        total.appendChild(document.createTextNode(dinterface.getPageParam("totalResultNum").value));

        document.getElementById("theitem").innerHTML = 0;
        
        document.getElementById("pagestatus").innerHTML = dinterface.getPageParam("pageNum").value+"/"+dinterface.getPageParam("totalPageNum").value;
        
        optionlen = document.getElementById("pagenum").options.length;
        for(i = 0; i < optionlen; i++)
        {
            document.getElementById("pagenum").options[0] = null;
        }
        for(i = 0; i < dinterface.getPageParam("totalPageNum").value; i++)
        {
            document.getElementById("pagenum").options[i] = new Option(i+1,i+1);
        }
        document.getElementById("pagenum").value = dinterface.getPageParam("pageNum").value;
        if(dinterface.getPageParam("pageNum").value > 1)
        {
        	  $("previouspage").innerHTML = "<a href='javascript:pageup();'><u>" + RESOURCE["previouspage"] + "</u></a>";
            $("firstpage").innerHTML = "<a href='javascript:firstpage();'><u>" + RESOURCE["firstpage"] + "</u></a>";
            document.getElementById("previouspage").disabled = false;
            document.getElementById("firstpage").disabled = false;
        }
        else
        {
        	  $("previouspage").innerHTML = RESOURCE["previouspage"];
            $("firstpage").innerHTML = RESOURCE["firstpage"];
            document.getElementById("previouspage").disabled = true;
            document.getElementById("firstpage").disabled = true;
        }
        if(dinterface.getPageParam("pageNum").value != dinterface.getPageParam("totalPageNum").value)
        {
        	  $("nextpage").innerHTML = "<a href='javascript:pagedown();'><u>" + RESOURCE["nextpage"] + "</u></a>";
            $("lastpage").innerHTML = "<a href='javascript:lastpage();'><u>" + RESOURCE["lastpage"] + "</u></a>";
            document.getElementById("nextpage").disabled = false;
            document.getElementById("lastpage").disabled = false;
        }
        else
        {
        	  $("nextpage").innerHTML = RESOURCE["nextpage"];
            $("lastpage").innerHTML = RESOURCE["lastpage"];
            document.getElementById("nextpage").disabled = true;
            document.getElementById("lastpage").disabled = true;
        }
        var countsPerPage = dinterface.getPageParam("resultNumPerPage").value;
        if (countsPerPage != 20 && countsPerPage != 40 && countsPerPage != 60 &&
        		countsPerPage != 80 && countsPerPage != 100)
        {
        	document.getElementById("columnnum").value = 0;
        }
        else
        {
        	document.getElementById("columnnum").value = countsPerPage;
        }
        
    }
    else
    {
    	document.getElementById("theitem").innerHTML = 0;
    	document.getElementById("totalitem").innerHTML = 0;
    	
    	document.getElementById("pagestatus").innerHTML = "1/1"
    	optionlen = document.getElementById("pagenum").options.length;
      for(i = 0; i < optionlen; i++)
      {
          document.getElementById("pagenum").options[0] = null;
      }
      document.getElementById("pagenum").options[0] = new Option(1,1);
      
      document.getElementById("previouspage").disabled = true;
      document.getElementById("firstpage").disabled = true;
      document.getElementById("nextpage").disabled = true;
      document.getElementById("lastpage").disabled = true;
      document.getElementById("previouspage").innerHTML = RESOURCE["previouspage"];
			document.getElementById("firstpage").innerHTML = RESOURCE["firstpage"];
			document.getElementById("nextpage").innerHTML = RESOURCE["nextpage"];
			document.getElementById("lastpage").innerHTML = RESOURCE["lastpage"];
   }

   callbackQueryLineDetailsData(dinterface);
}

function getLineInfoData()
{
	return availableLine;
}


/**
 *               
 * @param data:                 
 * @return   
 */

function getAvaliablePortData(data, neID)
{
	var avaliablePortData = new DataInterface();
	var tmpNEID
	for (var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		tmpNEID = parseInt(data.getDataRowParam(i,"neid"));
		if (neID == tmpNEID)
		{
			avaliablePortData.rows[avaliablePortData.rows.length] = data.getDataRow(i);
		}
	}
	return avaliablePortData;
}

/**
 *                
 * @param data:                 
 * @return   
 */
function getAvaliablePortOtherNEData(data, neID)
{
	var avaliablePortOtherNEData = new DataInterface();
	var tmpNEID;
	for (var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		tmpNEID = parseInt(data.getDataRowParam(i,"neid"));
		if (neID != tmpNEID)
		{
			avaliablePortOtherNEData.rows[avaliablePortOtherNEData.rows.length] = data.getDataRow(i);
		}
	}
	return avaliablePortOtherNEData;
}

/**
 *        BU                
 * @param data:                 
 * @return BU                
 */
function getAvailBUInfo(data)
{
	  availBuNameTypeMap.length = 0;
	  if(data.getDataRowLength() > 0)
	  {
	      var oadmBU = data.getDataRowParam(0,"butype1");
        var fpBU = data.getDataRowParam(0,"butype2");

        availBuNameTypeMap[1] = oadmBU;
        availBuNameTypeMap[2] = fpBU;
        
        availBuNameTypeMap.length = 2;
	  }
    
}
