
var buType = new Object();
buType["1"] = "OADM_BU";
buType["2"] = "Fiber_pair_BU";
buType["3"] = "OEQ";
var DIRECTION_EAST = 1;
var DIRECTION_WEST = 0;
var newLineSrcTable; //        
var newLineSinkTable;
var rptTable;
var buTable;
var parentWin = getParentWindow(); //     
var winurlobj = parentWin.winurlobj;

var SLM_DEFAULT_SEGMENT_NUM = 0;
var SLM_MIN_REPEATER_NUM = "0";
var SLM_MAX_REPEATER_NUM = "299";
var SLM_DEFAULT_REPEATER_NUM = 4;
var SLM_LENGTH_REPEATER_NUM = 3;

var SLM_DEFAULT_BUNUM = 0;
var SLM_MIN_BUNUM = "0";
var SLM_MAX_BUNUM = "50";

var availableLineData = parentWin.availableLine;//    
var availablePortData = parentWin.availablePort;//    (   )
var availablePortOtherNE = parentWin.availablePortOtherNE;// (    )
var buNameAndTypeMap = parentWin.availBuNameTypeMap;
var lmuPortWaveLen = parentWin.lmuPortWaveLen;// LMU       
var neid = parentWin.neid;
var lmuPortData; //  LMU  
var loaPortData; //  LOA  
var lmiPortData; //  LMU  
var curNEInfo;

var sinkNEList;
var SLM_LINEMGR_MAX_REMARK_LENGTH = 63;

var BAND_TYPE_DEFAULT = "1";

var sinkLineInfo = null;
var sinkAvailableLineData = null;

var newLineID = 0;

var boardRelationData = []; //LMU LAS        

/**var SLM_DEFAULT_PROBO_WAVE_BAND = ;
 var SLM_MIN_PROBO_WAVE_BAND = ;
 var SLM_MAX_PROBO_WAVE_BAND = ;
 var SLM_DEFAULT_LOADING_WAVE_BAND = ;
 var SLM_MIN_PROBO_LOADING_BAND = ;
 var SLM_MAX_PROBO_LOADING_BAND = ;
 */
loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
loadXMLdoc("../../../../help/" + SYSTEMCONF.getLanguage() + "/helpidresource.xml", "GET", false, EncapsulateHelpConfig);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/slmlinemgr_u2kv1r3c00/slmlinemgr_" + SYSTEMCONF.getLanguage() + ".xml");
loadXMLdoc("../../conf/slmlinemgr_u2kv1r3c00/slmcreatebutable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);
document.title = RESOURCE["createLineTitle"];
/**
 *        
 * @param  
 * @return  
 */
function init()
{
    initAvaiablePort();
    
    getWaveLength();
    
    initBtn();
    initNewLineTable();
    initRptTable();
    initBUTable();
}

/**
 *        
 * @param  
 * @return  
 */
function initAvaiablePort()
{
    initAvaliablePortSrcNE();
    initAvaliablePortOtherNE();
}

/**
 *            
 * @param  
 * @return  
 */
function initAvaliablePortSrcNE()
{
    curNEInfo = new TESLMNE(neid);
    lmuPortData = [];
    loaPortData = [];
    lmiPortData = [];
    curNEInfo.lmuPortList = lmuPortData;
    curNEInfo.lasPortList = loaPortData;
    curNEInfo.lmiPortList = lmiPortData;
    
    
    var availableObj = {};
    if (null != availablePortData) 
    {
        for (var i = 0, len = availablePortData.getDataRowLength(); i < len; i++) 
        {
            curNEInfo.setNEName(availablePortData.getDataRowParam(i, "neName"));
            
            var tempTEPort = createTEPort(availablePortData, lmuPortWaveLen, i);
            
            if ((SLM_TNB2LAS_BOARDTYPE == parseInt(availablePortData.getDataRowParam(i, "boardType")))
                && (10 == parseInt(availablePortData.getDataRowParam(i, "portId"))))
            {
            	continue;
            }
            
            if ((SLM_TNB2LMU_BOARDTYPE == parseInt(availablePortData.getDataRowParam(i, "boardType")))
            && (0 == tempTEPort.probeWaveArrays.length && 0 == tempTEPort.loadingWaveArrays.length))
            {
            	 continue;
            }
            
            switch (parseInt(availablePortData.getDataRowParam(i, "boardType")))
            {
                case SLM_TNB2LMU_BOARDTYPE:
                    lmuPortData.push(createTEPort(availablePortData, lmuPortWaveLen, i));
                    break;
                case SLM_TNB2LAS_BOARDTYPE:
                    loaPortData.push(createTEPort(availablePortData, lmuPortWaveLen, i));
                    break;
                case SLM_TNB2LMI_BOARDTYPE:
                    lmiPortData.push(createTEPort(availablePortData, lmuPortWaveLen, i));
                    break;
                default:
                    continue;
            }
        }
    }
    if (null != availableLineData) 
    {
    	  deleteBoardRelation(neid, boardRelationData);
    	  
        for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++) 
        {
        	  boardRelationData.push(getBoardRelationData(neid, index, availableLineData));
        	
            var lasPort = getLASPortFromLineData(neid, index, availableLineData);
            
            refreshTEPort(lasPort.neid, lasPort.slotId, lasPort.portId, loaPortData);

            var lmiPort = getLMIPortFromLineData(neid, index, availableLineData);
            
            refreshTEPort(lmiPort.neid, lmiPort.slotId, lmiPort.portId, lmiPortData);
        }
    }
}

/**
 *            
 * @param  
 * @return  
 */
function initAvaliablePortOtherNE()
{
    sinkNEList = [];
    var tmpNEID;
    var neInfo;
    
    var tmpSinkNEList = [];
    
    if (null != availablePortOtherNE) 
    {
        for (var i = 0, len = availablePortOtherNE.getDataRowLength(); i < len; i++) 
        {
            tmpNEID = parseInt(availablePortOtherNE.getDataRowParam(i, "neid"));
            
            var tempTEPort = createTEPort(availablePortOtherNE, lmuPortWaveLen, i);
            
            if ((SLM_TNB2LAS_BOARDTYPE == parseInt(availablePortOtherNE.getDataRowParam(i, "boardType")))
                && (10 == parseInt(availablePortOtherNE.getDataRowParam(i, "portId"))))
            {
            	continue;
            }
            
            if ((SLM_TNB2LMU_BOARDTYPE == parseInt(availablePortOtherNE.getDataRowParam(i, "boardType")))
            && (0 == tempTEPort.probeWaveArrays.length && 0 == tempTEPort.loadingWaveArrays.length))
            {
            	 continue;
            }
            
            if (!haveNEData(tmpNEID, sinkNEList)) 
            {
                neInfo = new TESLMNE(tmpNEID);
                neInfo.setNEName(availablePortOtherNE.getDataRowParam(i, "neName"));
                neInfo.lmuPortList = [];
                neInfo.lasPortList = [];
                neInfo.lmiPortList = [];
                sinkNEList.push(neInfo);
            }
            neInfo = getNEInfoData(tmpNEID, sinkNEList);
            
            if ((SLM_TNB2LAS_BOARDTYPE == parseInt(availablePortOtherNE.getDataRowParam(i, "boardType")))
                && (10 == parseInt(availablePortOtherNE.getDataRowParam(i, "portId"))))
            {
            	continue;
            }
            
            switch (parseInt(availablePortOtherNE.getDataRowParam(i, "boardType")))
            {
                case SLM_TNB2LMU_BOARDTYPE:
                    neInfo.lmuPortList.push(tempTEPort);
                    break;
                case SLM_TNB2LAS_BOARDTYPE:
                    neInfo.lasPortList.push(tempTEPort);
                    break;
                case SLM_TNB2LMI_BOARDTYPE:
                    neInfo.lmiPortList.push(tempTEPort);
                    break;
                default:
                    continue;
            }
        }
        
        for (var index = sinkNEList.length - 1; index >= 0 ; index--) 
        {
        	if (0 == sinkNEList[index].lmuPortList.length)
        	{
        		sinkNEList.splice(index, 1);
        	}
        }
        
        if (sinkNEList.length > 0)
        {
        	var selectedNE = sinkNEList[0];
        	
        	querySinkLineInfo(selectedNE.neid);
 
          neInfo = getNEInfoData(selectedNE.neid, sinkNEList);
          
          if (null == neInfo)
	        {
	        	return;
	        }
          
          deleteBoardRelation(selectedNE.neid, boardRelationData);
          
	        for (var index = 0, indexLen = sinkAvailableLineData.getDataRowLength(); index < indexLen; index++) 
	        {
        	    boardRelationData.push(getBoardRelationData(selectedNE.neid, index, sinkAvailableLineData));
        	
	            var lasPort = getLASPortFromLineData(selectedNE.neid, index, sinkAvailableLineData);
	            
	            refreshTEPort(lasPort.neid, lasPort.slotId, lasPort.portId, neInfo.lasPortList);

	            var lmiPort = getLMIPortFromLineData(selectedNE.neid, index, sinkAvailableLineData);
	            
	            refreshTEPort(lmiPort.neid, lmiPort.slotId, lmiPort.portId, neInfo.lmiPortList);
	         }
        }
    }
}

/**
 *         
 * @param  
 * @return  
 */
function querySinkLineInfo(neid)
{
	var data = createQuerySinkLineInfoXML(neid)
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_LINEINFO + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", false, callbackQuerySinkLineInfoData, null, "inputdata="+data);

}
/**
 *           XML  
 * @param  
 * @return  
 */
function createQuerySinkLineInfoXML(neid)
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", "0");
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *                
 * @param doc
 * @return  
 */
function callbackQuerySinkLineInfoData(doc)
{	
	var data = EncapsulateData(doc);
  
  sinkAvailableLineData = data;
}

/**
 *      
 * @param  
 * @return  
 */
function initBtn()
{
    $("okBtn").value = RESOURCE["okBtn"];
    $("cancelBtn").value = RESOURCE["cancelBtn"];
    $("applyBtn").value = RESOURCE["applyBtn"];
}

/**
 *        
 * @param  
 * @return  
 */
function initNewLineTable()
{
    initNewLineSrcTable();
    initNewLineSinkTable();
}

/**
 *        
 * @param  
 * @return  
 */
function initNewLineSrcTable()
{
    var selectedRow = parentWin.slmLineTable.getSelectedRows();
    
    newLineSrcTable = new CTable();
    newLineSrcTable.addHead(RESOURCE["attrCol"], RESOURCE["valueCol"]);
    
    var cTableAtom = null;
    var cTableAtomEle = null;
    
    
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element;
    var tmpNEList = [];
    tmpNEList.push(curNEInfo);
    createNEOption(cTableAtomEle, tmpNEList);
    cTableAtomEle.disabled = true;
    newLineSrcTable.addAttrRow("srcNE", RESOURCE["srcNE"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    createOption(cTableAtomEle, lmuPortData);
    var lmuPort = null;
    /*
     if(0 != selectedRow.length)
     {
     var lmuMap =  parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "curNELMUInfo", "curNELMUInfo");
     lmuPort = getTEPort(lmuMap,lmuPortData);
     cTableAtom.setValue(lmuPort);
     }*/
    cTableAtomEle.onchange = srcLMUListener;
    newLineSrcTable.addAttrRow("lineMonitorUnit", RESOURCE["lineMonitorUnit"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    createOption(cTableAtomEle, loaPortData);
    if (0 != newLineSrcTable.getAtom("lineMonitorUnit").getValue() && loaPortData.length > 0)
    {
    	var lasSlotId = "";
    	var lmuTEPort = getTEPort(newLineSrcTable.getAtom("lineMonitorUnit").getValue(), lmuPortData);
    	for (var i = 0, len = boardRelationData.length; i < len; i++)
    	{
    		boardRelation = boardRelationData[i];
    		if (curNEInfo.neid == boardRelation.neid && lmuTEPort.slotId == boardRelation.lmuSlotId)
    		{
    			lasSlotId = boardRelation.lasSlotId;
    			break;
    		}
    	}
    	
    	if ("" == lasSlotId)
    	{
    		for (var i = 0, len = loaPortData.length; i < len; i++)
    		{
    			var ishave = false;
    			for (var j = 0, len1 = boardRelationData.length; j < len1; j++)
    			{
    				if (curNEInfo.neid == boardRelationData[j].neid 
    					&& loaPortData[i].slotId == boardRelationData[j].lasSlotId)
    				{
    					ishave = true;
    				}
    				
    			}
    			
    			if (!ishave)
    			{
    				lasSlotId = loaPortData[i].slotId;
    			}
    		}
    	}
    	
    	if ("" != lasSlotId)
    	{
    		var vline = selectOptionLASSlot(cTableAtomEle, lasSlotId);
        cTableAtomEle.options[vline].selected = true;
    	}
    }
    /*
     if(0 != selectedRow.length)
     {
     var loaMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "curNELASInfo", "curNELASInfo");
     cTableAtom.setValue(getTEPort(loaMap, loaPortData));
     }*/
    newLineSrcTable.addAttrRow("lineAmplifierUnit", RESOURCE["lineAmplifierUnit"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    createOption(cTableAtomEle, lmiPortData);
    newLineSrcTable.addAttrRow("lineInterfaceUnit", RESOURCE["lineInterfaceUnit"], cTableAtom);
    
    var lmuTEPort = getTEPort(newLineSrcTable.getAtom("lineMonitorUnit").getValue(), lmuPortData);
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    createProbeWaveTypeOption(cTableAtomEle, lmuTEPort);
    cTableAtomEle.onchange = srcProbeWaveTypeListener;
    newLineSrcTable.addAttrRow("probeWaveType", RESOURCE["probeWaveType"], cTableAtom);
    
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    createProbeWaveLengthOption(cTableAtomEle, newLineSrcTable.getAtom("probeWaveType").getValue(), lmuTEPort);
    newLineSrcTable.addAttrRow("probeWaveNo", RESOURCE["probeWaveNo"], cTableAtom);
    
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    createLoadingWaveTypeOption(cTableAtomEle, lmuTEPort);
    cTableAtomEle.onchange = srcLoadingWaveTypeListener;
    newLineSrcTable.addAttrRow("loadingWaveType", RESOURCE["loadingWaveType"], cTableAtom);
    
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    createLoadingWaveLengthOption(cTableAtomEle, newLineSrcTable.getAtom("loadingWaveType").getValue(), lmuTEPort);
    newLineSrcTable.addAttrRow("loadingWaveNo", RESOURCE["loadingWaveNo"], cTableAtom);
    
    $("newLineSrcTable").appendChild(newLineSrcTable.getTable());
}

/**
 *        
 * @param  
 * @return  
 */
function initNewLineSinkTable()
{
    var selectedRow = parentWin.slmLineTable.getSelectedRows();
    newLineSinkTable = new CTable();
    newLineSinkTable.addHead(RESOURCE["attrCol"], RESOURCE["valueCol"]);
    
    var cTableAtom = null;
    var cTableAtomEle = null;
    
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element;
    var tmpNEList = [];
    createNEOption(cTableAtomEle, sinkNEList);
    
    
    var selectedNE = sinkNEList[0];
    /*
    if (0 != selectedRow.length) 
    {
        var sinkNEID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "sinkNEID", "sinkNEID");
        if (sinkNEID != neid) 
        {
            var tmpNE = getNEInfoFromNEList(sinkNEID, sinkNEList);
            if (null != tmpNE) 
            {
                cTableAtom.setValue(tmpNE);
                selectedNE = tmpNE;
            }
        }
    }*/
    cTableAtom.addOption("-", 0);
    
    
    cTableAtomEle.onchange = neSelectSinkListener;
    newLineSinkTable.addAttrRow("sinkNE", RESOURCE["sinkNE"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (null != selectedNE) 
    {
        createOption(cTableAtomEle, selectedNE.lmuPortList);
    }
    else
    {
    	cTableAtom.addOption("-", 0);
    }
    
    /**if(0 != selectedRow.length)
     {
     var lmuMap = getLMUPortMapping(parentWin.slmLineTable, availableLineData, neid);
     var sinkLMUPortData = selectedNE.lmuPortList;
     if (null != lmuMap)
     {
     cTableAtom.setValue(getTEPort(lmuMap,selectedNE.lmuPortList));
     }
     }*/
    cTableAtomEle.onchange = sinkLMUListener;
    newLineSinkTable.addAttrRow("lineMonitorUnit", RESOURCE["lineMonitorUnit"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (null != selectedNE) 
    {
        createOption(cTableAtomEle, selectedNE.lasPortList);
    }
    else
    {
    	cTableAtom.addOption("-", 0);
    }
    
    if (0 != newLineSinkTable.getAtom("lineMonitorUnit").getValue() && selectedNE.lasPortList > 0)
    {
    	var lasSlotId = "";
    	var lmuTEPort = getLMITEPort(selectedNE.neid, newLineSinkTable.getAtom("lineMonitorUnit").getValue(), getNEInfoData(selectedNE.neid, sinkNEList).lmuPortList);	
    	for (var i = 0, len = boardRelationData.length; i < len; i++)
    	{
    		boardRelation = boardRelationData[i];
    		if (selectedNE.neid == boardRelation.neid && lmuTEPort.slotId == boardRelation.lmuSlotId)
    		{
    			lasSlotId = boardRelation.lasSlotId;
    			break;
    		}
    	}
    	
    	if ("" == lasSlotId)
    	{
    		for (var i = 0, len = selectedNE.lasPortList.length; i < len; i++)
    		{
    			var ishave = false;
    			for (var j = 0, len1 = boardRelationData.length; j < len1; j++)
    			{
    				if (selectedNE.neid == boardRelationData[j].neid 
    					&& selectedNE.lasPortList[i].slotId == boardRelationData[j].lasSlotId)
    				{
    					ishave = true;
    				}
    				
    			}
    			
    			if (!ishave)
    			{
    				lasSlotId = selectedNE.lasPortList[i].slotId;
    			}
    		}
    	}
    	
    	if ("" != lasSlotId)
    	{
    		var vline = selectOptionLASSlot(cTableAtomEle, lasSlotId);
        cTableAtomEle.options[vline].selected = true;
    	}
    }
    /**if(0 != selectedRow.length)
     {
     var loaMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineAmplifierUnit", "lineAmplifierUnit");
     var sinkLOAPortData = selectedNE.lasPortList;
     if (null != loaMap)
     {
     cTableAtom.setValue(getTEPort(loaMap, selectedNE.lasPortList));
     }
     }*/
    newLineSinkTable.addAttrRow("lineAmplifierUnit", RESOURCE["lineAmplifierUnit"], cTableAtom);
    
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    cTableAtom.setValue();
    if (null != selectedNE) 
    {
        createOption(cTableAtomEle, selectedNE.lmiPortList);
    }
    else
    {
    	cTableAtom.addOption("-", 0);
    }
    
    newLineSinkTable.addAttrRow("lineInterfaceUnit", RESOURCE["lineInterfaceUnit"], cTableAtom);
    
    var lmuTEPort = null;
    if (null != selectedNE)
    {
        lmuTEPort = getLMITEPort(selectedNE.neid, newLineSinkTable.getAtom("lineMonitorUnit").getValue(), getNEInfoData(selectedNE.neid, sinkNEList).lmuPortList);	
    }
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (null != lmuTEPort)
    {
    	createProbeWaveTypeOption(cTableAtomEle, lmuTEPort);
      cTableAtomEle.onchange = sinkProbeWaveTypeListener;
    }
    else
    {
    	cTableAtom.addOption("-", 0);
    }
    newLineSinkTable.addAttrRow("probeWaveType", RESOURCE["probeWaveType"], cTableAtom);
    
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (null != lmuTEPort)
    {
      createProbeWaveLengthOption(cTableAtomEle, newLineSinkTable.getAtom("probeWaveType").getValue(), lmuTEPort);
    }
    else
    {
    	cTableAtom.addOption("-", 0);
    }
    newLineSinkTable.addAttrRow("probeWaveNo", RESOURCE["probeWaveNo"], cTableAtom);
    
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (null != lmuTEPort)
    {
      createLoadingWaveTypeOption(cTableAtomEle, lmuTEPort);
      cTableAtomEle.onchange = sinkLoadingWaveTypeListener;
    }
    else
    {
    	cTableAtom.addOption("-", 0);
    }
    newLineSinkTable.addAttrRow("loadingWaveType", RESOURCE["loadingWaveType"], cTableAtom);
    
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    if (null != lmuTEPort)
    {
      createLoadingWaveLengthOption(cTableAtomEle, newLineSinkTable.getAtom("loadingWaveType").getValue(), lmuTEPort);
    }
    else
    {
    	cTableAtom.addOption("-", 0);
    }
    newLineSinkTable.addAttrRow("loadingWaveNo", RESOURCE["loadingWaveNo"], cTableAtom);
    
    $("newLineSinkTable").appendChild(newLineSinkTable.getTable());
    
    var sinkNE = newLineSinkTable.getAtom("sinkNE").getValue();
    
    if (0 == sinkNE) 
    {        
        newLineSinkTable.getAtom("lineMonitorUnit").element.disabled = true;
        newLineSinkTable.getAtom("lineMonitorUnit").element.options[newLineSinkTable.getAtom("lineMonitorUnit").element.options.length - 1].selected = true;
        
        newLineSinkTable.getAtom("lineAmplifierUnit").element.disabled = true;
        newLineSinkTable.getAtom("lineAmplifierUnit").element.options[newLineSinkTable.getAtom("lineAmplifierUnit").element.options.length - 1].selected = true;
        
        newLineSinkTable.getAtom("lineInterfaceUnit").element.disabled = true;
        newLineSinkTable.getAtom("lineInterfaceUnit").element.options[newLineSinkTable.getAtom("lineInterfaceUnit").element.options.length - 1].selected = true;
        
        newLineSinkTable.getAtom("probeWaveType").element.disabled = true;

        newLineSinkTable.getAtom("probeWaveNo").element.disabled = true;
        newLineSinkTable.getAtom("loadingWaveType").element.disabled = true;
        newLineSinkTable.getAtom("loadingWaveNo").element.disabled = true;
    }
    
    if (0 == newLineSinkTable.getAtom("probeWaveType").element.options.length)
    {
    	  newLineSinkTable.getAtom("lineMonitorUnit").element.disabled = true;
        newLineSinkTable.getAtom("lineMonitorUnit").element.options[newLineSinkTable.getAtom("lineMonitorUnit").element.options.length - 1].selected = true;
        
        newLineSinkTable.getAtom("lineAmplifierUnit").element.disabled = true;
        newLineSinkTable.getAtom("lineAmplifierUnit").element.options[newLineSinkTable.getAtom("lineAmplifierUnit").element.options.length - 1].selected = true;
        
        newLineSinkTable.getAtom("lineInterfaceUnit").element.disabled = true;
        newLineSinkTable.getAtom("lineInterfaceUnit").element.options[newLineSinkTable.getAtom("lineInterfaceUnit").element.options.length - 1].selected = true;
        
        newLineSinkTable.getAtom("probeWaveType").element.disabled = true;
        newLineSinkTable.getAtom("probeWaveNo").element.disabled = true;
        newLineSinkTable.getAtom("loadingWaveType").element.disabled = true;
        newLineSinkTable.getAtom("loadingWaveNo").element.disabled = true;
    }
}

/**
 *        
 * @param  
 * @return  
 */
function srcLMUListener(evt)
{
	  var cTableAtomEle = null;
    var lmuTEPort = getTEPort(newLineSrcTable.getAtom("lineMonitorUnit").getValue(), lmuPortData);

    cTableAtomEle = newLineSrcTable.getAtom("probeWaveType").element;
    createProbeWaveTypeOption(cTableAtomEle, lmuTEPort);
    cTableAtomEle.onchange = srcProbeWaveTypeListener;
    
    cTableAtomEle = newLineSrcTable.getAtom("probeWaveNo").element;
    createProbeWaveLengthOption(cTableAtomEle, newLineSrcTable.getAtom("probeWaveType").getValue(), lmuTEPort);
    
    cTableAtomEle = newLineSrcTable.getAtom("loadingWaveType").element;
    createLoadingWaveTypeOption(cTableAtomEle, lmuTEPort);
    cTableAtomEle.onchange = srcLoadingWaveTypeListener;
    
    cTableAtomEle = newLineSrcTable.getAtom("loadingWaveNo").element;
    createLoadingWaveLengthOption(cTableAtomEle, newLineSrcTable.getAtom("loadingWaveType").getValue(), lmuTEPort);
    
    if (0 != newLineSrcTable.getAtom("lineMonitorUnit").getValue() && loaPortData.length > 0)
    {
    	var cTableAtomEle = newLineSrcTable.getAtom("lineAmplifierUnit").element;
    	var lasSlotId = "";
    	var lmuTEPort = getTEPort(newLineSrcTable.getAtom("lineMonitorUnit").getValue(), lmuPortData);
    	for (var i = 0, len = boardRelationData.length; i < len; i++)
    	{
    		boardRelation = boardRelationData[i];
    		if (curNEInfo.neid == boardRelation.neid && lmuTEPort.slotId == boardRelation.lmuSlotId)
    		{
    			lasSlotId = boardRelation.lasSlotId;
    			break;
    		}
    	}
    	
    	if ("" == lasSlotId)
    	{
    		for (var i = 0, len = loaPortData.length; i < len; i++)
    		{
    			var ishave = false;
    			for (var j = 0, len1 = boardRelationData.length; j < len1; j++)
    			{
    				if (curNEInfo.neid == boardRelationData[j].neid 
    					&& loaPortData[i].slotId == boardRelationData[j].lasSlotId)
    				{
    					ishave = true;
    				}
    				
    			}
    			
    			if (!ishave)
    			{
    				lasSlotId = loaPortData[i].slotId;
    			}
    		}
    	}
    	
    	if ("" != lasSlotId)
    	{
    		var vline = selectOptionLASSlot(cTableAtomEle, lasSlotId);
        cTableAtomEle.options[vline].selected = true;
    	}
    }
}

/**
 *        
 * @param  
 * @return  
 */
function srcLASListener(evt)
{
	  var cTableAtomEle = null;
	  var lasTEPort = getTEPort(newLineSrcTable.getAtom("lineAmplifierUnit").getValue(), loaPortData);
	  
	  if (0 != newLineSrcTable.getAtom("lineAmplifierUnit").getValue() && lmuPortData.length > 0)
    {
    	var cTableAtom = newLineSrcTable.getAtom("lineMonitorUnit");
    	var cTableAtomEle = newLineSrcTable.getAtom("lineMonitorUnit").element;
    	var lmuSlotId = "";
    	for (var i = 0, len = boardRelationData.length; i < len; i++)
    	{
    		boardRelation = boardRelationData[i];
    		if (curNEInfo.neid == boardRelation.neid && lasTEPort.slotId == boardRelation.lasSlotId)
    		{
    			lmuSlotId = boardRelation.lmuSlotId;
    			break;
    		}
    	}
    	
    	if ("" == lmuSlotId)
    	{
    		for (var i = 0, len = lmuPortData.length; i < len; i++)
    		{
    			var ishave = false;
    			for (var j = 0, len1 = boardRelationData.length; j < len1; j++)
    			{
    				if (curNEInfo.neid == boardRelationData[j].neid 
    					&& lmuPortData[i].slotId == boardRelationData[j].lmuSlotId)
    				{
    					ishave = true;
    				}
    				
    			}
    			
    			if (!ishave)
    			{
    				lmuSlotId = lmuPortData[i].slotId;
    			}
    		}
    	}
    	
    	if ("" != lmuSlotId)
    	{
    		var vline = selectOptionLASSlot(cTableAtomEle, lmuSlotId);
        cTableAtomEle.options[vline].selected = true;
        
	    	var lmuTEPort = getTEPort(newLineSrcTable.getAtom("lineMonitorUnit").getValue(), lmuPortData);
	    	
		    cTableAtomEle = newLineSrcTable.getAtom("probeWaveType").element;
		    createProbeWaveTypeOption(cTableAtomEle, lmuTEPort);
		    cTableAtomEle.onchange = srcProbeWaveTypeListener;
		    
		    cTableAtomEle = newLineSrcTable.getAtom("probeWaveNo").element;
		    createProbeWaveLengthOption(cTableAtomEle, newLineSrcTable.getAtom("probeWaveType").getValue(), lmuTEPort);
		    
		    cTableAtomEle = newLineSrcTable.getAtom("loadingWaveType").element;
		    createLoadingWaveTypeOption(cTableAtomEle, lmuTEPort);
		    cTableAtomEle.onchange = srcLoadingWaveTypeListener;
		    
		    cTableAtomEle = newLineSrcTable.getAtom("loadingWaveNo").element;
		    createLoadingWaveLengthOption(cTableAtomEle, newLineSrcTable.getAtom("loadingWaveType").getValue(), lmuTEPort);
    	}
    	else
    	{
    		    cTableAtom.addOption("-", 0);
	        	if (cTableAtomEle.options.length > 0)
		        {
		        	cTableAtomEle.options[cTableAtomEle.options.length - 1].selected = true;
		        }
    	}
    }
}

/**
 *        
 * @param  
 * @return  
 */
function sinkLMUListener(evt)
{
	  var sinkNE = newLineSinkTable.getAtom("sinkNE").getValue();
	  var selectedNE = null;
   	for (var i = 0, len = sinkNEList.length; i < len; i++)
   	{
    	 var slmNE = sinkNEList[i];
    	 if (sinkNE == slmNE)
    	 {
    	   selectedNE = sinkNEList[i];
    	   break;
    	 }
    }
	  
	  var lmuTEPort = null;
    if (null != selectedNE)
    {
        lmuTEPort = getLMITEPort(selectedNE.neid, newLineSinkTable.getAtom("lineMonitorUnit").getValue(), getNEInfoData(selectedNE.neid, sinkNEList).lmuPortList);	
    }
	  
    var cTableAtomEle = null;
    
    if (null != lmuTEPort)
    {
    	cTableAtomEle = newLineSinkTable.getAtom("probeWaveType").element;
    	createProbeWaveTypeOption(cTableAtomEle, lmuTEPort);
      cTableAtomEle.onchange = sinkProbeWaveTypeListener;

      cTableAtomEle = newLineSinkTable.getAtom("probeWaveNo").element;
      createProbeWaveLengthOption(cTableAtomEle, newLineSinkTable.getAtom("probeWaveType").getValue(), lmuTEPort);
      
      cTableAtomEle = newLineSinkTable.getAtom("loadingWaveType").element;
      createLoadingWaveTypeOption(cTableAtomEle, lmuTEPort);
      cTableAtomEle.onchange = sinkLoadingWaveTypeListener;
      
      cTableAtomEle = newLineSinkTable.getAtom("loadingWaveNo").element;
      createLoadingWaveLengthOption(cTableAtomEle, newLineSinkTable.getAtom("loadingWaveType").getValue(), lmuTEPort);
    }
    else
    {
    	newLineSinkTable.getAtom("probeWaveType").addOption("-", 0);
    	newLineSinkTable.getAtom("probeWaveNo").addOption("-", 0);
    	newLineSinkTable.getAtom("loadingWaveType").addOption("-", 0);
    	newLineSinkTable.getAtom("loadingWaveNo").addOption("-", 0);
    }
    
    if (0 != newLineSinkTable.getAtom("lineMonitorUnit").getValue() && selectedNE.lasPortList > 0)
    {
    	var cTableAtomEle = newLineSinkTable.getAtom("lineAmplifierUnit").element;
    	var lasSlotId = "";
    	var lmuTEPort = getLMITEPort(selectedNE.neid, newLineSinkTable.getAtom("lineMonitorUnit").getValue(), getNEInfoData(selectedNE.neid, sinkNEList).lmuPortList);	
    	for (var i = 0, len = boardRelationData.length; i < len; i++)
    	{
    		boardRelation = boardRelationData[i];
    		if (selectedNE.neid == boardRelation.neid && lmuTEPort.slotId == boardRelation.lmuSlotId)
    		{
    			lasSlotId = boardRelation.lasSlotId;
    			break;
    		}
    	}
    	
    	if ("" == lasSlotId)
    	{
    		for (var i = 0, len = selectedNE.lasPortList.length; i < len; i++)
    		{
    			var ishave = false;
    			for (var j = 0, len1 = boardRelationData.length; j < len1; j++)
    			{
    				if (selectedNE.neid == boardRelationData[j].neid 
    					&& selectedNE.lasPortList[i].slotId == boardRelationData[j].lasSlotId)
    				{
    					ishave = true;
    				}
    				
    			}
    			
    			if (!ishave)
    			{
    				lasSlotId = selectedNE.lasPortList[i].slotId;
    			}
    		}
    	}
    	
    	if ("" != lasSlotId)
    	{
    		var vline = selectOptionLASSlot(cTableAtomEle, lasSlotId);
        cTableAtomEle.options[vline].selected = true;
    	}
    }
}

/**
 *        
 * @param  
 * @return  
 */
function sinkLASListener(evt)
{
	  var sinkNE = newLineSinkTable.getAtom("sinkNE").getValue();
	  var selectedNE = null;
   	for (var i = 0, len = sinkNEList.length; i < len; i++)
   	{
    	 var slmNE = sinkNEList[i];
    	 if (sinkNE == slmNE)
    	 {
    	   selectedNE = sinkNEList[i];
    	   break;
    	 }
    }
	  
	  var lasTEPort = null;
	  if (null != selectedNE)
    {
        lasTEPort = getLMITEPort(selectedNE.neid, newLineSinkTable.getAtom("lineAmplifierUnit").getValue(), getNEInfoData(selectedNE.neid, sinkNEList).lasPortList);	
    }
	  
    if (0 != newLineSinkTable.getAtom("lineAmplifierUnit").getValue() && selectedNE.lmuPortList > 0)
    {
    	var cTableAtom = newLineSrcTable.getAtom("lineMonitorUnit");
    	var cTableAtomEle = newLineSinkTable.getAtom("lineMonitorUnit").element;
    	var lmuSlotId = "";
    	for (var i = 0, len = boardRelationData.length; i < len; i++)
    	{
    		boardRelation = boardRelationData[i];
    		if (selectedNE.neid == boardRelation.neid && lasTEPort.slotId == boardRelation.lasSlotId)
    		{
    			lmuSlotId = boardRelation.lmuSlotId;
    			break;
    		}
    	}
    	
    	if ("" == lmuSlotId)
    	{
    		for (var i = 0, len = selectedNE.lmuPortList.length; i < len; i++)
    		{
    			var ishave = false;
    			for (var j = 0, len1 = boardRelationData.length; j < len1; j++)
    			{
    				if (selectedNE.neid == boardRelationData[j].neid 
    					&& selectedNE.lmuPortList[i].slotId == boardRelationData[j].lmuSlotId)
    				{
    					ishave = true;
    				}
    				
    			}
    			
    			if (!ishave)
    			{
    				lmuSlotId = selectedNE.lmuPortList[i].slotId;
    			}
    		}
    	}
    	
    	if ("" != lmuSlotId)
    	{
    		var vline = selectOptionLASSlot(cTableAtomEle, lmuSlotId);
        cTableAtomEle.options[vline].selected = true;
        
        lmuTEPort = getLMITEPort(selectedNE.neid, newLineSinkTable.getAtom("lineMonitorUnit").getValue(), getNEInfoData(selectedNE.neid, sinkNEList).lmuPortList);	
        
        if (null != lmuTEPort)
		    {
		    	cTableAtomEle = newLineSinkTable.getAtom("probeWaveType").element;
		    	createProbeWaveTypeOption(cTableAtomEle, lmuTEPort);
		      cTableAtomEle.onchange = sinkProbeWaveTypeListener;
		
		      cTableAtomEle = newLineSinkTable.getAtom("probeWaveNo").element;
		      createProbeWaveLengthOption(cTableAtomEle, newLineSinkTable.getAtom("probeWaveType").getValue(), lmuTEPort);
		      
		      cTableAtomEle = newLineSinkTable.getAtom("loadingWaveType").element;
		      createLoadingWaveTypeOption(cTableAtomEle, lmuTEPort);
		      cTableAtomEle.onchange = sinkLoadingWaveTypeListener;
		      
		      cTableAtomEle = newLineSinkTable.getAtom("loadingWaveNo").element;
		      createLoadingWaveLengthOption(cTableAtomEle, newLineSinkTable.getAtom("loadingWaveType").getValue(), lmuTEPort);
		    }
		    else
		    {
		    	newLineSinkTable.getAtom("probeWaveType").addOption("-", 0);
		    	newLineSinkTable.getAtom("probeWaveNo").addOption("-", 0);
		    	newLineSinkTable.getAtom("loadingWaveType").addOption("-", 0);
		    	newLineSinkTable.getAtom("loadingWaveNo").addOption("-", 0);
		    }
    	}
    	else
    	{
    		    cTableAtom.addOption("-", 0);
	        	if (cTableAtomEle.options.length > 0)
		        {
		        	cTableAtomEle.options[cTableAtomEle.options.length - 1].selected = true;
		        }
    	}
    	
    }
	  
}

/**
 *        
 * @param  
 * @return  
 */
function srcProbeWaveTypeListener(evt)
{
    var probeWaveType = newLineSrcTable.getAtom("probeWaveType").getValue();
    var cTableAtom = newLineSrcTable.getAtom("probeWaveNo");
    var cTableAtomEle = cTableAtom.element;
    createWaveLengthOption(cTableAtomEle, probeWaveType);
}

/**
 *        
 * @param  
 * @return  
 */
function srcLoadingWaveTypeListener(evt)
{
    var loadingWaveType = newLineSrcTable.getAtom("loadingWaveType").getValue();
    var cTableAtom = newLineSrcTable.getAtom("loadingWaveNo");
    var cTableAtomEle = cTableAtom.element;
    createWaveLengthOption(cTableAtomEle, loadingWaveType);
}

/**
 *        
 * @param  
 * @return  
 */
function sinkProbeWaveTypeListener(evt)
{
    var probeWaveType = newLineSinkTable.getAtom("probeWaveType").getValue();
    var cTableAtom = newLineSinkTable.getAtom("probeWaveNo");
    var cTableAtomEle = cTableAtom.element;
    createWaveLengthOption(cTableAtomEle, probeWaveType);
}

/**
 *        
 * @param  
 * @return  
 */
function sinkLoadingWaveTypeListener(evt)
{
    var loadingWaveType = newLineSinkTable.getAtom("loadingWaveType").getValue();
    var cTableAtom = newLineSinkTable.getAtom("loadingWaveNo");
    var cTableAtomEle = cTableAtom.element;
    createWaveLengthOption(cTableAtomEle, loadingWaveType);
}

/**
 *            
 * @param  
 * @return  
 */
function initBUTable()
{
    buTable = new SortTable();
    buTable.setImage("../../../../images/");
    var lineTableOffset = 0;
    if (isIE) 
    {
        lineTableOffset = document.body.offsetHeight * 0.35;
    }
    else 
    {
        lineTableOffset = document.body.clientHeight * 0.35;
    }
    buTable.setBodyHeight(getComponetHeight($("buTable"), lineTableOffset) + "px");
    createTableHead(buTable, window.tableconf[0]);
    var newData = new DataInterface();
    createTableBody(buTable, window.tableconf[0], newData, RESOURCE);
	  buTable.setOnRowSelectHandler(rowSelectHandlerParamTable); 
	  
	  buTable.setOnCellEditHandler(buTblCellEditHandler);
	  
    $("buTable").oncontextmenu = popupMenuHandler
    $("buTable").appendChild(buTable.getTable());
    
    
}

function rowSelectHandlerParamTable(rows)
{
  	var len = buTable.getDataRowLength();
		for (var i=0; i<len; i++)
		{
				setCellSelected(buTable, i, "eqptType");
        setCellSelected(buTable, i, "eqptName");
        setCellSelected(buTable, i, "spanId");
        setCellSelected(buTable, i, "eqptPos");
		}
}

/**
 *        
 * @param   
 */
function buTblCellEditHandler(param)
{
    var rowindex = param["rowindex"];
	  var colID = param["colid"];
	  var stage = param["stage"];
	  
	  if(stage == TABLE_CONSTANT.BEFOREEDIT && colID == "eqptName")
	  {
	      var eqptNameCellEdit = buTable.getCellEdit(rowindex, colID);
	  	  
	  	  eqptNameCellEdit.element.options.length = 0;
	  	  
	  	  var selectedType = buTable.getCellStoreValue(rowindex, "eqptType", "eqptType");
	  	  if(3 != selectedType && 0 != buNameAndTypeMap.length)
	  	  {
	  	      var buNames = buNameAndTypeMap[selectedType];
	  	      if(null != buNames && "" != buNames)
	  	      {
	  	          var buNameArr = buNames.split(",");
	  	          for(var i = 0; i < buNameArr.length; i++)
	  	          {
	  	              eqptNameCellEdit.addOption(buNameArr[i], buNameArr[i]);
	  	          }
	  	      }
	  	      
	  	  }
	  }
}

/**
 *          
 * @param  
 * @return  
 */
function initRptTable()
{
    rptTable = new CTable();
    
    var cTableAtom = null;
    var cTableAtomEle = null;
    
    cTableAtom = new Atom("text");
    cTableAtom.setValue(SLM_DEFAULT_REPEATER_NUM);
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = false;
    checkText(cTableAtomEle, SLM_MIN_REPEATER_NUM, SLM_MAX_REPEATER_NUM);
    cTableAtomEle.onblur = repeaterNumChangeListener;
    rptTable.addAttrRow("repeaterNum", RESOURCE["repeaterNum"], cTableAtom);
    
    cTableAtom = new Atom("text");
    cTableAtom.setValue(SLM_DEFAULT_REPEATER_NUM + 1);
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = true;
    rptTable.addAttrRow("segmentNum", RESOURCE["segmentNum"], cTableAtom);
    
    cTableAtom = new Atom("text");
    cTableAtom.setValue(SLM_DEFAULT_BUNUM);
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = false;
    checkText(cTableAtomEle, SLM_MIN_BUNUM, SLM_MAX_BUNUM);
    cTableAtomEle.onblur = buNumChangeListener;
    rptTable.addAttrRow("buEquipmentNum", RESOURCE["buEquipmentNum"], cTableAtom);
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = false;
    cTableAtomEle.onpaste = function()
	  {
		    return false;
	  }
    cTableAtom.element["onkeypress"] = function()
    {
        if (restrictByAllow(this,window.event,"\"`'\\=,:;?&!(){}[]<>/"))
        {
        	return calStrSinoLen(this,SLM_LINEMGR_MAX_REMARK_LENGTH);
        }
        else
        {
        	return false;
        }
    }
    cTableAtomEle.onkeyup = function()
    {
        return calStrSinoLen(this, SLM_LINEMGR_MAX_REMARK_LENGTH);        
    }
    rptTable.addAttrRow("remark", RESOURCE["remarkDiv"], cTableAtom);
    
    $("rptTable").appendChild(rptTable.getTable());
}

/**
 *              
 * @param  
 * @return  
 */
function remarkLengthCheckListener(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    return calStrSinoLen(newLineSrcTable.getAtom("remark").element, SLM_LINEMGR_MAX_REMARK_LENGTH);
}

/**
 *   LMU      
 * @param  
 * @return  
 */
function lmuSelectListener(evt)
{
    newLineSrcTable.getAtom("lineAmplifierUnit").element.onchange = null;
    if (!evt) 
    {
        evt = window.event;
    }
    $("applyBtn").disabled = false;
    var slotId;
    var portId;
    var lmuPort = newLineSrcTable.getAttrValue("lineMonitorUnit");
    if (null != availableLineData) 
    {
        for (var i = 0, len = availableLineData.getDataRowLength(); i < len; i++) 
        {
            slotId = availableLineData.getDataRowParam(i, "lmuSlotId");
            portId = availableLineData.getDataRowParam(i, "lmuPortId");
            lmuSlotId = lmuPort.split("-")[0];
            lmuPortId = lmuPort.split("-")[2].split("(")[0];
            if (lmuSlotId == slotId && lmuPortId == portId) 
            {
                newLineSrcTable.setAttrValue("lineAmplifierUnit", getPort(availableLineData.getDataRowParam(i, "loaneid"), availableLineData.getDataRowParam(i, "loaSlotId"), availableLineData.getDataRowParam(i, "loaPortId"), loaPortData));
                break;
            }
        }
    }
    newLineSrcTable.getAtom("lineAmplifierUnit").element.onchange = loaSelectListener;
}

function neSelectSinkListener(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    
    var sinkNE = newLineSinkTable.getAtom("sinkNE").getValue();
    
    if (0 == sinkNE) 
    {        
        newLineSinkTable.getAtom("lineMonitorUnit").element.disabled = true;
        createNullOption(newLineSinkTable.getAtom("lineMonitorUnit").element);
        
        newLineSinkTable.getAtom("lineAmplifierUnit").element.disabled = true;
        createNullOption(newLineSinkTable.getAtom("lineAmplifierUnit").element);
        
        newLineSinkTable.getAtom("lineInterfaceUnit").element.disabled = true;
        createNullOption(newLineSinkTable.getAtom("lineInterfaceUnit").element);
        
        newLineSinkTable.getAtom("probeWaveType").element.disabled = true;
        createNullOption(newLineSinkTable.getAtom("probeWaveType").element);
        
        newLineSinkTable.getAtom("probeWaveNo").element.disabled = true;
        createNullOption(newLineSinkTable.getAtom("probeWaveNo").element);
        
        newLineSinkTable.getAtom("loadingWaveType").element.disabled = true;
        createNullOption(newLineSinkTable.getAtom("loadingWaveType").element);
        
        newLineSinkTable.getAtom("loadingWaveNo").element.disabled = true;
        createNullOption(newLineSinkTable.getAtom("loadingWaveNo").element);
    }
    else
    {
    	  var selectedNE = null;
    	  for (var i = 0, len = sinkNEList.length; i < len; i++)
    	  {
    	  	var slmNE = sinkNEList[i];
    	  	if (sinkNE == slmNE)
    	  	{
    	  		selectedNE = sinkNEList[i];
    	  		break;
    	  	}
    	  }
    	  
    	  querySinkLineInfoListener(selectedNE.neid);
    }
}

/**
 *         
 * @param  
 * @return  
 */
function querySinkLineInfoListener(neid)
{
  $("okBtn").disabled = true;
  $("applyBtn").disabled = true;
  $("cancelBtn").disabled = true;
  setAllElement(true);  
    
	var data = createQuerySinkLineInfoXML(neid)
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_LINEINFO + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackQuerySinkLineInfoListenerData, null, "inputdata="+data);

}

/**
 *                
 * @param doc
 * @return  
 */
function callbackQuerySinkLineInfoListenerData(doc)
{
	var data = EncapsulateData(doc);
  
  sinkAvailableLineData = data;
  
  var errorCode = data.getSErrorCode();
  
  if (0 == errorCode)
  {
  	var sinkNE = newLineSinkTable.getAtom("sinkNE").getValue();
  	var selectedNE = null;
    for (var i = 0, len = sinkNEList.length; i < len; i++)
    {
      var slmNE = sinkNEList[i];
    	if (sinkNE == slmNE)
    	{
    	  selectedNE = sinkNEList[i];
    	  break;
    	}
    }
    
    neInfo = getNEInfoData(selectedNE.neid, sinkNEList);
    
  	if (null != neInfo)
  	{
  		deleteBoardRelation(selectedNE.neid, boardRelationData);
  		
		  for (var index = 0, indexLen = sinkAvailableLineData.getDataRowLength(); index < indexLen; index++) 
		  {
        boardRelationData.push(getBoardRelationData(selectedNE.neid, index, sinkAvailableLineData));
        	
        	
				var lasPort = getLASPortFromLineData(selectedNE.neid, index, sinkAvailableLineData);
					            
				refreshTEPort(lasPort.neid, lasPort.slotId, lasPort.portId, neInfo.lasPortList);
				
				var lmiPort = getLMIPortFromLineData(selectedNE.neid, index, sinkAvailableLineData);
					            
				refreshTEPort(lmiPort.neid, lmiPort.slotId, lmiPort.portId, neInfo.lmiPortList);
			} 
		}
  	
	  newLineSinkTable.getAtom("lineMonitorUnit").element.disabled = false;
	  createOption(newLineSinkTable.getAtom("lineMonitorUnit").element, selectedNE.lmuPortList);
	    	  
	  newLineSinkTable.getAtom("lineAmplifierUnit").element.disabled = false;
	  createOption(newLineSinkTable.getAtom("lineAmplifierUnit").element, selectedNE.lasPortList);
	    	  
	  newLineSinkTable.getAtom("lineInterfaceUnit").element.disabled = false;
	  createOption(newLineSinkTable.getAtom("lineInterfaceUnit").element, selectedNE.lmiPortList);
	  
	  var lmuTEPort = null;
	  if (null != selectedNE)
	  {
	    lmuTEPort = getLMITEPort(selectedNE.neid, newLineSinkTable.getAtom("lineMonitorUnit").getValue(), getNEInfoData(selectedNE.neid, sinkNEList).lmuPortList);	
	  }
	  
	  if (null != lmuTEPort)
	  {
	    	createProbeWaveTypeOption(newLineSinkTable.getAtom("probeWaveType").element, lmuTEPort);
	    	createProbeWaveLengthOption(newLineSinkTable.getAtom("probeWaveNo").element, newLineSinkTable.getAtom("probeWaveType").getValue(), lmuTEPort);
	    	createLoadingWaveTypeOption(newLineSinkTable.getAtom("loadingWaveType").element, lmuTEPort);
	    	createLoadingWaveLengthOption(newLineSinkTable.getAtom("loadingWaveNo").element, newLineSinkTable.getAtom("loadingWaveType").getValue(), lmuTEPort);
	  }
	  else
	  {
	  	  newLineSinkTable.getAtom("probeWaveType").addOption("-", 0);
	      newLineSinkTable.getAtom("probeWaveNo").addOption("-", 0);
	      newLineSinkTable.getAtom("loadingWaveType").addOption("-", 0);
	      newLineSinkTable.getAtom("loadingWaveNo").addOption("-", 0);
	  }
	  newLineSinkTable.getAtom("probeWaveType").element.disabled = false;  
	  newLineSinkTable.getAtom("probeWaveNo").element.disabled = false
	  newLineSinkTable.getAtom("loadingWaveType").element.disabled = false;
	  newLineSinkTable.getAtom("loadingWaveNo").element.disabled = false;
  }
  
    if (0 != newLineSinkTable.getAtom("lineMonitorUnit").getValue() && selectedNE.lasPortList > 0)
    {
    	var cTableAtomEle = newLineSinkTable.getAtom("lineAmplifierUnit").element;
    	var lasSlotId = "";
    	var lmuTEPort = getLMITEPort(selectedNE.neid, newLineSinkTable.getAtom("lineMonitorUnit").getValue(), getNEInfoData(selectedNE.neid, sinkNEList).lmuPortList);	
    	for (var i = 0, len = boardRelationData.length; i < len; i++)
    	{
    		boardRelation = boardRelationData[i];
    		if (selectedNE.neid == boardRelation.neid && lmuTEPort.slotId == boardRelation.lmuSlotId)
    		{
    			lasSlotId = boardRelation.lasSlotId;
    			break;
    		}
    	}
    	
    	if ("" == lasSlotId)
    	{
    		for (var i = 0, len = selectedNE.lasPortList.length; i < len; i++)
    		{
    			var ishave = false;
    			for (var j = 0, len1 = boardRelationData.length; j < len1; j++)
    			{
    				if (selectedNE.neid == boardRelationData[j].neid 
    					&& selectedNE.lasPortList[i].slotId == boardRelationData[j].lasSlotId)
    				{
    					ishave = true;
    				}
    				
    			}
    			
    			if (!ishave)
    			{
    				lasSlotId = selectedNE.lasPortList[i].slotId;
    			}
    		}
    	}
    	
    	if ("" != lasSlotId)
    	{
    		var vline = selectOptionLASSlot(cTableAtomEle, lasSlotId);
        cTableAtomEle.options[vline].selected = true;
    	}
    }
  
  $("okBtn").disabled = false;
  $("applyBtn").disabled = false;
  $("cancelBtn").disabled = false;
  setAllElement(false);
  
  showErrorDialog(data);
}

/**
 *   LOA      
 * @param  
 * @return  
 */
function loaSelectListener(evt)
{
    newLineSrcTable.getAtom("lineMonitorUnit").element.onchange = null;
    if (!evt) 
    {
        evt = window.event;
    }
    $("applyBtn").disabled = false;
    var slotId;
    var portId;
    var loaPort = newLineSrcTable.getAttrValue("lineAmplifierUnit");
    if (null != availableLineData) 
    {
        for (var i = 0, len = availableLineData.getDataRowLength(); i < len; i++) 
        {
            slotId = availableLineData.getDataRowParam(i, "loaSlotId");
            portId = availableLineData.getDataRowParam(i, "loaPortId");
            loaSlotId = loaPort.split("-")[0];
            loaPortId = loaPort.split("-")[2].split("(")[0];
            if (loaSlotId == slotId && loaPortId == portId) 
            {
                newLineSrcTable.setAttrValue("lineMonitorUnit", getPort(availableLineData.getDataRowParam(i, "lmuneid"), availableLineData.getDataRowParam(i, "lmuSlotId"), availableLineData.getDataRowParam(i, "lmuPortId"), lmuPortData));
                break;
            }
        }
    }
    newLineSrcTable.getAtom("lineMonitorUnit").element.onchange = lmuSelectListener;
}

/**
 *   LSU      
 * @param  
 * @return  
 */
function lsuSelectListener(evt)
{
    newLineSrcTable.getAtom("lineMonitorUnit").element.onchange = null;
    newLineSrcTable.getAtom("lineAmplifierUnit").element.onchange = null;
    if (!evt) 
    {
        evt = window.event;
    }
    $("applyBtn").disabled = false;
    var slotId;
    var portId;
    var lsuPort = newLineSrcTable.getAttrValue("lineSelectUnit");
    if (null != availableLineData) 
    {
        for (var i = 0, len = availableLineData.getDataRowLength(); i < len; i++) 
        {
            slotId = availableLineData.getDataRowParam(i, "lsuSlotId");
            lsuSlotId = lsuPort.split("-")[0];
            if (lsuSlotId == slotId) 
            {
                newLineSrcTable.setAttrValue("lineMonitorUnit", getPort(availableLineData.getDataRowParam(i, "lmuneid"), availableLineData.getDataRowParam(i, "lmuSlotId"), availableLineData.getDataRowParam(i, "lmuPortId"), lmuPortData));
                newLineSrcTable.setAttrValue("lineAmplifierUnit", getPort(availableLineData.getDataRowParam(i, "loaneid"), availableLineData.getDataRowParam(i, "loaSlotId"), availableLineData.getDataRowParam(i, "loaPortId"), loaPortData));
                break;
            }
        }
    }
    newLineSrcTable.getAtom("lineMonitorUnit").element.onchange = lmuSelectListener;
    newLineSrcTable.getAtom("lineAmplifierUnit").element.onchange = loaSelectListener;
}

/**
 *            
 * @param  
 * @return  
 */
function lmiNESelectListener(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    $("applyBtn").disabled = false;
    var tmpLMIArray = [];
    var neid = newLineSrcTable.getAttrValue("lineInterfaceNE");
    for (var i = 0, len = lmiPortData.length; i < len; i++) 
    {
        if (neid == lmiPortData[i].neid) 
        {
            tmpLMIArray.push(lmiPortData[i]);
        }
    }
    createOption(newLineSrcTable.getAtom("lineInterfaceUnit").element, tmpLMIArray);
}

/**
 *        Option  
 * @param  
 * @return  
 */
function createLMIOption(neid)
{
    var tmpLMIArray = [];
    for (var i = 0, len = lmiPortData.length; i < len; i++) 
    {
        if (neid == lmiPortData[i].neid) 
        {
            tmpLMIArray.push(lmiPortData[i]);
        }
    }
    createOption(newLineSrcTable.getAtom("lineInterfaceUnit").element, tmpLMIArray);
}

/**
 *               port  
 * @param optionArray, port
 * @return  
 */
function containPort(optionArray, port)
{
    for (var i = 0, len = optionArray.length; i < len; i++) 
    {
        if (port.neid == optionArray[i].value) 
        {
            return true;
        }
    }
    return false;
}

function buNumChangeListener()
{
    
    var buTableRowLength = buTable.getDataRowLength();
    
    var buNumber = rptTable.getAtom("buEquipmentNum").getValue();
    if (null == buNumber) 
    {
        return;
    }
    
    if (buNumber > buTableRowLength)
    {
    	for (var i = 0, len = buNumber - buTableRowLength; i < len; i++)
    	{
    		addBuTableRow();
    	}
    }

    if (buNumber < buTableRowLength)
    {
    	for (var i = 0, len = buTableRowLength - buNumber; i < len; i++)
    	{
    		delBuTableRow();
    	}
    }

    addCellEvent();
}

function addBuTableRow()
{
	  var newData = new DataInterface();
    var obj;
    var ptag;
    
    obj = new Object();
    ptag = new ParamTag();
    ptag.value = "2";
    obj["eqptType"] = ptag;
        
    ptag = new ParamTag();
    ptag.value = "";
    obj["eqptName"] = ptag;
        
    ptag = new ParamTag();
    ptag.value = "";
    obj["spanId"] = ptag;
        
    ptag = new ParamTag();
    ptag.value = "";
    obj["eqptPos"] = ptag;
        
    newData.rows.append(obj);
    
    createTableBody(buTable, window.tableconf[0], newData, RESOURCE);
    buTable.adjustDataRows();
}

function delBuTableRow()
{
	  if (buTable.getDataRowLength() <= 0) 
    {
        return;
    }
    
    buTable.deleteRow(buTable.getDataRowLength() - 1);
    
    buTable.adjustDataRows();
}


/**
 *              
 * @return  
 */
function addCellEvent()
{
    var cell;
    var editelement;
    
    var spanNumber = rptTable.getAtom("segmentNum").getValue();
    
    for (var i = 0, tbLen = buTable.getDataRowLength(); i < tbLen; i++)//     
     {
        cell = buTable.getCell(i, "eqptType");
        var eqptType = buTable.getCellStoreValue(i, "eqptType", "eqptType");
        cell.element.editElement.element["onchange"] = function()
        {
            var rowindex = this.parentNode.parentNode.rowIndex;
            var cpcel2 = buTable.getCell(rowindex, "eqptName");
            if (this.value != "3") 
            {
                buTable.setCellIsEdit(cpcel2, 1);
                cpcel2.element.showElement.setValue("");
                buTable.setCellValue(cpcel2, "eqptName", "");
                cpcel2.element.editElement.element.style.imeMode = "disabled";
                cpcel2.element.editElement.element.maxLength = 8;
                cpcel2.element.editElement.element["onkeypress"] = function()
                {
                    if (!restrict(this, event, "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")) 
                    {
                        return false;
                    }
                    return true;
                }
            }
            else 
            {
                buTable.setCellIsEdit(cpcel2, 0);
                cpcel2.element.showElement.setValue("");
                buTable.setCellValue(cpcel2, "eqptName", "");
            }
        }
        
        cell = buTable.getCell(i, "eqptName");
        if (eqptType == "3") 
        {
            buTable.setCellIsEdit(cell, 0);
            cell.element.showElement.setValue("");
            buTable.setCellValue(cell, "eqptName", "");
        }
        else 
        {
            buTable.setCellIsEdit(cell, 1);
            cell.element.editElement.element.style.imeMode = "disabled";
            cell.element.editElement.element.maxLength = 8;
            cell.element.editElement.element["onkeypress"] = function()
            {
                if (!restrict(this, event, "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")) 
                {
                    return false;
                }
                return true;
            }
        }
        
        cell = buTable.getCell(i, "spanId");
        textCheck(cell.element.editElement.element, "1", spanNumber, 1);
        var spanId = buTable.getCellStoreValue(i, "spanId", "spanId");
        if (parseInt(spanId) > parseInt(spanNumber))
        {
        	cell.element.showElement.setValue("");
        	buTable.setCellValue(cell, "spanId", "");
        }
        
        cell = buTable.getCell(i, "eqptPos");
        textCheck(cell.element.editElement.element, "0.1", "79.9");
    }
}

/**
 * Repeater         
 * @param  
 * @return  
 */
function repeaterNumChangeListener()
{
    $("applyBtn").disabled = false;
    if ("" == rptTable.getAttrValue("repeaterNum")) 
    {
        rptTable.setAttrValue("segmentNum", "");
        return;
    }
    rptTable.setAttrValue("segmentNum", parseInt(rptTable.getAttrValue("repeaterNum")) + 1);
    
    addCellEvent();
}

/**
 *       
 * @param neid
 * @return  
 */
function TESLMLineCrossSpan(spanNo, fiberLength)
{
	this.spanNo = spanNo;
	this.fiberLength = fiberLength;
}

/**
 *               
 *      
 * 1.                 
 * 2.                 
 * @param  
 * @return  
 */
function doCreateLine(isApply)
{
    if ($("applyBtn").disabled) 
    {
        xcloseDialog();
    }
    
    var srcLasPort = newLineSrcTable.getAtom("lineAmplifierUnit").getValue();
    var srcLmiPort = newLineSrcTable.getAtom("lineInterfaceUnit").getValue();
    var sinkLasPort = newLineSinkTable.getAtom("lineAmplifierUnit").getValue();
    var sinkLmiPort = newLineSinkTable.getAtom("lineInterfaceUnit").getValue();
    
    if("" == srcLasPort || "" == srcLmiPort || "" == sinkLasPort || "" == sinkLmiPort)
		{
			alert(RESOURCE["noAvailableResource"]);
			return;
		}
		
		var srcProbeWaveBand = newLineSrcTable.getAtom("probeWaveType").getValue();
    var srcprobeWaveIndex = newLineSrcTable.getAtom("probeWaveNo").getValue();
    var srcLoadingWaveBand = newLineSrcTable.getAtom("loadingWaveType").getValue();
    var srcLoadingWaveIndex = newLineSrcTable.getAtom("loadingWaveNo").getValue();
    
    if("" == srcProbeWaveBand || "" == srcprobeWaveIndex || "" == srcLoadingWaveBand || "" == srcLoadingWaveIndex)
		{
			alert(RESOURCE["LMUBoardNotInPosition"]);
			return;
		}
		
    var buNumber = rptTable.getAtom("buEquipmentNum").getValue();
    var eqptNameList = [];
		for (var index = 0; index < buNumber; index++) 
    {
			var spanId = buTable.getCellStoreValue(index, "spanId", "spanId");
	    var eqptType = buTable.getCellStoreValue(index, "eqptType", "eqptType");
	    var eqptPos = buTable.getCellStoreValue(index, "eqptPos", "eqptPos");
	    var eqptName = buTable.getCellStoreValue(index, "eqptName", "eqptName");
	    if ("3" != eqptType)
	    {
	    	eqptNameList.push(eqptName);
	    }
	  
	    if (null == spanId || "" == spanId
	    || null == eqptType || "" == eqptType
	    || null == eqptPos || "" == eqptPos
	    || ((null == eqptName || "" == eqptName) && "3" != eqptType) || "NO NAME" == eqptName)
	    {
	    	alert(RESOURCE["eqmiswrong"]);
	    	return;
	    }
    }
    
    var len = eqptNameList.length
    for(var i = 0; i < len; i++)
    {
    	for(var j = 0; j < len; j++)
    	{
    		if (i == j)
    		{
    			continue;
    		}
    		
    		if (eqptNameList[i] == eqptNameList[j])
    		{
    			alert(RESOURCE["eqmrepeated"]);
	    	  return;
    		}
    	}
    }
		
		var eqptPosList = [];
		var isEqmatsamepos = false;
		for (var index = 0; index < buNumber; index++) 
		{
			var spanId = buTable.getCellStoreValue(index, "spanId", "spanId");
			var eqptPos = buTable.getCellStoreValue(index, "eqptPos", "eqptPos");
			
			for (var j = 0, k = eqptPosList.length; j < k; j++)
	    {
	    	if (spanId == eqptPosList[j].spanNo && eqptPos == eqptPosList[j].fiberLength)
	      {
	      	isEqmatsamepos = true;
	        break;
	      }
	    }
			
			if (isEqmatsamepos)
			{
				alert(RESOURCE["eqmatsamepos"]);
				return;
			}
			
			var crossspan = new TESLMLineCrossSpan(spanId, eqptPos);
			eqptPosList.push(crossspan);
		}
		
    $("okBtn").disabled = true;
    $("applyBtn").disabled = true;
    $("cancelBtn").disabled = true;
    if (isApply) 
    {
        setAllElement(true);
    }
    var data = createNewLineXML();
    if (null == data) 
    {
        alert(RESOURCE["checkDataInfo"]);
        $("okBtn").disabled = false;
        $("applyBtn").disabled = false;
        $("cancelBtn").disabled = false;
        if (isApply) 
        {
            setAllElement(false);
        }
        return;
    }
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_CREATE_LINE + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST", false, callbackCreateLineData, isApply, "inputdata=" + data);
}


function createNewLineXML()
{
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var buNumber = rptTable.getAtom("buEquipmentNum").getValue();
    
    newLineID = getNewLineID();
    
    createSrcLineXML(buNumber, bussiness);
    
    if (0 != newLineSinkTable.getAtom("sinkNE").getValue()) 
    {
        createSinkLineXML(buNumber, bussiness);
    }
    
    root.getRoot().appendChild(bussiness);
    
    return root.toString();
}

function getNewLineID()
{
	var doc = parentWin.tableDoc;
	
	var srcAvailableLineData = EncapsulateData(doc);
  
  var lineIDList = [];
  
  if (null != srcAvailableLineData)
  {
	  for (var index = 0, indexLen = srcAvailableLineData.getDataRowLength(); index < indexLen; index++) 
		{
		    var aLineID = srcAvailableLineData.getDataRowParam(index, "lineID");
	      
	      lineIDList.push(aLineID);
		}
  }
  
  if (null != sinkAvailableLineData && 0 != newLineSinkTable.getAtom("sinkNE").getValue())
  {
		for (var index = 0, indexLen = sinkAvailableLineData.getDataRowLength(); index < indexLen; index++) 
		{
		    var aLineID = sinkAvailableLineData.getDataRowParam(index, "lineID");
	      
	      lineIDList.push(aLineID);
		}
  }

	var tempid = 0;
	
	var isRepeat = true;
	
	while(isRepeat)
	{
		  tempid ++; 
      isRepeat = checkRepeatLineID(lineIDList, tempid);
	}
	
	return tempid;
}

function checkRepeatLineID(lineIDList, lineID)
{
		for (var index = 0, len = lineIDList.length; index < len; index++)
		{
			if (lineID == lineIDList[index])
			{
				return true;
			}
		}
		return false;
}

function createSinkLineXML(buNumber, bussiness)
{
    if (0 == buNumber) 
    {
        var row = new tagElement("row-params");
        createLineXMLData(row, newLineSinkTable, DIRECTION_WEST, newLineSrcTable);
        param = new tagElement("param");
        param.setAttribute("name", "eqptNum");
        param.setAttribute("value", "0");
        row.appendChild(param);
        bussiness.appendChild(row);
        return;
    }
    for (var index = 0; index < buNumber; index++) 
    {
        var row = new tagElement("row-params");
        createLineXMLData(row, newLineSinkTable, DIRECTION_WEST, newLineSrcTable);
        createLineBUXMLData(row, index, buNumber);
        bussiness.appendChild(row);
    }
}

function createSrcLineXML(buNumber, bussiness)
{
    if (0 == buNumber) 
    {
        var row = new tagElement("row-params");
        createLineXMLData(row, newLineSrcTable, DIRECTION_EAST, newLineSinkTable);
        param = new tagElement("param");
        param.setAttribute("name", "eqptNum");
        param.setAttribute("value", "0");
        row.appendChild(param);
        bussiness.appendChild(row);
        return;
    }
    for (var index = 0; index < buNumber; index++) 
    {
        var row = new tagElement("row-params");
        createLineXMLData(row, newLineSrcTable, DIRECTION_EAST, newLineSinkTable);
        createLineBUXMLData(row, index, buNumber);
        bussiness.appendChild(row);
    }
}

function createLineBUXMLData(row, index, buNumber)
{
    var param = new tagElement("param");
    param.setAttribute("name", "eqptNum");
    param.setAttribute("value", buNumber);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "eqptId");
    param.setAttribute("value", (index + 1));
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "spanId");
    param.setAttribute("value", buTable.getCellStoreValue(index, "spanId", "spanId"));
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "eqptType");
    param.setAttribute("value", buTable.getCellStoreValue(index, "eqptType", "eqptType"));
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "eqptDistance");
    param.setAttribute("value", parseFloat(buTable.getCellStoreValue(index, "eqptPos", "eqptPos")) * 10);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "eqptName");
    param.setAttribute("value", buTable.getCellStoreValue(index, "eqptName", "eqptName"));
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "eqptDistanceLength");
    param.setAttribute("value", "800");
    row.appendChild(param);
}

function getNEInfo(neName, direction)
{
    if (DIRECTION_EAST == direction) 
    {
        return curNEInfo;
    }
    else 
    {
        return getNEInfoFromNEListByNEName(neName, sinkNEList);
    }
}

function getOPNEInfo(neName, direction)
{
    if (DIRECTION_EAST == direction) 
    {
        return getNEInfoFromNEListByNEName(neName, sinkNEList);
    }
    else 
    {
        return curNEInfo;
    }
}

function createLineXMLData(row, createLineTable, direction, opCreateLineTable)
{
    var neStr = "srcNE";
    var opNEStr = "sinkNE"
    if (DIRECTION_WEST == direction) 
    {
        neStr = "sinkNE";
        opNEStr = "srcNE";
    }
    var neName = createLineTable.getAtom(neStr).getValue();
    var neInfo = getNEInfo(neName, direction);
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neInfo.neid);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "neName");
    param.setAttribute("value", neName);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lineID");
    param.setAttribute("value", newLineID);
    row.appendChild(param);
    
    var lmuTEPort = getTEPort(createLineTable.getAtom("lineMonitorUnit").getValue(), neInfo.lmuPortList);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmuSlot");
    param.setAttribute("value", lmuTEPort.slotId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmuPortId");
    param.setAttribute("value", lmuTEPort.portId);
    row.appendChild(param);
    
    var lasTEPort = getTEPort(createLineTable.getAtom("lineAmplifierUnit").getValue(), neInfo.lasPortList);
    
    param = new tagElement("param");
    param.setAttribute("name", "lasSlot");
    param.setAttribute("value", lasTEPort.slotId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lasPort");
    param.setAttribute("value", lasTEPort.portId);
    row.appendChild(param);
    
    var lmiTEPort = getTEPort(createLineTable.getAtom("lineInterfaceUnit").getValue(), neInfo.lmiPortList);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmiSlot");
    param.setAttribute("value", lmiTEPort.slotId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmiPortId");
    param.setAttribute("value", lmiTEPort.portId);
    row.appendChild(param);
    
    var opNEName = opCreateLineTable.getAtom(opNEStr).getValue();
    
    var opNEInfo = getOPNEInfo(opNEName, direction);
    
    var opNEID = 0;
    if (null != opNEInfo) 
    {
        opNEID = opNEInfo.neid;
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "opNeID");
    param.setAttribute("value", opNEID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "opNEName");
    param.setAttribute("value", opNEName);
    row.appendChild(param);
    
    var opLMISlotId = 0;
    if (0 != opCreateLineTable.getAtom("lineInterfaceUnit").getValue()) 
    {
        var lmiTEPort = getTEPort(opCreateLineTable.getAtom("lineInterfaceUnit").getValue(), opNEInfo.lmiPortList);
        
        opLMISlotId = lmiTEPort.slotId;
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "opLmiSlot");
    param.setAttribute("value", opLMISlotId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lineDirection");
    param.setAttribute("value", direction);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "probeWaveBand");
    var tmpValue = createLineTable.getAtom("probeWaveType").getValue();
    if (null == tmpValue || "" == tmpValue) 
    {
        tmpValue = 0;
    }
    param.setAttribute("value", tmpValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "probeWaveIndex");
    tmpValue = createLineTable.getAtom("probeWaveNo").getValue();
    if (null == tmpValue || "" == tmpValue) 
    {
        tmpValue = 0;
    }
    param.setAttribute("value", tmpValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "loadingWaveBand");
    tmpValue = createLineTable.getAtom("loadingWaveType").getValue();
    if (null == tmpValue || "" == tmpValue) 
    {
        tmpValue = 0;
    }
    param.setAttribute("value", tmpValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "loadingWaveIndex");
    tmpValue = createLineTable.getAtom("loadingWaveNo").getValue();
    if (null == tmpValue || "" == tmpValue) 
    {
        tmpValue = 0;
    }
    param.setAttribute("value", tmpValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "spanNum");
    param.setAttribute("value", rptTable.getAtom("segmentNum").getValue());
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "lineRemark");
    param.setAttribute("value", rptTable.getAtom("remark").getValue());
    row.appendChild(param);
    
}

/**
 *            
 * @param doc
 * @return  
 */
function callbackCreateLineData(doc, isApply)
{
    var data = EncapsulateData(doc);
    var errorCode = data.getSErrorCode();
    if (0 == errorCode || 1 == errorCode) 
    {
        parentWin.doQueryLineInfo();
        if (isApply) 
        {
            freshNewLineTable();
        }
        $("okBtn").disabled = false;
        $("applyBtn").disabled = false;
        $("cancelBtn").disabled = false;
        showOperResult(data);
        if (!isApply)// && 0 == errorCode) //               
        {
            xcloseDialog();
        }
    }
    else 
    {
        showOperResult(data);
        $("okBtn").disabled = false;
        $("applyBtn").disabled = false;
        $("cancelBtn").disabled = false;
    }
    if (isApply) 
    {
        setAllElement(false);
    }
}

/**
 *      AU9D18037          begin
 *              
 * @return  
 */
function freshNewLineTable()
{
    var newLineData = new NewLineData();
    availableLineData.rows[availableLineData.rows.length] = newLineData;
    initAvaiablePort();
    refreshOptions(newLineData);
    
    rptTable.getAtom("repeaterNum").setValue(SLM_DEFAULT_REPEATER_NUM);
    rptTable.getAtom("segmentNum").setValue(SLM_DEFAULT_REPEATER_NUM + 1);
    rptTable.getAtom("buEquipmentNum").setValue(SLM_DEFAULT_BUNUM);
    rptTable.getAtom("remark").setValue("");
    
    buTable.clearTableData();
}

/**
 *                  
 *      AU9D27227     l00104422        options       null          
 * @return  
 */
function refreshOptions(newLineData)
{
    var lsuOptions = newLineSrcTable.getAtom("lineAmplifierUnit").element.options;
    for (var i = lsuOptions.length - 1; i >= 0; i--) 
    {
        var lsuMap = lsuOptions[i].value;
        var lsuSlotIdOp = lsuMap.split("-")[0];
        var lsuPortIdOp = lsuMap.split("-")[2].split("(")[0];
        if (newLineData.srcLasSlotId.value == lsuSlotIdOp && newLineData.srcLasPortId.value == lsuPortIdOp) 
        {
            lsuOptions[i] = null;
            break;
        }
    }
    var lmiOptions = newLineSrcTable.getAtom("lineInterfaceUnit").element.options;
    var lmineid = newLineSrcTable.getAtom("srcNE").getValue();
    for (var i = lmiOptions.length - 1; i >= 0; i--) 
    {
        var lmiMap = lmiOptions[i].value;
        var lmiSlotIdOp = lmiMap.split("-")[0];
        if (newLineData.srcLmiSlotId.value == lmiSlotIdOp) 
        {
            lmiOptions[i] = null;
            break;
        }
    }
    
    /*
    var removeFlg = true;
    for (var i = 0, len = lmiPortData.length; i < len; i++) 
    {
        var tmpPort = lmiPortData[i];
        if (lmineid == tmpPort.neid) 
        {
            removeFlg = false;
            break;
        }
    }
    
    var lmiNEOptions = newLineSrcTable.getAtom("srcNE").element.options
    if (removeFlg) 
    {
        for (var index = lmiNEOptions.length - 1; index >= 0; index--) 
        {
            if (lmineid == lmiNEOptions[index].value) 
            {
                lmiNEOptions[index] = null;
                break;
            }
        }
        createLMIOption(newLineSrcTable.getAttrValue("srcNE"));
    }*/
    
    if (0 == newLineData.sinkLasSlotId.value)
    {
    	return;
    }
    
    var lsuOptions = newLineSinkTable.getAtom("lineAmplifierUnit").element.options;
    for (var i = lsuOptions.length - 1; i >= 0; i--) 
    {
        var lsuMap = lsuOptions[i].value;
        var lsuSlotIdOp = lsuMap.split("-")[0];
        var lsuPortIdOp = lsuMap.split("-")[2].split("(")[0];
        if (newLineData.sinkLasSlotId.value == lsuSlotIdOp && newLineData.sinkLasPortId.value == lsuPortIdOp) 
        {
            lsuOptions[i] = null;
            break;
        }
    }
    var lmiOptions = newLineSinkTable.getAtom("lineInterfaceUnit").element.options;
    var lmineid = newLineSinkTable.getAtom("sinkNE").getValue();
    for (var i = lmiOptions.length - 1; i >= 0; i--) 
    {
        var lmiMap = lmiOptions[i].value;
        var lmiSlotIdOp = lmiMap.split("-")[0];
        if (newLineData.sinkLmiSlotId.value == lmiSlotIdOp) 
        {
            lmiOptions[i] = null;
            break;
        }
    }
}

/**
 *   data       
 * @return  
 */
function NewLineData()
{
    var lmuTEPort = getTEPort(newLineSrcTable.getAtom("lineMonitorUnit").getValue(), lmuPortData);
    this.srcLmuSlotId = new dataObject(lmuTEPort.slotId);
    this.srcLmuneid = new dataObject(lmuTEPort.neid);
    this.srcLmuNeName = new dataObject(lmuTEPort.neName);
    this.srcLmuBoardName = new dataObject(lmuTEPort.boardName);
    this.srcLmuBoardType = new dataObject(lmuTEPort.boardType);
    this.srcLmuPortId = new dataObject(lmuTEPort.portId);
    this.srcLmuPortName = new dataObject(lmuTEPort.portName);
    
    var loaTEPort = getTEPort(newLineSrcTable.getAtom("lineAmplifierUnit").getValue(), loaPortData);
    this.srcLasSlotId = new dataObject(loaTEPort.slotId);
    this.srcLasneid = new dataObject(loaTEPort.neid);
    this.srcLasNeName = new dataObject(loaTEPort.neName);
    this.srcLasBoardName = new dataObject(loaTEPort.boardName);
    this.srcLasBoardType = new dataObject(loaTEPort.boardType);
    this.srcLasPortId = new dataObject(loaTEPort.portId);
    this.srcLasPortName = new dataObject(loaTEPort.portName);
    
    var lmiTEPort = getTEPort(newLineSrcTable.getAtom("lineInterfaceUnit").getValue(), lmiPortData);
    this.srcLmiSlotId = new dataObject(lmiTEPort.slotId);
    this.srcLmineid = new dataObject(lmiTEPort.neid);
    this.srcLmiNeName = new dataObject(lmiTEPort.neName);
    this.srcLmiBoardName = new dataObject(lmiTEPort.boardName);
    this.srcLmiBoardType = new dataObject(lmiTEPort.boardType);
    this.srcLmiPortId = new dataObject(lmiTEPort.portId);
    this.srcLmiPortName = new dataObject(lmiTEPort.portName);
    
    if (0 == newLineSinkTable.getAtom("lineMonitorUnit").getValue())
    {
    	  this.sinkLmuSlotId = new dataObject(0);
        this.sinkLmuneid = new dataObject(0);
        this.sinkLmuNeName = new dataObject("");
        this.sinkLmuBoardName = new dataObject("");
        this.sinkLmuBoardType = new dataObject(0);
        this.sinkLmuPortId = new dataObject(0);
        this.sinkLmuPortName = new dataObject("");
        
        this.sinkLasSlotId = new dataObject(0);
        this.sinkLasneid = new dataObject(0);
        this.sinkLasNeName = new dataObject("");
        this.sinkLasBoardName = new dataObject("");
        this.sinkLasBoardType = new dataObject(0);
        this.sinkLasPortId = new dataObject(0);
        this.sinkLasPortName = new dataObject("");
        
        this.sinkLmiSlotId = new dataObject(0);
        this.sinkLmineid = new dataObject(0);
        this.sinkLmiNeName = new dataObject("");
        this.sinkLmiBoardName = new dataObject("");
        this.sinkLmiBoardType = new dataObject(0);
        this.sinkLmiPortId = new dataObject(0);
        this.sinkLmiPortName = new dataObject(lmiTEPort.portName);
    }
    else
    {
    	  var neInfo = getNEInfoFromNEListByNEName(newLineSinkTable.getAtom("sinkNE").getValue(), sinkNEList);
    	  lmuTEPort = getTEPort(newLineSinkTable.getAtom("lineMonitorUnit").getValue(), neInfo.lmuPortList);
        this.sinkLmuSlotId = new dataObject(lmuTEPort.slotId);
        this.sinkLmuneid = new dataObject(lmuTEPort.neid);
        this.sinkLmuNeName = new dataObject(lmuTEPort.neName);
        this.sinkLmuBoardName = new dataObject(lmuTEPort.boardName);
        this.sinkLmuBoardType = new dataObject(lmuTEPort.boardType);
        this.sinkLmuPortId = new dataObject(lmuTEPort.portId);
        this.sinkLmuPortName = new dataObject(lmuTEPort.portName);
    
        loaTEPort = getTEPort(newLineSinkTable.getAtom("lineAmplifierUnit").getValue(), neInfo.lasPortList);
        this.sinkLasSlotId = new dataObject(loaTEPort.slotId);
        this.sinkLasneid = new dataObject(loaTEPort.neid);
        this.sinkLasNeName = new dataObject(loaTEPort.neName);
        this.sinkLasBoardName = new dataObject(loaTEPort.boardName);
        this.sinkLasBoardType = new dataObject(loaTEPort.boardType);
        this.sinkLasPortId = new dataObject(loaTEPort.portId);
        this.sinkLasPortName = new dataObject(loaTEPort.portName);
    
        lmiTEPort = getTEPort(newLineSinkTable.getAtom("lineInterfaceUnit").getValue(), neInfo.lmiPortList);
        this.sinkLmiSlotId = new dataObject(lmiTEPort.slotId);
        this.sinkLmineid = new dataObject(lmiTEPort.neid);
        this.sinkLmiNeName = new dataObject(lmiTEPort.neName);
        this.sinkLmiBoardName = new dataObject(lmiTEPort.boardName);
        this.sinkLmiBoardType = new dataObject(lmiTEPort.boardType);
        this.sinkLmiPortId = new dataObject(lmiTEPort.portId);
        this.sinkLmiPortName = new dataObject(lmiTEPort.portName);
    }
    
    this.remark = new dataObject(rptTable.getAttrValue("remark"));
}

/**
 *            
 *      AU9D18037          end
 * @return  
 */
function dataObject(value)
{
    this.value = value;
    this.options = null;
}

/**
 *               
 * @param
 * @return  
 */
function setAllElement(flag)
{
    newLineSrcTable.getAtom("lineMonitorUnit").element.disabled = flag;
    newLineSrcTable.getAtom("lineAmplifierUnit").element.disabled = flag;
    newLineSrcTable.getAtom("lineInterfaceUnit").element.disabled = flag;
    newLineSrcTable.getAtom("probeWaveType").element.disabled = flag;
    newLineSrcTable.getAtom("probeWaveNo").element.disabled = flag;
    newLineSrcTable.getAtom("loadingWaveType").element.disabled = flag;
    newLineSrcTable.getAtom("loadingWaveNo").element.disabled = flag;
    
    newLineSinkTable.getAtom("sinkNE").element.disabled = flag;
    newLineSinkTable.getAtom("lineMonitorUnit").element.disabled = flag;
    newLineSinkTable.getAtom("lineAmplifierUnit").element.disabled = flag;
    newLineSinkTable.getAtom("lineInterfaceUnit").element.disabled = flag;
    newLineSinkTable.getAtom("probeWaveType").element.disabled = flag;
    newLineSinkTable.getAtom("probeWaveNo").element.disabled = flag;
    newLineSinkTable.getAtom("loadingWaveType").element.disabled = flag;
    newLineSinkTable.getAtom("loadingWaveNo").element.disabled = flag;
    
    rptTable.getAtom("repeaterNum").element.disabled = flag;
    rptTable.getAtom("segmentNum").element.disabled = flag;
    rptTable.getAtom("buEquipmentNum").element.disabled = flag;
    rptTable.getAtom("remark").element.disabled = flag;
    
}

/**
 *          
 * @param doc
 * @return  
 */
function doCancel()
{
    xcloseDialog();
}

/**
 *    LMI                
 * @return  
 */
Object.prototype.toString = function()
{
    return this.neName;
}

