 var modifyLineTable; //        
var parentWin = getParentWindow(); //     
var winurlobj = parentWin.winurlobj;; //       

var availableLineData = parentWin.availableLine;//    
var availablePortData = parentWin.availablePort;//    
var SLM_MIN_REPEATER_NUM = "0";
var SLM_MAX_REPEATER_NUM = "239";
var SLM_DEFAULT_REPEATER_NUM = 21
var SLM_LENGTH_REPEATER_NUM = 3;
var lmuPortData; //  LMU  
var loaPortData; //  LOA  
var lsuPortData; //  LSU  
var lmiPortData; //  LMU  

var modifyFlg = true; //            

var loaMap;
var lmuMap;
var lsuMap;
var lmiMap;
var segmentNum;

loadXMLdoc("../../../../conf/system.xml","GET",false,EncapsulateSConf);
loadXMLdoc("../../../../help/"+SYSTEMCONF.getLanguage()+"/helpidresource.xml", "GET", false, EncapsulateHelpConfig);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/slmlinemgr/slmlinemgr_" + SYSTEMCONF.getLanguage() + ".xml");
document.title = RESOURCE["modifyLineTitle"];
/**
 *        
 * @param  
 * @return  
 */
function init()
{	
	initAvaiablePort();
	initBtn();
	initTable();
}
/**
 *        
 * @param  
 * @return  
 */
function initAvaiablePort()
{
	var selectedRow = parentWin.slmLineTable.getSelectedRows();
	var selectedLineID;
	if(1 == selectedRow.length)
	{
		selectedLineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
	}
	lmuPortData = [];
	loaPortData = [];
	lsuPortData = [];
	lmiPortData = [];
	if (null != availablePortData)
	{
		for (var i = 0, len = availablePortData.getDataRowLength(); i < len; i++)
		{
			switch(parseInt(availablePortData.getDataRowParam(i,"boardType")))
			{
				case SLM_LMU_BOARDTYPE:
					lmuPortData.push(createTEPort(availablePortData, i));
					break;
				case SLM_LOA_BOARDTYPE:
					loaPortData.push(createTEPort(availablePortData, i));
					break;
				case SLM_LSU_BOARDTYPE:
					lsuPortData.push(createTEPort(availablePortData, i));
					break;
				case SLM_LMI_BOARDTYPE:
					lmiPortData.push(createTEPort(availablePortData, i));
					break;
				default:
					continue;
			}
		}
	}
	if (null != availableLineData)
	{
		for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++)
		{
			var lsuneid = availableLineData.getDataRowParam(index, "lsuneid");
			var lsuSlotId = availableLineData.getDataRowParam(index, "lsuSlotId");
			var lsuPortId = availableLineData.getDataRowParam(index, "lsuPortId");
			var lineID = availableLineData.getDataRowParam(index, "lineID");
			
			if (lineID != selectedLineID)
			{
				refreshTEPort(lsuneid, lsuSlotId, lsuPortId, lsuPortData);	
			}
		  /*var lsuIndex = getTEPortIndex(lsuneid, lsuSlotId, lsuPortId, lsuPortData);
		  if(-1 != lsuIndex)
		  {
		  	lsuPortData.splice(lsuIndex, 1);
		  }	*/		
		  																												
		}
	}
}

/**
 *      
 * @param  
 * @return  
 */
function initBtn()
{
	$("okBtn").value = RESOURCE["okBtn"];
	$("cancelBtn").value = RESOURCE["cancelBtn"];
	
	$("okBtn").disabled = true;	
}
/**
 *        
 * @param  
 * @return  
 */
function initTable()
{
	var selectedRow = parentWin.slmLineTable.getSelectedRows();
	modifyLineTable = new CTable();
	modifyLineTable.addHead(RESOURCE["attrCol"], RESOURCE["valueCol"]);
	
	var cTableAtom = null;
	var cTableAtomEle = null;
	
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	createOption(cTableAtomEle, lmuPortData);
	if(0 != selectedRow.length)
	{
		lmuMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineMonitorUnit", "lineMonitorUnit");
		cTableAtom.setValue(getTEPort(lmuMap,lmuPortData));
	}
	cTableAtomEle.onchange = lmuSelectListener;
	modifyLineTable.addAttrRow("lineMonitorUnit", RESOURCE["lineMonitorUnit"], cTableAtom);
	
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	createOption(cTableAtomEle, loaPortData);
	if(0 != selectedRow.length)
	{
		loaMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineAmplifierUnit", "lineAmplifierUnit");
		cTableAtom.setValue(getTEPort(loaMap, loaPortData));
	}
	cTableAtomEle.onchange = loaSelectListener;
	modifyLineTable.addAttrRow("lineAmplifierUnit", RESOURCE["lineAmplifierUnit"], cTableAtom);
	
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	createOption(cTableAtomEle, lsuPortData);
	if(0 != selectedRow.length)
	{
		lsuMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineSelectUnit", "lineSelectUnit");
		var lsuTEPort = getModifySelectUnit(selectedRow, availableLineData, lsuPortData);
		if(null != lsuTEPort)
		{
			cTableAtom.setValue(lsuTEPort);
		}
	}
	cTableAtomEle.onchange = lsuSelectListener;
	modifyLineTable.addAttrRow("lineSelectUnit", RESOURCE["lineSelectUnit"], cTableAtom);
	
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	var lmiTEPort = getLMINE(selectedRow, availableLineData, lmiPortData);
	if(0 != selectedRow.length)
	{
	    lmiMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineMonitorInterface", "lineMonitorInterface");
	    lmiMap = lmiMap.substring(lmiMap.indexOf("-") + 1);
  }
	var lmineid;
	var lmiSlotId;
	var lmiPortId;
	if (null == lmiTEPort)
	{
		var lineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
		for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++)
		{
			if(lineID == availableLineData.getDataRowParam(index, "lineID"))
			{
				lmineid = availableLineData.getDataRowParam(index, "lmineid");
				lmiSlotId = availableLineData.getDataRowParam(index, "lmiSlotId");
				lmiPortId = availableLineData.getDataRowParam(index, "lmiPortId");
			}
		}
		cTableAtomEle.options.add(new Option("UNKNOWN", lmineid), 0);
	}
	else
	{
		cTableAtomEle.options.add(new Option(lmiTEPort.neName, lmiTEPort.neid), 0);
	}
	cTableAtomEle.disabled = true;
	modifyLineTable.addAttrRow("lineInterfaceNE", RESOURCE["lineInterfaceNE"], cTableAtom);
	
	cTableAtom = new Atom("text");
	if(null == lmiTEPort)
	{
		cTableAtom.setValue(parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineMonitorInterface", "lineMonitorInterface"));
	}
	else
	{
		cTableAtom.setValue(lmiTEPort.toString());
	}
	cTableAtomEle = cTableAtom.element;
	cTableAtomEle.disabled = true;
	modifyLineTable.addAttrRow("lineInterfaceUnit", RESOURCE["lineInterfaceUnit"], cTableAtom);
	
	segmentNum = parentWin.document.getElementById("totalitem").innerHTML;;
	cTableAtom = new Atom("text");
	if(0 == segmentNum)
	{
		cTableAtom.setValue("");
	}
	else
	{
		cTableAtom.setValue(segmentNum - 1);
	}
	cTableAtomEle = cTableAtom.element;
  cTableAtomEle.disabled = false;
  checkText(cTableAtomEle,SLM_MIN_REPEATER_NUM,SLM_MAX_REPEATER_NUM,SLM_LENGTH_REPEATER_NUM);
	cTableAtomEle.onblur = repeaterNumChangeListener;
	modifyLineTable.addAttrRow("repeaterNum", RESOURCE["repeaterNum"], cTableAtom);
	
	cTableAtom = new Atom("text");
	if(0 == segmentNum)
	{
		cTableAtom.setValue("")
	}
	else
	{
		cTableAtom.setValue(segmentNum);	
	}
	cTableAtomEle = cTableAtom.element;
  cTableAtomEle.disabled = true;
	modifyLineTable.addAttrRow("segmentNum", RESOURCE["segmentNum"], cTableAtom);
	
	
	$("modifyLineTable").appendChild(modifyLineTable.getTable());
}


/**
 *   LMU      
 * @param  
 * @return  
 */
function lmuSelectListener(evt)
{
	enableBtn();
	modifyLineTable.getAtom("lineAmplifierUnit").element.onchange = null;
	modifyLineTable.getAtom("lineSelectUnit").element.onchange = null;
	if (!evt)
	{
		evt = window.event;
	}
	var slotId;
	var portId;
	var lmuPort = modifyLineTable.getAttrValue("lineMonitorUnit");
	if (null != availableLineData)
	{
		for (var i = 0, len = availableLineData.getDataRowLength(); i < len; i++)
		{
			slotId = availableLineData.getDataRowParam(i, "lmuSlotId");
			portId = availableLineData.getDataRowParam(i, "lmuPortId");
			lmuSlotId = lmuPort.split("-")[0];
			lmuPortId = lmuPort.split("-")[2].split("(")[0];
			if (lmuSlotId == slotId && lmuPortId == portId )
			{
				modifyLineTable.setAttrValue("lineAmplifierUnit", getPort(availableLineData.getDataRowParam(i, "loaneid"), availableLineData.getDataRowParam(i, "loaSlotId"), availableLineData.getDataRowParam(i, "loaPortId"),loaPortData));
				modifyLineTable.setAttrValue("lineSelectUnit", getLSUPort(availableLineData.getDataRowParam(i, "lsuneid"), availableLineData.getDataRowParam(i, "lsuSlotId"), lsuPortData));
				break;
			}
		}
	}
	modifyLineTable.getAtom("lineAmplifierUnit").element.onchange = loaSelectListener;
	modifyLineTable.getAtom("lineSelectUnit").element.onchange = lsuSelectListener;
}
/**
 *   LOA      
 * @param  
 * @return  
 */
function loaSelectListener(evt)
{
	enableBtn();
	modifyLineTable.getAtom("lineMonitorUnit").element.onchange = null;
	modifyLineTable.getAtom("lineSelectUnit").element.onchange = null;
	if (!evt)
	{
		evt = window.event;
	}
	var slotId;
	var portId;
	var loaPort = modifyLineTable.getAttrValue("lineAmplifierUnit");
	if (null != availableLineData)
	{
		for (var i = 0, len = availableLineData.getDataRowLength(); i < len; i++)
		{
			slotId = availableLineData.getDataRowParam(i, "loaSlotId");
			portId = availableLineData.getDataRowParam(i, "loaPortId");
			loaSlotId = loaPort.split("-")[0];
			loaPortId = loaPort.split("-")[2].split("(")[0];
			if (loaSlotId == slotId && loaPortId == portId )
			{
				modifyLineTable.setAttrValue("lineMonitorUnit", getPort(availableLineData.getDataRowParam(i, "lmuneid"), availableLineData.getDataRowParam(i, "lmuSlotId"), availableLineData.getDataRowParam(i, "lmuPortId"),lmuPortData));
				modifyLineTable.setAttrValue("lineSelectUnit", getLSUPort(availableLineData.getDataRowParam(i, "lsuneid"), availableLineData.getDataRowParam(i, "lsuSlotId"),lsuPortData));
				break;
			}
		}
	}
	modifyLineTable.getAtom("lineMonitorUnit").element.onchange = lmuSelectListener;
	modifyLineTable.getAtom("lineSelectUnit").element.onchange = lsuSelectListener;
}
/**
 *   LSU      
 * @param  
 * @return  
 */
function lsuSelectListener(evt)
{
	enableBtn();
	modifyLineTable.getAtom("lineMonitorUnit").element.onchange = null;
	modifyLineTable.getAtom("lineAmplifierUnit").element.onchange = null;
	if (!evt)
	{
		evt = window.event;
	}
	var slotId;
	var lsuPort = modifyLineTable.getAttrValue("lineSelectUnit");
	if (null != availableLineData)
	{
		for (var i = 0, len = availableLineData.getDataRowLength(); i < len; i++)
		{
			slotId = availableLineData.getDataRowParam(i, "lsuSlotId");
			lsuSlotId = lsuPort.split("-")[0];
			if (lsuSlotId == slotId)
			{
				modifyLineTable.setAttrValue("lineMonitorUnit", getPort(availableLineData.getDataRowParam(i, "lmuneid"), availableLineData.getDataRowParam(i, "lmuSlotId"), availableLineData.getDataRowParam(i, "lmuPortId"),lmuPortData));
				modifyLineTable.setAttrValue("lineAmplifierUnit", getPort(availableLineData.getDataRowParam(i, "loaneid"), availableLineData.getDataRowParam(i, "loaSlotId"), availableLineData.getDataRowParam(i, "loaPortId"),loaPortData));
				break;
			}
		}
	}
	modifyLineTable.getAtom("lineMonitorUnit").element.onchange = lmuSelectListener;
	modifyLineTable.getAtom("lineAmplifierUnit").element.onchange = loaSelectListener;
}

/**
 * Repeater         
 * @param  
 * @return  
 */
function repeaterNumChangeListener()
{
	enableBtn();
	if ("" == modifyLineTable.getAttrValue("repeaterNum"))
	{
		modifyLineTable.setAttrValue("segmentNum", "");
		return;
	}
	modifyLineTable.setAttrValue("segmentNum", parseInt(modifyLineTable.getAttrValue("repeaterNum")) + 1);
}

/**
 *             
 * @param  
 * @return  
 */
function doModifyLineInfo()
{
	$("okBtn").disabled = true;
	$("cancelBtn").disabled = true;
	var data = createModifyLineInfoXML();
	if (null == data)
	{
		alert(RESOURCE["checkModifyDataInfo"]);  
		$("okBtn").disabled = false;	
		$("cancelBtn").disabled = false;	
		return;
	}
	if (modifyFlg)
	{
		if (!confirm(RESOURCE["confirmModify"]))
		{
			$("okBtn").disabled = false;	
			$("cancelBtn").disabled = false;	
			return;
		}
	}
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_MODIFY_LINE + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackModifyLineInfoData, null, "inputdata=" + data); 

}
/**
 *               
 * @param  
 * @return  
 */
function createModifyLineInfoXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	var selectedRow = parentWin.slmLineTable.getSelectedRows();
	var lineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", lineID);
	row.appendChild(param);
	
	var newlmumap = modifyLineTable.getAtom("lineMonitorUnit").getValue();
	var lmuTEPort = getTEPort(newlmumap, lmuPortData);
	param = new tagElement("param");
	param.setAttribute("name", "lmuneid");
	param.setAttribute("value", lmuTEPort.neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmuSlotId");
	param.setAttribute("value", lmuTEPort.slotId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmuPortId");
	param.setAttribute("value", lmuTEPort.portId);
	row.appendChild(param);
	
	var newloamap = modifyLineTable.getAtom("lineAmplifierUnit").getValue();
	var loaTEPort = getTEPort(newloamap, loaPortData);
	param = new tagElement("param");
	param.setAttribute("name", "loaneid");
	param.setAttribute("value", loaTEPort.neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "loaSlotId");
	param.setAttribute("value", loaTEPort.slotId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "loaPortId");
	param.setAttribute("value", loaTEPort.portId);
	row.appendChild(param);
	
	var newlsumap = modifyLineTable.getAtom("lineSelectUnit").getValue();
	var lsuTEPort = getTEPort(newlsumap, lsuPortData);
	param = new tagElement("param");
	param.setAttribute("name", "lsuneid");
	param.setAttribute("value", lsuTEPort.neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lsuSlotId");
	param.setAttribute("value", lsuTEPort.slotId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lsuPortId");
	param.setAttribute("value", lsuTEPort.portId);
	row.appendChild(param);
	
	var lmineid = modifyLineTable.getAtom("lineInterfaceNE").getValue();
	var newlmimap = modifyLineTable.getAtom("lineInterfaceUnit").getValue();
	var lmiTEPort = getLMITEPort(lmineid, newlmimap, lmiPortData);
	var lmineid;
	var lmiSlotId;
	var lmiPortId;
	if (null == lmiTEPort)
	{
		for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++)
		{
			if(lineID == availableLineData.getDataRowParam(index, "lineID"))
			{
				lmineid = availableLineData.getDataRowParam(index, "lmineid");
				lmiSlotId = availableLineData.getDataRowParam(index, "lmiSlotId");
				lmiPortId = availableLineData.getDataRowParam(index, "lmiPortId");
			}
		}
	}
	else
	{
		lmineid = lmiTEPort.neid;
		lmiSlotId = lmiTEPort.slotId;
		lmiPortId = lmiTEPort.portId;
	}
	param = new tagElement("param");
	param.setAttribute("name", "lmineid");
	param.setAttribute("value", lmineid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmiSlotId");
	param.setAttribute("value", lmiSlotId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmiPortId");
	param.setAttribute("value", lmiPortId);
	row.appendChild(param);
	
	var modifyCommand1 = 1;
	var modifyCommand2 = 1;
	if((lmuMap == newlmumap) && (loaMap == newloamap) && (lmiMap == newlmimap) && (lsuMap == newlsumap))
	{
	    modifyCommand1 = 0;
	}
	
	if ("" == modifyLineTable.getAtom("repeaterNum").getValue())
	{
		return null;
	}
	
	param = new tagElement("param");
	param.setAttribute("name", "modifyCommand1");
	param.setAttribute("value", modifyCommand1);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "segmentNum");
	var newSegmentNum = modifyLineTable.getAttrValue("segmentNum");
	param.setAttribute("value", newSegmentNum);
	row.appendChild(param);
	
	if(segmentNum == newSegmentNum)
	{
	    modifyCommand2 = 0;
	}
	
	param = new tagElement("param");
	param.setAttribute("name", "modifyCommand2");
	param.setAttribute("value", modifyCommand2);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	var lmuSlotId;
  var lmuPortId;
	var loaSlotId;
	var loaPortId;
	var lsuSlotId;
	for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++)
	{
		availableLineID = availableLineData.getDataRowParam(index, "lineID");
		lmuSlotId = availableLineData.getDataRowParam(index, "lmuSlotId");
		lmuPortId = availableLineData.getDataRowParam(index, "lmuPortId");
		loaSlotId = availableLineData.getDataRowParam(index, "loaSlotId");
		loaPortId = availableLineData.getDataRowParam(index, "loaPortId");
		lsuSlotId = availableLineData.getDataRowParam(index, "lsuSlotId");
	
		if (lmuTEPort.slotId == lmuSlotId && lmuTEPort.portId == lmuPortId 
		 && loaTEPort.slotId == loaSlotId && loaTEPort.portId == loaPortId
		 && lsuTEPort.slotId == lsuSlotId && lineID == availableLineID)
		{
			modifyFlg = false;
		}
	}	
	
	return root.toString();
}
/**
 *            
 * @param doc
 * @return  
 */
function callbackModifyLineInfoData(doc) 
{
	var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	if (0 == errorCode || 1 == errorCode) 
	{
		parentWin.doQueryLineInfo();
		if (0 == errorCode)
		{
			xcloseDialog();
		}
	}
	showErrorDialog(data);
	$("okBtn").disabled = false;	
	$("cancelBtn").disabled = false;	
	xcloseDialog();
}

/**
 *       
 * @return  
 */
function showErrorDialog(dinterface)
{
    var errArr = [];
    errArr[0] = "nename";
    
    var errorObj = null;
    var errstrArr = new Array();
    var errstr;
    for(var i = dinterface.getBErrLength() - 1; i >= 0; i--)
	  {	
	  	  errorObj = dinterface.getError().rowErrors[i].errorObj;
	  	  errstr = errorObj["nename"] + dinterface.getError().getRowCode(i);
	  	  if(errstrArr.contains(errstr))
	  	  {
	  	      dinterface.getError().rowErrors.splice(i, 1);
	  	  }
	  	  else
	  	  {
	  	      errstrArr[errstrArr.length] = errstr;
	  	  }
	  }
    openErrPage("../../../../page/", dinterface.getError(), errArr);
}
/**
 *          
 * @param doc
 * @return  
 */
function doCancel()
{
	xcloseDialog();
}
/**
 *   LMI  
 * @param doc
 * @return  
 */
function getLMINE(selectedRow, availableLineData, lmiPortData)
{
	var lineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
	var neid;
	var slotId;
	for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++)
	{
		if(lineID == availableLineData.getDataRowParam(index, "lineID"))
		{
			neid = availableLineData.getDataRowParam(index, "lmineid");
			slotId = availableLineData.getDataRowParam(index, "lmiSlotId");
		}
	}
	for (var i = 0, len = lmiPortData.length; i < len; i++)
	{
		if (parseInt(neid) == lmiPortData[i].neid && parseInt(slotId) == lmiPortData[i].slotId)
		{
			return lmiPortData[i];
		}
	}
	return null;
}
/**
 *   LSU    
 * @param  
 * @return  
 */

function getModifySelectUnit(selectedRow, availableLineData, lsuPortData)
{
	var lineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
	var neid;
	var slotId;
	for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++)
	{
		if(lineID == availableLineData.getDataRowParam(index, "lineID"))
		{
			neid = availableLineData.getDataRowParam(index, "lsuneid");
			slotId = availableLineData.getDataRowParam(index, "lsuSlotId");
			portId = availableLineData.getDataRowParam(index, "lsuPortId");
		}
	}
	for (var i = 0, len = lsuPortData.length; i < len; i++)
	{
		if (neid == lsuPortData[i].neid && slotId == lsuPortData[i].slotId && portId == lsuPortData[i].portId)
		{
			return lsuPortData[i];
		}
	}
	return null;
}
/**
 *       
 * @return  
 */
function enableBtn()
{
	$("okBtn").disabled = false;	
	$("cancelBtn").disabled = false;	
}
