/**
 *     neid, slotId  portId            
 * @param   
 * @return   
 */
function getPort(neid, slotId, portId, portArray)
{
	for (var i = 0, len = portArray.length; i < len; i++)
	{
		if (neid == portArray[i].neid && slotId == portArray[i].slotId && portId == portArray[i].portId)
		{
			return portArray[i];
		}
	}
}
/**
 *     neid, slotId            (LSU    )
 * @param   
 * @return   
 */
function getLSUPort(neid, slotId, portArray)
{
	for (var i = 0, len = portArray.length; i < len; i++)
	{
		if (neid == portArray[i].neid && slotId == portArray[i].slotId)
		{
			return portArray[i];
		}
	}
}
/**
 *     neid   slotId  portId                 
 * @param   
 * @return   
 */
function refreshTEPort(neid, slotId, portId, portArray)
{
	for (var i = 0; i < portArray.length; i++)
	{
		if (neid == portArray[i].neid && slotId == portArray[i].slotId && portId == portArray[i].portId)
		{
			portArray.splice(i, 1);
			continue;
		}
	}
}
/**
 *     neid   slotId  portId            
 * @param   
 * @return   
 */
function getTEPortIndex(neid, slotId, portId, portArray)
{
	for (var i = 0, len = portArray.length; i < len; i++)
	{
		if (neid == portArray[i].neid && slotId == portArray[i].slotId && portId == portArray[i].portId)
		{
			return i;
		}
	}
	return -1;
}

/**
 *            TEPort    
 * @param portMap
 * @param portArray
 * @return   
 */
function getTEPort(portMap, portArray)
{
	var slotId = portMap.split("-")[0];
	var portId = portMap.split("-")[2].split("(")[0];
	for(var i = 0, len = portArray.length; i < len; i++)
	{
		if(parseInt(slotId) == portArray[i].slotId && parseInt(portId) == portArray[i].portId)
		{
			return portArray[i];
		}
	}
	return null;
}

/**
 *                 LMI TEPort    
 * @param portMap
 * @param portArray
 * @return   
 */
function getLMITEPort(neid, portMap, portArray)
{
	var slotId = portMap.split("-")[0];
	var portId = portMap.split("-")[2].split("(")[0];
	for(var i = 0, len = portArray.length; i < len; i++)
	{
		if(parseInt(neid) == portArray[i].neid && parseInt(slotId) == portArray[i].slotId && parseInt(portId) == portArray[i].portId)
		{
			return portArray[i];
		}
	}
	return null;
}
/**
 *    LSU       
 * @param   
 * @return   
 */

function getSelectUnit(selectedRow, availableLineData, lsuPortData)
{
	var lineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
	var neid;
	var slotId;
	for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++)
	{
		if(lineID == availableLineData.getDataRowParam(index, "lineID"))
		{
			neid = availableLineData.getDataRowParam(index, "lsuneid");
			slotId = availableLineData.getDataRowParam(index, "lsuSlotId");
		}
	}
	for (var i = 0, len = lsuPortData.length; i < len; i++)
	{
		if (neid == lsuPortData[i].neid && slotId == lsuPortData[i].slotId)
		{
			return lsuPortData[i];
		}
	}
	return null;
}
/**
 *    LMI       
 * @param   
 * @return   
 */
function getInterfaceNE(selectedRow, availableLineData, lmiPortData)
{
	var lineID = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
	var neid;
	var slotId;
	for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++)
	{
		if(lineID == availableLineData.getDataRowParam(index, "lineID"))
		{
			neid = availableLineData.getDataRowParam(index, "lmineid");
			slotId = availableLineData.getDataRowParam(index, "lmiSlotId");
		}
	}
	for (var i = 0, len = lmiPortData.length; i < len; i++)
	{
		if (parseInt(neid) == lmiPortData[i].neid)
		{
			return lmiPortData[i];
		}
	}
	return null;
}

/**
 *     TEPort    
 * @param data
 * @param index
 * @return   
 */
function createTEPort(data, index)
{
	var neid = data.getDataRowParam(index, "neid");
	var neName = data.getDataRowParam(index, "neName");
	var slotId = data.getDataRowParam(index, "slotId");
	var boardType = data.getDataRowParam(index, "boardType");
	var boardName = data.getDataRowParam(index, "boardName");
	var portId = data.getDataRowParam(index, "portId");
	var portName = data.getDataRowParam(index, "portName");
	
	return new TEPort(neid, neName, slotId, boardName, boardType, portId, portName);
}

/**
 *      CTable            
 * @param   
 * @return   
 */
function createOption(cTableAtomEle, portDataArray)
{
	cTableAtomEle.options.length = 0;
	for (var i = 0, len = portDataArray.length; i < len; i++)
	{
		var index = getInsertIndex(cTableAtomEle, portDataArray[i])
		if(-1 != index)
		{
			cTableAtomEle.options.add(new Option(portDataArray[i].toString(), portDataArray[i]), index);
		}
	}
}

/**
 *    option          
 * @param cTableAtomEle
 * @param portData
 * @return   
 */
function getInsertIndex(cTableAtomEle, portData)
{
	var slotId = parseInt(portData.slotId);
	var optionData = new Option(portData.toString(), portData);
	
	var portId = parseInt(portData.portId);
	var otherSlotId;
	var otherPortId;
	for (var i = 0, len = cTableAtomEle.options.length; i < len; i++)
	{
		var tmp = cTableAtomEle.options[i].value.split("-");
		otherSlotId = parseInt(tmp[0]);
		otherPortId = parseInt(tmp[2].split("(")[0]);
		if (slotId < otherSlotId)
		{
			return i;
		}
		else if(slotId == otherSlotId && portId == otherPortId)
		{
			return -1;
		}
	}  
	return cTableAtomEle.options.length;
}

/**
 *           
 * @param data:                  errArr:           
 * @return   
 */
function showOperResult(data, errArr)
{
	if (null == errArr)
	{
		errArr = [];//                 
		errArr[0] = "nename";//                 
	
		/*for(var i = 0, len = data.getBErrLength(); i < len; i++)
		{	
			data.getError().rowErrors[i].errorObj["lineID"] = RESOURCE["slmLineError"]+ data.getError().rowErrors[i].errorObj["lineID"];
		}	*/	
	}
	openErrPage("../../../../page/",data.getError(),errArr);
}
