 var winurlobj = getNeProperty(self);

var btnRightArr = new Object();//        
var slmLineTable;//   (      )   
var slmParamTable;//   (      )  
var DEFAULT_QUERY_LINEID = 0;//              id
var DEFAULT_QUERY_SEGMENTID = 0; //              id
var availableLine =null; //      
var availablePort = null;//      
var DEFAULT_SEGMENT_NUM = "--";
var SLM_LINEMGR_MAX_FIBERTYPE_LENGTH = 15;

var SLM_LINEMGR_MIN_REFRACTIVE_RATE = "1.300";//      
var SLM_LINEMGR_MAX_REFRACTIVE_RATE = "1.600";//      
var SLM_LINEMGR_MIN_FIBER_LENGTH = "45.0";//         
var SLM_LINEMGR_MAX_FIBER_LENGTH= "400.0";//        
var SLM_LINEMGR_MIN_ATTENUATION = "0.15"; //       
var SLM_LINEMGR_MAX_ATTENUATION = "0.30"; //       

loadXMLdoc("../../../../conf/system.xml","GET",false,EncapsulateSConf);
loadXMLdoc("../../../../help/"+SYSTEMCONF.getLanguage()+"/helpidresource.xml", "GET", false,EncapsulateHelpConfig);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/slmlinemgr/slmlinemgr_" + SYSTEMCONF.getLanguage() + ".xml");

loadXMLdoc("../../conf/slmlinemgr/slmlinetable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);
loadXMLdoc("../../conf/slmlinemgr/slmparamtable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);

/**
 *      
 * @param  
 * @return  
 */
function init()
{
	initBtn();
	initTable();
	doQueryLineInfo();
}
/**
 *           
 * @param  
 * @return  
 */
function initBtn()
{
	$("queryBtn").value = RESOURCE["queryBtn"];
	$("createBtn").value = RESOURCE["createBtn"];
	$("activeBtn").value = RESOURCE["activeBtn"];
	$("applyBtn").value = RESOURCE["applyBtn"];
	$("modifyBtn").value = RESOURCE["modifyBtn"];
	$("delBtn").value = RESOURCE["delBtn"];
	btnRightArr.queryBtn = new BtnRightObj("queryBtn", TECMDCODE_SLM_LINEMGR_QUERY_LINE);
	btnRightArr.createBtn = new BtnRightObj("createBtn", TECMDCODE_SLM_LINEMGR_CREATE_LINE);
	btnRightArr.activeBtn = new BtnRightObj("activeBtn", TECMDCODE_SLM_LINEMGR_ACTIVATE_BASELINE);
	btnRightArr.applyBtn = new BtnRightObj("applyBtn", TECMDCODE_SLM_LINEMGR_SET_LINE_PARAM);
	btnRightArr.modifyBtn = new BtnRightObj("modifyBtn", TECMDCODE_SLM_LINEMGR_MODIFY_LINE);
	btnRightArr.delBtn = new BtnRightObj("delBtn", TECMDCODE_SLM_LINEMGR_DELETE_LINE);
	
	sendRightInfo(); 
}
/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
	slmLineTable = new SortTable();
	slmLineTable.setImage("../../../../images/");
	var lineTableOffset = 0;
	if (isIE)
	{
		lineTableOffset = document.body.offsetHeight * 0.50;
	}
	else
	{
		lineTableOffset = document.body.clientHeight * 0.50;
	}
	slmLineTable.setBodyHeight(getComponetHeight($("slmLineTable"),lineTableOffset) + "px");
	createTableHead(slmLineTable, window.tableconf[0]); 
	slmLineTable.setOnRowSelectHandler(rowSelectHandler);
	$("slmLineTable").oncontextmenu = remarkMenuHandler
	$("slmLineTable").appendChild(slmLineTable.getTable());
	
	slmParamTable = new SortTable();
	slmParamTable.setImage("../../../../images/");
	slmParamTable.setBodyHeight(getComponetHeight($("slmParamTable"),55)+"px");
	createTableHead(slmParamTable, window.tableconf[1]);
	slmParamTable.setOnRowSelectHandler(rowSelectHandlerParamTable); 
	slmParamTable.setOnCellEditHandler(cellEditHandler);
	$("slmParamTable").oncontextmenu = popupMenuHandler;
	$("slmParamTable").appendChild(slmParamTable.getTable());
}

function rowSelectHandlerParamTable(rows)
{
  var selrows = slmParamTable.getSelectedRowCount();
  document.getElementById("theitem").innerHTML = selrows;
}
/**
 *              
 * @return  
 */
function addCellEvent()
{
    var cell;
    var editelement;
    
    for(var i = 0, tbLen = slmParamTable.getDataRowLength(); i < tbLen; i++)//     
    {
        cell = slmParamTable.getCell(i,"fiberType");//  fiberType   
        if(null != cell)
        {
            editelement = cell.element.editElement.element;//  fiberType          
            editelement.maxLength = SLM_LINEMGR_MAX_FIBERTYPE_LENGTH;//     text        
            
            editelement.onkeyup = function()
            {
            	  return calStrSinoLen(this, SLM_LINEMGR_MAX_FIBERTYPE_LENGTH);
            }
        }
				cell = slmParamTable.getCell(i, "refractiveRate");	
				textCheck(cell.element.editElement.element, SLM_LINEMGR_MIN_REFRACTIVE_RATE, SLM_LINEMGR_MAX_REFRACTIVE_RATE, 3);
				
			  cell = slmParamTable.getCell(i, "fiberLength");	
				textCheck(cell.element.editElement.element, SLM_LINEMGR_MIN_FIBER_LENGTH, SLM_LINEMGR_MAX_FIBER_LENGTH, 1);
			 
				cell = slmParamTable.getCell(i, "attenuation");	
				textCheck(cell.element.editElement.element, SLM_LINEMGR_MIN_ATTENUATION, SLM_LINEMGR_MAX_ATTENUATION, 2);
    }
}
/**
 *             
 * @param rows
 * @return  
 */
function rowSelectHandler(rows)
{
	slmParamTable.clearTableData();
	if (rows.length == 1)
	{
	  disableAllBtn();
		queryLineDetails();
	}
	else
	{
		refreshBtnStatus();
	}
}
/**
 *                
 * @param param
 * @return  
 */
function cellEditHandler(param)
{
	$("applyBtn").disabled = !btnRightArr["applyBtn"].right;
}

	

/**
 *              
 * @param evt
 * @return  
 */
function remarkMenuHandler(evt)
{
	if (!evt)
	{
		evt = window.event;
	}
	 var elem = (evt.target) ? evt.target : evt.srcElement;   
	if (elem != null && elem.blur)
    {
    	elem.blur();	  	
    }
    while (elem != null)
	{
		if (elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
    } 
    if (elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		return;
	} 
	var rowid= elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
	if (rows.length == 0)
	{
		return;
	}
    if (rows.contains(rowid))
	{
		createRemarkMenu(rows, evt); 
	}
}
/**
 *         
 * @param  
 * @return  
 */
function createRemarkMenu(rows, evt)
{
	removejsDOMmenu();
	var menuSize = 150;
	var cursorMenu = new jsDOMenu(menuSize);
	cursorMenu.addMenuItem(new menuItem(RESOURCE["remarkTitle"], "", openRemrkDlg, true));
	setPopUpMenu(cursorMenu);
	showMenu(evt);
}
/**
 *           
 * @param  
 * @return  
 */
function openRemrkDlg()
{
	removejsDOMmenu();
	var dialogHeight = 175;//"175px";
	var dialogWidth = 275;//"275px";
	xshowModalDialog("slmlineremarkmodify.html", RESOURCE["remarkTitle"], dialogWidth, dialogHeight, "../../../../images/");
}

/**
 *          
 * @param  
 * @return  
 */
function sendRightInfo()
{
	var url = "../../../../securityServlet?neID="+winurlobj["neid"]+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url, "POST", false, callbackRightInfoData, null, "inputdata=" + createRightInfoXML());

}
/**
 *               XML  
 * @param  
 * @return      
 */
function createRightInfoXML()
{
	var root = new inputxml("datainterface")
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	for (var btnrightobj in btnRightArr)
	{
		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "btnId");
		param.setAttribute("value", btnRightArr[btnrightobj].btnId);
		row.appendChild(param)
		
		param = new tagElement("param");
		param.setAttribute("name", "sfid");
		param.setAttribute("value", btnRightArr[btnrightobj].sfid);
		row.appendChild(param)
		bussiness.appendChild(row);
	}
	root.getRoot().appendChild(bussiness);
	
	
	return root.toString();
}
/**
 *             
 * @param doc 
 * @return  
 */
function callbackRightInfoData(doc)
{
	var data = EncapsulateData(doc);
	for (var i = 0, len = data.getDataRowLength(); i<len; i++)
	{
		var right = data.getDataRowParam(i,"right");
		
		
		var btnDisabled = parseInt(right)?false:true;
		$(data.getDataRowParam(i,"btnId")).disabled = btnDisabled;
		btnRightArr[data.getDataRowParam(i,"btnId")].right = !btnDisabled;
	}
}

/**
 *       
 * @param   
 * @return  
 */
function doQueryLineInfo()
{
	removejsDOMmenu(); 
	disableAllBtn();
	var data = createQueryLineInfoXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_LINE+ "&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url,"POST",false,callbackQueryLineInfoData,null,"inputdata="+data);

}
/**
 *           XML  
 * @param  
 * @return  
 */
function createQueryLineInfoXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", DEFAULT_QUERY_LINEID);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *           
 * @param doc 
 * @return  
 */
function callbackQueryLineInfoData(doc)
{
	availableLine = null;
	var data = EncapsulateData(doc);
	slmLineTable.clearTableData();
  slmParamTable.clearTableData();
	var errorCode = data.getSErrorCode();
	availableLine = data;

	if (0 == errorCode || 1 == errorCode)
	{
		
		var newData = getPortMap(data); 
		createTableBody(slmLineTable, window.tableconf[0], newData, RESOURCE);
		if(!slmLineTable.element.colsArray.selectedId)
	  {
	  	 slmLineTable.element.colsArray.selectedId = "lineID";
	  	 slmLineTable.element.colsArray.imgflag = 1;
	  }
	  var td=slmLineTable.element.headRow.element.cols[slmLineTable.element.colsArray.selectedId].element; 
	  slmLineTable.sortRows(td,slmLineTable.element.colsArray.imgflag);
		
		
		if (0 < slmLineTable.getDataRowLength() && 0 == slmLineTable.getSelectedRowCount())
		{
			slmLineTable.setRowSelect(0);
			rowSelectHandler(slmLineTable.getSelectedRows());
		}
		else
		{
			$("activeBtn").disabled = true;
			$("modifyBtn").disabled = true;
			$("delBtn").disabled = true;
			slmParamTable.clearTableData();
			refreshBtnStatus();
		}
		showErrorDialog(data);
	}
	else
	{
		showErrorDialog(data);
		refreshBtnStatus()	
	}
}
/**
 *     data      
 * @param data
 * @return newData
 */
function getPortMap(data)
{
	var newData = new DataInterface();
	var slotId;
	var boardName;
	var portId;
	var portName;
	var neName;
	for (var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		obj = new Object();
		ptag = new ParamTag();
		ptag.value = data.getDataRowParam(i, "lineID");
		obj["lineID"] = ptag;
		
		slotId = data.getDataRowParam(i,"lmuSlotId");
		boardName = data.getDataRowParam(i, "lmuBoardName");
		portId = data.getDataRowParam(i, "lmuPortId");
		portName = data.getDataRowParam(i, "lmuPortName");

		ptag = new ParamTag();
		ptag.value = slotId + "-" + boardName + "-" + portName;
		obj["lineMonitorUnit"] = ptag;
		
		slotId = data.getDataRowParam(i,"loaSlotId");
		boardName = data.getDataRowParam(i, "loaBoardName");
		portId = data.getDataRowParam(i, "loaPortId");
		portName = data.getDataRowParam(i, "loaPortName");

		ptag = new ParamTag();
		ptag.value = slotId + "-" + boardName + "-" + portName;
		obj["lineAmplifierUnit"] = ptag;
		
		slotId = data.getDataRowParam(i,"lsuSlotId");
		boardName = data.getDataRowParam(i, "lsuBoardName");
		portId = data.getDataRowParam(i, "lsuPortId");
		portName = data.getDataRowParam(i, "lsuPortName");

		ptag = new ParamTag();
		ptag.value = slotId + "-" + boardName + "-" + portName;
		obj["lineSelectUnit"] = ptag;
		
		neName = data.getDataRowParam(i, "lmiNeName");
		slotId = data.getDataRowParam(i, "lmiSlotId");
		boardName = data.getDataRowParam(i, "lmiBoardName");
		portId = data.getDataRowParam(i, "lmiPortId");
		portName = data.getDataRowParam(i, "lmiPortName");

		ptag = new ParamTag();
		ptag.value = neName + "-" + slotId + "-" + boardName + "-" + portName;
		obj["lineMonitorInterface"] = ptag;
		
		ptag = new ParamTag();
		ptag.value = data.getDataRowParam(i, "remark");
		obj["remark"] = ptag;
		
		newData.rows.append(obj)
	}
	return newData;
}
/**
 *                      
 * @param  
 * @return  
 */
function queryLineDetails()
{
	setLineTableStatus(true);
	var data = createQueryLineDetailsXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_LINE_DETAILS + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", false, constructtblXML, null, "inputdata="+data);

}
/**
 *                   XML  
 * @param  
 * @return  
 */
function createQueryLineDetailsXML()
{
	var selectedRow = slmLineTable.getSelectedRows();
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	
  var pageparam = new tagElement("page-params");
  param = new tagElement("param");
  param.setAttribute("name","pageNum");
  if(document.getElementById("pagenum").value != "")
  {
      param.setAttribute("value",document.getElementById("pagenum").value);
  }
  else
  {
      param.setAttribute("value","1");
  }
  pageparam.appendChild(param);
    
    
  param = new tagElement("param");
  param.setAttribute("name","resultNumPerPage");
  param.setAttribute("value",document.getElementById("columnnum").value);
  pageparam.appendChild(param);
  root.getRoot().appendChild(pageparam);
    
	
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "segmentID");
	param.setAttribute("value", DEFAULT_QUERY_SEGMENTID);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *                 
 * @param doc
 * @return  
 */
function callbackQueryLineDetailsData(data)
{
	var segmentNum;
	
	var refractiveRate;//      0.001
	var fiberLength;   //       1
	var attenuation;   //       0.01
	
	if (0 == data.getSErrorCode())
	{
		for (var i = 0, len = data.getDataRowLength(); i < len; i++)
		{
			refractiveRate = (parseFloat(data.getDataRowParam(i, "refractiveRate")) / 1000).toFixed(3);
			fiberLength = (parseFloat(data.getDataRowParam(i, "fiberLength")) / 10).toFixed(1);
			attenuation = (parseFloat(data.getDataRowParam(i, "attenuation")) / 100).toFixed(2);
			data.rows[i]["refractiveRate"].value = refractiveRate;
			data.rows[i]["fiberLength"].value = fiberLength;
			data.rows[i]["attenuation"].value = attenuation;
		}
		createTableBody(slmParamTable, window.tableconf[1], data, RESOURCE);
		if(!slmParamTable.element.colsArray.selectedId)
	  {
	  	 slmParamTable.element.colsArray.selectedId = "segmentID";
	  	 slmParamTable.element.colsArray.imgflag = 1;
	  }
	  var td=slmParamTable.element.headRow.element.cols[slmParamTable.element.colsArray.selectedId].element; 
	  slmParamTable.sortRows(td,slmParamTable.element.colsArray.imgflag);
		
		
		addCellEvent();
	}
	else
	{
	}
	setLineTableStatus(false);
	refreshBtnStatus();
}
/**
 *       
 * @param  
 * @return  
 */
function doActivateLine() 
{
	removejsDOMmenu(); 
	if (!confirm(RESOURCE["confirmActivate"]))
	{
		return;
	}
	setTableStatus(true);
	disableAllBtn();
	var data = createActivateLineXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_ACTIVATE_BASELINE + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackActivateLineData, null, "inputdata="+data);

}

/**
 *               XML
 * @param  
 * @return  
 */
function createActivateLineXML()
{
	var selectedRow = slmLineTable.getSelectedRows();
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
	row.appendChild(param);
	

	var lineID = slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
	for(var index = 0, indexLen = availableLine.getDataRowLength(); index < indexLen; index++)
	{
		if(lineID == availableLine.getDataRowParam(index, "lineID"))
		{
			break;
		}
	}
	
	param = new tagElement("param");
	param.setAttribute("name", "lmineid");
	param.setAttribute("value", availableLine.getDataRowParam(index, "lmineid"));
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmiSlotId");
	param.setAttribute("value", availableLine.getDataRowParam(index, "lmiSlotId"));
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmiPortId");
	param.setAttribute("value", availableLine.getDataRowParam(index, "lmiPortId"));
	row.appendChild(param);
	
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	
	return root.toString();
}
function callbackActivateLineData(doc)
{
	var data = EncapsulateData(doc);
	if (0 == data.getSErrorCode())
	{
		alert(RESOURCE["activeSuccess"]);
	}
	else
	{
		showErrorDialog(data);
	}
	setTableStatus(false);
	refreshBtnStatus();
}
/**
 *   LMI  ID
 *       00104422
 *      AU9D17405
 * @param lineID
 * @return lmineid
 */
function getLMIneid(lineID)
{
	var lmineid = winurlobj["neid"];
	for (var index = 0, indexLen = availableLine.getDataRowLength(); index < indexLen; index++)
	{
		if(availableLine.getDataRowParam(index, "lineID") == lineID)
		{
			lmineid =  availableLine.getDataRowParam(index, "lmineid");
		}
	}
	return lmineid;
}
/**
 *       
 * @param  
 * @return  
 */
function doSetLineInfo ()
{
	removejsDOMmenu(); 
	setTableStatus(true);
	disableAllBtn();
	
	var data = createApplyLineInfoXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_SET_LINE_PARAM + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackApplyLineInfoData, null, "inputdata="+data);
	
}
/**
 *           XML  
 * @param  
 * @return  
 */
function createApplyLineInfoXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var colId = null;
	var cellModifyFlag = null;
	var isModified = false;
	
	var colValue = 0;
	
	for (var rowIndex = 0, rowLen = slmParamTable.getDataRowLength(); rowIndex < rowLen; rowIndex++)
	{
		if (!slmParamTable.getModify(rowIndex))
		{
			continue;
		}
		isModified = true;
		rowData = slmParamTable.getRow(rowIndex);
		row = new tagElement("row-params");
		
		param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",winurlobj["neid"]);
		row.appendChild(param);
		
		var selectedRow = slmLineTable.getSelectedRows();
		param = new tagElement("param");
		param.setAttribute("name","lineID");
		param.setAttribute("value",slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
		row.appendChild(param);
		
		for (var colIndex = 0, colLen = slmParamTable.getColumnCount(); colIndex < colLen; colIndex++)
		{
			colId = window.tableconf[1].getColId(colIndex);
			cellModifyFlag = slmParamTable.getCellModify(rowIndex, colId);
			colKeyArray = window.tableconf[1].getColKeyArray(colIndex);
			
			for (var keyindx = 0, keyLen = colKeyArray.length; keyindx < keyLen; keyindx++)
			{
				param = new tagElement("param");
				var keyName = colKeyArray[keyindx].name;
				colValue = slmParamTable.getCellStoreValue(rowIndex, colId, keyName);
				if (keyName == "attenuation")
				{
					colValue = parseFloat(colValue) * 100; 
				}
				else if (keyName == "refractiveRate")
				{
					colValue = parseFloat(colValue) * 1000; 
				}
				else if (keyName == "fiberLength")
				{
					colValue = parseFloat(colValue) * 10; 
				}
				param.setAttribute("name", keyName);
				param.setAttribute("value", colValue);
				param.setAttribute("modifyFalg", cellModifyFlag);
				row.appendChild(param);
			}
		}
		bussiness.appendChild(row);
	}
	
	if(!isModified)
	{
		return null;
	}
	
	root.getRoot().appendChild(bussiness);

	return root.toString();
}
/**
 *            
 * @param doc
 * @return  
 */
function callbackApplyLineInfoData(doc)
{
	var data = EncapsulateData(doc);
	refreshTableState(slmParamTable, window.tableconf[1], data);
	setTableStatus(false);
	refreshBtnStatus();
	
	if(0 != data.getSErrorCode())
	{
		$("applyBtn").disabled = !btnRightArr["applyBtn"].right;
		showErrorDialog(data);
	}
}
/**
 *                
 * @param  
 * @return  
 */
function doDeleteLine()
{
	removejsDOMmenu(); 
	if (!confirm(RESOURCE["confirmDelete"]))
	{
		return;
	}
	setTableStatus(true);
	disableAllBtn();
	var selectedRow = slmLineTable.getSelectedRows();
	var data = createDeleteLineXML(selectedRow);
	var url = "../../../../neExlorerServlet?sfid=" +TECMDCODE_SLM_LINEMGR_DELETE_LINE + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackDeleteLineData, selectedRow, "inputdata="+data);

} 
/**
 *             XML  
 * @param  
 * @return  
 */
function createDeleteLineXML(selectedRow)
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
} 
/**
 *              
 * @param doc
 * @return  
 */
function callbackDeleteLineData(doc, selectedRow)
{
	var data = EncapsulateData(doc);
	if (0 == data.getSErrorCode())
	{
		slmParamTable.clearTableData();
		
		var lineID = slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
		slmLineTable.deleteRow(selectedRow[0]);
		slmLineTable.adjustDataRows();
		
		for(var index = 0, len = availableLine.getDataRowLength(); index < len; index++)
		{
			if(availableLine.getDataRowParam(index, "lineID") == lineID)
			{
				availableLine.rows.removeAt(index);
				break;
			}
		}
		document.getElementById("theitem").innerHTML = 0;
        document.getElementById("totalitem").innerHTML = 0;
		alert(RESOURCE["deleteSuccess"]);		        
	}
	else
	{
		showErrorDialog(data);
	}
	setTableStatus(false);
	refreshBtnStatus();
	
	    if (0 < slmLineTable.getDataRowLength())
		{
		    if (0 == slmLineTable.getSelectedRowCount())
		    {
			    slmLineTable.setRowSelect(0);
			    rowSelectHandler(slmLineTable.getSelectedRows());
			}
		}
		else
		{
		    document.getElementById("theitem").innerHTML = 0;
    	    document.getElementById("totalitem").innerHTML = 0;
    	
    	    document.getElementById("pagestatus").innerHTML = "1/1"
    	    optionlen = document.getElementById("pagenum").options.length;
            for(i = 0; i < optionlen; i++)
            {
                document.getElementById("pagenum").options[0] = null;
            }
            document.getElementById("pagenum").options[0] = new Option(1,1);
      
            document.getElementById("previouspage").disabled = true;
            document.getElementById("firstpage").disabled = true;
            document.getElementById("nextpage").disabled = true;
            document.getElementById("lastpage").disabled = true;
            document.getElementById("previouspage").innerHTML = RESOURCE["previouspage"];
			document.getElementById("firstpage").innerHTML = RESOURCE["firstpage"];
			document.getElementById("nextpage").innerHTML = RESOURCE["nextpage"];
			document.getElementById("lastpage").innerHTML = RESOURCE["lastpage"];
		}
	
} 

/**
 *       
 * @param  
 * @return  
 */
function refreshBtnStatus()
{
	if(slmLineTable.getSelectedRowCount() == 1)
	{
		$("activeBtn").disabled = !btnRightArr["activeBtn"].right;
		$("modifyBtn").disabled = !btnRightArr["modifyBtn"].right;
		$("delBtn").disabled = !btnRightArr["delBtn"].right;
	}
	else
	{
		$("activeBtn").disabled = true;
		$("modifyBtn").disabled = true;
		$("delBtn").disabled = true;
	}
	$("queryBtn").disabled = !btnRightArr["queryBtn"].right;
	$("createBtn").disabled = !btnRightArr["createBtn"].right;
	
	$("applyBtn").disabled = true;
	for (var rowIndex = 0, rowLen = slmParamTable.getDataRowLength(); rowIndex < rowLen; rowIndex++)
	{
		if (slmParamTable.getModify(rowIndex))
		{
			$("applyBtn").disabled = false;
			break;
		}
	}
}
/**
 *       
 * @param  
 * @return  
 */
function queryAvailablePort()
{
	var data = createQueryAvailablePortXML()
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_AVAILABLE_PORT + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", false, callbackQueryAvailablePortData, null, "inputdata="+data);

}
/**
 *           XML  
 * @param  
 * @return  
 */
function createQueryAvailablePortXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param");
	param.setAttribute("name","neid");
	param.setAttribute("value",winurlobj["neid"]);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *                
 * @param doc
 * @return  
 */
function callbackQueryAvailablePortData(doc)
{	
	availablePort = null;
	var data = EncapsulateData(doc);
	availablePort = data;
}
/**
 *              
 * @param  
 * @return  
 */
function openCreateLineDlg()
{
	removejsDOMmenu();
	queryAvailablePort();
	if(0 == availableLine.getDataRowLength() && 0 == availablePort.getDataRowLength())
	{
		alert(RESOURCE["noAvailableResource"]);
		return;
	}
	var dialogHeight = 300;//"300px";
	var dialogWidth = 450;//"450px";
	xshowModalDialog("slmlinecreate.html", RESOURCE["createLineTitle"], dialogWidth, dialogHeight, "../../../../images/");
}
/**
 *             
 * @param  
 * @return  
 */
function openModifyDlg()
{
	removejsDOMmenu(); 
	queryAvailablePort();
	var dialogHeight = 280;//"280px";
	var dialogWidth = 450;//"450px";
	xshowModalDialog("slmlinemodify.html", RESOURCE["modifyLineTitle"], dialogWidth, dialogHeight, "../../../../images/");
}

/**
 *         
 *      
 *     AU9D17370
 *                
 * @param flg:    true                  
 * @return  
 */
function setTableStatus(flg)
{
	if(flg)
	{
		for (var i = 0, len = slmLineTable.getDataRowLength(); i < len; i++)
		{
			slmLineTable.getRow(i).element.onclick = null;
		}
		$("slmParamTable").oncontextmenu = null;
		for (var j = 0, len = slmParamTable.getDataRowLength(); j < len; j++)
		{
			slmParamTable.getCellElement(j, "fiberType").ondblclick = null;
			slmParamTable.getCellElement(j, "refractiveRate").ondblclick = null;
			slmParamTable.getCellElement(j, "attenuation").ondblclick = null;
			slmParamTable.getCellElement(j, "fiberLength").ondblclick = null;
		}
	}
	else
	{
		for (var i = 0, len = slmLineTable.getDataRowLength(); i < len; i++)
		{
			slmLineTable.getRow(i).element.onclick = rowclick;
		}
		
		$("slmParamTable").oncontextmenu = popupMenuHandler;
		for (var j = 0, len = slmParamTable.getDataRowLength(); j < len; j++)
		{
			slmParamTable.getCellElement(j, "fiberType").ondblclick = cellondbclick;
			slmParamTable.getCellElement(j, "refractiveRate").ondblclick = cellondbclick;
			slmParamTable.getCellElement(j, "attenuation").ondblclick = cellondbclick;
			slmParamTable.getCellElement(j, "fiberLength").ondblclick = cellondbclick;
		}
	}
}
/**
 *          
 * @param flg:    true                  
 * @return  
 */
function setLineTableStatus(flg)
{
	if(flg)
	{
		for (var i = 0, len = slmLineTable.getDataRowLength(); i < len; i++)
		{
			slmLineTable.getRow(i).element.onclick = null;
		}
	}
	else
	{
		for (var i = 0, len = slmLineTable.getDataRowLength(); i < len; i++)
		{
			slmLineTable.getRow(i).element.onclick = rowclick;
		}
	}
}
/**
 *       
 * @return  
 */
function disableAllBtn()
{
	$("queryBtn").disabled = true;
	$("createBtn").disabled = true;
	$("activeBtn").disabled = true;
	$("applyBtn").disabled = true;
	$("modifyBtn").disabled = true;
	$("delBtn").disabled = true;
}


function showErrorDialog(dinterface)
{
  	removejsDOMmenu();
    var errArr = [];
    errArr[0] = "nename";
    
    var errorObj = null;
    var errstrArr = new Array();
    var errstr;
    for(var i = dinterface.getBErrLength() - 1; i >= 0; i--)
	  {	
	  	  errorObj = dinterface.getError().rowErrors[i].errorObj;
	  	  errstr = errorObj["nename"] + dinterface.getError().getRowCode(i);
	  	  if(errstrArr.contains(errstr))
	  	  {
	  	      dinterface.getError().rowErrors.splice(i, 1);
	  	  }
	  	  else
	  	  {
	  	      errstrArr[errstrArr.length] = errstr;
	  	  }
	  }
    openErrPage("../../../../page/", dinterface.getError(), errArr);

}



function firstpage()
{
    document.getElementById("pagenum").value = 1;
    queryLineDetails();
}

function pageup()
{
    document.getElementById("pagenum").value = parseInt(document.getElementById("pagenum").value)-1;
    queryLineDetails();
}

function pagedown()
{
    document.getElementById("pagenum").value = parseInt(document.getElementById("pagenum").value) + 1;
    queryLineDetails();
}

function lastpage()
{
	var str = document.getElementById("pagestatus").innerHTML;
    document.getElementById("pagenum").value = str.split("/")[1];
    queryLineDetails();
}


function constructtblXML(doc)
{
    for(var i=0; i< slmParamTable.getDataRowLength(); i++)
    {
        slmParamTable.deleteRow(i);
    }
    slmParamTable.adjustDataRows();
    
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
	  
    if("pageNum" in dinterface.page)
    {
        var total = document.getElementById("totalitem");
        total.removeChild(total.childNodes[0]);
        total.appendChild(document.createTextNode(dinterface.getPageParam("totalResultNum").value));

        document.getElementById("theitem").innerHTML = 0;
        
        document.getElementById("pagestatus").innerHTML = dinterface.getPageParam("pageNum").value+"/"+dinterface.getPageParam("totalPageNum").value;
        
        optionlen = document.getElementById("pagenum").options.length;
        for(i = 0; i < optionlen; i++)
        {
            document.getElementById("pagenum").options[0] = null;
        }
        for(i = 0; i < dinterface.getPageParam("totalPageNum").value; i++)
        {
            document.getElementById("pagenum").options[i] = new Option(i+1,i+1);
        }
        document.getElementById("pagenum").value = dinterface.getPageParam("pageNum").value;
        if(dinterface.getPageParam("pageNum").value > 1)
        {
        	  $("previouspage").innerHTML = "<a href='javascript:pageup();'><u>" + RESOURCE["previouspage"] + "</u></a>";
            $("firstpage").innerHTML = "<a href='javascript:firstpage();'><u>" + RESOURCE["firstpage"] + "</u></a>";
            document.getElementById("previouspage").disabled = false;
            document.getElementById("firstpage").disabled = false;
        }
        else
        {
        	  $("previouspage").innerHTML = RESOURCE["previouspage"];
            $("firstpage").innerHTML = RESOURCE["firstpage"];
            document.getElementById("previouspage").disabled = true;
            document.getElementById("firstpage").disabled = true;
        }
        if(dinterface.getPageParam("pageNum").value != dinterface.getPageParam("totalPageNum").value)
        {
        	  $("nextpage").innerHTML = "<a href='javascript:pagedown();'><u>" + RESOURCE["nextpage"] + "</u></a>";
            $("lastpage").innerHTML = "<a href='javascript:lastpage();'><u>" + RESOURCE["lastpage"] + "</u></a>";
            document.getElementById("nextpage").disabled = false;
            document.getElementById("lastpage").disabled = false;
        }
        else
        {
        	  $("nextpage").innerHTML = RESOURCE["nextpage"];
            $("lastpage").innerHTML = RESOURCE["lastpage"];
            document.getElementById("nextpage").disabled = true;
            document.getElementById("lastpage").disabled = true;
        }
        var countsPerPage = dinterface.getPageParam("resultNumPerPage").value;
        if (countsPerPage != 20 && countsPerPage != 40 && countsPerPage != 60 &&
        		countsPerPage != 80 && countsPerPage != 100)
        {
        	document.getElementById("columnnum").value = 0;
        }
        else
        {
        	document.getElementById("columnnum").value = countsPerPage;
        }
        
    }
    else
    {
    	document.getElementById("theitem").innerHTML = 0;
    	document.getElementById("totalitem").innerHTML = 0;
    	
    	document.getElementById("pagestatus").innerHTML = "1/1"
    	optionlen = document.getElementById("pagenum").options.length;
      for(i = 0; i < optionlen; i++)
      {
          document.getElementById("pagenum").options[0] = null;
      }
      document.getElementById("pagenum").options[0] = new Option(1,1);
      
      document.getElementById("previouspage").disabled = true;
      document.getElementById("firstpage").disabled = true;
      document.getElementById("nextpage").disabled = true;
      document.getElementById("lastpage").disabled = true;
      document.getElementById("previouspage").innerHTML = RESOURCE["previouspage"];
			document.getElementById("firstpage").innerHTML = RESOURCE["firstpage"];
			document.getElementById("nextpage").innerHTML = RESOURCE["nextpage"];
			document.getElementById("lastpage").innerHTML = RESOURCE["lastpage"];
   }

   callbackQueryLineDetailsData(dinterface);
}



