 var newLineTable; //        
var parentWin = getParentWindow(); //     
var winurlobj = parentWin.winurlobj;

var SLM_DEFAULT_SEGMENT_NUM = 0;
var SLM_MIN_REPEATER_NUM = "0";
var SLM_MAX_REPEATER_NUM = "239";
var SLM_DEFAULT_REPEATER_NUM = 4;
var SLM_LENGTH_REPEATER_NUM = 3;
var availableLineData = parentWin.availableLine;//    
var availablePortData = parentWin.availablePort;//    
var lmuPortData; //  LMU  
var loaPortData; //  LOA  
var lsuPortData; //  LSU  
var lmiPortData; //  LMU  
var SLM_LINEMGR_MAX_REMARK_LENGTH = 63;

loadXMLdoc("../../../../conf/system.xml","GET",false,EncapsulateSConf);
loadXMLdoc("../../../../help/"+SYSTEMCONF.getLanguage()+"/helpidresource.xml", "GET", false,EncapsulateHelpConfig);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/slmlinemgr/slmlinemgr_"+ SYSTEMCONF.getLanguage() +".xml");
document.title = RESOURCE["createLineTitle"];
/**
 *        
 * @param  
 * @return  
 */
function init()
{
	initAvaiablePort();
	initBtn();
	initTable();
}
/**
 *        
 * @param  
 * @return  
 */
function initAvaiablePort()
{
	lmuPortData = [];
	loaPortData = [];
	lsuPortData = [];
	lmiPortData = [];
	

	var availableObj = {};	
	if (null != availablePortData)
	{
		for (var i = 0, len = availablePortData.getDataRowLength(); i < len; i++)
		{		
			switch (parseInt(availablePortData.getDataRowParam(i,"boardType")))
			{
				case SLM_LMU_BOARDTYPE:
					lmuPortData.push(createTEPort(availablePortData, i));
					break;
				case SLM_LOA_BOARDTYPE:
					loaPortData.push(createTEPort(availablePortData, i));
					break;
				case SLM_LSU_BOARDTYPE:
					lsuPortData.push(createTEPort(availablePortData, i));
					break;
				case SLM_LMI_BOARDTYPE:
					lmiPortData.push(createTEPort(availablePortData, i));
					break;
				default:
					continue;
			}
		}
	}
	if (null != availableLineData)
	{
		for (var index = 0, indexLen = availableLineData.getDataRowLength(); index < indexLen; index++)
		{
			var lsuneid = availableLineData.getDataRowParam(index, "lsuneid");
			var lsuSlotId = availableLineData.getDataRowParam(index, "lsuSlotId");
			var lsuPortId = availableLineData.getDataRowParam(index, "lsuPortId");

			refreshTEPort(lsuneid, lsuSlotId, lsuPortId, lsuPortData);
		  /*var lsuIndex = getTEPortIndex(lsuneid, lsuSlotId, lsuPortId, lsuPortData);
		  if(-1 != lsuIndex)
		  {
		  	lsuPortData.splice(lsuIndex, 1);
		  }*/
		  var lmineid = availableLineData.getDataRowParam(index, "lmineid");
			var lmiSlotId = availableLineData.getDataRowParam(index, "lmiSlotId");
			var lmiPortId = availableLineData.getDataRowParam(index, "lmiPortId");
			
			refreshTEPort(lmineid, lmiSlotId, lmiPortId, lmiPortData);
		  /*var lmiIndex = getTEPortIndex(lmineid, lmiSlotId, lmiPortId, lmiPortData);
		  if(-1 != lmiIndex)
		  {
		  	lmiPortData.splice(lmiIndex, 1);
		  }	*/																															
		}
	}
}

/**
 *      
 * @param  
 * @return  
 */
function initBtn()
{
	$("okBtn").value = RESOURCE["okBtn"];
	$("cancelBtn").value = RESOURCE["cancelBtn"];
	$("applyBtn").value = RESOURCE["applyBtn"];
}
/**
 *        
 * @param  
 * @return  
 */
function initTable()
{
	var selectedRow = parentWin.slmLineTable.getSelectedRows();
	newLineTable = new CTable();
	newLineTable.addHead(RESOURCE["attrCol"], RESOURCE["valueCol"]);
	
	var cTableAtom = null;
	var cTableAtomEle = null;
	
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	createOption(cTableAtomEle, lmuPortData);
	if(0 != selectedRow.length)
	{
		var lmuMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineMonitorUnit", "lineMonitorUnit");
		cTableAtom.setValue(getTEPort(lmuMap,lmuPortData));
	}
	cTableAtomEle.onchange = lmuSelectListener;
	newLineTable.addAttrRow("lineMonitorUnit", RESOURCE["lineMonitorUnit"], cTableAtom);
	
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	createOption(cTableAtomEle, loaPortData);
	if(0 != selectedRow.length)
	{
		var loaMap = parentWin.slmLineTable.getCellStoreValue(selectedRow[0], "lineAmplifierUnit", "lineAmplifierUnit");
		cTableAtom.setValue(getTEPort(loaMap, loaPortData));
	}
	cTableAtomEle.onchange = loaSelectListener;
	newLineTable.addAttrRow("lineAmplifierUnit", RESOURCE["lineAmplifierUnit"], cTableAtom);
	
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	createOption(cTableAtomEle ,lsuPortData);
	if(0 != selectedRow.length)
	{
		var lsuTEPort = getSelectUnit(selectedRow, availableLineData, lsuPortData);
		if(null != lsuTEPort)
		{
			cTableAtom.setValue(lsuTEPort);
		}
	}
	cTableAtomEle.onchange = lsuSelectListener;
	newLineTable.addAttrRow("lineSelectUnit", RESOURCE["lineSelectUnit"], cTableAtom);
	
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	for (var i = 0, len = lmiPortData.length; i <len; i++)
	{
		if (!containPort(cTableAtomEle.options,lmiPortData[i]))
		{
			cTableAtomEle.options[cTableAtomEle.options.length] = new Option(lmiPortData[i].neName, lmiPortData[i].neid);
		}
	}
	
	var options = cTableAtomEle.options;
  var lmiNeList= [];
  for(var i = options.length - 1; i >= 0; i--)
  {
    var obj = new Object();
		obj.neName = options[i].text;
		obj.neid = options[i].value;
		lmiNeList[lmiNeList.length] = obj;
		options[i] = null;
  }
  lmiNeList.sort();
  cTableAtomEle.options.length = 0;
  for(var i = 0, listlen = lmiNeList.length; i < listlen; i++)
  {
		cTableAtomEle.options[cTableAtomEle.options.length] = new Option(lmiNeList[i].neName, lmiNeList[i].neid);        
  }
    
	cTableAtomEle.onchange = lmiNESelectListener;
	newLineTable.addAttrRow("lineInterfaceNE", RESOURCE["lineInterfaceNE"], cTableAtom);
	if(0 != selectedRow.length)
	{
		var lmiTEPort = getInterfaceNE(selectedRow, availableLineData, lmiPortData);
		if(null != lmiTEPort)
		{
			cTableAtom.element.value = lmiTEPort.neid;
		}
	}
	
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	newLineTable.addAttrRow("lineInterfaceUnit", RESOURCE["lineInterfaceUnit"], cTableAtom);
	createLMIOption(newLineTable.getAttrValue("lineInterfaceNE"));
	if(0 != selectedRow.length)
	{
		var lmiTEPort = getInterfaceNE(selectedRow, availableLineData,lmiPortData)
		cTableAtom.setValue(lmiTEPort);
	}
	
	cTableAtom = new Atom("text");
	cTableAtom.setValue(SLM_DEFAULT_REPEATER_NUM);
	cTableAtomEle = cTableAtom.element;
  cTableAtomEle.disabled = false;
	checkText(cTableAtomEle,SLM_MIN_REPEATER_NUM,SLM_MAX_REPEATER_NUM);
	cTableAtomEle.onblur = repeaterNumChangeListener;
	newLineTable.addAttrRow("repeaterNum", RESOURCE["repeaterNum"], cTableAtom);
	
	cTableAtom = new Atom("text");
	cTableAtom.setValue(SLM_DEFAULT_REPEATER_NUM + 1);
	cTableAtomEle = cTableAtom.element;
  cTableAtomEle.disabled = true;
	newLineTable.addAttrRow("segmentNum", RESOURCE["segmentNum"], cTableAtom);
	
	cTableAtom = new Atom("text");
	cTableAtomEle = cTableAtom.element;
	cTableAtomEle.disabled = false;
	cTableAtomEle.onkeyup = remarkLengthCheckListener;
	newLineTable.addAttrRow("remark", RESOURCE["remarkDiv"], cTableAtom);
	
	$("newLineTable").appendChild(newLineTable.getTable());
}
/**
 *              
 * @param  
 * @return  
 */
function remarkLengthCheckListener(evt)
{
	if (!evt)
	{
		evt = window.event;
	}
	return calStrSinoLen(newLineTable.getAtom("remark").element, SLM_LINEMGR_MAX_REMARK_LENGTH);
}
/**
 *   LMU      
 * @param  
 * @return  
 */
function lmuSelectListener(evt)
{
	newLineTable.getAtom("lineAmplifierUnit").element.onchange = null;
	newLineTable.getAtom("lineSelectUnit").element.onchange = null;
	if (!evt)
	{
		evt = window.event;
	}
	$("applyBtn").disabled = false;
	var slotId;
	var portId;
	var lmuPort = newLineTable.getAttrValue("lineMonitorUnit");
	if (null != availableLineData)
	{
		for (var i = 0, len = availableLineData.getDataRowLength(); i < len; i++)
		{
			slotId = availableLineData.getDataRowParam(i, "lmuSlotId");
			portId = availableLineData.getDataRowParam(i, "lmuPortId");
			lmuSlotId = lmuPort.split("-")[0];
			lmuPortId = lmuPort.split("-")[2].split("(")[0];
			if(lmuSlotId == slotId && lmuPortId == portId )
			{
				newLineTable.setAttrValue("lineAmplifierUnit", getPort(availableLineData.getDataRowParam(i, "loaneid"), availableLineData.getDataRowParam(i, "loaSlotId"), availableLineData.getDataRowParam(i, "loaPortId"),loaPortData));
				newLineTable.setAttrValue("lineSelectUnit", getLSUPort(availableLineData.getDataRowParam(i, "lsuneid"), availableLineData.getDataRowParam(i, "lsuSlotId"), lsuPortData));
				break;
			}
		}
	}
	newLineTable.getAtom("lineAmplifierUnit").element.onchange = loaSelectListener;
	newLineTable.getAtom("lineSelectUnit").element.onchange = lsuSelectListener;
}
/**
 *   LOA      
 * @param  
 * @return  
 */
function loaSelectListener(evt)
{
	newLineTable.getAtom("lineMonitorUnit").element.onchange = null;
	newLineTable.getAtom("lineSelectUnit").element.onchange = null;
	if (!evt)
	{
		evt = window.event;
	}
	$("applyBtn").disabled = false;
	var slotId;
	var portId;
	var loaPort = newLineTable.getAttrValue("lineAmplifierUnit");
	if (null != availableLineData)
	{
		for (var i = 0, len = availableLineData.getDataRowLength(); i < len; i++)
		{
			slotId = availableLineData.getDataRowParam(i, "loaSlotId");
			portId = availableLineData.getDataRowParam(i, "loaPortId");
			loaSlotId = loaPort.split("-")[0];
			loaPortId = loaPort.split("-")[2].split("(")[0];
			if (loaSlotId == slotId && loaPortId == portId )
			{
				newLineTable.setAttrValue("lineMonitorUnit", getPort(availableLineData.getDataRowParam(i, "lmuneid"), availableLineData.getDataRowParam(i, "lmuSlotId"), availableLineData.getDataRowParam(i, "lmuPortId"),lmuPortData));
				newLineTable.setAttrValue("lineSelectUnit", getLSUPort(availableLineData.getDataRowParam(i, "lsuneid"), availableLineData.getDataRowParam(i, "lsuSlotId"),lsuPortData));
				break;
			}
		}
	}
	newLineTable.getAtom("lineMonitorUnit").element.onchange = lmuSelectListener;
	newLineTable.getAtom("lineSelectUnit").element.onchange = lsuSelectListener;
}
/**
 *   LSU      
 * @param  
 * @return  
 */
function lsuSelectListener(evt)
{
	newLineTable.getAtom("lineMonitorUnit").element.onchange = null;
	newLineTable.getAtom("lineAmplifierUnit").element.onchange = null;
	if (!evt)
	{
		evt = window.event;
	}
	$("applyBtn").disabled = false;
	var slotId;
	var portId;
	var lsuPort = newLineTable.getAttrValue("lineSelectUnit");
	if (null != availableLineData)
	{
		for (var i = 0, len = availableLineData.getDataRowLength(); i < len; i++)
		{
			slotId = availableLineData.getDataRowParam(i, "lsuSlotId");
			lsuSlotId = lsuPort.split("-")[0];
			if (lsuSlotId == slotId)
			{
				newLineTable.setAttrValue("lineMonitorUnit", getPort(availableLineData.getDataRowParam(i, "lmuneid"), availableLineData.getDataRowParam(i, "lmuSlotId"), availableLineData.getDataRowParam(i, "lmuPortId"),lmuPortData));
				newLineTable.setAttrValue("lineAmplifierUnit", getPort(availableLineData.getDataRowParam(i, "loaneid"), availableLineData.getDataRowParam(i, "loaSlotId"), availableLineData.getDataRowParam(i, "loaPortId"),loaPortData));
				break;
			}
		}
	}
	newLineTable.getAtom("lineMonitorUnit").element.onchange = lmuSelectListener;
	newLineTable.getAtom("lineAmplifierUnit").element.onchange = loaSelectListener;
}
/**
 *            
 * @param  
 * @return  
 */
function lmiNESelectListener(evt)
{
	if (!evt)
	{
		evt = window.event;
	}
	$("applyBtn").disabled = false;
	var tmpLMIArray = [];
	var neid = newLineTable.getAttrValue("lineInterfaceNE");
	for (var i = 0, len = lmiPortData.length; i < len; i++)
	{
		if (neid == lmiPortData[i].neid)
		{
			tmpLMIArray.push(lmiPortData[i]);
		}
	}
	createOption(newLineTable.getAtom("lineInterfaceUnit").element, tmpLMIArray);
}
/**
 *        Option  
 * @param  
 * @return  
 */
function createLMIOption(neid)
{
	var tmpLMIArray = [];
	for (var i = 0, len = lmiPortData.length; i < len; i++)
	{
		if (neid == lmiPortData[i].neid)
		{
			tmpLMIArray.push(lmiPortData[i]);
		}
	}
	createOption(newLineTable.getAtom("lineInterfaceUnit").element, tmpLMIArray);
}
/**
 *               port  
 * @param optionArray, port
 * @return  
 */
function containPort(optionArray, port)
{
	for (var i = 0, len = optionArray.length; i < len; i++)
	{
		if (port.neid == optionArray[i].value)
		{
			return true;
		}
	}
	return false;
}
/**
 * Repeater         
 * @param  
 * @return  
 */
function repeaterNumChangeListener()
{
	$("applyBtn").disabled = false;
	if ("" == newLineTable.getAttrValue("repeaterNum"))
	{
		newLineTable.setAttrValue("segmentNum", "");
		return;
	}
	newLineTable.setAttrValue("segmentNum", parseInt(newLineTable.getAttrValue("repeaterNum"))+1);
}

/**
 *               
 * @param  
 * @return  
 */
function doCreateLine(isApply)
{
	if ($("applyBtn").disabled)
	{
		xcloseDialog();
	}
	$("okBtn").disabled = true;
	$("applyBtn").disabled = true;
	$("cancelBtn").disabled = true;
	if(isApply)
	{
		setAllElement(true);
	}
	var data = createNewLineXML();
	if (null == data)
	{
		alert(RESOURCE["checkDataInfo"]);
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		$("cancelBtn").disabled = false;
		if (isApply)
		{
			setAllElement(false);
		}
		return;
	}
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_CREATE_LINE + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackCreateLineData, isApply, "inputdata="+data); 
} 
/**
 *           XML  
 * @param  
 * @return  
 */
function createNewLineXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	if("" == newLineTable.getAtom("lineMonitorUnit").getValue())
	{
		return null;
	}
	var lmuTEPort = getTEPort(newLineTable.getAtom("lineMonitorUnit").getValue(), lmuPortData);
	param = new tagElement("param");
	param.setAttribute("name", "lmuneid");
	param.setAttribute("value", lmuTEPort.neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmuSlotId");
	param.setAttribute("value", lmuTEPort.slotId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmuPortId");
	param.setAttribute("value", lmuTEPort.portId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmuBoardName");
	param.setAttribute("value", lmuTEPort.boardName);
	row.appendChild(param);
	
	if("" == newLineTable.getAtom("lineAmplifierUnit").getValue())
	{
		return null;
	}
	var loaTEPort = getTEPort(newLineTable.getAtom("lineAmplifierUnit").getValue(), loaPortData);
	param = new tagElement("param");
	param.setAttribute("name", "loaneid");
	param.setAttribute("value", loaTEPort.neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "loaSlotId");
	param.setAttribute("value", loaTEPort.slotId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "loaPortId");
	param.setAttribute("value", loaTEPort.portId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "loaBoardName");
	param.setAttribute("value", loaTEPort.boardName);
	row.appendChild(param);
	
	if("" == newLineTable.getAtom("lineSelectUnit").getValue())
	{
		return null;
	}
	var lsuTEPort = getTEPort(newLineTable.getAtom("lineSelectUnit").getValue(), lsuPortData);
	param = new tagElement("param");
	param.setAttribute("name", "lsuneid");
	param.setAttribute("value", lsuTEPort.neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lsuSlotId");
	param.setAttribute("value", lsuTEPort.slotId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lsuPortId");
	param.setAttribute("value", lsuTEPort.portId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lsuBoardName");
	param.setAttribute("value", lsuTEPort.boardName);
	row.appendChild(param);
	
	if("" == newLineTable.getAtom("lineInterfaceUnit").getValue())
	{
		return null;
	}
	var lmineid = newLineTable.getAtom("lineInterfaceNE").getValue();
	var lmiTEPort = getLMITEPort(lmineid, newLineTable.getAtom("lineInterfaceUnit").getValue(), lmiPortData);
	param = new tagElement("param");
	param.setAttribute("name", "lmineid");
	param.setAttribute("value", lmiTEPort.neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmiSlotId");
	param.setAttribute("value", lmiTEPort.slotId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmiPortId");
	param.setAttribute("value", lmiTEPort.portId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmiBoardName");
	param.setAttribute("value", lmiTEPort.boardName);
	row.appendChild(param);
	
	
	if("" == newLineTable.getAtom("repeaterNum").getValue())
	{
		return null;
	}
	param = new tagElement("param");
	param.setAttribute("name", "segmentNum");
	param.setAttribute("value", newLineTable.getAttrValue("segmentNum"));
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "remark");
	param.setAttribute("value", newLineTable.getAttrValue("remark"));
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *            
 * @param doc
 * @return  
 */
function callbackCreateLineData(doc, isApply) 
{
	var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	if (0 == errorCode || 1 == errorCode) 
	{
		parentWin.doQueryLineInfo();
		if (isApply)
		{
			freshNewLineTable();
		}
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		$("cancelBtn").disabled = false;
		showOperResult(data);
		if (!isApply && 0 == errorCode) //               
		{
			xcloseDialog();
		}
	}
	else
	{
		showOperResult(data);
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		$("cancelBtn").disabled = false;
	}
	if(isApply)
	{
		setAllElement(false);
	}
}
/**
 *      AU9D18037          begin
 *              
 * @return  
 */
function freshNewLineTable()
{
	var newLineData = new NewLineData();
	availableLineData.rows[availableLineData.rows.length] = newLineData;
	initAvaiablePort();
	refreshOptions(newLineData);
}

/**
 *                  
 *      AU9D27227     l00104422        options       null          
 * @return  
 */
function refreshOptions(newLineData)
{
	var lsuOptions = newLineTable.getAtom("lineSelectUnit").element.options;
	for (var i = lsuOptions.length - 1; i >= 0; i--)
	{
		var lsuMap = lsuOptions[i].value;
		var lsuSlotIdOp = lsuMap.split("-")[0];
		var lsuPortIdOp = lsuMap.split("-")[2].split("(")[0];
		if (newLineData.lsuSlotId.value == lsuSlotIdOp && newLineData.lsuPortId.value == lsuPortIdOp)
		{
			lsuOptions[i] = null;
			break;
		}
	}
	var lmiOptions = newLineTable.getAtom("lineInterfaceUnit").element.options;
	var lmineid = newLineTable.getAtom("lineInterfaceNE").getValue();
	for (var i = lmiOptions.length - 1; i >= 0; i--)
	{
		var lmiMap = lmiOptions[i].value;
		var lmiSlotIdOp = lmiMap.split("-")[0];
		var lmiPortIdOp = lmiMap.split("-")[2].split("(")[0];
		if (newLineData.lmineid.value == lmineid && newLineData.lmiSlotId.value == lmiSlotIdOp && newLineData.lmiPortId.value == lmiPortIdOp)
		{
			lmiOptions[i] = null;
			break;
		}
	}
	var removeFlg = true;
	for (var i = 0, len = lmiPortData.length; i < len; i++)
	{
		var tmpPort = lmiPortData[i];
		if (lmineid == tmpPort.neid)
		{
			removeFlg = false;
			break;
		}
	}
	var lmiNEOptions = newLineTable.getAtom("lineInterfaceNE").element.options
	if(removeFlg)
	{
		for(var index = lmiNEOptions.length - 1; index >= 0; index--)
		{
			if(lmineid == lmiNEOptions[index].value)
			{
				lmiNEOptions[index] = null;
				break;
			}
		}
		createLMIOption(newLineTable.getAttrValue("lineInterfaceNE"));
	}
}

/**
 *   data       
 * @return  
 */
function NewLineData()
{
	var lmuTEPort = getTEPort(newLineTable.getAtom("lineMonitorUnit").getValue(), lmuPortData);
	this.lmuSlotId = new dataObject(lmuTEPort.slotId);
	this.lmuneid = new dataObject(lmuTEPort.neid);
	this.lmuNeName = new dataObject(lmuTEPort.neName);
	this.lmuBoardName = new dataObject(lmuTEPort.boardName);
	this.lmuBoardType = new dataObject(lmuTEPort.boardType);
	this.lmuPortId = new dataObject(lmuTEPort.portId);
	this.lmuPortName = new dataObject(lmuTEPort.portName);
	
	var loaTEPort = getTEPort(newLineTable.getAtom("lineAmplifierUnit").getValue(), loaPortData);
	this.loaSlotId = new dataObject(loaTEPort.slotId);
	this.loaneid = new dataObject(loaTEPort.neid);
	this.loaNeName = new dataObject(loaTEPort.neName);
	this.loaBoardName = new dataObject(loaTEPort.boardName);
	this.loaBoardType = new dataObject(loaTEPort.boardType);
	this.loaPortId = new dataObject(loaTEPort.portId);
	this.loaPortName = new dataObject(loaTEPort.portName);
	
	var lsuTEPort = getTEPort(newLineTable.getAtom("lineSelectUnit").getValue(), lsuPortData);
	this.lsuSlotId = new dataObject(lsuTEPort.slotId);
	this.lsuneid = new dataObject(lsuTEPort.neid);
	this.lsuNeName = new dataObject(lsuTEPort.neName);
	this.lsuBoardName = new dataObject(lsuTEPort.boardName);
	this.lsuBoardType = new dataObject(lsuTEPort.boardType);
	this.lsuPortId = new dataObject(lsuTEPort.portId);
	this.lsuPortName = new dataObject(lsuTEPort.portName);
	
	var lmineid = newLineTable.getAtom("lineInterfaceNE").getValue();
	var lmiTEPort = getLMITEPort(lmineid, newLineTable.getAtom("lineInterfaceUnit").getValue(), lmiPortData);
	this.lmiSlotId = new dataObject(lmiTEPort.slotId);
	this.lmineid = new dataObject(lmiTEPort.neid);
	this.lmiNeName = new dataObject(lmiTEPort.neName);
	this.lmiBoardName = new dataObject(lmiTEPort.boardName);
	this.lmiBoardType = new dataObject(lmiTEPort.boardType);
	this.lmiPortId = new dataObject(lmiTEPort.portId);
	this.lmiPortName = new dataObject(lmiTEPort.portName);
	
	this.remark = new dataObject(newLineTable.getAttrValue("remark"));
}

/**
 *            
 *      AU9D18037          end
 * @return  
 */
function dataObject(value)
{
	this.value = value;
	this.options = null;
}

/**
 *               
 * @param 
 * @return  
 */
function setAllElement(flag)
{
	newLineTable.getAtom("lineMonitorUnit").element.disabled = flag;
	newLineTable.getAtom("lineAmplifierUnit").element.disabled = flag;
	newLineTable.getAtom("lineSelectUnit").element.disabled = flag;
	newLineTable.getAtom("lineInterfaceNE").element.disabled = flag;
	newLineTable.getAtom("lineInterfaceUnit").element.disabled = flag;
	newLineTable.getAtom("repeaterNum").element.disabled = flag;
	newLineTable.getAtom("remark").element.disabled = flag;
}
/**
 *          
 * @param doc
 * @return  
 */
function doCancel()
{
	xcloseDialog();
}

/**
 *    LMI                
 * @return  
 */
Object.prototype.toString = function()
{
	return this.neName;
}
