var st = null;

var urlObject = getNeProperty(self);//the URL object of this page 
var neID = urlObject.neid; //network element id
var nmUsrID = urlObject.nmUser ;//network manager userID, write operation log and check right
var nmUserName = urlObject.nmUserName ;//network manager userName
var btnRightArr = new Object();//save to button right


var NUM_ZERO = 0;
var CODE_FAULT = 2; //operation fault erroeCode 
var CODE_PARTSUCC = 1;//part success errorCode
var CODE_SUCC = 0;//operation success errorCode
var querySFID = TECMDCODE_GET_OPERATOR_INFO;//9401;
var applySFID = TECMDCODE_SET_OPERATOR_INFO;//9400;


/**
 * initialize this page
 * @param data: NO
 * @return NO
 */
function initPage()
{

	initTable();   //initialize the rsvpTable
	initButton();   //initialize buttons
	
	var rightURL = "../../../../securityServlet?neID=" + neID + "&nmUser=" + nmUsrID;
	getRightInfo(urlObject, btnRightArr);//call the function which come from the right.js file, get function right;
	
	doQuery();    //run query
}

/**
 * initialize rsvpTable
 * @param data:NO
 * @return NO
 */
function initTable()
{	
	st = new SortTable();        
    st.setImage("../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setOnCellEditHandler(handleCellDbClickEvent);//cells of the rsvpTable edited event
    $("tablediv").appendChild(st.getTable());
    
    st.setBodyHeight(getComponetHeight($("tablediv"),75)+"px");
    st.setBodyWidth(window.tableconf[0].width,window.tableconf[0].percent,0);
}

function handleCellDbClickEvent()
{
	document.getElementById("applybtn").disabled = !btnRightArr.applybtn.right;
}


/**
 * initialize button enable status
 * @param data:NO
 * @return NO
 */
 function initButton()
 {
    document.getElementById("querybtn").value = RESOURCE["querybutton"];
    
    document.getElementById("applybtn").value = RESOURCE["applybutton"];
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", querySFID);
    
    btnRightArr.applybtn = new BtnRightObj("applybtn", applySFID);
    
    
 }  

 /**
  * operate query 
  * @param data:no
  * @return no
  */
function doQuery()
{
    document.getElementById("querybtn").disabled = !btnRightArr.querybtn.right;    
    document.getElementById("applybtn").disabled = true;        
    
    if(!btnRightArr.querybtn.right)
    {
    	return;
    }
    
    setBtnStatus(false);//set disabled buttons status   
    
    var queryURL = "../../../../neExlorerServlet?sfid=" + querySFID +"&nmUser="+nmUsrID;
    var xmlData = constructQueryXML();//construct query XML
    loadXMLdoc(queryURL, "POST", true, handleQueryBack, null, "inputdata="+xmlData);//send query request      
}

/**
 * construct query XML
 * @param data: no
 * @return xml
 */
function constructQueryXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");  
    
    var thirdlevel = new tagElement("param");              
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",neID);
    secondlevel.appendChild(thirdlevel);       
    
    firstlevel.appendChild(secondlevel);
    
    root.getRoot().appendChild(firstlevel);
    
    return root.toString();
} 
 
/**
 * handle callback function of query
 * @param doc 
 * @return no
 */
function handleQueryBack(doc)
{
	var data = EncapsulateData(doc);
	
	if( CODE_FAULT != data.getSErrorCode() )
	{
		st.clearTableData();//clear rsvpTable data
		createTableBody(st, window.tableconf[0], data, RESOURCE);//Display The Page Data		
	}
	
	handleQueryErrInfo(data);//hanlde query error
	
	document.getElementById("querybtn").disabled = !btnRightArr.querybtn.right;
	document.getElementById("applybtn").disabled = true;	
	
	addListerner();	
}

function encapsulateBackData(datainterface)
{	
	for(var i = 0, len = datainterface.getDataRowLength(); i < len; i++)
	{		
	    var diObj = datainterface.rows[i];
	    if("" == diObj["internationalid"].value)
	    {
	    	diObj["internationalid"].value = "  ";
	    }
	       
	}
}


function addListerner()
{
	var cell;
	
	for(var i = 0,len = st.getDataRowLength();i<len;i++)
	{
		cell = st.getCellEdit(i,"internationalid");
		cell.element.maxLength = 3;
		checkInputData(cell.element, 3);
		cell = st.getCellEdit(i,"internalid");
		cell.element.maxLength = 6;
		checkInputData(cell.element, 6);
		cell = st.getCellEdit(i,"customid");
		cell.element.maxLength = 118;
		checkInputData(cell.element, 118);
	}
}
function checkInputData(obj,maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);        
    }
    
    obj.onkeydown = function()
    {
    	  var letterFlg = forbidSignInput();//      
    	  if(!letterFlg)
    	  {
    	      return letterFlg;
    	  }
    	  var code=event.keyCode!=0?event.keyCode:event.charCode;
    	  if(!event.shiftKey && !event.ctrlKey && (code <= 36 || code >= 41) && code != 9 || (event.shiftKey && code != 16))
    	  {
    	      $("applybtn").disabled = false;
    	  }    	  
    }
}
/**
 * operate modify
 * @param no
 * @return no
 */
function doApply()
{		
	setBtnStatus(false);
	
	var xmlData = constructApplyXML();
	var applyURL = "../../../../neExlorerServlet?sfid=" + applySFID +"&nmUser="+nmUsrID;//? come form macrores.js
	loadXMLdoc(applyURL, "POST", true, handleApplyBack, null, "inputdata="+xmlData);//send modify request
}

/**
 * construct modify XML
 * @param data: no
 * @return xml
 */
function constructApplyXML()
{
    var root = new inputxml("datainterface");
    var firstLevel = new tagElement("bussiness-params");
    
    var secondLevel, thirdLevel;  
    
	secondLevel = new tagElement("row-params");
    		
	thirdLevel = new tagElement("param");
	thirdLevel.setAttribute("name", "neid");
	thirdLevel.setAttribute("value", neID);
	secondLevel.appendChild(thirdLevel);
    		
	thirdLevel = new tagElement("param");
	thirdLevel.setAttribute("name", "internationalid");
	var internationalid = st.getCellStoreValue(0, "internationalid", "internationalid")
	if(undefined == internationalid)
	{
		internationalid = "";
	}
	thirdLevel.setAttribute("value", internationalid);
	secondLevel.appendChild(thirdLevel);
    		
	thirdLevel = new tagElement("param");
	thirdLevel.setAttribute("name", "internalid");
	var internalid = st.getCellStoreValue(0, "internalid", "internalid")
	if(undefined == internalid)
	{
		internalid = "";
	}
	thirdLevel.setAttribute("value", internalid);
	secondLevel.appendChild(thirdLevel);
    		
	thirdLevel = new tagElement("param");
	thirdLevel.setAttribute("name", "customid");
	var customid = st.getCellStoreValue(0, "customid", "customid")
	if(undefined == customid)
	{
		customid = "";
	}
	thirdLevel.setAttribute("value", customid);
	secondLevel.appendChild(thirdLevel);
    		
	firstLevel.appendChild(secondLevel);

    
    root.getRoot().appendChild(firstLevel);
    
    return root.toString();
}

/**
 * handle callback function of modify
 * @param doc 
 * @return no
 */
function handleApplyBack(doc)
{	
	var data = EncapsulateData(doc);
	var applybtnStatus = !( CODE_SUCC != data.getSErrorCode());
	document.getElementById("applybtn").disabled = applybtnStatus;
	document.getElementById("querybtn").disabled = false;
	
	handleErrInfo(data);
	
	refreshTableState(st, window.tableconf[0], data);//Call the function of the common.js file
	

}


/**
 * set buttons status
 * @param enableStatus boolean
 * @return
 */
function setBtnStatus(enableStatus)
{
	document.getElementById("querybtn").disabled = !enableStatus;
	document.getElementById("applybtn").disabled = !enableStatus;
}

/**
 * handle query error
 * @param data
 * @return no
 */
function handleQueryErrInfo(data)
{
	var errArr = [];//define errors object
	errArr.push("nename");
	
	openErrPage("../../../../page/", data.getError(), errArr);//open the error page
}

/**
 * handle operate error
 */
function handleErrInfo(data)
{
	var errArr = [];//define errors object
	errArr.push("nename");	
	
	openErrPage("../../../../page/", data.getError(), errArr);//open the error page
}
