var winurlobj = getNeProperty(self);

var hasApplyRight = true;

function initpage()
{
	$("querybtn").value=RESOURCE["querybutton"];
	$("applybtn").value=RESOURCE["applybutton"];

    st = new SortTable();
    st.setImage("../../../../images/");
    tc = window.tableconf[0];
    var supportAttr = winurlobj["supportAttr"].split(",");
    
    filterAttrCol(tc,supportAttr);
    
    if(tc.getIndexByid("ENVCTRL_COM_ALARMCSK_ALARMLEVEL") != -1)//       
    {
    	tc.colArray.removeAt(0);
    }

    createTableHead(st, window.tableconf[0]);
    
    st.setOnCellEditHandler(cellEditHandler);
    
    $("table").appendChild(st.getTable());
    
    $("table").oncontextmenu = popupMenuHandler;
    
    st.setBodyHeight(getComponetHeight($("table"),80)+"px");
    
    window.onresize=function()
	{
		st.setBodyHeight(getComponetHeight($("table"),80)+"px");
	}
    
    if(tc.getIndexByid("ENVCTRL_COM_INPUTCSK_ALARMLEVEL") != -1)//       
    { 
	    var hc=st.getHeadCell("ENVCTRL_COM_INPUTCSK_ALARMLEVEL");
	    st.setHCAttribute(hc,1,0,compareNum);
    }
    
    sendRightInfo();
    
    if(!$("querybtn").disabled)
    {
        sendQueryInfo();	
    }
    
}

/**
 *          
 * @param   
 * @return   
 */ 
function sendRightInfo()
{
	var url = "../../../../securityServlet?neID="+winurlobj["neid"]+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url,"POST",false,rightHandleBack,null,"inputdata=" + createRightXML());
}

/**
 *                 XML
 * @param   
 * @return   
 */ 
function createRightXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;
	var thirdlevel=null;
	
	secondlevel = new tagElement("row-params"); //bean               	
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","querybtn");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value", TECMDCODE_GET_PMUATTRIB);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	
	
	secondlevel = new tagElement("row-params"); //bean               	
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","applybtn");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value", TECMDCODE_SET_PMUATTRIB);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
		
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();
}

/**
 *               
 * @param   
 * @return   
 */ 
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
    
	for(var i = 0; i < data.getDataRowLength(); i++)  //            
    {
    	var right = data.getDataRowParam(i,"right");
    	
    	if(0 == right)
    	{
    		$(data.getDataRowParam(i,"btnID")).disabled = true;
    	} 
    	else
    	{
    		$(data.getDataRowParam(i,"btnID")).disabled = false;
    	}        
    }   
}

function sendQueryInfo()
{
	$("querybtn").disabled = true;
    $("applybtn").disabled = true;

    var neid = winurlobj.neid;
    var slotid = winurlobj.slotid;
    var xmlstr = createQueryXML(neid,slotid,tc);
    
    urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_GET_PMUATTRIB+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,queryCallBack,null,"inputdata="+xmlstr);
}

var boardType = 0;//c00104334   

function queryCallBack(doc)
{
	$("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    if(data.getSErrorCode() == 2)
    {
    	showErrorDialog(data);
    	return;
    }
    
     for(var i = 0; i <  data.getDataRowLength(); i++)
    {
    	
        diobj = data.rows[i];
        
        if(null != diobj["ENVCTRL_COM_TEMPERUPLIMIT"]&&"/" != diobj["ENVCTRL_COM_TEMPERUPLIMIT"].value)
        {

	        key = "ENVCTRL_COM_TEMPERUPLIMIT";
	    	addDot(diobj,key);
        }
        
        if(null != diobj["ENVCTRL_COM_TEMPERDOWNLIMIT"]&&"/" != diobj["ENVCTRL_COM_TEMPERDOWNLIMIT"].value)
        {
	            key = "ENVCTRL_COM_TEMPERDOWNLIMIT";
	        	addDot(diobj,key);
        }
        
        if(null != diobj["ENVCTRL_COM_ENV_TEMP"]&&"/" != diobj["ENVCTRL_COM_ENV_TEMP"].value)
        {
	            key = "ENVCTRL_COM_ENV_TEMP";
	        	addDot(diobj,key);
        }

        if(null != diobj["ENVCTRL_PMU_INPUTVOLTUPLIMIT"]&&"/" != diobj["ENVCTRL_PMU_INPUTVOLTUPLIMIT"].value)
        {

	        key = "ENVCTRL_PMU_INPUTVOLTUPLIMIT";
	    	addDot(diobj,key);
        }
        
        if(null != diobj["ENVCTRL_PMU_INPUTVOLTDOWNLIMIT"]&&"/" != diobj["ENVCTRL_PMU_INPUTVOLTDOWNLIMIT"].value)
        {
	            key = "ENVCTRL_PMU_INPUTVOLTDOWNLIMIT";
	        	addDot(diobj,key);
        }
        
        boardType = data.getDataRowParam(i,"boardType");
    }
    
    createGenCfgTableBody(st, tc, data, RESOURCE);
    
    addListener();
    
    if(data.getSErrorCode() == 0)
    {
    	return;
    }
    
    showErrorDialog(data);
    data = null;
    
}

function addDot(diobj,key)
{
	var len = diobj[key].value.length;
	var value = diobj[key].value;
	
	if(len > 1)
	{
		if(len == 2&&value.charAt(0) == "-")
		{
			value = "-0."+value.charAt(1);
		}
		else
		{
			value = value.substring(0,len-1)+"."+value.charAt(len-1);
		}
	}
	else
	{
		value = "0."+value;
	}
	
	diobj[key].value = value;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    
    if(tc.getIndexByid("ENVCTRL_COM_INPUTCSK_USE") != -1)//        
    {
    }
    else if (tc.getIndexByid("ENVCTRL_PMU_CODE_STATE") != -1)//      
    {
    }
    else
    {
    	errArr[3] = "attrId";
    }
    
    var errorObj = null;
    for(var i = 0, len = data.getBErrLength(); i < len; i++)
	{	
		errorObj = data.getError().rowErrors[i].errorObj;
		errorObj["attrId"] = getAttrName(tc,data.getError().getRowKey(i,"attrId"));
	}
    openErrPage("../../../../page/", data.getError(), errArr);
}

var BOARD_TYPE = ["640", "44", "1229", "1228", "1227", "1226","1628","1629","1630","1632"];      //SCC,PMU,LMU,LOA,LSU,LMI,B2LMU,B2LAS,B2LMI,B2LSCC        
var TEMPERLIMIT_MIN = ["-50.0", "-40.0", "-5.0", "-5.0", "-5.0", "-5.0","-15.0","-15.0","-15.0","-50.0"];  //SCC,PMU,LMU,LOA,LSU,LMI,B2LMU,B2LAS,B2LMI,B2LSCC         
var TEMPERLIMIT_MAX = ["100.0", "80.0", "65.0", "65.0", "65.0", "65.0","100.0","100.0","100.0","100.0"];   //SCC,PMU,LMU,LOA,LSU,LMI,B2LMU,B2LAS,B2LMI,B2LSCC         

var INTPUT_VOLT_LEVEL = [0, 1];                         //          48v,60v
var INPUT_VOLT_UPLIMIT_DEFAULT = ["60.0", "71.0"];      //                    
var INPUT_VOLT_DOWNLIMIT_DEFAULT = ["41.0", "51.0"];    //                    
var INPUT_VOLT_UPLIMIT_MIN = ["55.0", "65.0"];          //                    
var INPUT_VOLT_UPLIMIT_MAX = ["65.0", "75.0"];          //                    
var INPUT_VOLT_DOWNLIMIT_MIN = ["38.0", "48.0"];        //                    
var INPUT_VOLT_DOWNLIMIT_MAX =["48.0", "58.0"];          //                    

function addListener()
{
	var firstInputVolt;
	var secondInputVolt;
	var inputVoltDownLimit;
	var seriOverVolt;
	var seriUnderVolt;
	var commonOverVolt;
	var commonUnderVolt;
	var secSeriOverVolt;
	var secSeriUnderVolt;
	var secCommonOverVolt;
	var secCommonUnderVolt;
	var tempUpLimit;
	var tempDownLimit;
	var tempUpLimitCell;
	var tempDownLimitCell;
	var ids = getIDs();
	
	var temperDown = 0;
    var temperUp = 0;
    for (var i = 0, len = BOARD_TYPE.length; i < len; i ++)
    {
    	if (BOARD_TYPE[i] == boardType)
    	{
    		temperDown = TEMPERLIMIT_MIN[i];
    		temperUp = TEMPERLIMIT_MAX[i];
    		break;
    	}
    }

	for(var i = 0,len = st.getDataRowLength(); i < len; i++)
	{
		
		if(ids.contains("ENVCTRL_COM_TEMPERUPLIMIT"))
		{
			tempUpLimitCell = st.getCell(i,"ENVCTRL_COM_TEMPERUPLIMIT");
			tempUpLimitCell.element.style.imeMode = "disabled";
			tempUpLimitCell.element.ondblclick =  function()
			{
				tempdbclick(this, temperDown);
			}
			
			tempUpLimit = st.getCellEdit(i,"ENVCTRL_COM_TEMPERUPLIMIT");
			
			
			textCheck(tempUpLimit.element, temperDown, temperUp);

		}
		
		if(ids.contains("ENVCTRL_COM_TEMPERDOWNLIMIT"))
		{
			tempDownLimitCell = st.getCell(i,"ENVCTRL_COM_TEMPERDOWNLIMIT");
			
			tempDownLimitCell.element.ondblclick = function()
			{
				tempdbclick(this,"0.0");
			}
			
			tempDownLimit = st.getCellEdit(i,"ENVCTRL_COM_TEMPERDOWNLIMIT");
			
			textCheck(tempDownLimit.element, temperDown, temperUp);

		}
		
		if(ids.contains("ENVCTRL_PMU_INPUTVOLTUPLIMIT"))
		{	
		    handleInputVoltUpLimit(i);
        }

		
		if(ids.contains("ENVCTRL_PMU_INPUTVOLTDOWNLIMIT"))
		{
		    handleInputVoltDownLimit(i);	
		}
		
		if(ids.contains("ENVCTRL_PMU_CSKCTRLSWMODE"))
		{
			handleCSKCTRLSWMODE(i);
		}
		
		if(ids.contains("ENVCTRL_COM_INPUTCSK_USE"))
		{
			handleInputCSKUse(i);
		}
		
		if(ids.contains("ENVCTRL_COM_TEMPEMONITOR"))
		{
			var tempMonitorCellEdit = st.getCellEdit(i,"ENVCTRL_COM_TEMPEMONITOR");
			var tempMonitorCell = st.getCell(i,"ENVCTRL_COM_TEMPEMONITOR");
			var tempMonitorValue = st.getCellStoreValue(i,"ENVCTRL_COM_TEMPEMONITOR","ENVCTRL_COM_TEMPEMONITOR");
			if(tempMonitorValue == "0")
			{
				var tempupCell = st.getCell(i,"ENVCTRL_COM_TEMPERUPLIMIT");
				
				var tempdownCell = st.getCell(i,"ENVCTRL_COM_TEMPERDOWNLIMIT");
				
				st.setCellValue(tempupCell,"ENVCTRL_COM_TEMPERUPLIMIT","3276.7");
				st.getCellShow(i,"ENVCTRL_COM_TEMPERUPLIMIT").setValue("-");
				
				st.setCellIsEdit(tempupCell,0);
				tempupCell.element.ondblclick = null;
			    tempupCell.element.style.backgroundColor = "#C8C8C8";
			    
			    st.setCellValue(tempdownCell,"ENVCTRL_COM_TEMPERDOWNLIMIT","3276.7");
				st.getCellShow(i,"ENVCTRL_COM_TEMPERDOWNLIMIT").setValue("-");
				
				st.setCellIsEdit(tempdownCell,0);
				tempdownCell.element.ondblclick = null;
			    tempdownCell.element.style.backgroundColor = "#C8C8C8";
			}
			
			tempMonitorCell.element.ondblclick = function()
			{
				var index = this.parentNode.rowIndex;
				var upCell = st.getCell(index,"ENVCTRL_COM_TEMPERUPLIMIT");
				var downCell = st.getCell(index,"ENVCTRL_COM_TEMPERDOWNLIMIT");
				
				var tempValue = st.getCellStoreValue(index,"ENVCTRL_COM_TEMPEMONITOR","ENVCTRL_COM_TEMPEMONITOR");
				upCell.element.modify = true;
				downCell.element.modify = true;
				
				if(tempValue == 0)
				{
					st.setCellValue(upCell,"ENVCTRL_COM_TEMPERUPLIMIT","3276.7");
					st.setCellValue(downCell,"ENVCTRL_COM_TEMPERDOWNLIMIT","3276.7");
				}
				tempdbclick(this,tempValue);
			}
			
			tempMonitorCellEdit.element.onchange = function()
			{
				var index = this.parentNode.parentNode.rowIndex;
				var tempupCell = st.getCell(index,"ENVCTRL_COM_TEMPERUPLIMIT");
				var tempupEdit = st.getCellEdit(index,"ENVCTRL_COM_TEMPERUPLIMIT");
				var tempupShow = st.getCellShow(index,"ENVCTRL_COM_TEMPERUPLIMIT");
				
				var tempdownCell = st.getCell(index,"ENVCTRL_COM_TEMPERDOWNLIMIT");
				var tempdownEdit = st.getCellEdit(index,"ENVCTRL_COM_TEMPERDOWNLIMIT");
				var tempdownShow = st.getCellShow(index,"ENVCTRL_COM_TEMPERDOWNLIMIT");
				
				if(this.value == "0")//      
				{
					st.setCellValue(tempupCell,"ENVCTRL_COM_TEMPERUPLIMIT","3276.7");
					tempupShow.setValue("-");
					
					st.setCellIsEdit(tempupCell,0);
					tempupCell.element.ondblclick = null;
					tempupCell.element.modify = true;
				    tempupCell.element.style.backgroundColor = "#C8C8C8";
				    
				    st.setCellValue(tempdownCell,"ENVCTRL_COM_TEMPERDOWNLIMIT","3276.7");
					tempdownShow.setValue("-");
					
					st.setCellIsEdit(tempdownCell,0);
					tempdownCell.element.ondblclick = null;
					tempdownCell.element.modify = true;
				    tempdownCell.element.style.backgroundColor = "#C8C8C8";
				}
				else
				{
					st.setCellValue(tempupCell,"ENVCTRL_COM_TEMPERUPLIMIT","60.0")//      
					tempupShow.setValue("60.0");
					tempupCell.element.modify = true;
					
					st.setCellValue(tempdownCell,"ENVCTRL_COM_TEMPERDOWNLIMIT","0.0")//      
					tempdownShow.setValue("0.0");
					tempdownCell.element.modify = true;
					
					st.setCellIsEdit(tempupCell,1);
					tempupCell.element.ondblclick = cellondbclick;
					tempupCell.element.style.backgroundColor = "#ffffff";
					
					st.setCellIsEdit(tempdownCell,1);
					tempdownCell.element.ondblclick = cellondbclick;
					tempdownCell.element.style.backgroundColor = "#ffffff";
				}
			}
		}
	}
}

function handleCSKCTRLSWMODE(stRow)
{
	var ctrlModecell = st.getCellEdit(stRow, "ENVCTRL_PMU_CSKCTRLSWMODE");			
	var ctrlModeValue = st.getCellStoreValue(stRow, "ENVCTRL_PMU_CSKCTRLSWMODE","ENVCTRL_PMU_CSKCTRLSWMODE");
	
	var k0StateEdit = st.getCellEdit(stRow, "ENVCTRL_PMU_K0STATE");
	var k0StateCell = st.getCell(stRow, "ENVCTRL_PMU_K0STATE");
	var k0StateShow = st.getCellShow(stRow, "ENVCTRL_PMU_K0STATE");
	
	var k1StateCell = st.getCell(stRow, "ENVCTRL_PMU_K1STATE");
	var k1StateEdit = st.getCellEdit(stRow, "ENVCTRL_PMU_K1STATE");
	var k1StateShow = st.getCellShow(stRow, "ENVCTRL_PMU_K1STATE");
	
	
	if(ctrlModeValue == "0")//      
	{
		k0StateShow.setValue("-");
		k0StateCell.element.ondblclick = null;
	    k0StateCell.element.style.backgroundColor = "#C8C8C8";
	    
	    st.setCellIsEdit(k0StateCell,0);
	    
	    k1StateShow.setValue("-");
		k1StateCell.element.ondblclick = null;
	    k1StateCell.element.style.backgroundColor = "#C8C8C8";
	    
	    st.setCellIsEdit(k1StateCell,0);
	    
	}
	else//      
	{
		k0StateEdit.clearOptions();
		k0StateEdit.addOption(k0State[0],"0");
		k0StateEdit.addOption(k0State[1],"1");
		
		st.setCellIsEdit(k0StateCell,1);
		
		k1StateEdit.clearOptions();
		k1StateEdit.addOption(k1State[0],"0");
		k1StateEdit.addOption(k1State[1],"1");
		
		st.setCellIsEdit(k1StateCell,1);
		
	}
	
		
	ctrlModecell.element.onchange = function()
	{
		var index = this.parentNode.parentNode.rowIndex;
		
		var k0StateCell = st.getCell(index, "ENVCTRL_PMU_K0STATE");
		var k0StateEdit = st.getCellEdit(index, "ENVCTRL_PMU_K0STATE");
		var k0StateShow = st.getCellShow(index, "ENVCTRL_PMU_K0STATE");
		
		var k1StateCell = st.getCell(index, "ENVCTRL_PMU_K1STATE");
		var k1StateEdit = st.getCellEdit(index, "ENVCTRL_PMU_K1STATE");
		var k1StateShow = st.getCellShow(index, "ENVCTRL_PMU_K1STATE");
		
			
		if(this.value == "0")//      
		{
			st.setCellValue(k0StateCell, "ENVCTRL_PMU_K0STATE","0")
			k0StateShow.setValue("-");
			k0StateCell.element.ondblclick = null;
		    k0StateCell.element.style.backgroundColor = "#C8C8C8";
		    
		    st.setCellIsEdit(k0StateCell,0);
			
			st.setCellValue(k0StateCell, "ENVCTRL_PMU_K1STATE","0")
			k1StateShow.setValue("-");
			k1StateCell.element.ondblclick = null;
		    k1StateCell.element.style.backgroundColor = "#C8C8C8";
		    
		    st.setCellIsEdit(k1StateCell,0);
		    
		}
		else
		{
			st.setCellValue( k0StateCell,"ENVCTRL_PMU_K0STATE","0");
			k0StateEdit.clearOptions();
			k0StateEdit.addOption(k0State[0], "0");
			k0StateEdit.addOption(k0State[1], "1");
			k0StateShow.setValue(k0State[0]);
			k0StateCell.element.modify = true;
			k0StateCell.element.ondblclick = cellondbclick;
			k0StateCell.element.style.backgroundColor = "#d0f946";
			
			st.setCellIsEdit(k0StateCell,1);
			
			st.setCellValue( k0StateCell,"ENVCTRL_PMU_K1STATE","0");
			k1StateEdit.clearOptions();
			k1StateEdit.addOption(k1State[0], "0");
			k1StateEdit.addOption(k1State[1], "1");
			k1StateShow.setValue(k1State[0]);
			k1StateCell.element.modify = true;
			k1StateCell.element.ondblclick = cellondbclick;
			k1StateCell.element.style.backgroundColor = "#d0f946";
			
			st.setCellIsEdit(k1StateCell,1);
			
		}
	}
}

function getIDs()
{
	var ids = new Array();
	for(var i=0,len=tc.getColsLength();i<len;i++)
	{
		ids[ids.length] = tc.getColId(i);
	}
	return ids;
}

function tempdbclick(obj,value)
{
	obj.style.backgroundColor = "#d0f946";
    obj.modify = true;  
    obj.parentNode.modify = true; 
	obj.showElement.element.style.display = "none";
	obj.editElement.element.style.display = ""; 
	
	var colid = obj.colid;
	var editdom = obj.parent.editdom[colid];
	obj.appendChild(editdom.element);
	
	if(editdom.type == "text")
	{
	if(obj.showElement.getValue() == "/")
	{
		editdom.setValue(value);
		
	}
	else
	{
		editdom.setValue(obj.showElement.getValue());
	  	
	}
  }else if(editdom.type == "select")
  {
  	editdom.setValue(value);
  }
	
	editdom.element.focus();
	
    handleCellEdit(obj,TABLE_CONSTANT.BEFOREEDIT); 
}

function sendSetInfo()
{
	$("querybtn").disabled = true;
    $("applybtn").disabled = true;
        
    var neid = winurlobj.neid;
    var xmlstr = createSetXML(neid,st,tc);
    
    urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_SET_PMUATTRIB+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,setCallBack,null,"inputdata="+xmlstr);
}

function setCallBack(doc)
{
	$("querybtn").disabled = false;
    
	var data = EncapsulateData(doc);
    
    if(data.getSErrorCode() != 0)
    {
    	$("applybtn").disabled = false;
    }
    
    showErrorDialog(data,tc);
   
    refreshTableState(st,tc,data);
    
    if(st.getCell(0,"ENVCTRL_COM_TEMPEMONITOR"))
    {
    	if(st.getCellStoreValue(0,"ENVCTRL_COM_TEMPEMONITOR","ENVCTRL_COM_TEMPEMONITOR") == "0")
    	{
    		var tempupCell = st.getCell(0,"ENVCTRL_COM_TEMPERUPLIMIT");
    		var tempdownCell = st.getCell(0,"ENVCTRL_COM_TEMPERDOWNLIMIT");
    		
    		st.setCellIsEdit(tempupCell,0);
			tempupCell.element.ondblclick = null;
		    tempupCell.element.style.backgroundColor = "#C8C8C8";
		    
			tempdownCell.element.ondblclick = null;
			tempdownCell.element.modify = true;
		    tempdownCell.element.style.backgroundColor = "#C8C8C8";
    	}
    }
}


/**
 *                  XML   
 * @param neid:   ID slotid:   ID tc:               
 * @return String:             XML   
 */
function createSetXML(neid,st,tc)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var colid = null;
    var key = null;
    var colkeyarray = null;
    var cellModifyFlag = false;
    var portid = null;
    var index = 0;
    var port = null;
    var mdband;
    var wave1;
    var wave2;
    var temp;
    for(var rowindex = 0,rowlen = st.getDataRowLength();rowindex<rowlen;rowindex++)
    {
    	if(!st.getModify(rowindex))
    	{
    		continue;
    	}
    	row = new tagElement("row-params");
    	param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",neid); 
		row.appendChild(param);	
    	for(var colindex = 0,collen = st.getColumnCount();colindex<collen;colindex++)
    	{
    		colid = tc.getColId(colindex);
    		cellModifyFlag = st.getCellModify(rowindex,colid);
    		colkeyarray = tc.getColKeyArray(colindex);
    		for(var keyindex = 0,keylen = colkeyarray.length;keyindex<keylen;keyindex++)
    		{
    			param = new tagElement("param");
    			
    			key = colkeyarray[keyindex].name;
    			
    			if("portname" == key)
    			{
    				param.setAttribute("name","port");
    				port = st.getCellStoreValue(rowindex,colid,key);
    				param.setAttribute("value",port.substring(0,port.indexOf("(")));
    				row.appendChild(param);
    				
    				continue;
    			}
    			
    			if("ENVCTRL_COM_TEMPEMONITOR"==key)
    			{
    				continue;
    			}

    			param.setAttribute("name",key);

    			if("ENVCTRL_COM_TEMPERDOWNLIMIT"==key||"ENVCTRL_COM_TEMPERUPLIMIT"==key)
    			{
    				param.setAttribute("value",(st.getCellStoreValue(rowindex,colid,key)*10).toString());
    			}
    			else if ("ENVCTRL_PMU_INPUTVOLTUPLIMIT" == key || "ENVCTRL_PMU_INPUTVOLTDOWNLIMIT" == key)
    			{
    				param.setAttribute("value", (st.getCellStoreValue(rowindex, colid,key) * 10).toString());
    			}    		
    			else if ("switch" == key)
    			{
    			    var switchValue = st.getCellStoreValue(rowindex,colid,key);
    			    if (switchValue != null && -1 != switchValue.indexOf("CSK-"))
    			    {
    			        param.setAttribute("value",switchValue.substring(4));
    			    } 
    			    else
    			    {
    			        param.setAttribute("value",st.getCellStoreValue(rowindex,colid,key));
    			    }
    			}
    			else
    			{
    				param.setAttribute("value",st.getCellStoreValue(rowindex,colid,key));
    			}
    			
    			param.setAttribute("modifyFlag",cellModifyFlag); 
    			row.appendChild(param);		
    		}    		
    	}
    	bussiness.appendChild(row);
    } 

     di.getRoot().appendChild(bussiness);
     return di.toString();
}

/**
 *                   
 * @param   
 * @return   
 */
function cellEditHandler()
{
	if(hasApplyRight)
	{
		$("applybtn").disabled = false; 
	}
}
/**
 *         
 */
window.onresize=function()
{
	 st.setBodyHeight(getTableHeight($("table"),st)+"px");
}


function handleInputVoltUpLimit(stRow)
{
    var voltUpLimitCell =null;	//                 
	var voltUpLimitEdit = null;		//             
	var inputVoltLevel = null;       //          
	var inputVoltUpLimitMin = null;
	var inputVoltUpLimitMax = null;
	var inputVoltUpLimitDefault = null;    
	
	voltUpLimitCell = st.getCell(stRow, "ENVCTRL_PMU_INPUTVOLTUPLIMIT");		    
    voltUpLimitEdit = st.getCellEdit(stRow, "ENVCTRL_PMU_INPUTVOLTUPLIMIT");				
	
	voltUpLimitCell.element.ondblclick = function()
	{
	    inputVoltLevel = st.getCellStoreValue(stRow, "ENVCTRL_PMU_INPUTVOLTLEVEL", "ENVCTRL_PMU_INPUTVOLTLEVEL");
	
    	for (var j = 0; j < INTPUT_VOLT_LEVEL.length; j ++)
	    {
	        if (inputVoltLevel == INTPUT_VOLT_LEVEL[j])
	        {
	            inputVoltUpLimitMin= INPUT_VOLT_UPLIMIT_MIN[j];
	            inputVoltUpLimitMax = INPUT_VOLT_UPLIMIT_MAX[j];
	            inputVoltUpLimitDefault = INPUT_VOLT_UPLIMIT_DEFAULT[j];
	            break;
	        }
	    }
	
		tempdbclick(this, inputVoltUpLimitDefault);
		
        textCheck(voltUpLimitEdit.element, inputVoltUpLimitMin, inputVoltUpLimitMax);						
	}
}

/**
 *                           
 * @param stRow              
 * @return   
 */
function handleInputVoltDownLimit(stRow)
{
    var inputVoltLevel = null;//          
    var voltDownLimitCell = null; //                 
	var voltDownLimit = null;	//                 
	var inputVoltDownLimitMin = null;//                 
	var inputVoltDownLimitMax = null;//                 
    var inputVoltDownLimitDefault = null;//                 
    
    voltDownLimitCell = st.getCell(stRow, "ENVCTRL_PMU_INPUTVOLTDOWNLIMIT");
	voltDownLimit = st.getCellEdit(stRow,"ENVCTRL_PMU_INPUTVOLTDOWNLIMIT");
	
	voltDownLimitCell.element.ondblclick = function()
    {
	    inputVoltLevel = st.getCellStoreValue(stRow, "ENVCTRL_PMU_INPUTVOLTLEVEL", "ENVCTRL_PMU_INPUTVOLTLEVEL");

		for (var j = 0; j < INTPUT_VOLT_LEVEL.length; j ++)
		{
		    if (inputVoltLevel == INTPUT_VOLT_LEVEL[j])
		    {
		        inputVoltDownLimitMin = INPUT_VOLT_DOWNLIMIT_MIN[j];
		        inputVoltDownLimitMax = INPUT_VOLT_DOWNLIMIT_MAX[j];
		        inputVoltDownLimitDefault = INPUT_VOLT_DOWNLIMIT_DEFAULT[j];
		        break;
		    }
		}
		tempdbclick(this, inputVoltDownLimitDefault);
		
	    textCheck(voltDownLimit.element, inputVoltDownLimitMin, inputVoltDownLimitMax);
	}
}

/**
 *                      
 * @param stRow              
 * @return   
 */
function handleInputCSKUse(stRow)
{
    var useValue = st.getCellStoreValue(stRow,"ENVCTRL_COM_INPUTCSK_USE","ENVCTRL_COM_INPUTCSK_USE");
	var useCellEdit = st.getCellEdit(stRow,"ENVCTRL_COM_INPUTCSK_USE");
	var alarmModeCell = st.getCell(stRow,"ENVCTRL_COM_INPUTCSK_ALARMMODE");
	var alarmModeShow = st.getCellShow(stRow,"ENVCTRL_COM_INPUTCSK_ALARMMODE");
	
	if(useValue == "0")
	{
		alarmModeShow.setValue("-");
		alarmModeCell.element.ondblclick = null;
	    alarmModeCell.element.style.backgroundColor = "#C8C8C8";
	    
	    st.setCellIsEdit(alarmModeCell,0);
	}
	
	useCellEdit.element.onchange = function()
	{
		var index = this.parentNode.parentNode.rowIndex;
		var alarmModeCell = st.getCell(index,"ENVCTRL_COM_INPUTCSK_ALARMMODE");
		var alarmModeEdit = st.getCellEdit(index,"ENVCTRL_COM_INPUTCSK_ALARMMODE");
		var alarmModeShow = st.getCellShow(index,"ENVCTRL_COM_INPUTCSK_ALARMMODE");
		
		if(this.value == "0")
		{
			st.setCellValue(alarmModeCell,"ENVCTRL_COM_INPUTCSK_ALARMMODE","0");
			alarmModeShow.setValue("-");
			alarmModeCell.element.ondblclick = null;
		    alarmModeCell.element.style.backgroundColor = "#C8C8C8";
		    
		    st.setCellIsEdit(alarmModeCell,0);
		}
		else
		{
			st.setCellValue(alarmModeCell,"ENVCTRL_COM_INPUTCSK_ALARMMODE","0");
			alarmModeEdit.clearOptions();
			alarmModeEdit.addOption(intputAlarmMode[0],"0");
			alarmModeEdit.addOption(intputAlarmMode[1],"1");
			alarmModeShow.setValue(intputAlarmMode[0]);
			alarmModeCell.element.modify = true;
			alarmModeCell.element.ondblclick = cellondbclick;
			alarmModeCell.element.style.backgroundColor = "#d0f946";
			
			st.setCellIsEdit(alarmModeCell,1);
		}
	}
}
