var winobj = getNeProperty(parent);

var routewayTable;
var routwayid = 0;
var availablePort;
var ROUTWAY_NUM = 2;
var F1ROUTEWAY = "F1";
var DEFAULT_BOARDID = -1;
var availablePortData;
var routewayTableData;

var btnRightArr = new Object();
function initBody()
{
    $("availablePortTitle").appendChild(document.createTextNode(RESOURCE["choiceChannel"]));
    initTable();
    initButton();
}

function tabSelectHandler()
{
    if (btnRightArr.queryBtn.right) 
    {
        queryData();
    }
}

function queryData()
{
    queryAvailablePort();
    queryRouteway();
    fillAvailablePort(availablePortData);
    addDataToRoutewayTable(routewayTableData);
    compareData(availablePort, routewayTable);
}

function initTable()
{
    availablePort = new CSelect("255px", "400px");
    availablePort.element.style.fontSize = "12px";
    availablePort.multipleFlag = true;
    $("availablePort").appendChild(availablePort.getElement());
    
    routewayTable = new SortTable();
    routewayTable.head.setAttribute("id", "htmlTableF1DataRouteWayTHead");
    routewayTable.body.setAttribute("id", "htmlTableF1DataRouteWayTBody");
    routewayTable.setImage("../../../../images/");
    routewayTable.setBodyHeight("400px");
    createTableHead(routewayTable, window.tableconf[0]);
    routewayTable.isUsedForSelectList = true;
    document.getElementById("routewaytable").appendChild(routewayTable.getTable());
}

function initButton()
{
    btnRightArr.queryBtn = new BtnRightObj("queryBtn", TECMDCODE_GET_GNRL);
    btnRightArr.applyBtn = new BtnRightObj("applyBtn", TECMDCODE_SET_GNRL);
    getRightInfo(winobj, btnRightArr);
    $("queryBtn").value = RESOURCE["getButton"];
    $("applyBtn").value = RESOURCE["setButton"];
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
}

function queryXMLInfo()
{
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winobj["neid"]);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

function queryAvailablePort()
{
    $("applyBtn").disabled = true;
    var xml = queryXMLInfo();
    var url = "../../../../neExlorerServlet?sfid=" + Query_Available_Port + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, callbackAvailablePortData, null, "inputdata=" + xml);
}

function callbackAvailablePortData(doc)
{
    var data = EncapsulateData(doc);
    var errObj = null;
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        availablePortData = data;
    }
}

function fillAvailablePort(data)
{
    availablePort.clear();
    var value;
    var text;
    var option;
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        text = data.getDataRowParam(i, "availableport");
        value = data.getDataRowParam(i, "availableportid");
        if (value.indexOf("EFT") < 0 && value.indexOf("EMS") < 0) //F1 don't support EFT board
        {
            option = new COption(text, value);
            availablePort.addOption(option);
        }
    }
    
}

function queryRouteway()
{
    $("queryBtn").disabled = true;
    var xml = createQueryRoutewayXMLInfo();
    var url = "../../../../neExlorerServlet?sfid=" + Query_Routeway + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, callbackQueryRoutewayData, null, "inputdata=" + xml);
}

function createQueryRoutewayXMLInfo()
{
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ingressslotid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "egressslotid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

function callbackQueryRoutewayData(doc)
{
    var data = EncapsulateData(doc);
    var errorObj = null;
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode()) 
    {
        routewayTable.clearTableData();
        routewayTableData = data;
    }
    else 
    {
        errorObj = [];
        errorObj.push("");
    }
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    showOperResult(data, errorObj);
}

function addDataToRoutewayTable(data)
{
    if (data) 
    {
        createTableBody(routewayTable, window.tableconf[0], data, RESOURCE);
        adjustRoutewayTable(routewayTable);
    }
}


function addRouteway()
{
    var selectedRowIndex = [];
    var selectedRowNum = 0;
    var options = availablePort.getSelected();
    if (options.length <= 0) 
    {
        alert(RESOURCE["twoRoutewaySelected"]);
        $("moveToRightBtn").disabled = false;
        return;
    }
    $("applyBtn").disabled = !btnRightArr.applyBtn.right;
    for (var i = 0, m = options.length; i < m; i++) 
    {
        selectedRowNum++;
        selectedRowIndex[selectedRowIndex.length] = options[i].getIndex();
    }
    if (selectedRowNum != 2) 
    {
        selectedRow = [];
        alert(RESOURCE["twoRoutewaySelected"]);
        return;
    }
    addToRoutewayTable(availablePort, routewayTable, selectedRowIndex);
}

function addToRoutewayTable(availablePort, routewayTable, selectedRowIndex)
{
    var dataInterface = new DataInterface();
    var obj = new Object();
    
    var para = new ParamTag();
    para.value = (routewayTable.getDataRowLength() + 1) + "";
    obj["routwayid"] = para;
    
    var option = availablePort.getOption(selectedRowIndex[0]);
    para = new ParamTag();
    para.value = option.text;
    obj["firstdatarouteway"] = para;
    
    para = new ParamTag();
    para.value = option.value;
    obj["fid"] = para;
    
    option = availablePort.getOption(selectedRowIndex[1]);
    para = new ParamTag();
    para.value = option.text;
    obj["seconddatarouteway"] = para;
    
    para = new ParamTag();
    para.value = option.value;
    obj["sid"] = para;
    
    dataInterface.rows[0] = obj
    
    availablePort.removeOption(selectedRowIndex[1]);
    availablePort.removeOption(selectedRowIndex[0]);
    
    createTableBody(routewayTable, window.tableconf[0], dataInterface, RESOURCE);
    routewayTable.adjustDataRows();
    
    if (!routewayTable.element.colsArray.selectedId) 
    {
        routewayTable.element.colsArray.selectedId = "routwayid";
        routewayTable.element.colsArray.imgflag = 1;
    }
    var td = routewayTable.element.headRow.element.cols[routewayTable.element.colsArray.selectedId].element;
    routewayTable.sortRows(td, routewayTable.element.colsArray.imgflag);
    
    selectedRowIndex = []
}

function sortAvailablePort()
{
    var t_text;
    var t_value;
    var t_option;
    var tobject_availablePort = [];
    var tobject_port = 0;
    var t_slotid;
    var t_portid;
    var t_boardmap;
    var t_arr;
    for (i = t_availablePort.getOptions().length - 1; i >= 0; i--) 
    {
        t_option = t_availablePort.getOption(i);
        t_text = t_option.text;
        t_value = t_option.value;
        
        t_arr = t_value.split("-");
        t_slotid = t_arr[0];
        t_portid = t_arr[1];
        
        tobject_port = new TEPort(t_slotid, t_portid, t_text);
        tobject_availablePort.push(tobject_port);
        
        t_availablePort.removeOption(i);
    }
    
    tobject_availablePort.sort(sortfun);
    
    for (var i = 0; i < tobject_availablePort.length; i++) 
    {
        t_value = tobject_availablePort[i].slotid + "-" + tobject_availablePort[i].portid;
        t_option = new COption(tobject_availablePort[i].portname, t_value);
        t_availablePort.addOption(t_option);
    }
}

function deleteRouteway()
{
    var selectedRows = routewayTable.getSelectedRows();
    if (selectedRows.length == 0) 
    {
        alert(RESOURCE["selectRouteway"]);
        return;
    }
    for (var i = selectedRows.length - 1; i >= 0; i--) 
    {
        var text = routewayTable.getCellStoreValue(selectedRows[i], "firstdatarouteway", "firstdatarouteway");
        var value = routewayTable.getCellHiddenValue(selectedRows[i], "firstdatarouteway", "fid");
        var option = new COption(text, value);
        availablePort.addOption(option);
        
        text = routewayTable.getCellStoreValue(selectedRows[i], "seconddatarouteway", "seconddatarouteway");
        value = routewayTable.getCellHiddenValue(selectedRows[i], "seconddatarouteway", "sid");
        option = new COption(text, value);
        availablePort.addOption(option);
        routewayTable.deleteRow(selectedRows[i]);
    }
    routewayTable.adjustDataRows();
    adjustRoutewayTable(routewayTable);
    
    $("applyBtn").disabled = !btnRightArr.applyBtn.right;
    
}

function adjustRoutewayTable(routewayTable)
{
    var len = routewayTable.getDataRowLength();
    if (len == 0) 
    {
        return;
    }
    for (var i = 0; i < len; i++) 
    {
        var routwayid = i + 1;
        routewayTable.setAtomValue(routewayTable.getCell(i, "routwayid").element.showElement, routwayid);
        routewayTable.setCellValue(routewayTable.getCell(i, "routwayid"), "routwayid", routwayid);
    }
    routewayTable.adjustDataRows();
}

function setRouteway()
{	
    $("applyBtn").disabled = true;
    
    /**
     *          
     */
    var hasNew = routewayTable.getDataRowLength() > 0;

    var hasOld = null != routewayTableData && routewayTableData.rows.length != 0;
    /**
     *               
     */
    if (hasOld)
    {    	
    	deleteOld();
    }
    if (hasNew && routewayTableData.rows.length == 0)
    {
    	addNew();        
    }
}

function addNew()
{	
	var url = "../../../../neExlorerServlet?sfid=" + Set_Routeway + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, callbackSetRoutewayData, null, "inputdata=" + createSetRoutewayXMLInfo());
}


function deleteOld()
{
	var url = "../../../../neExlorerServlet?sfid=" + Del_Routeway + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, callbackDeleteRoutewayData, null, "inputdata=" + createDeleteRoutewayXMLInfo());
}

/**
 * 
 * @param doc
 */
function callbackDeleteRoutewayData(doc)
{
	var data = EncapsulateData(doc);	
	if (0 == data.getSErrorCode()) 
	{
		routewayTableData.rows.clear();
	}	
}

function createDeleteRoutewayXMLInfo()
{
	var root = new inputxml("datainterface");
	/**
	 * 
	 */
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    
	/**
	 * 
	 */
    for (var i = 0, len = routewayTableData.rows.length; i < len; i++) 
    {
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winobj["neid"]);
        row.appendChild(param);
                        
        var firstRouteway = routewayTableData.getDataRowParam(i, "fid")
        var firstRoutewayList = firstRouteway.split("-");
        var firstslotid = parseInt(firstRoutewayList[0]);
        var firstportid = parseInt(firstRoutewayList[1]);
        
        param = new tagElement("param");
        param.setAttribute("name", "ingressslotid");
        param.setAttribute("value", firstslotid);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "ingressportid");
        param.setAttribute("value", firstportid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "firstdatarouteway");
        param.setAttribute("value", routewayTableData.getDataRowParam(i, "firstdatarouteway"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "seconddatarouteway");
        param.setAttribute("value", routewayTableData.getDataRowParam(i, "seconddatarouteway"));
        row.appendChild(param);
        
        var secondRouteway = routewayTableData.getDataRowParam(i, "sid");
        var secondRoutewayList = secondRouteway.split("-");
        var secondslotid = parseInt(secondRoutewayList[0]);
        var secondportid = parseInt(secondRoutewayList[1]);
        
        param = new tagElement("param");
        param.setAttribute("name", "egressslotid");
        param.setAttribute("value", secondslotid);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "egressportid");
        param.setAttribute("value", secondportid);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}


function createSetRoutewayXMLInfo()
{
    var root = new inputxml("datainterface");
	/**
	 * 
	 */
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    
	/**
	 * 
	 */
    for (var i = 0, len = routewayTable.getDataRowLength(); i < len; i++) 
    {
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winobj["neid"]);
        row.appendChild(param);
        
        var firstRouteway = routewayTable.getCellHiddenValue(i, "firstdatarouteway", "fid");
        var firstRoutewayList = firstRouteway.split("-");
        var firstslotid = parseInt(firstRoutewayList[0]);
        var firstportid = parseInt(firstRoutewayList[1]);
        
        param = new tagElement("param");
        param.setAttribute("name", "ingressslotid");
        param.setAttribute("value", firstslotid);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "ingressportid");
        param.setAttribute("value", firstportid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "firstdatarouteway");
        param.setAttribute("value", routewayTable.getCellShow(i, "firstdatarouteway").getValue());
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "seconddatarouteway");
        param.setAttribute("value", routewayTable.getCellShow(i, "seconddatarouteway").getValue());
        row.appendChild(param);
        
        var secondRouteway = routewayTable.getCellHiddenValue(i, "seconddatarouteway", "sid");
        var secondRoutewayList = secondRouteway.split("-");
        var secondslotid = parseInt(secondRoutewayList[0]);
        var secondportid = parseInt(secondRoutewayList[1]);
        
        param = new tagElement("param");
        param.setAttribute("name", "egressslotid");
        param.setAttribute("value", secondslotid);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "egressportid");
        param.setAttribute("value", secondportid);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

function callbackSetRoutewayData(doc)
{
    var data = EncapsulateData(doc);
    refreshTableState(routewayTable, window.tableconf[0], data);
    if (0 != data.getSErrorCode()) 
    {
        $("applyBtn").disabled = true;
    }
    showOperResult(data);
}

function showOperResult(data, errArr)
{
    errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../page/", data.getError(), errArr);
}

function compareData(selectData, tableData)
{
    for (var i = 0, tblen = tableData.getDataRowLength(); i < tblen; i++) 
    {
        for (var j = 0, len = selectData.getOptions().length; j < len; j++) 
        {
            if ((tableData.getCellHiddenValue(i, "firstdatarouteway", "fid") == selectData.getOption(j).value) ||
            (tableData.getCellHiddenValue(i, "seconddatarouteway", "sid") == selectData.getOption(j).value)) 
            {
                selectData.removeOption(j);
                j = j - 1;
                len--;
            }
        }
    }
}

function TEPort(slotid, portid, portname)
{
    this.slotid = slotid;
    this.portid = portid;
    this.portname = portname;
}

TEPort.prototype.toString = function()
{
    return this.portname;
}

function sortfun(a, b)
{
    if (a.slotid > b.slotid) 
    {
        return 1;
    }
    else if (a.slotid < b.slotid) 
    {
        return -1;
    }
    else if (a.portid > b.portid) 
    {
        return 1;
    }
    else if (a.portid <= b.portid) 
    {
        return -1;
    }
}
