 /**
 * NS3  
 */
var TN96NS3CPTYPE = 2347;
/**
 * EOW  
 */
var TN96EOWCPTYPE = 2339;


function TEBoard(neid, shelfName, slotId, boardName, boardType)
{
	this.neid = neid;
	this.slotId = slotId;
	this.shelfName = shelfName;
	this.boardName = boardName;
	this.boardType = boardType;
}

TEBoard.prototype.equals = function(otherboard)
{
	return (this.neid == otherboard.neid && this.slotId == otherboard.slotId);
}

TEBoard.prototype.contains = function(otherboard)
{
	return (this.neid == otherboard.neid && this.slotId == otherboard.slotId);
}

TEBoard.prototype.toString = function()
{		
	  var resultStr = this.slotId + "-" + this.boardName;
    if (this.shelfName != null && this.shelfName != "") 
    {
        resultStr = this.shelfName + "-" + getSlotIDFromSlot(this.slotId) + "-" + this.boardName;
    }
    return resultStr;
}

/**
 *    NS3  
 */
TEBoard.prototype.isNS3Board = function()
{
	return this.boardType == TN96NS3CPTYPE;
}

/**
 *    EOW  
 */
TEBoard.prototype.isEOWBoard = function()
{
	return this.boardType == TN96EOWCPTYPE;
}

/**
 * TEPort        
 * @param neid, neName, slotId, boardName, boardType, portId, portName
 * @return  
 */
function TEPort(neid, neName, shelfName, slotId, boardName, boardType, portId, portName)
{
	this.neid = neid;
	this.neName = neName;
	this.shelfName = shelfName;
	this.slotId = slotId;
	this.boardName = boardName;
	this.boardType = boardType;
	this.portId = portId;
	this.portName = portName;
}
/**
 * TEPort equals   
 * @param otherPort
 * @return boolean
 */
TEPort.prototype.equals = function(otherPort)
{	
	return this.neid == otherPort.neid && this.slotId == otherPort.slotId && this.portId == otherPort.portId;	
}

/**
 * TEPort equals   
 * @param otherPort
 * @return boolean
 */
TEPort.prototype.contains = function(otherPort)
{	
	return this.neid == otherPort.neid && this.slotId == otherPort.slotId && this.portId == otherPort.portId;	
}

/**
 *    NS3  
 */
TEPort.prototype.isNS3Board = function()
{
	return this.boardType == TN96NS3CPTYPE;
}

/**
 *    EOW  
 */
TEPort.prototype.isEOWBoard = function()
{
	return this.boardType == TN96EOWCPTYPE;
}

/**
 *        
 * @param  
 * @return  
 */
TEPort.prototype.toString = function()
{		
	
	var portMapping = this.slotId + "-" + this.boardName + "-" + this.portName;
  if (this.shelfName != null && this.shelfName != "") 
  {
      portMapping = this.shelfName + "-" + getSlotIDFromSlot(this.slotId) + "-" + this.boardName + "-" + this.portName;
  }
	
	return portMapping;
}
