 var newE1XCTable; //         
var parentWin = getParentWindow(); //      
var winurlobj = parentWin.winurlobj;

var currentE1XC = parentWin.currentE1XC;
var parentAvailablePortData = parentWin.availablePort;//            datainterface  
var availableTEPortData; //     

loadXMLdoc("../../../../conf/system.xml","GET",false,EncapsulateSConf);
loadXMLdoc("../../../../help/"+SYSTEMCONF.getLanguage()+"/helpidresource.xml", "GET", false,EncapsulateHelpConfig);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/orderwire_u2kv1r7c00/e1xc_"+SYSTEMCONF.getLanguage() +".xml");    

document.title = RESOURCE["createE1XCTitle"];

/**
 *        
 * 
 * @param  
 * @return  
 */
function init()
{
	initAvaiablePort();
	initBtn();
	initTable();
}

/**
 *   TEPort  
 * @param data
 * @param index
 * @return  
 */
function createTEPort(data, index)
{
	var neid = data.getDataRowParam(index, "neid");
	var neName = data.getDataRowParam(index, "neName");
	var shelfName = data.getDataRowParam(index, "shelfName");
	var slotId = data.getDataRowParam(index, "slotId");
	var boardType = data.getDataRowParam(index, "boardType");
	var boardName = data.getDataRowParam(index, "boardName");
	var portId = data.getDataRowParam(index, "portId");
	var portName = data.getDataRowParam(index, "portName");
	
	return new TEPort(neid, neName, shelfName, slotId, boardName, boardType, portId, portName);
}

/**
 *        
 * 
 * @param  
 * @return  
 */
function initAvaiablePort()
{
	availableTEPortData = [];
	
	var availableObj = {};	
	if (null != parentAvailablePortData)
	{
		for (var i = 0, len = parentAvailablePortData.getDataRowLength(); i < len; i++)
		{		
			switch (parseInt(parentAvailablePortData.getDataRowParam(i,"boardType")))
			{
				case TN96NS3CPTYPE:					
				case TN96EOWCPTYPE:
					availableTEPortData.push(createTEPort(parentAvailablePortData, i));
					break;				
				default:
					continue;
			}
		}
	}
	if (null != currentE1XC)
	{
		for (var index = 0, indexLen = currentE1XC.getDataRowLength(); index < indexLen; index++)
		{
			
			var srcneid = currentE1XC.getDataRowParam(index, "neid");
			var srcslotid = currentE1XC.getDataRowParam(index, "srcslot");
			var srcportid = currentE1XC.getDataRowParam(index, "srcportid");
			
			var sinkneid = currentE1XC.getDataRowParam(index, "neid");
			var sinkslotid = currentE1XC.getDataRowParam(index, "sinkslot");
			var sinkportid = currentE1XC.getDataRowParam(index, "sinkportid");

			filterAvailablePort(srcneid, srcslotid, srcportid);			
						
			filterAvailablePort(sinkneid, sinkslotid, sinkportid);						
		}
	}
}

/**
 *      NS3  
 * 
 * @param neid
 * @param slotid
 * @param portid
 */
function filterAvailablePort(neid, slotid, portid)
{	
	for (var i = 0, len = availableTEPortData.length; i < len; i++)
	{
		var port = availableTEPortData[i];
		if (port.neid == neid && port.slotId == slotid && port.portId == portid)
		{
			availableTEPortData.remove(port);
			break;
		}
	}
}

/**
 *      
 * 
 * @param  
 * @return  
 */
function initBtn()
{
	$("okBtn").value = RESOURCE["okBtn"];
	$("cancelBtn").value = RESOURCE["cancelBtn"];
}

/**
 *          
 * 
 * @returns
 */
function getAvailableSlotData()
{
	var availableSlotData = [];
	for (var i = 0, len = availableTEPortData.length; i < len; i++)
	{
		var port = availableTEPortData[i];	
		var board = new TEBoard(port.neid, port.shelfName, port.slotId, port.boardName, port.boardType);
		/*
		if (!availableSlotData.contains(board))
		{
			availableSlotData.push(board);
		}*/
		
		var isHave = false;
		
		for (var j = 0, k = availableSlotData.length; j < k; j++)
		{
			if (board.contains(availableSlotData[j]))
			{
				isHave = true;
				break;
			}
		}
		
		if (!isHave)
		{
			availableSlotData.push(board);
		}
					
	}	
	return availableSlotData;
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function srcSlotSelectionChanged(evt)
{
	if (!evt)
	{
		evt = window.event;
	}		
	
	var srcBoard = newE1XCTable.getAttrValue("srcSlot");
	var srcslotid = srcBoard;
	
	var srcPortData = [];
	/**
	 *      
	 */
	for (var i = 0, len = availableTEPortData.length; i < len; i++)
	{
		var port = availableTEPortData[i];
		if (port.slotId == srcslotid)
		{
			srcPortData.push(port);
		}
	}
	createOption(newE1XCTable.getAtom("srcSlot"), newE1XCTable.getAtom("srcport").element, availableTEPortData);
		
	/**
	 *      ,      
	 */	
	newE1XCTable.getAtom("sinkSlot").element.onchange = null;
	/**
	 * 
	 */
	var sinkSlotData = getAvailableSlotData();
	sinkSlotData.sort();
	for (var i = 0, len = sinkSlotData.length; i < len; i++)
  {
  	var sinkBoard = sinkSlotData[i];
		if (sinkBoard.slotId  == srcBoard)
		{
			sinkSlotData.remove(sinkBoard);
			break;
		}
  }		
	createOption(newE1XCTable.getAtom("sinkSlot"), newE1XCTable.getAtom("sinkSlot").element, sinkSlotData);
	newE1XCTable.getAtom("sinkSlot").element.onchange = sinkSlotSelectionChanged;
	
	createOption(newE1XCTable.getAtom("sinkSlot"), newE1XCTable.getAtom("sinkport").element, availableTEPortData);
	
	/**
	 * TODO :             
	 */
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function sinkSlotSelectionChanged(evt)
{
	if (!evt)
	{
		evt = window.event;
	}		
	
	var sinkBoard = newE1XCTable.getAttrValue("sinkSlot");
	var srcslotid = sinkBoard;
	
	var sinkPortData = [];
	/**
	 *      
	 */
	for (var i = 0, len = availableTEPortData.length; i < len; i++)
	{
		var port = availableTEPortData[i];
		if (port.slotId == srcslotid)
		{
			sinkPortData.push(port);
		}
	}
	createOption(newE1XCTable.getAtom("sinkSlot"), newE1XCTable.getAtom("sinkport").element, availableTEPortData);
		
	/**
	 *      ,      
	 */	 
	/**
	 * 
	 */
/*
	var srcSlotData = getAvailableSlotData();
	srcSlotData.sort();
	for (var i = 0, len = srcSlotData.length; i < len; i++)
  {
  	var srcBoard = srcSlotData[i];
		if (sinkBoard == srcBoard.slotId)
		{
			srcSlotData.remove(srcBoard);
			break;
		}
  }		
	createOption(newE1XCTable.getAtom("srcSlot"), newE1XCTable.getAtom("srcSlot").element, srcSlotData);
	newE1XCTable.getAtom("srcSlot").element.onchange = srcSlotSelectionChanged;	
	
	createOption(newE1XCTable.getAtom("srcSlot"), newE1XCTable.getAtom("srcport").element, availableTEPortData);
*/
	/**
	 * TODO :             
	 */
}


/**
 *        
 * 
 * @param  
 * @return  
 */
function initTable()
{
	newE1XCTable = new CTable();
	newE1XCTable.addHead(RESOURCE["attrCol"], RESOURCE["valueCol"]);
	var cTableAtom = null;
	var cTableAtomEle = null;
	
	/**
	 *    
	 */
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	var availableBoards = getAvailableSlotData();
	availableBoards.sort();
	createOption(cTableAtom, cTableAtomEle, availableBoards);
	cTableAtomEle.onchange = srcSlotSelectionChanged;
	newE1XCTable.addAttrRow("srcSlot", RESOURCE["xcsrcslotlabel"], cTableAtom);
	
	/**
	 *    
	 */	
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	createOption(newE1XCTable.getAtom("srcSlot"), cTableAtomEle, availableTEPortData);
	newE1XCTable.addAttrRow("srcport", RESOURCE["xcsrcportlabel"], cTableAtom);
	
	/**
	 *    
	 */
	cTableAtom = new Atom("text");
	cTableAtom.setValue(1);
	cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = true;
    newE1XCTable.addAttrRow("srcpath", RESOURCE["xcsrcpathlabel"], cTableAtom);
	
	/**
	 *    
	 */
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	createOptionWithoutUsedSlot(cTableAtom, cTableAtomEle, availableBoards, newE1XCTable.getAttrValue("srcSlot"));		
	cTableAtomEle.onchange = sinkSlotSelectionChanged;
	newE1XCTable.addAttrRow("sinkSlot", RESOURCE["xcsinkslotlabel"], cTableAtom);
	
	/**
	 *    
	 */	
	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	createOption(newE1XCTable.getAtom("sinkSlot"), cTableAtomEle, availableTEPortData);
	newE1XCTable.addAttrRow("sinkport", RESOURCE["xcsinkportlabel"], cTableAtom);
	
	/**
	 *    
	 */
	cTableAtom = new Atom("text");
	cTableAtom.setValue(1);
	cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = true;
    newE1XCTable.addAttrRow("sinkpath", RESOURCE["xcsinkpathlabel"], cTableAtom);
	
	
	$("xcTable").appendChild(newE1XCTable.getTable());
}

/**
 *    CTable       
 * 
 * @param  
 * @return  
 */
function createOption(cTableAtom, cTableAtomEle, portDataArray)
{
	if (cTableAtomEle.options == null)
	{
		return;
	}
	
	cTableAtomEle.options.length = 0;
	for (var i = 0, len = portDataArray.length; i < len; i++)
	{
		var index = getInsertIndex(cTableAtom, cTableAtomEle, portDataArray[i])
		if(-1 != index)
		{
			if (isNaN(portDataArray[i].portId))
			{
				cTableAtomEle.options.add(new Option(portDataArray[i].toString(), portDataArray[i].slotId), index);
			}
			else
			{
				cTableAtomEle.options.add(new Option(portDataArray[i].toString(), portDataArray[i].slotId + "-" + portDataArray[i].portId), index);
			}
			
		}
	}
}

/**
 *    CTable       
 * 
 * @param  
 * @return  
 */
function createOptionWithoutUsedSlot(cTableAtom, cTableAtomEle, portDataArray, usedSlotId)
{
	if (cTableAtomEle.options == null)
	{
		return;
	}
	
	cTableAtomEle.options.length = 0;
	for (var i = 0, len = portDataArray.length; i < len; i++)
	{
		if (usedSlotId == portDataArray[i].slotId)
		{
			continue;
		}
		
		var index = getInsertIndex(cTableAtom, cTableAtomEle, portDataArray[i])
		if(-1 != index)
		{
			if (isNaN(portDataArray[i].portId))
			{
				cTableAtomEle.options.add(new Option(portDataArray[i].toString(), portDataArray[i].slotId), index);
			}
			else
			{
				cTableAtomEle.options.add(new Option(portDataArray[i].toString(), portDataArray[i].slotId + "-" + portDataArray[i].portId), index);
			}
			
		}
	}
}


/**
 *   option      
 * 
 * @param cTableAtomEle
 * @param portData
 * @return  
 */
function getInsertIndex(cTableAtom, cTableAtomEle, portData)
{
	var slotIDAtom = getSlot(cTableAtom.getValue());
	
	var slotId = parseInt(portData.slotId);
	var optionData = new Option(portData.toString(), portData);
	
	var portId = parseInt(portData.portId);
	
	if (!isNaN(portId) && slotIDAtom != slotId)
	{
		 return -1;
	}
	
	var shelfName = portData.shelfName;
	var otherShelfName;
	var otherSlotId;
	var otherPortId;
	for (var i = 0, len = cTableAtomEle.options.length; i < len; i++)
	{
		var tmp = cTableAtomEle.options[i].value.split("-");
		otherSlotId = parseInt(tmp[0]);
		
		if (tmp.length > 1)
		{
			if (slotIDAtom != slotId)
			{
				return -1;
			}
			
			otherPortId = parseInt(tmp[1]);
			if (slotId < otherSlotId)
			{
				return i;
			}
			else if(slotId == otherSlotId && portId == otherPortId)
			{
				return -1;
			}
		}
		else
		{
			if (slotId < otherSlotId)
			{
				return i;
			}
			else if(slotId == otherSlotId)
			{
				return -1;
			}
		}
		
		
	}  
	
	return cTableAtomEle.options.length;
}


/**
 *               
 * 
 * @param  
 * @return  
 */
function doCreateE1Xc(isApply)
{
	var srcBoard = newE1XCTable.getAttrValue("srcSlot");
	
	var sinkBoard = newE1XCTable.getAttrValue("sinkSlot");
	
	if (sinkBoard == null || sinkBoard == "" || sinkBoard == "" || sinkBoard == "")
	{
		alert(RESOURCE["chooseBoard"]);
		return;
	}
	
	$("okBtn").disabled = true;
	$("cancelBtn").disabled = true;

	var data = createNewE1XCXML();
	if (null == data)
	{
		alert(RESOURCE["checkDataInfo"]);
		$("okBtn").disabled = false;
		$("cancelBtn").disabled = false;
		
		return;
	}
	var url = "../../../../neExlorerServlet?neid=" + parentWin.parent.neid +"&sfid=" + TECMDCODE_MARINE_ADD_E1XC + "&nmUser=" + parentWin.parent.obj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackCreateE1XCData, isApply, "inputdata="+data); 
} 

/**
 * 
 * @param slotUnit
 * @returns
 */
function getSlot(slotUnit)
{
	return slotUnit.split("-")[0];	
}

/**
 * 
 * @param portUnit
 * @returns
 */
function getPortID(portUnit)
{
	var attr = portUnit.split("-"); 
	return attr[attr.length-1];	
}

/**
 *           XML  
 * 
 * @param  
 * @return  
 */
function createNewE1XCXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	
	var row = new tagElement("row-params");
	
	var param;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", parentWin.parent.neid);
	row.appendChild(param);
	
	/**
	 *    
	 */
	var srcSlotUnit = newE1XCTable.getAtom("srcSlot").getValue();
	if (null == srcSlotUnit || "" == srcSlotUnit)
	{
		return null;
	}
	
	var srcSlot = getSlot(srcSlotUnit);
	param = new tagElement("param");
	param.setAttribute("name", "srcslot");
	param.setAttribute("value", srcSlot);
	row.appendChild(param);
	
	/**
	 *    
	 */
	var srcPortUnit = newE1XCTable.getAtom("srcport").getValue();
	var srcPortID = getPortID(srcPortUnit);
	param = new tagElement("param");
	param.setAttribute("name", "srcportid");
	param.setAttribute("value", srcPortID);
	row.appendChild(param);
	/**
	 *    
	 */
	param = new tagElement("param");
	param.setAttribute("name", "srcpathid");
	param.setAttribute("value", "1");
	row.appendChild(param);
	
	/**
	 *    
	 */
	var sinkSlotUnit = newE1XCTable.getAtom("sinkSlot").getValue();
	if (null == sinkSlotUnit || "" == sinkSlotUnit)
	{
		return null;
	}
	
	var sinkSlot = getSlot(sinkSlotUnit);
	param = new tagElement("param");
	param.setAttribute("name", "sinkslot");
	param.setAttribute("value", sinkSlot);
	row.appendChild(param);
	
	/**
	 *    
	 */
	var sinkPortUnit = newE1XCTable.getAtom("sinkport").getValue();
	var sinkPortID = getPortID(sinkPortUnit);
	param = new tagElement("param");
	param.setAttribute("name", "sinkportid");
	param.setAttribute("value", sinkPortID);
	row.appendChild(param);
	
	/**
	 *    
	 */
	param = new tagElement("param");
	param.setAttribute("name", "sinkpathid");
	param.setAttribute("value", "1");
	row.appendChild(param);
	
	
	bussiness.appendChild(row);
	
	row = new tagElement("row-params");
	
	var param;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", parentWin.parent.neid);
	row.appendChild(param);
	
	/**
	 *    
	 */
	var srcSlotUnit = newE1XCTable.getAtom("sinkSlot").getValue();
	if (null == srcSlotUnit || "" == srcSlotUnit)
	{
		return null;
	}
	
	var srcSlot = getSlot(srcSlotUnit);
	param = new tagElement("param");
	param.setAttribute("name", "srcslot");
	param.setAttribute("value", srcSlot);
	row.appendChild(param);
	
	/**
	 *    
	 */
	var srcPortUnit = newE1XCTable.getAtom("sinkport").getValue();
	var srcPortID = getPortID(srcPortUnit);
	param = new tagElement("param");
	param.setAttribute("name", "srcportid");
	param.setAttribute("value", srcPortID);
	row.appendChild(param);
	/**
	 *    
	 */
	param = new tagElement("param");
	param.setAttribute("name", "srcpathid");
	param.setAttribute("value", "1");
	row.appendChild(param);
	
	/**
	 *    
	 */
	var sinkSlotUnit = newE1XCTable.getAtom("srcSlot").getValue();
	if (null == sinkSlotUnit || "" == sinkSlotUnit)
	{
		return null;
	}
	
	var sinkSlot = getSlot(sinkSlotUnit);
	param = new tagElement("param");
	param.setAttribute("name", "sinkslot");
	param.setAttribute("value", sinkSlot);
	row.appendChild(param);
	
	/**
	 *    
	 */ 
	var sinkPortUnit = newE1XCTable.getAtom("srcport").getValue();
	var sinkPortID = getPortID(sinkPortUnit);
	param = new tagElement("param");
	param.setAttribute("name", "sinkportid");
	param.setAttribute("value", sinkPortID);
	row.appendChild(param);
	
	/**
	 *    
	 */
	param = new tagElement("param");
	param.setAttribute("name", "sinkpathid");
	param.setAttribute("value", "1");
	row.appendChild(param);
	
	
	bussiness.appendChild(row);
	
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 * 
 * @param doc
 * @return  
 */
function callbackCreateE1XCData(doc, isApply) 
{
	var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	if (0 == errorCode) 
	{
		parentWin.doQueryxc();
				
		$("okBtn").disabled = false;
		$("cancelBtn").disabled = false;
		showOperResult(data);
		if (!isApply) //                
		{
			xcloseDialog();
		}
		else
		{
			/**
			 *                  
			 */
			parentWin.queryAvailablePort();
			currentE1XC = parentWin.currentE1XC;
			parentAvailablePortData = parentWin.availablePort;//            datainterface  
			
			initAvaiablePort();
			
			var availableBoards = getAvailableSlotData();
			availableBoards.sort();
			createOption(newE1XCTable.getAtom("srcSlot"), newE1XCTable.getAtom("srcSlot").element, availableBoards);
			createOption(newE1XCTable.getAtom("srcSlot"), newE1XCTable.getAtom("srcport").element, availableTEPortData);
			createOptionWithoutUsedSlot(newE1XCTable.getAtom("sinkSlot"), newE1XCTable.getAtom("sinkSlot").element, newE1XCTable.getAttrValue("srcSlot"));
			createOption(newE1XCTable.getAtom("sinkSlot"), newE1XCTable.getAtom("sinkport").element, availableTEPortData);
		}
	}
	else
	{
		showOperResult(data);
		$("okBtn").disabled = false;
		$("cancelBtn").disabled = false;
	}
	if(isApply)
	{
		$("okBtn").disabled = false;
		$("cancelBtn").disabled = false;
	}
}

/**
 *       
 * 
 * @param data:           
 *            errArr:       
 * @return  
 */
function showOperResult(data, errArr)
{
	if (null == errArr)
	{
		errArr = [];//            
		errArr[0] = "nename";//            
	}
	openErrPage("../../../../page/",data.getError(),errArr);
}

/**
 *          
 * 
 * @param doc
 * @return  
 */
function doCancel()
{
	xcloseDialog();
}
