 //  URL  
var winurlobj;
var tableconfObj;
var st;
var neid;
var slotid;
var curCellEle;
var curCellkeyArray;

var hasQueryRight = true;
var hasApplyRight = true;

var flag = true;

var ttiCols = [];
ttiCols.push("OTN_TCM_ST_TTI");
ttiCols.push("OTN_TCM_SR_TTI");
ttiCols.push("OTN_PM_ST_TTI");
ttiCols.push("OTN_PM_SR_TTI");
ttiCols.push("OTN_SM_ST_TTI");
ttiCols.push("OTN_SM_SR_TTI");

var maxDegNumCols = [];
maxDegNumCols[1] = "163360";
maxDegNumCols[2] = "656216";
maxDegNumCols[4] = "2635912";

var language = SYSTEMCONF.getLanguage();

/**
 *       
 * @param  
 * @return  
 */
function initMainPage(filename)
{
	loadXMLdoc("../../../conf/gencfg/"+filename+".xml", "GET", false,EncapsulateGenCfg);
	
    var win = new Object();
    win = getNeProperty(self);
    var neid = win["neid"];
    var slotid = win["slotid"];
    var urlStr = self.location.search;
    var xmlstr = createQuerySupportAttrXML(neid,slotid,win["boardType"]);
    urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_NTF_CREATECIRCUITPACK;
    loadXMLdoc(urlreq, "POST",true,initGenCfgPage,[gencfg,urlStr],"inputdata="+xmlstr);
    win = null;
}

/**
 *      
 * @param sfid:   ID
 * @return  
 */
function initBody(sfidArr,nofiltercols,hiddenCols,isOPUOverHead)
{
	if(isOPUOverHead)
	{
		loadXMLdoc("../../../conf/ophbyte/otn/opuophbytetable_"+SYSTEMCONF.getLanguage() +".xml", "GET", false,EncapsulateTable);
	}
	else
	{
		loadXMLdoc("../../../conf/ophbyte/ots/otsoverheadtable_"+SYSTEMCONF.getLanguage() +".xml", "GET", false,EncapsulateTable);
	}
	
	$("querybtn").value=RESOURCE["querybutton"];
    $("applybtn").value=RESOURCE["applybutton"]; 
    	
	$("textdisplay").innerHTML = RESOURCE["textmodel"];
	$("hexdisplay").innerHTML = RESOURCE["hexmodel"];
	
    winurlobj = getNeProperty(self);
    
    neid = winurlobj["neid"];
    
    slotid = winurlobj["slotid"];
    
	st = new SortTable();
	
    st.setImage("../../../../../images/");
	 

    tableconfObj = window.tableconf[0];
    
    
    var attrArr = winurlobj["supportAttr"].split(",");
    
    
    if(null != hiddenCols)
    {
    	for(var i = 0, len = hiddenCols.length; i < len; i++)
    	{
    		var cell = tableconfObj.getColFromColId(hiddenCols[i]);
    		if(null != cell)
    		{
    			cell.width = "0";
    		}
    	}
    }
    
    st.setOnCellEditHandler(cellEditHandler);
    
    addPTOption(); 
    
    createTableHead(st, tableconfObj);   
     
    
	document.getElementById("tablecomponent").appendChild(st.getTable());	
	
	
	 st.setBodyHeight(getComponetHeight($("tablecomponent"),110)+"px");
	
	window.onresize=function()
	{
		st.setBodyHeight(getComponetHeight($("tablecomponent"),110)+"px");
	}	
	
	$("tablecomponent").oncontextmenu=popupMenuHandler;	
	st.setBodyWidth(tableconfObj.width,tableconfObj.percent,0);
	var querySfid = sfidArr[0];
	var setSfid = sfidArr[1];
	sendQueryRightReq(querySfid,setSfid);
	
}

/**
 *     PT   
 * @param  
 * @return  
 */
function addPTOption()
{
    if(null == tableconfObj.getColFromColId("SR_OTN_OTN_PT"))
    {
    	return;
    }
    
	  var ptCellEle = tableconfObj.getColFromColId("SR_OTN_OTN_PT").cell.editElement;
    for(var ptValue = 1; ptValue < 255; ptValue++)
    {
    	  if(ptValue == 85 || ptValue == 102 || ptValue == 255)
    	  {
    	  	continue;
    	  }
        var opobj = new OPTag();
        opobj.name = getPTShowValue(ptValue);
        opobj.value = ptValue;
        ptCellEle.options[ptCellEle.options.length] = opobj;
    }
}



/**
 *    TTI         
 * @param  
 * @return  
 */
function addListerner()
{
	var cell = null;
	var rowindex = 0;
	var grade = 1;
	var cellEdit = null;
	for(var i = 0,len = st.getDataRowLength();i<len;i++)
	{
		rowindex = i;
		grade = st.getCellStoreValue(i,"operaObj","grade")
		cell = st.getCell(i,"OTN_TCM_ST_TTI");
		if(null != cell&&cell.element.isEdit == "1")
		{
			cell.element["ondblclick"] = function()
			{	
				showTTIMgrDialog(this,"OTN_TCM_ST_TTI",["ST_SRC_FLAG","ST_SINK_FLAG","ST_USER_FLAG"]);	
			}
		}
        cell = st.getCell(i,"OTN_TCM_SR_TTI");
        if(null != cell&&cell.element.isEdit == "1")
        {
			cell.element["ondblclick"] = function()
			{			
				showTTIMgrDialog(this,"OTN_TCM_SR_TTI",["SR_SRC_FLAG","SR_SINK_FLAG","SR_USER_FLAG"]);	
			}	
        }
        
        cell = st.getCell(i,"OTN_PM_ST_TTI");
		if(null != cell&&cell.element.isEdit == "1")
		{
			cell.element["ondblclick"] = function()
			{	
				showTTIMgrDialog(this,"OTN_PM_ST_TTI",["ST_SRC_FLAG","ST_SINK_FLAG","ST_USER_FLAG"]);	
			}
		}
        cell = st.getCell(i,"OTN_PM_SR_TTI");
        if(null != cell&&cell.element.isEdit == "1")
        {
			cell.element["ondblclick"] = function()
			{			
				showTTIMgrDialog(this,"OTN_PM_SR_TTI",["SR_SRC_FLAG","SR_SINK_FLAG","SR_USER_FLAG"]);	
			}	
        }
        
        cell = st.getCell(i,"OTN_SM_ST_TTI");
		if(null != cell&&cell.element.isEdit == "1")
		{
			cell.element["ondblclick"] = function()
			{	
				showTTIMgrDialog(this,"OTN_SM_ST_TTI",["ST_SRC_FLAG","ST_SINK_FLAG","ST_USER_FLAG"]);	
			}
		}
        cell = st.getCell(i,"OTN_SM_SR_TTI");
        if(null != cell&&cell.element.isEdit == "1")
        {
			cell.element["ondblclick"] = function()
			{			
				showTTIMgrDialog(this,"OTN_SM_SR_TTI",["SR_SRC_FLAG","SR_SINK_FLAG","SR_USER_FLAG"]);	
			}	
        }
        
        cell = st.getCell(i,"OTN_TCM_DEG_TH");
        if(null != cell&&cell.element.isEdit == "1")
		{
			checkDataCellEvent(cell.element.editElement.element,0,maxDegNumCols[grade]);
		}
        cell = st.getCell(i,"OTN_TCM_DEG_TIMES");
        if(null != cell&&cell.element.isEdit == "1")
		{
			checkDataCellEvent(cell.element.editElement.element,2,10,6);
		}
        cell = st.getCell(i,"OTN_PM_DEG_TH");
        if(null != cell&&cell.element.isEdit == "1")
		{
			checkDataCellEvent(cell.element.editElement.element,0,maxDegNumCols[grade]);
		}
        cell = st.getCell(i,"OTN_PM_DEG_TIMES");
        if(null != cell&&cell.element.isEdit == "1")
		{
			checkDataCellEvent(cell.element.editElement.element,2,10,6);
		}
        cell = st.getCell(i,"OTN_SM_DEG_TH");
        if(null != cell&&cell.element.isEdit == "1")
		{
			checkDataCellEvent(cell.element.editElement.element,0,maxDegNumCols[grade]);
		}
        cell = st.getCell(i,"OTN_SM_DEG_TIMES");
        if(null != cell&&cell.element.isEdit == "1")
		{
			checkDataCellEvent(cell.element.editElement.element,2,10,6);
		}
		
		

		if(null != cellEdit)
		{
			var bdType = winurlobj["boardType"];
			if(bdType == 922||bdType == 923||bdType == 915 || bdType == 1088 || bdType == 1084)
			{
				cellEdit.clearOptions();
				cellEdit.addOption(RESOURCE["Bursty"],2);
			}else
			{
				cellEdit.clearOptions();
				cellEdit.addOption(RESOURCE["Poisson"],1);				
			}
		}		
	}	
}
/**
 *     OTN    
 * @param  sfid:   ID
 * @return  
 */
function sendQueryOTNReq(sfid)
{
	if(!hasQueryRight)
	{
		return;
	}
	var urlreq ="../../../../../neExlorerServlet?sfid="+sfid+"&nmUser="+winurlobj["nmUser"];	
    var inputData = createQueryXML(neid,slotid,tableconfObj);
    
    $("querybtn").disabled = true;
    $("applybtn").disabled = true; 
	loadXMLdoc(urlreq,"POST",true, handleQueryOTNRsp,sfid ,"inputdata="+inputData);
}

/**
 *     OTN    
 * @param sfid:   ID
 * @return  
 */
function sendSetOTNReq(sfid)
{	
	var urlreq ="../../../../../neExlorerServlet?sfid="+sfid+"&nmUser="+winurlobj["nmUser"];
	
    var inputData = createSetXML(neid,st,tableconfObj); 
    
    if(null != inputData) 
    {
	    $("querybtn").disabled = true;
    	$("applybtn").disabled = true; 
	    
		loadXMLdoc(urlreq,"POST",true, handleSetOTNRsp,sfid ,"inputdata="+inputData);
    }
}

/**
 *          
 * @param doc:       
 * @return  
 */
function handleQueryOTNRsp(doc,sfid)
{

	var data = EncapsulateData(doc);
	
	if(0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{	
		handleReturnData(data);
		
		createGenCfgTableBody(st, tableconfObj, data);
	}
	showErrorPage(data,"query",sfid);	
	
	if($("hex").checked)
	{
		flag = true;
		dataConvert();
	}
	
	$("querybtn").disabled = false;	
	
	addListerner();		
}

/**
 *     OTN    
 * @param doc         sfid:   ID
 * @return  
 */
function handleSetOTNRsp(doc,sfid)
{
	var data = EncapsulateData(doc);	
	
	$("querybtn").disabled = false;
	if(0 != data.getSErrorCode())
	{	
		$("applybtn").disabled = false; 
	} 
	  
	refreshTableState(st, tableconfObj, data);	
	
	showErrorPage(data,"set",sfid);
	
}

/**
 *       , TTI      00    
 * @param doc        
 * @return  
 */
function handleReturnData(data)
{
	var convertDataValue;
	
	var convertKeys = ['ST_SRC_FLAG','ST_SINK_FLAG','ST_USER_FLAG','SR_SRC_FLAG','SR_SINK_FLAG','SR_USER_FLAG','R_SRC_FLAG','R_SINK_FLAG','R_USER_FLAG'];
	
	for(var index = 0, len = data.getDataRowLength(); index < len; index++)
	{
		for(var key = 0; key < convertKeys.length; key ++)
		{
			convertDataValue = data.getDataRowParam(index, convertKeys[key]);
			if(null != convertDataValue)
			{
				data.rows[index][convertKeys[key]].value = convertTTIValue(convertDataValue);
			}
		}
	}
}

/**
 *   TTI  ,        00  
 * @param ttivalue      TTI  
 * @return TTI  
 */
function convertTTIValue(ttivalue)
{
	while(ttivalue.length >= 2)
	{
	   if("00" == ttivalue.substring(ttivalue.length-2,ttivalue.length))
	   {
	   		ttivalue = ttivalue.substring(0,ttivalue.length-2);
	   }
	   else
	   {
	   		break;
	   }
	}
	return ttivalue;
}

/**
 *   TTI  
 * @param cellEle:      colid  ID key:key
 * @return  
 */
function showTTIMgrDialog(cellEle,colid,keyArray)
{
	
	var value = [];
	for(var i = 0,len = keyArray.length; i < len; i++)
	{
		value[i] = cellEle.storeValue[keyArray[i]];
	}
	curCellEle = cellEle;
	curCellkeyArray = keyArray;
	xshowModalDialog("ttimgrdialog.html?srcflag="+value[0]+"&sinkflag="+value[1]+"&userflag="+value[2],RESOURCE["title"],450,300,"../../../../../images/");
}

/**
 *        
 * @param key:key value: 
 * @return  
 */
function refreshCellValue(srcFlag,sinkFlag,userFlag)
{
	var colid = curCellEle.colid;
	var rows = st.getSelectedRows();
	var tmpEle;
	var tempsrcFlag = srcFlag;
	var tempsinkFlag = sinkFlag;
	var tempuserFlag = userFlag;
	var storeSrcFlag = removeSpace(text2Hex(tempsrcFlag));
	var storeSinkFlag = removeSpace(text2Hex(tempsinkFlag));
	var storeUserFlag = removeSpace(text2Hex(tempuserFlag));
	
	for(var i = 0; i < rows.length; i++)
	{
		tmpEle = st.getCellElement(rows[i],colid);
		if(tmpEle.isEdit != 1)
		{
			continue;
		}
		st.setAtomValue(tmpEle.showElement,srcFlag+"-"+sinkFlag+"-"+userFlag);		
		
		tmpEle.currentValue[curCellkeyArray[0]] = storeSrcFlag;
		tmpEle.storeValue[curCellkeyArray[0]] = storeSrcFlag;
		tmpEle.currentValue[curCellkeyArray[1]] = storeSinkFlag;
		tmpEle.storeValue[curCellkeyArray[1]] = storeSinkFlag;
		tmpEle.currentValue[curCellkeyArray[2]] = storeUserFlag;
		tmpEle.storeValue[curCellkeyArray[2]] = storeUserFlag;
		tmpEle.modify = true;
		tmpEle.style.background = "#d0f946";
		tmpEle.parentNode.modify = true;				
	}	
	cellEditHandler();
}

/**
 *               
 * @param  
 * @return  
 */
function cellEditHandler()
{
	if(hasApplyRight)
	{
		$("applybtn").disabled = false; 
	}
}

/**
 *         
 * @param doc        
 * @return  
 */
function showErrorPage(data,flag,sfid)
{
	var errArr = [];
	for(var i = 0, len = data.getBErrLength(); i < len; i++)
	{		
		if(language == "zh"){
			data.getError().rowErrors[i].errorObj["attrId"] = RESOURCE[flag] + getAttrName(tableconfObj,data.getError().getRowKey(i,"attrId"));
		}
		else{
			data.getError().rowErrors[i].errorObj["attrId"] = RESOURCE[flag] + " " +getAttrName(tableconfObj,data.getError().getRowKey(i,"attrId"));
		}
	}
	errArr.push("nename");
	errArr.push("slotid");
	errArr.push("boardname");
	errArr.push("portname");
	errArr.push("grade");
	errArr.push("path");
	errArr.push("attrId");
	openErrPage("../../../../../page/",data.getError(),errArr);
}

/**
 *         
 * @param   
 * @return  
 */
function sendQueryRightReq(querySfid,applySfid)
{
	var url = "../../../../../securityServlet?neID="+winurlobj["neid"]+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url,"POST",false,rightHandleBack,null,"inputdata=" + createRightXML(querySfid,applySfid));
}

/**
 *           
 * @param  
 * @return  
 */ 
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
    
	for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
    	if(0 == data.getDataRowParam(i,"right"))
    	{
    		if(data.getDataRowParam(i,"type") == "query")
    		{
    			hasQueryRight = false;    			
    		}
    		else
    		{
    			hasApplyRight = false;
    		}   		   		
    	}     	    
    } 
    $("querybtn").disabled = !hasQueryRight;
    $("applybtn").disabled = true; 
}
 
/**
 *           XML
 * @param  
 * @return  
 */ 
function createRightXML(querySfid,applySfid)
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;;
	var thirdlevel=null;
	secondlevel = new tagElement("row-params"); //bean         	
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","type");
	thirdlevel.setAttribute("value","query");
	secondlevel.appendChild(thirdlevel);	
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",querySfid);
	secondlevel.appendChild(thirdlevel);	
	firstlevel.appendChild(secondlevel);
	
	secondlevel = new tagElement("row-params"); //bean         
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","type");
	thirdlevel.setAttribute("value","apply");
	secondlevel.appendChild(thirdlevel);	
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",applySfid);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function popupMenuHandler(evt)
{
  	if(!evt){
  	  evt= window.event;	
  	}
  	 
    var elem = (evt.target) ? evt.target : evt.srcElement;   

    if(elem!= null&&elem.blur)
    {
    	elem.blur();	  	
    }
   
   while(elem!=null)
	 {
	    if(elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
   } 
  
	if(elem == null || elem.tagName != 'TD' || null == elem.parent || elem.editElement == null)
	{
		  return;
	}  
	
	  var rowid= elem.parentNode.rowIndex;
    var rows =elem.parent.getSelectedRows();
    var colid = elem.colid;
 
    if(rows.contains(rowid))
    {
    	if(null != elem.editElement && elem.isEdit == 1)
    	{
    		  if(ttiCols.contains(colid))
    			{
    				elem.ondblclick();
    			}
    			else
    			{
    			  createTablePopupMenu(elem,evt);
    			}
    			return;
    	}
    	
    	for(var i = 0; i < rows.length; i++)
    	{
    		var tmpElem = elem.parent.getCellElement(rows[i],colid);
    		if(null != tmpElem.editElement && tmpElem.isEdit == 1)
    		{
    			 if(ttiCols.contains(colid))
    			 {
    				  tmpElem.ondblclick();
    			 }
    			else
    			{
    			   createTablePopupMenu(tmpElem,evt);
    			}
    			 return;
    		}
    	}
    }    
}

function dataConvert()
{
	if($("text").checked&&flag)
	{
		return;
	}
	if(($("hex").checked == true)&&!flag) 
	{
		return;
	}
	var cellShow = null;
	for(var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		if(-1 != tableconfObj.getIndexByid("OTN_TCM_ST_TTI"))
		{
			cellShow = st.getCellShow(i,"OTN_TCM_ST_TTI");
			if(("-" != cellShow.getValue())&&("/" != cellShow.getValue()))
			{
				convert(i,"OTN_TCM_ST_TTI");
			}
		}
		
		cellShow = st.getCellShow(i,"OTN_TCM_SR_TTI");
		if(("-" != cellShow.getValue())&&("/" != cellShow.getValue()))
		{
			convert(i,"OTN_TCM_SR_TTI");
		}
		
		cellShow = st.getCellShow(i,"OTN_TCM_R_TTI");
		if(("-" != cellShow.getValue())&&("/" != cellShow.getValue()))
		{
			convert(i,"OTN_TCM_R_TTI");
		}
	}
	flag = !flag;
}

function convert(index,key)
{
	var cell = st.getCell(index,key);
	var previousValue = st.getCellShow(index,key).getValue();
	var currentValue = "";
	var showvalue = "";
	var J0Mode = "";
	if(flag)
	{
		currentValue = text2Hex(previousValue);
	}
	else
	{
		currentValue = hex2Text(previousValue);
	}
	
	st.setCellValue(cell,key,currentValue);  
	st.getCellShow(index,key).setValue(currentValue);

}

function addSpaceAll()
{
	var storeValue = null;
	var J0Mode = null;
	var showValue = null;
	var cell = null;
	var temp = null;
	for(var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		if(-1 != tableconfObj.getIndexByid("OTN_TCM_ST_TTI"))
		{
			showValue = st.getCellShow(i,"OTN_TCM_ST_TTI");
			if(("-" != showValue.getValue())&&("/" != showValue.getValue()))
			{
				storeValue = showValue.getValue();
				showValue = addSpace(storeValue);
				st.getCellShow(i,"OTN_TCM_ST_TTI").setValue(showValue);
				cell = st.getCell(i,"OTN_TCM_ST_TTI");
				st.setCellValue(cell,"OTN_TCM_ST_TTI",showValue);
			}
		}
		
		showValue = st.getCellShow(i,"OTN_TCM_SR_TTI");
		if(("-" != showValue.getValue())&&("/" != showValue.getValue()))
		{
			  storeValue = showValue.getValue();
				showValue = addSpace(storeValue);
				st.getCellShow(i,"OTN_TCM_SR_TTI").setValue(showValue);
				cell = st.getCell(i,"OTN_TCM_SR_TTI");
				st.setCellValue(cell,"OTN_TCM_SR_TTI",showValue);
		}
		
		showValue = st.getCellShow(i,"OTN_TCM_R_TTI");
		if(("-" != showValue.getValue())&&("/" != showValue.getValue()))
		{
			  storeValue = showValue.getValue();
				showValue = addSpace(storeValue);
				st.getCellShow(i,"OTN_TCM_R_TTI").setValue(showValue);
				cell = st.getCell(i,"OTN_TCM_R_TTI");
				st.setCellValue(cell,"OTN_TCM_R_TTI",showValue);
		}
	}
}

function addSpace(value)
{
	var temp = "";
	for(var i = 0,len = value.length;i<len;i++)
	{
		temp += value.substring(i,i+2);
		
		if(i<value.length-1)
		{
			temp += " ";
		}
		i++;
	}
	return temp;
}


function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "boardname";
    errArr[2] = "portid";
    openErrPage("../../../../../page/", data.getError(), errArr);
}
