
var win = getParentWindow();

document.title = RESOURCE["filtercondition"];

var FBSMTypeName = [];
FBSMTypeName["829"] = "OTU1";
FBSMTypeName["823"] = "OTU2";
FBSMTypeName["820"] = "OTU3";
FBSMTypeName["838"] = "OTU4";
FBSMTypeName["807"] = "OTU5G";

var FBPMTypeName = [];
FBPMTypeName["832"] = "ODU0";
FBPMTypeName["829"] = "ODU1";
FBPMTypeName["823"] = "ODU2";
FBPMTypeName["820"] = "ODU3";
FBPMTypeName["838"] = "ODU4";
FBPMTypeName["841"] = "ODUflex";
FBPMTypeName["880"] = "ODU1";
FBPMTypeName["807"] = "ODU5G";

var FBOPUTypeName = [];
FBOPUTypeName["832"] = "OPU0";
FBOPUTypeName["829"] = "OPU1";
FBOPUTypeName["823"] = "OPU2";
FBOPUTypeName["820"] = "OPU3";
FBOPUTypeName["838"] = "OPU4";
FBOPUTypeName["841"] = "OPUflex";
FBOPUTypeName["880"] = "OPU1";
FBOPUTypeName["807"] = "OPU5G";

var GradeList = null;

function getFBTypeName()
{
	if (win.queryOTNfid == TE_FUNC_CFG_SM_OVERHEAD)
	{
		return FBSMTypeName;
	}
	else if(win.queryOTNfid == TE_FUNC_CFG_OPU_OVERHEAD)
	{
		return FBOPUTypeName;
	}
	else
	{
		return FBPMTypeName;
	}
}
/**
 *      
 * @param  
 * @return  
 */	
function initBody()
{
	$("okbtn").value=RESOURCE["okbutton"];
	$("canclebtn").value=RESOURCE["cancelbutton"];
	if(win.queryOTNfid == TE_FUNC_CFG_TCM_OVERHEAD)
	{
		$("fdTcmGrade").style.display= "";
	}
	else
	{
		$("fdTcmGrade").style.display= "none";
	}
	initFilterCondition();
}

function initFilterCondition()
{
	var portfbtypes = null;
	GradeList = [];
	var fbtypeList = [];
	
	for (var index = 0, len = win.CurrentFilterRes.length; index < len; index++) 
    {
    	portfbtypes = win.CurrentFilterRes[index];
        for(var i = 0;i < portfbtypes.gradeList.length;i++)
        {
        	if(GradeList.indexOf(portfbtypes.gradeList[i]) == -1)
        	{
        		GradeList[GradeList.length] = portfbtypes.gradeList[i];
        		fbtypeList[fbtypeList.length] = portfbtypes.fbtypeList[i];

        	}
        }
    }
    
    sortByGrade(GradeList,fbtypeList);

    initPort();
    initGrade(GradeList,fbtypeList);
    initTCMGrade();
    doPortSelected();
}

function  sortByGrade(GradeList,fbtypeList)
{
	if(GradeList.length<=1)
	{
		return;
	}
	
	for(var i=0,iLength=GradeList.length;i<iLength;i++)
	{
		for(var j=i+1,jLength=GradeList.length;j<jLength;j++)
		{
			if(getFBTypeName()[fbtypeList[i]]>getFBTypeName()[fbtypeList[j]])
			{
				var t = GradeList[i];
				GradeList[i] = GradeList[j];
				GradeList[j] = t;
				t = fbtypeList[i];
				fbtypeList[i] = fbtypeList[j];
				fbtypeList[j] = t;
			}
		}
	}
}

function getPortType(port)
{
	var portfbtypes = null;
	for (var index = 0, len = win.CurrentFilterRes.length; index < len; index++) 
    {
    	portfbtypes = win.CurrentFilterRes[index];
    	if(portfbtypes.port == port)
    	{
    		break;
    	}
    }
    return portfbtypes;
}

function doFilter()
{
	var selectedPorts = getSelectedPorts();
	var selectedGrades = getSelectedGrades();
	var selectedTcmGrades = getSelectedTCMGrades();
	win.doFilter(selectedPorts,selectedGrades,selectedTcmGrades);
	if(isIE)
	{
		xcloseDialog();
	}
}
function xcloseWindow()
{
	xcloseDialog();
}

/**
 *         
 */
function initPort()
{
	var tmpTable = document.createElement("table");
	tmpTable.width = "100%";
	var curRow =  null;
	var rowIndex = 0;
	var tdIndex = 0;
	var portfbtypes = null;

	for (var index = 0, len = win.CurrentFilterRes.length; index < len; index++) 
    {
    	if((index) % 2 == 0)
		{
			curRow = tmpTable.insertRow(rowIndex);
			tdIndex = 0;
			rowIndex++;
		}
    	portfbtypes = win.CurrentFilterRes[index];
    	var isCheck = "";
    	if(win.filterCondition.selectedPorts.contains(portfbtypes.port))
    	{
    		isCheck = "checked='checked'";
    	}
    	var objectid = "cbPort" + portfbtypes.port;
    	var inner = "<input type='checkbox' name='cbPort' id='" + objectid + "' value='" + portfbtypes.port + "' onclick='doPortSelected()' " + isCheck + "/>"
					+ "<span title='" + portfbtypes.portName + "'>" + getPortName(portfbtypes.portName) + "</span>";
		var curCell	= curRow.insertCell(tdIndex);
		tdIndex++;
		curCell.innerHTML = inner;
    }
    $("dvPort").appendChild(tmpTable);
}

function getPortName(portname)
{
	if(portname.length > 24)
	{
		portname = portname.substring(0,24) + "...";
	}
	return portname;
}

/**
 *         
 *                
 */
function doPortSelected()
{
	var availableGrade = [];
	var selectedCount = 0;
	for (var index = 0, len = win.CurrentFilterRes.length; index < len; index++) 
    {
    	portfbtypes = win.CurrentFilterRes[index];
    	if( $("cbPort"+portfbtypes.port) != null && $("cbPort"+portfbtypes.port).checked)
		{
			availableGrade = availableGrade.concat(portfbtypes.gradeList);
			selectedCount++;
		}
    }
    if(selectedCount == 0)
    {
    	availableGrade = GradeList;
    }
    else
    {
    	if(selectedCount == win.CurrentFilterRes.length)
    	{
    		$("cbPortAllSelect").checked = true;
    	}
    	else
    	{
    		$("cbPortAllSelect").checked = false;
    	}
    }
	disableNoAvailableGrade(availableGrade);
}

/**
 *         
 */
function disableNoAvailableGrade(availableGrade)
{
	for (var index = 0, len = GradeList.length; index < len; index++) 
    {
    	var grade =  GradeList[index];
    	if( $("cbGrade" + grade) != null && !availableGrade.contains(grade))
		{
			$("cbGrade" + grade).checked = false;
			$("cbGrade" + grade).disabled = true;
			$("spGrade" + grade).disabled = true;
		}
		else
		{
			$("cbGrade"+grade).disabled = false;
			$("spGrade" + grade).disabled = false;
		}
		
    }
}

/**
 *                
 *             
 */
function doPortAllSelect()
{
	var portfbtypes = null;
	for (var index = 0, len = win.CurrentFilterRes.length; index < len; index++) 
    {
    	portfbtypes = win.CurrentFilterRes[index];
    	if( $("cbPort"+portfbtypes.port) == null )
		{
			continue;
		}
		$("cbPort"+portfbtypes.port).checked = $("cbPortAllSelect").checked;
    }
}

/**
 *            
 *        
 */
function getSelectedPorts()
{
	var selectedPorts = [];
	for (var index = 0, len = win.CurrentFilterRes.length; index < len; index++) 
    {
    	portfbtypes = win.CurrentFilterRes[index];
    	if( $("cbPort"+portfbtypes.port) != null && $("cbPort"+portfbtypes.port).checked)
		{
			selectedPorts[selectedPorts.length] = portfbtypes.port;
		}
    }
    return selectedPorts;
}

/**
 *         
 */
function initGrade(/*Array*/gradeList,/*Array*/fbtypeList)
{
	var tmpTable = document.createElement("table");
	tmpTable.width = "100%";
	var curRow =  null;
	var rowIndex = 0;
	var tdIndex = 0;
	
	for (var index = 0, len = gradeList.length; index < len; index++) 
    {
    	if((index) % 3 == 0)
		{
			curRow = tmpTable.insertRow(rowIndex);
			tdIndex = 0;
			rowIndex++;
		}
		var grade =  gradeList[index];
		var isCheck = "";
		if(win.filterCondition.selectedGrades.contains(grade))
    	{
    		isCheck = "checked='checked'";
    	}
    	var fbname =  getFBTypeName()[fbtypeList[index]];
    	var objectid = "cbGrade" + grade;
    	var inner = "<input type='checkbox' name='cbGrade' id='" + objectid + "' onclick='doGradeSelected()' value='" + grade + "' " + isCheck + " />"
					+ "<span id='spGrade" + grade + "'>" + fbname + "</span>";
		var curCell	= curRow.insertCell(tdIndex);
		tdIndex++;
		curCell.innerHTML = inner;
    }
    $("dvGrade").appendChild(tmpTable);
}

function doGradeSelected()
{
	var selectedCount = 0;
	for (var index = 0, len = GradeList.length; index < len; index++) 
    {
    	var grade =  GradeList[index];
    	if( $("cbGrade"+grade) != null && $("cbGrade"+grade).checked)
		{
			selectedCount++;
		}
		
    }
    if(selectedCount == GradeList.length)
    {
    	$("cbGradeAllSelect").checked = true;
    }
    else
    {
    	$("cbGradeAllSelect").checked = false
    }
}

/**
 *                
 *             
 */
function doGradeAllSelect()
{
	for (var index = 0, len = GradeList.length; index < len; index++) 
    {
    	var grade =  GradeList[index];
    	if( $("cbGrade"+grade) == null )
		{
			continue;
		}
		$("cbGrade"+grade).checked = $("cbGradeAllSelect").checked;
    }
}

function getSelectedGrades()
{
	var selectedGrades = [];
	for (var index = 0, len = GradeList.length; index < len; index++) 
    {
    	var grade =  GradeList[index];
    	if( $("cbGrade"+grade) != null && $("cbGrade"+grade).checked)
		{
			selectedGrades[selectedGrades.length] = grade;
		}
    }
    return selectedGrades;
}

/**
 *    TCM     
 */
function initTCMGrade()
{
	var tmpTable = document.createElement("table");
	tmpTable.width = "100%";
	var curRow =  null;
	var rowIndex = 0;
	var tdIndex = 0;
	for (var index = 2, len = 7; index <= len; index++) 
    {
    	if((index - 2) % 3 == 0)
		{
			curRow = tmpTable.insertRow(rowIndex);
			tdIndex = 0;
			rowIndex++;
		}
		var isCheck = "";
		if(win.filterCondition.selectedTcmLevels.contains(index))
    	{
    		isCheck = "checked='checked'";
    	}
    	var tcmname = "TCM-" + (index - 1);
    	var objectid = "cbTcmGrade" + index;
    	var inner = "<input type='checkbox' name='cbTcmGrade' id='" + objectid + "' onclick='doTcmSelected()' value='" + index + "' " + isCheck + " />"
					+ "<span>" + tcmname + "</span>";
		var curCell	= curRow.insertCell(tdIndex);
		tdIndex++;
		curCell.innerHTML = inner;
    }
    $("dvTcmgrade").appendChild(tmpTable);
}

function doTcmSelected()
{
	var selectedCount = 0;
	for( var i = 2 ; i <= 7; i++ )
    {
    	if( $("cbTcmGrade"+i) != null && $("cbTcmGrade"+i).checked)
		{
			selectedCount++;
		}
    }
    if(selectedCount == 6)
    {
    	$("cbTcmGradeAllSelect").checked = true;
    }
    else
    {
    	$("cbTcmGradeAllSelect").checked = false
    }
}

/**
 * TCM               
 *             
 */
function doTcmGradeSelect()
{
	for( var i = 2 ; i <= 7; i++ )
	{
		if( $("cbTcmGrade"+i) == null )
		{
			continue;
		}
		$("cbTcmGrade"+i).checked = $("cbTcmGradeAllSelect").checked;
	}
}

function getSelectedTCMGrades()
{
	var selectedTCMGrades = [];
	for( var i = 2 ; i <= 7; i++ )
    {
    	if( $("cbTcmGrade"+i) != null && $("cbTcmGrade"+i).checked)
		{
			selectedTCMGrades[selectedTCMGrades.length] = i;
		}
    }
    return selectedTCMGrades;
}
