/**
 *          js             
 *   :     00104334
 *   : 2008-01-23
 */
var parentWin = getParentWindow();
var winurlobj = parentWin.winurlobj;

var obj = getNeProperty(self);

document.title = RESOURCE["ViewTestPeriodInfo"];

var usableLGTable = null;   //    
var selectedLGTable = null  //    

/**
 *      
 */
function initPage()
{
    initTable();
    getSLMUnit();
    
    initButton();
    
    getTestPeriod();
}

/**
 *      
 */
function initTable()
{
    $("lmu").innerText = RESOURCE["Lmu"];
    $("cycle").innerText = RESOURCE["Cycle"];
    $("usableLGLabel").innerText = RESOURCE["UsableLGLabel"];
    $("selectedLGLabel").innerText = RESOURCE["SelectedLGLabel"];
    
    usableLGTable = new SortTable();
    
    usableLGTable.setImage("../../../../images/"); 
    
    usableLGTable.setBodyHeight("250px");
    
    usableLGTable.isUsedForSelectList = true;
    
    createTableHead(usableLGTable, window.tableconf[0]);    
    
    document.getElementById("usableLGList").appendChild(usableLGTable.getTable());  
    
    selectedLGTable = new SortTable();
    
    selectedLGTable.setImage("../../../../images/"); 
    
    selectedLGTable.setBodyHeight("250px");
    
    selectedLGTable.isUsedForSelectList = true;
    
    createTableHead(selectedLGTable, window.tableconf[1]);
    
    $("selectedLGList").appendChild(selectedLGTable.getTable());
    
    usableLGTable.isListenerRegister = true;
    selectedLGTable.isListenerRegister = true;
    usableLGTable.isUsedForSelectList = true;
    selectedLGTable.isUsedForSelectList = true;
}

/**
 *      
 */
function initButton()
{
    $("cancel").value = RESOURCE["Cancel"];
    cfgAddBtn.disabled = true;
    cfgDelBtn.disabled = true;
    
}

/**
 *         
 */
function getSLMUnit()
{
    lmuSlotId = obj["lmuSlotId"];
    
    lmuBoardName = obj["lmuBoardName"];

    lmuUnit = lmuSlotId + "-" + lmuBoardName;
    
    addSelectOption($("lmuList"), lmuUnit, lmuUnit);
    
    getLineList();
}

/**
 *        
 */
function getLineList()
{
    var lineID = 0;
    
    var xml = getLineListXML(lineID);
    
    var sfid = TECMDCODE_SLM_GET_LINE_STATUS;
    
    var url = "../../../../neExlorerServlet?sfid=";
    url += sfid+"&nmUser="+winurlobj["nmUser"];
    
    loadXMLdoc(url, "POST", false, getLineListBack, null, "inputdata=" + xml);
    
    
    
}

/**
 *           XML  
 */
function getLineListXML(lineID)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = new tagElement("row-params");
    var param = new tagElement("param");
   
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
   
    param = new tagElement("param");
    param.setAttribute("name", "lineID");
    param.setAttribute("value", lineID);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);

    
    return root.toString();
}

/**
 *             
 */
function getLineListBack(doc)
{   
    var data = EncapsulateData(doc);    
   
   showErrorDialog(data);
   
   var smallErrorCode = data.getSErrorCode();
   
    if (0 != smallErrorCode)
    {       
        return;
    }
    
    usableLGTable.clearTableData();   
    selectedLGTable.clearTableData();
        
    var lmu = $("lmuList").value;
    var lmuAttr = lmu.split("-");
    var lmuSlotId = lmuAttr[0]; //   
    
    var lineName = null;        //    
    var tempSlotId = null;      //   
    var status = null;          //    
    var lineID = null;          //  ID
    var remark = null;            //    

    var dataInterface = new DataInterface();
    var obj = null;
    var ptag = null;

    for (var i = 0, len = data.getDataRowLength(); i < len; ++ i)
    {
        tempSlotId = data.getDataRowParam(i, "lmuSlotId");
        status = data.getDataRowParam(i, "currentWorkStatus");
        
        if (lmuSlotId != tempSlotId)
        {
            continue;
        }       
        
        lineID = data.getDataRowParam(i, "lineID"); //    
        remark = data.getDataRowParam(i, "remark");     //    
        
        if ("" != remark)
        {
            lineName = lineID + "-" + remark;
        }
        else
        {
            lineName = lineID;
        }
    
        obj = new Object();
        
        ptag = new ParamTag();
        ptag.value = lineName;  
        obj["lineName"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = lineID;
        obj["lineID"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = remark;
        obj["remark"] = ptag;     
        
        dataInterface.rows.append(obj);
    }  
    
    createTableBody(usableLGTable, window.tableconf[0], dataInterface, RESOURCE);
}

/**
 *  select    option   
 */
function addSelectOption(oListbox,sName,sValue)
{
    var oOption = document.createElement("option"); 
    
    oOption.appendChild(document.createTextNode(sName));
    
    oOption.setAttribute("value",sValue);

    oListbox.appendChild(oOption);
}


/**
 *        
 */
function showErrorDialog(data)
{
    
    var errArr = new Array();
    errArr.push("nename");
    
    openErrPage("../../../../page/", data.getError(), errArr); 
}

function doCancel()
{
    xcloseDialog();
}

function getTestPeriod()
{
    var lmuSlotId = obj["lmuSlotId"];
    var lmuPortId = 1;
    
    var xml = getTestPeriodXML(lmuSlotId, lmuPortId);
    
    var sfid = TECMDCODE_MARINE_GET_TEST_PERIOD;
    
    var url = "../../../../neExlorerServlet?sfid="+sfid+"&nmUser="+winurlobj["nmUser"];
    
    loadXMLdoc(url, "POST", false, getTestPeriodBack, null, "inputdata=" + xml);
}

function getTestPeriodXML(lmuSlotId, lmuPortId)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = new tagElement("row-params");
    var param = new tagElement("param");
   
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
   
    param = new tagElement("param");
    param.setAttribute("name", "lmuSlotId");
    param.setAttribute("value", lmuSlotId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmuPortId");
    param.setAttribute("value", lmuPortId);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function getTestPeriodBack(doc)
{
    var data = EncapsulateData(doc);    
    var smallErrorCode = data.getSErrorCode();
   
    if (0 != smallErrorCode)
    {
        showErrorDialog(data);       
        return;
    }

    var period = data.getDataRowParam(0, "period");
    var periodStr = "";
    for (var i = 0; i < periodToMin.length; i ++)
    {
        if (period == periodToMin[i])
        {
            periodStr = periodToStr[i];
            break;
        }
    }
    addSelectOption($("cycleList"), RESOURCE[periodStr], period);
    
    var lineNum = data.getDataRowParam(0, "lineNum");
    var lineIdArray = [];
    lineIdArray[0] = data.getDataRowParam(0, "lineId1");
    lineIdArray[1] = data.getDataRowParam(0, "lineId2");
    lineIdArray[2] = data.getDataRowParam(0, "lineId3");
    lineIdArray[3] = data.getDataRowParam(0, "lineId4");
    lineIdArray[4] = data.getDataRowParam(0, "lineId5");
    lineIdArray[5] = data.getDataRowParam(0, "lineId6");
    lineIdArray[6] = data.getDataRowParam(0, "lineId7");
    lineIdArray[7] = data.getDataRowParam(0, "lineId8");
    
    var dataInterface = new DataInterface();
    var obj = null;
    var ptag = null;
    for (var i = 0; i < lineNum; i ++)
    {
        for (var j = usableLGTable.getDataRowLength() - 1; j >= 0; j --)
        {
            if (usableLGTable.getCellStoreValue(j, "lineID", "lineID") == lineIdArray[i])
            {
                obj = new Object();
                ptag = new ParamTag;
                ptag.value = usableLGTable.getCellStoreValue(j, "lineName", "lineName");     
                obj["lineName"] = ptag;
                
                ptag = new ParamTag;
                ptag.value = usableLGTable.getCellStoreValue(j, "lineID", "lineID");     
                obj["lineID"] = ptag;
                
                ptag = new ParamTag;
                ptag.value = usableLGTable.getCellStoreValue(j, "remark", "remark");     
                obj["remark"] = ptag;
                
                usableLGTable.deleteRow(j);
                usableLGTable.adjustDataRows();
                dataInterface.rows.append(obj); 
                break;
            }
        }
        
        createTableBody(selectedLGTable, window.tableconf[1], dataInterface, RESOURCE);
        
        var IMAGE_FLAG = 1;
        selectedLGTable.sortRows(selectedLGTable.getHeadCell("lineName").element, IMAGE_FLAG);
    }
}
