 window.tabs = [];

function Tabs()
{
	this.id = window.tabs.length;
	window.tabs[this.id] = this;
	this.TabHead = document.createElement("div");
	this.TabHead.appendChild(document.createElement("ul"));
	this.TabBody = document.createElement("div");
	this.TabBody.setAttribute("align", "center");
	this.addTabs = new Array();
	this.loadOver = 0;
	this.selectTabid;
	this.selectTabClass = "";
	this.t_headClass = "";
	this.t_bodyClass = "";
	this.tabNodes = new Object();
	var _this = this;
	/**
	 * tab        
	 */
	this.hrefDisable=true;
	tabsEvent(window, "unload", function()
	{
		try
		{
			_this.clear();
		}
		catch(e)
		{
		}
	});
	this.setHrefDisable = function(flag)
	{
		this.hrefDisable=flag;
	}
	this.getAllTabsID = function()
	{
		var result = [];
		for ( var key in this.tabNodes)
		{
			result.push(key);
		}
		return result;
	}
	this.clear = function()
	{
		var nodes = this.tabNodes;
		for(var a in nodes)
		{
			nodes[a].clear();
		}
		this.tabNodes = null;

		if(this.TabBody && this.TabBody.parentNode)
		{
			this.TabBody.parentNode.removeChild(this.TabBody);
		}
		if(this.TabHead && this.TabHead.parentNode)
		{
			this.TabHead.parentNode.removeChild(this.TabHead);
		}
		this.TabHead = null;
		this.TabBody = null;
		this.TabFrame = null;
		this.selectTabClass = "";
		this.t_headClass = "";
		this.t_bodyClass = "";
		delete this.selectTabid;
		this.selectTabid = null;
	}

	this.getSelectedTabIndex = function()
	{
		var tempCount = -1;
		for ( var key in this.tabNodes)
		{
			tempCount++;
			if (this.tabNodes[key].id == this.selectTabid)
			{
				return tempCount;
			}
		}
		return -1;
	}

	this.addTab = function(tid, headstr, burl, imgurl)
	{

		if (typeof this.tabNodes[tid] == "undefined")
		{
			this.add(tid, headstr, burl, imgurl);
		}
		else
		{
			this.removeTabNode(tid);
			this.add(tid, headstr, burl, imgurl)
		}
	}

	this.insertTabAt = function(tid, headstr, burl, imgurl, insertAt)
	{
		this.add(tid, headstr, burl, imgurl, insertAt);
	}

	this.getTab = function(tid)
	{

		if (typeof this.tabNodes[tid] == "undefined")
		{

			return null;
		}
		else
		{

			return this.tabNodes[tid];
		}

	}

	this.add = function(tid, headstr, burl, imgurl, insertAt)
	{
		var tabs = this.tabNodes;
		var result = [];
		for ( var key in tabs)
		{
			if (this.tabNodes[key].head.firstChild.getAttribute("href"))
			{
				this.tabNodes[key].head.firstChild.removeAttribute("href");
			}
		}
		var t = new Tab(tid, headstr, burl, imgurl)
		this.tabNodes[tid] = t;
		if (typeof this.selectTabid != "undefined")
		{
			this.tabNodes[this.selectTabid].head.className = this.t_headClass;
			this.tabNodes[this.selectTabid].body.style.display = "none";
		}
		this.tabNodes[tid].head.className = this.t_headClass;
		this.tabNodes[tid].body.className = this.t_bodyClass;
		this.TabHead.firstChild.appendChild(this.tabNodes[tid].head);
		if (insertAt)
		{
			this.TabHead.firstChild.insertBefore(this.tabNodes[tid].head,
					this.tabNodes[insertAt].head);
		}
		this.TabBody.appendChild(this.tabNodes[tid].body);
		this.addTabs.push(tid);
		EventUtil.addEventHandler(this.tabNodes[tid].body, "load",
				readystatechange);
	}

	this.getSelectedTabID = function()
	{
		if (this.selectTabid != null)
		{
			return this.selectTabid;
		}
		return -1;
	}

	function readystatechange()
	{
		var tabsid = window.tabs.length - 1;
		var tabs = window.tabs[tabsid].tabNodes;

		var srcName = "";
		if (isIE)
		{
			srcName = arguments[0].srcElement.name;
		}
		else
		{
			srcName = arguments[0].currentTarget.name;
		}

		for ( var i = window.tabs[tabsid].addTabs.length; i >= 0; i--)
		{
			if (srcName == window.tabs[tabsid].addTabs[i])
			{
				window.tabs[tabsid].addTabs.removeAt(i);
			}
		}
		var result = [];
		for ( var key in tabs)
		{
			result.push(key);
		}
		/**
		 *     href     
		 */
		if (window.tabs[tabsid].addTabs.length == 0&& window.tabs[tabsid].hrefDisable)
		{
			for ( var i = 0; i < result.length; i++)
			{
				window.tabs[tabsid].tabNodes[result[i]].head.firstChild
						.setAttribute("href", "javascript:window.tabs["
								+ tabsid + "].selectTab('" + result[i] + "');");
				window.tabs[tabsid].tabNodes[result[i]].head.firstChild
						.setAttribute("href", "#");
				window.tabs[tabsid].tabNodes[result[i]].head.firstChild.setAttribute("tabsid",tabsid);
				window.tabs[tabsid].tabNodes[result[i]].head.firstChild.setAttribute("tabid",result[i]);
				window.tabs[tabsid].tabNodes[result[i]].head.firstChild.onclick=function(evt)
				{
					evt = evt?evt:window.event;
					var objElement = evt.srcElement?evt.srcElement:evt.currentTarget;
					window.tabs[objElement.getAttribute("tabsid")].selectTab(objElement.getAttribute("tabid"));
				}
				EventUtil.removeEventHandler(
						window.tabs[tabsid].tabNodes[result[i]].body, "load",
						readystatechange);
			}
		}
	}
	/**
	 *   Tab     
	 */
	this.enableHref = function()
	{
		var tabsid = window.tabs.length - 1;
		var tabs = window.tabs[tabsid].tabNodes;

		var result = [];
		for ( var key in tabs)
		{
			result.push(key);
		}
		/**
		 *     href     
		 */
		if (window.tabs[tabsid].addTabs.length == 0)
		{
			for ( var i = 0; i < result.length; i++)
			{
				window.tabs[tabsid].tabNodes[result[i]].head.firstChild
						.setAttribute("href", "#");
				window.tabs[tabsid].tabNodes[result[i]].head.firstChild
						.setAttribute("href", "#");
				window.tabs[tabsid].tabNodes[result[i]].head.firstChild.setAttribute("tabsid",tabsid);
				window.tabs[tabsid].tabNodes[result[i]].head.firstChild.setAttribute("tabid",result[i]);
				window.tabs[tabsid].tabNodes[result[i]].head.firstChild.onclick=function(evt)
				{
					evt = evt?evt:window.event;
					var objElement = evt.srcElement?evt.srcElement:evt.currentTarget;
					window.tabs[objElement.getAttribute("tabsid")].selectTab(objElement.getAttribute("tabid"));
				}
			}
		}
	}
	this.removeTabNodeHref = function()
	{
		var tabs = this.tabNodes;
		for ( var key in tabs)
		{
			if (this.tabNodes[key].head.firstChild.getAttribute("href"))
			{
				this.tabNodes[key].head.firstChild.removeAttribute("href");
			}
		}
	}
	this.setClass = function(theadstr, tbodystr, hcontentstr, t_hstr, t_bstr,
			t_selectstr)
	{
		this.TabHead.className = theadstr;
		this.TabBody.className = tbodystr;
		this.TabHead.firstChild.className = hcontentstr;
		this.t_headClass = t_hstr;
		this.t_bodyClass = t_bstr;
		this.selectTabClass = t_selectstr;
	}

	this.selectTab = function(key)
	{
		if (key == "BoardView")
		{
			getModify(getNeProperty(top).neid);
			if (state)
			{
				if (confirm(RESOURCE["ismodify"]))
				{
					this.gotoPage(key);
				}

			}
			else
			{
				this.gotoPage(key);
			}
		}
		else
		{
			this.gotoPage(key);
		}
	}

	this.gotoPage = function(key)
	{
		if (getNeProperty(top) != null)
		{
			setTIDOnchangeModify(
					"../../../../../isModifyTL1ExplorerServlet?type=setState&neid="
							+ getNeProperty(top).neid + "&isModify=", false);
		}
		if (this.tabNodes[this.selectTabid])
		{
			this.tabNodes[this.selectTabid].head.className = this.t_headClass;
			this.tabNodes[this.selectTabid].head.firstChild.style.color = "#000000";
			this.tabNodes[this.selectTabid].body.style.display = "none";
			var oldTabWin = this.getTabWindow(this.selectTabid);
			if (oldTabWin && oldTabWin.hideMenu)
			{
				oldTabWin.hideMenu();
			}
		}
		if (!this.tabNodes[key])
		{
			return;
		}

		this.selectTabid = key;
		this.tabNodes[key].head.className = this.selectTabClass;
		this.tabNodes[this.selectTabid].head.firstChild.style.color = "#0000FF";
		this.tabNodes[key].body.style.display = "";

		var tabWin = this.getTabWindow(key);
		if (tabWin && tabWin.hideMenu)
		{
			tabWin.hideMenu();
		}
		if (tabWin && tabWin.frames)
		{
			var len = tabWin.frames.length;
			for ( var i = 0; i < len; i++)
			{
				if (tabWin.frames[i].hideMenu)
				{
					tabWin.frames[i].hideMenu();
				}
			}
		}

		if (tabWin && tabWin.tabSelectHandler)
		{
			tabWin.tabSelectHandler();
		}

	}

	this.getTabWindow = function(key)
	{

		var frameIndex = -1;
		var iframeArray = document.getElementsByTagName("iframe");
		for ( var i = 0; i < iframeArray.length; i++)
		{
			if (iframeArray[i].name == key)
			{
				frameIndex = i;
				break;
			}
		}
		return window.frames[frameIndex];
	}

	this.closeTab = function(key)
	{
		var sibling;
		if ((key != this.selectTabid)
				|| (!(this.tabNodes[key].head.nextSibling) && !(this.tabNodes[key].head.previousSibling)))
		{
			this.removeTabNode(key);
		}
		else if ((sibling = this.tabNodes[key].head.nextSibling)
				|| (sibling = this.tabNodes[key].head.previousSibling))
		{
			var t_id = sibling.id.substring(9);
			this.removeTabNode(key);
			this.selectTabid = t_id;
			this.tabNodes[t_id].head.className = this.selectTabClass;
			this.tabNodes[t_id].body.style.display = "";
		}
	}

	this.removeTabNode = function(key)
	{
		if (!this.tabNodes[key])
		{
			return;
		}
		this.TabHead.firstChild.removeChild(this.tabNodes[key].head);
		this.tabNodes[key].clear();
		this.addTabs.remove(key);
		delete this.tabNodes[key];
		if (this.selectTabid == key)
		{
			delete this.selectTabid;
		}
	}

	this.getTabs = function()
	{
		var div = document.createElement("div");
		div.appendChild(this.TabHead);
		div.appendChild(this.TabBody);
		return div;
	}
	function focusHandler()
	{
		this.blur();
	}

	function Tab(tid, headstr, burl, imgurl)
	{
		this.id = tid;
		this.head = document.createElement("li");
		this.head.setAttribute("id", "tab_head_" + tid);
		var anchor = document.createElement("a");
		anchor.onfocus = focusHandler;
		anchor.setAttribute("target", "_self");
		this.img = document.createElement("img");
		anchor.appendChild(this.img);
		if (imgurl == null || imgurl == "")
		{
			this.img.style.display = "none";
		}
		anchor.appendChild(document.createTextNode(headstr));
		this.head.appendChild(anchor);

		this.body = document.createElement("iframe");
		this.body.refrence = this.head;
		this.body.setAttribute("name", this.id);
		this.body.setAttribute("align", "center");
		this.body.setAttribute("id", "tab_body_" + tid);
		if (burl.indexOf("?") != -1)
		{
			burl = burl + "&r=" + Math.random();
		}
		else
		{
			burl = burl + "?r=" + Math.random();
		}
		this.body.src = burl;

		this.body.style.display = "none";

		this.getID = function()
		{
			return this.id;
		}

		this.getHead = function()
		{
			return this.head;
		}

		this.getBody = function()
		{
			return this.body;
		}
		this.setImage = function(imgpath)
		{
			this.img.style.display = "";
			this.img.src = imgpath;
		}
		this.setURL = function(newURL)
		{
			this.body.src = newURL;
		}
		this.setTips = function(tips)
		{
			this.head.title = tips;
		}
		this.setText = function(text)
		{
			this.head.childNodes[0].replaceChild(document.createTextNode(text),
					this.head.childNodes[0].childNodes[1]);
		}
		this.setHeadName = function(key, headName)
		{
			this.head.removeChild(this.head.children[0])
			var a = document.createElement("a");
			a.onfocus = focusHandler;
			a.setAttribute("target", "_self");
			this.img = document.createElement("img");
			this.img.style.display = "none";
			a.appendChild(this.img);
			a.appendChild(document.createTextNode(headName));
			this.head.appendChild(a);
		}
		this.clear = function()
		{
			if(this.body.contentWindow.windowUnload)
			{
				try
				{
					this.body.contentWindow.windowUnload();
				}
				catch(e)
				{
					
				}
			}
			try
			{
				this.body.src = "";
				this.body.parentNode.removeChild(this.body);
				this.body = null;
				this.head.parentNode.removeChild(this.head);
				this.head = null;
				this.img = null;
				this.head = null;
				this.getID = null;
				this.getHead = null;
				this.getBody = null;
				this.setImage = null;
				this.setURL = null;
				this.setTips = null;
				this.setText = null;
				this.setHeadName = null;
				this.setCloseImage = null;
				this.clear = null;
			}
			catch(e)
			{
				
			}
		}
	}

	this.setCloseImage = function(path)
	{
		Tab.imagesrc = path;
	}
}

function tabsEvent(el, event, handler)
{
	if (el.addEventListener)
	{
		el.addEventListener(event, handler, false);
	}
	else if (el.attachEvent)
	{
		el.attachEvent("on"+event, handler);
	}
}
