 /**
 *          js             
 *   :     00104334
 *   : 2008-01-23
 */

var parentWin = getParentWindow();

var obj = getNeProperty(self);
var nmUser = obj["nmUser"];


var usableLGTable = null;   //    
var selectedLGTable = null  //    

var LEFT_TO_RIGHT = 1;      //        
var RIGHT_TO_LEFT = 0;      //        

var isBaselineValid = false;

var isSetTestPeriod = true;

var sync = true;

/**
 *     Id  url   
 */
function getLineId()
{
    var obj = getNeProperty(self);
    
    return obj["lineID"];
}

/**
 *     Id  url   
 */
function getNeID()
{
    var obj = getNeProperty(self);
    
    return obj["neID"];
}

/**
 *     Id  url   
 */
function getTitle()
{
    var obj = getNeProperty(self);
    
    return obj["functitle"] + "-" + RESOURCE["StartCycleTest"];
}

function setBaselineValid(valid)
{
    isBaselineValid = valid;
}

function getBaselineValid()
{
    return isBaselineValid;
}

var isPeriodValid = false;

function setPeriodValid(flag)
{
    isPeriodValid = flag;   
}

function getPeriodValid()
{
    return isPeriodValid;
}

var isSTPSucess = false;

function setSTPSucess(flag)
{
    isSTPSucess = flag;
}

function getSTPSucess()
{
    return isSTPSucess;
}

document.title = getTitle();

/**
 *      
 */
function initPage()
{
	  if (!isIE)
	  {
		  sync = false;
	  }
	  
	  
    initTable();
    getSLMUnit();
    
    initButton();
    
    initCycleList();
    
    rowSelectHandler(); 
}

/**
 *      
 */
function initTable()
{
    $("lmu").innerText = RESOURCE["Lmu"];
    $("cycle").innerText = RESOURCE["Cycle"];
    $("usableLGLabel").innerText = RESOURCE["UsableLGLabel"];
    $("selectedLGLabel").innerText = RESOURCE["SelectedLGLabel"];
    
    usableLGTable = new SortTable();
    
    usableLGTable.setImage("../../../../images/"); 
    
    usableLGTable.setBodyHeight("250px");
    
    usableLGTable.isUsedForSelectList = true;
    
    createTableHead(usableLGTable, window.tableconf[0]);    
    
    document.getElementById("usableLGList").appendChild(usableLGTable.getTable());  
    
    selectedLGTable = new SortTable();
    
    selectedLGTable.setImage("../../../../images/"); 
    
    selectedLGTable.setBodyHeight("250px");
    
    selectedLGTable.isUsedForSelectList = true;
    
    createTableHead(selectedLGTable, window.tableconf[1]);
    
    $("selectedLGList").appendChild(selectedLGTable.getTable());
    
    usableLGTable.isListenerRegister = true;
    selectedLGTable.isListenerRegister = true;
}

/**
 *      
 */
function initButton()
{
    $("set").value = RESOURCE["applyBtn"];
    $("start").value = RESOURCE["Start"];
    
}

/**
 *      
 *             AU9D26361
 */
function initCycleList()
{
    addSelectOption($("cycleList"), RESOURCE["TwelveHours"], Period_12h);
    addSelectOption($("cycleList"), RESOURCE["Everyday"], Period_24h);
    addSelectOption($("cycleList"), RESOURCE["ThreeDays"], Period_3d);
    addSelectOption($("cycleList"), RESOURCE["Week"], Period_7d);
    addSelectOption($("cycleList"), RESOURCE["HalfMonth"], Period_14d);
    addSelectOption($("cycleList"), RESOURCE["Month"], Period_28d);
    addSelectOption($("cycleList"), RESOURCE["Poll"], Period_poll);   
}

/**
 *         
 */
function getSLMUnit()
{
	  $("set").disabled = true;
	  
    var xml = getSLMUnitXML();
    
    var sfid = TECMDCODE_SLM_GET_LMU;
    
    var url = "../../../../neExlorerServlet?sfid=";
    url += sfid+"&nmUser="+nmUser;
    
    loadXMLdoc(url, "POST", sync, getSLMUnitBack, null, "inputdata=" + xml);
    
    
}

/**
 *            XML  
 */
function getSLMUnitXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeID());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmuSlotId");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
 
       
    return root.toString();
}

/**
 *              
 */
function getSLMUnitBack(doc)
{
    var data = EncapsulateData(doc);
    
    showErrorDialog(data);
   
    var smallErrorCode = data.getSErrorCode();
   
    if (0 != smallErrorCode && 1 != smallErrorCode)
    {       
        return;
    }    
        
    $("lmuList").options.length = 0;
     
    
    var lmuUnit = null;             //            
    var lmuUnitValue = null;        //lmu 
    var lmuSlotId = null;           //lmu   
    var lmuBoardName = null;        //lmu    
    var currWorkStatus = null;      //lmu        
    
    for(var i = 0, len = data.getDataRowLength(); i < len; ++ i)
    {
        currWorkStatus = data.getDataRowParam(i, "currentWorkStatus");
        
        if (IDLE_STATUS != currWorkStatus)
        {
            continue;
        }
        
        lmuSlotId = data.getDataRowParam(i, "lmuSlotId");
        
        lmuBoardName = data.getDataRowParam(i, "lmuBoardName");
        
        
        lmuUnit = lmuSlotId + "-" + lmuBoardName;
        
        addSelectOption($("lmuList"), lmuUnit, lmuUnit);
    }
    
    if (null == $("lmuList").value || "" == $("lmuList").value)
    {
        alert(RESOURCE["noresource"]);
        return;
    }
    
    getLineList();

}

/**
 *        
 */
function getLineList()
{
    var lineID = 0;
    
    var xml = getLineListXML(lineID);
    
    var sfid = TECMDCODE_SLM_GET_CYCLE_LINE_STATUS;
    
    var url = "../../../../neExlorerServlet?sfid=";
    url += sfid+"&nmUser="+nmUser;
    
    loadXMLdoc(url, "POST", false, getLineListBack, null, "inputdata=" + xml);

    
    
}

/**
 *           XML  
 */
function getLineListXML(lineID)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = new tagElement("row-params");
    var param = new tagElement("param");
   
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeID());
    row.appendChild(param);
   
    param = new tagElement("param");
    param.setAttribute("name", "lineID");
    param.setAttribute("value", lineID);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);

    
    return root.toString();
}

/**
 *             
 */
function getLineListBack(doc)
{ 
    var data = EncapsulateData(doc);    
   
   showErrorDialog(data);
   
   var smallErrorCode = data.getSErrorCode();
   
    if (0 != smallErrorCode)
    {       
        return;
    }
    
    usableLGTable.clearTableData();   
    selectedLGTable.clearTableData();
        
    var lmu = $("lmuList").value;
    var lmuAttr = lmu.split("-");
    var lmuSlotId = lmuAttr[0]; //   
    
    var lineName = null;        //    
    var tempSlotId = null;      //   
    var status = null;          //    
    var lineID = null;          //  ID
    var remark = null;            //    

    var dataInterface = new DataInterface();
    var obj = null;
    var ptag = null;

    for (var i = 0, len = data.getDataRowLength(); i < len; ++ i)
    {
        tempSlotId = data.getDataRowParam(i, "lmuSlot");
        status = data.getDataRowParam(i, "currentWorkStatus");
        
        if (lmuSlotId != tempSlotId || IDLE_STATUS != status)
        {
            continue;
        }       
        
        lineID = data.getDataRowParam(i, "lineID"); //    
        remark = data.getDataRowParam(i, "lineRemark");     //    
        
        if ("" != remark)
        {
            lineName = lineID + "-" + remark;
        }
        else
        {
            lineName = lineID;
        }
    
        obj = new Object();
        
        ptag = new ParamTag();
        ptag.value = lineName;  
        obj["lineName"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = lineID;
        obj["lineID"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = remark;
        obj["remark"] = ptag;     
        
        dataInterface.rows.append(obj);
    }  
    
    createTableBody(usableLGTable, window.tableconf[0], dataInterface, RESOURCE);    
    
    getTestPeriod();
    
    $("set").disabled = false;
    
    rowSelectHandler();    
    
}

/**
 *  from            to    
 */
function cfgMoveBtn(direction)
{
    var tblConfIndex = null;
    if (LEFT_TO_RIGHT == direction)
    {
        from = usableLGTable;
        to = selectedLGTable;
        tblConfIndex = LEFT_TO_RIGHT;
        
    }
    else if (RIGHT_TO_LEFT == direction)
    {
        from = selectedLGTable;
        to = usableLGTable;
        tblConfIndex = RIGHT_TO_LEFT;
    }
    
    var selectedRows = from.getSelectedRows();  
    if (0 == selectedRows.length)
    {
        alert(RESOURCE["NotSelectData"]);
        return;
    }
    
    var rowId = null;
    
    var dataInterface = new DataInterface();
    var obj = null;
    var ptag = null;
    
    for (var i = selectedRows.length - 1; i >= 0; -- i)
    {
        rowId = selectedRows[i];
        
        obj = new Object();
        
        ptag = new ParamTag;
        ptag.value = from.getCellStoreValue(rowId, "lineName", "lineName");     
        obj["lineName"] = ptag;
        
        ptag = new ParamTag;
        ptag.value = from.getCellStoreValue(rowId, "lineID", "lineID");     
        obj["lineID"] = ptag;
        
        ptag = new ParamTag;
        ptag.value = from.getCellStoreValue(rowId, "remark", "remark");     
        obj["remark"] = ptag;
        
        from.deleteRow(rowId);
        from.adjustDataRows();
        dataInterface.rows.append(obj);     
    }
    
    
    createTableBody(to, window.tableconf[tblConfIndex], dataInterface, RESOURCE);
    
    var IMAGE_FLAG = 1;
    to.sortRows(to.getHeadCell("lineName").element, IMAGE_FLAG);
    
    rowSelectHandler();
}

/**
 *             
 */
function rowSelectHandler()
{
    var len = selectedLGTable.getDataRowLength();
    
    if (0 == len)
    {
        $("start").disabled = true;
    }
    else
    {
        $("start").disabled = false;
    }
}

/**
 *            
 */
function setCycleTestIS()
{   
	  isSetTestPeriod = true;
	  
    setTestPeriod();
}

/**
 *            
 */
function startCycleTestIS()
{   
    var lineNum = selectedLGTable.getDataRowLength();
    if (lineNum <= 0)
    {
        alert(RESOURCE["NotSelectData"]);
        return;
    }
    
    hasBaseline();
    if (!getBaselineValid())
    {       
        return;
    }
    
    isSetTestPeriod = false;
    
    setTestPeriod();
    if (false == getSTPSucess())
    {
        return;
    }
    
    getTestTime();          
    if (!getPeriodValid())
    {       
        return;
    }

    startCycleTest();
}

/**
 *       
 */
function setTestPeriod()
{
    if (null == $("lmuList").value || "" == $("lmuList").value)
    {
        alert(RESOURCE["NotSelectLMU"]);
			  return;
    }
    
    if (null == $("cycleList").value || "" == $("cycleList").value)
    {
        alert(RESOURCE["NotSelectCycle"]);
			  return;
    }
	
    var lmu = $("lmuList").value;
    var lmuAttr = lmu.split("-");
    var lmuSlotId = lmuAttr[0];             //   
    
    var period = $("cycleList").value;
    var lineNum = selectedLGTable.getDataRowLength();
    
    var lineIdList = "";
    if ("0" != lineNum)
    {
	    for (var i = 0; i < lineNum -1; ++ i)
	    {
	        lineIdList += selectedLGTable.getCellStoreValue(i, "lineID", "lineID");
	        lineIdList +=",";
	    }
	    lineIdList += selectedLGTable.getCellStoreValue(i, "lineID", "lineID");
    }
    else
    {
    	lineIdList = "0";
    }
    
    var LMU_PORT_ID = 1;    //LMU       1
    var xml = setTestPeriodXML(lmuSlotId, LMU_PORT_ID, period, lineNum, lineIdList);
    
    var sfid = TECMDCODE_SLM_SET_TEST_PERIOD;
    
    var url = "../../../../neExlorerServlet?sfid=";
    url += sfid+"&nmUser="+nmUser;
    
    loadXMLdoc(url, "POST", false, setTestPeriodBack, null, "inputdata=" + xml);
    
    
}

/**
 *            XML  
 */
function setTestPeriodXML(lmuSlotId, lmuPortId, period, lineNum, lineIdList)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = new tagElement("row-params");
    var param = new tagElement("param");
   
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeID());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmuSlotId");
    param.setAttribute("value", lmuSlotId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "period");
    param.setAttribute("value", period);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lineNum");
    param.setAttribute("value", lineNum);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lineIdList");
    param.setAttribute("value", lineIdList);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    
    return root.toString();
}

/**
 *             
 */
function setTestPeriodBack(doc)
{
    var data = EncapsulateData(doc);
    
    var smallErrorCode = data.getSErrorCode();
    
    if (0 != smallErrorCode)
    {
    	  showErrorDialog(data);
        setSTPSucess(false);
        return;
    }
    
    if (isSetTestPeriod)
    {
    	alert(data.errObj.getGlobleEInfo());
    }
    
    
    setSTPSucess(true); 
}

/**
 *          
 */
function startCycleTest()
{   
    var lmu = $("lmuList").value;
    var lmuAttr = lmu.split("-");
    var lmuSlotId = lmuAttr[0]; 
    var LMU_PORT_ID = 1;    //LMU       1
    
    var xml = startCycleTestXML(lmuSlotId, LMU_PORT_ID);
    
    var sfid = TECMDCODE_SLM_START_CYCLE_TEST;
    
    var url = "../../../../neExlorerServlet?sfid=";
    url += sfid+"&nmUser="+nmUser;
    
    loadXMLdoc(url, "POST", false, startCycleTestBack, null, "inputdata=" + xml);
    
}

/**
 *        XML  
 */
function startCycleTestXML(lmuSlotId, lmuPortId)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = new tagElement("row-params");
    var param = new tagElement("param");
   
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeID());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmuSlotId");
    param.setAttribute("value", lmuSlotId);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    
    return root.toString();
}

/**
 *          
 */
function startCycleTestBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (0 != smallErrorCode)
    {
        showErrorDialog(data);
    }
    else
    {
        getLineStatus(getLineIDArray());
        
        xcloseDialog();
    }
}

/**
 *           
 */
function getTestTime()
{   
    var xml = getTestTimeXML();
    
    var sfid = TECMDCODE_SLM_GET_TEST_TIME;
    
    var url = "../../../../neExlorerServlet?sfid=";
    url += sfid+"&nmUser="+nmUser;
    
    loadXMLdoc(url, "POST", false, getTestTimeBack, null, "inputdata=" + xml);
    
    
    
}

/**
 *                XML  
 */
function getTestTimeXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    
    
    for(var i = 0, len = selectedLGTable.getDataRowLength(); i < len; ++ i)
    {
        row = new tagElement("row-params");
    
        param = new tagElement("param");   
        param.setAttribute("name", "neid");
        param.setAttribute("value", getNeID());
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "lineID");
        param.setAttribute("value", selectedLGTable.getCellStoreValue(i, "lineID", "lineID"));
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    
    
    return root.toString();
}

/**
 *                
 */
function getTestTimeBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (0 != smallErrorCode)
    {
        showErrorDialog(data);
        setPeriodValid(false);
        return;
    }
    
    var lineIdList = [];
    var testTimeValid = null;
    for (var i = 0, len = data.getDataRowLength(); i < len; ++ i)
    {
        testTimeValid = data.getDataRowParam(i, "testTimeValid", "testTimeValid");
        lineID = data.getDataRowParam(i, "lineID", "lineID");
        
        var TIME_UNVALID = 0;
        if (TIME_UNVALID == testTimeValid)
        {
            setPeriodValid(false);
            lineIdList.push(lineID);
        }
    }
    
    if (0 != lineIdList.length)
    {
        alert(RESOURCE["Line"] + lineIdList.join(", ") +RESOURCE["PeriodTooLittle"]);
        return;
    }
    
    setPeriodValid(true);
}

/**
 *  select    option   
 */
function addSelectOption(oListbox,sName,sValue)
{
    var oOption = document.createElement("option"); 
    
    oOption.appendChild(document.createTextNode(sName));
    
    oOption.setAttribute("value",sValue);

    oListbox.appendChild(oOption);
}

/**
 *           
 */
function hasBaseline()
{

    var lineIdList = [];    //  Id  
    var lineID = null;      //  ID
    var lineGroup = null;   //    ,   :lineID + remark
    
    var attr = null;        //          
    

    for (var i = 0, len = selectedLGTable.getDataRowLength(); i < len; ++ i)
    {
        lineID = selectedLGTable.getCellStoreValue(i, "lineID", "lineID");
        
        lineIdList.push(lineID);
    }
    
    var xml = hasBaselineXML(lineIdList);
    
    var sfid = TECMDCODE_SLM_HAS_BASELINE;
    
    var url = "../../../../neExlorerServlet?sfid=";    
    url += sfid+"&nmUser="+nmUser;
    
    loadXMLdoc(url, "POST", false, hasBaselineBack, null, "inputdata=" + xml);
    

    
    

}

/**
 *              XML  
 */
function hasBaselineXML(lineIdList)
{   
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    
    for (var i = 0, len = lineIdList.length; i < len; ++ i)
    {
        row = new tagElement("row-params");
        param = new tagElement("param");  
        param.setAttribute("name", "neid");
        param.setAttribute("value", getNeID());
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "indexID");
        param.setAttribute("value", lineIdList[i]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "testMode");
        param.setAttribute("value", IS_MODE);
        row.appendChild(param);
    
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    
    
    return root.toString();
}

/**
 *                
 */
function hasBaselineBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (0 != smallErrorCode)
    {
        showErrorDialog(data);
        setBaselineValid(false);
        return;
    }
    
    var lineID = null;              //  ID
    var hasBaseline = null;        //      
    var baselineValid = null;       //      
    var noBaseLineList = [];        //          
    var notValidLineList = [];      //          
    
    for (var i = 0, len = data.getDataRowLength(); i < len; ++ i)    
    {
        lineID = data.getDataRowParam(i, "lineID");
        
        hasBaseline = data.getDataRowParam(i, "hasBaseline");
        
        if ("0" == hasBaseline)
        {
            noBaseLineList.push(lineID);
            continue;
        }
        
        baselineValid = data.getDataRowParam(i, "baselineValid");
        
        if (NOT_VALID == baselineValid)
        {
            notValidLineList.push(lineID);
        }   
    }
    
    var alertStr = "";
   
   
    if (0 != noBaseLineList.length)
    {
        alertStr += RESOURCE["NoBaseLineId"];
        alertStr += noBaseLineList.join(", ");
    }
   
    if (0 != notValidLineList)
    {
        if (0 != noBaseLineList.length)
        {
            alertStr += "\n";
        }
        alertStr += RESOURCE["NotValidLineId"];
        alertStr += notValidLineList.join(", ");
    }
    
    if ("" != alertStr)
    {
        alert(alertStr);
        setBaselineValid(false);
        
        return;
    }   
    
    setBaselineValid(true);
}

/**
 *        
 */
function showErrorDialog(data)
{
    var errArr = new Array();
    errArr.push("nename");
    
    openErrPage("../../../../page/", data.getError(), errArr); 
}

function doCancel()
{
    xcloseDialog();
}

/**
 *            
 */
function getLineStatus(lineIDArray)
{
	var rowNeId = null;    
    var lineStatus = parentWin.lineStatus; 
    for (var i = 0, len = lineIDArray.length; i < len; ++ i)
    {
        dataLineId = lineIDArray[i];
      
        for (var j = 0, rowNum = lineStatus.getDataRowLength(); j < rowNum; ++ j)
        {
            rowNeId = lineStatus.getCellStoreValue(j, "neid", "neid");
            rowLineId = lineStatus.getCellStoreValue(j, "lineID", "lineID");
              
            if ((getNeID() == rowNeId) && (dataLineId == rowLineId))
            {
                if (i == 0)
                {
                    lineStatus.setCellValue(lineStatus.getCell(j, "currentWorkStatus"), "currentWorkStatus", TESTING_STATUS);
                    tmpName = RESOURCE[CURRENT_WORK_STATUS[TESTING_STATUS]];
                    lineStatus.setAtomValue(lineStatus.getCellElement(j, "currentWorkStatus").showElement, tmpName);
        
                    lineStatus.setCellValue(lineStatus.getCell(j, "testMode"), "testMode", IS_MODE);
                    tmpName = RESOURCE[TEST_MODE[IS_MODE]];
                    lineStatus.setAtomValue(lineStatus.getCellElement(j, "testMode").showElement, tmpName);
                    
                    lineStatus.setCellValue(lineStatus.getCell(j, "testType"), "testType", CYCLE_TEST);
                    tmpName = RESOURCE[TEST_TYPE[CYCLE_TEST]];
                    lineStatus.setAtomValue(lineStatus.getCellElement(j, "testType").showElement, tmpName);
                }
                else
                {
                    lineStatus.setCellValue(lineStatus.getCell(j, "currentWorkStatus"), "currentWorkStatus", WAITING_STATUS);
                    tmpName = RESOURCE[CURRENT_WORK_STATUS[data.getDataRowParam(j, "currentWorkStatus")]];
                    lineStatus.setAtomValue(lineStatus.getCellElement(j, "currentWorkStatus").showElement, tmpName);
        
                    lineStatus.setCellValue(lineStatus.getCell(j, "testMode"), "testMode", IS_MODE);
                    tmpName = RESOURCE[TEST_MODE[data.getDataRowParam(j, "testMode")]];
                    lineStatus.setAtomValue(lineStatus.getCellElement(j, "testMode").showElement, tmpName);
                    
                    lineStatus.setCellValue(lineStatus.getCell(j, "testType"), "testType", CYCLE_TEST);
                    tmpName = RESOURCE[TEST_TYPE[data.getDataRowParam(j, "testType")]];
                    lineStatus.setAtomValue(lineStatus.getCellElement(j, "testType").showElement, tmpName);
                }    
                break;
            }
        }        
    }
    
    lineStatus.adjustDataRows();
    
    parentWin.refreshLineStatus();
    
    parentWin.lineStatusRowSltHandler();  
}

function getLineIDArray()
{
    var lineNum = selectedLGTable.getDataRowLength();
    
    var lineIdArray = [];
    for (var i = 0; i < lineNum; ++ i)
    {
        lineIdArray[lineIdArray.length] = selectedLGTable.getCellStoreValue(i, "lineID", "lineID");
    }
    
    return lineIdArray;    
}

function getTestPeriod()
{
    var lmu = $("lmuList").value;
    var lmuAttr = lmu.split("-");
    var lmuSlotId = lmuAttr[0]; //   
    var lmuPortId = 1;
    
    var xml = getTestPeriodXML(lmuSlotId, lmuPortId);
    
    var sfid = TECMDCODE_MARINE_GET_TEST_PERIOD;
    
    var url = "../../../../neExlorerServlet?sfid="+sfid+"&nmUser="+nmUser;
    
    loadXMLdoc(url, "POST", false, getTestPeriodBack, null, "inputdata=" + xml);
}

function getTestPeriodXML(lmuSlotId, lmuPortId)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = new tagElement("row-params");
    var param = new tagElement("param");
   
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeID());
    row.appendChild(param);
   
    param = new tagElement("param");
    param.setAttribute("name", "lmuSlotId");
    param.setAttribute("value", lmuSlotId);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function getTestPeriodBack(doc)
{
    var data = EncapsulateData(doc);    
    var smallErrorCode = data.getSErrorCode();
    var bigErrorCode = 0;   
    if (0 != smallErrorCode)
    {
        bigErrorCode = data.getBErrorCode();
        
        if (42787 != bigErrorCode)
        {
            showErrorDialog(data);
        }        
        return;
    }

    var period = data.getDataRowParam(0, "period");
    $("cycleList").value = period;
    
    var lineNum = data.getDataRowParam(0, "lineNum");
    var lineIdArray = [];
    lineIdArray[0] = data.getDataRowParam(0, "lineId1");
    lineIdArray[1] = data.getDataRowParam(0, "lineId2");
    lineIdArray[2] = data.getDataRowParam(0, "lineId3");
    lineIdArray[3] = data.getDataRowParam(0, "lineId4");
    lineIdArray[4] = data.getDataRowParam(0, "lineId5");
    lineIdArray[5] = data.getDataRowParam(0, "lineId6");
    lineIdArray[6] = data.getDataRowParam(0, "lineId7");
    lineIdArray[7] = data.getDataRowParam(0, "lineId8");
    
    var dataInterface = new DataInterface();
    var obj = null;
    var ptag = null;
    for (var i = 0; i < lineNum; i ++)
    {
        for (var j = usableLGTable.getDataRowLength() - 1; j >= 0; j --)
        {
            if (usableLGTable.getCellStoreValue(j, "lineID", "lineID") == lineIdArray[i])
            {
                obj = new Object();
                ptag = new ParamTag;
                ptag.value = usableLGTable.getCellStoreValue(j, "lineName", "lineName");     
                obj["lineName"] = ptag;
                
                ptag = new ParamTag;
                ptag.value = usableLGTable.getCellStoreValue(j, "lineID", "lineID");     
                obj["lineID"] = ptag;
                
                ptag = new ParamTag;
                ptag.value = usableLGTable.getCellStoreValue(j, "remark", "remark");     
                obj["remark"] = ptag;
                
                usableLGTable.deleteRow(j);
                usableLGTable.adjustDataRows();
                dataInterface.rows.append(obj); 
                break;
            }
        }
    }
    createTableBody(selectedLGTable, window.tableconf[1], dataInterface, RESOURCE);
        
    var IMAGE_FLAG = 1;
    selectedLGTable.sortRows(selectedLGTable.getHeadCell("lineName").element, IMAGE_FLAG);
        
    var IMAGE_FLAG = 1;
    usableLGTable.sortRows(usableLGTable.getHeadCell("lineName").element, IMAGE_FLAG);
}
